/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrBudgetAmtConsumeReqBO;
import com.tydic.agreement.ability.bo.AgrBudgetAmtConsumeRspBO;
import com.tydic.agreement.ability.bo.BudgetAmtConsumeBO;
import com.tydic.agreement.busi.AgrBudgetAmtConsumeBusiService;
import com.tydic.agreement.busi.AgrSyncBudgetAmtBusiService;
import com.tydic.agreement.busi.bo.AgrSyncBudgetAmtBusiReqBO;
import com.tydic.agreement.common.bo.AgrAgreementBO;
import com.tydic.agreement.dao.AgrAgreementBudgetAmtMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.po.AgrAgreementBudgetAmtPO;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.contract.api.ecp.ExtSyncContractBudgetAmtService;
import com.tydic.contract.api.ecp.bo.ExtSyncContractBudgetAmtReqBO;
import com.tydic.contract.api.ecp.bo.ExtSyncContractBudgetAmtRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AgrBudgetAmtConsumeBusiServiceImpl
implements AgrBudgetAmtConsumeBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrBudgetAmtConsumeBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementBudgetAmtMapper agreementBudgetAmtMapper;
    @Autowired
    private ExtSyncContractBudgetAmtService extSyncContractBudgetAmtService;
    @Autowired
    private AgrSyncBudgetAmtBusiService agrSyncBudgetAmtBusiService;

    public AgrBudgetAmtConsumeRspBO updateOrderConsume(AgrBudgetAmtConsumeReqBO reqBO) {
        AgrBudgetAmtConsumeRspBO rspBO = new AgrBudgetAmtConsumeRspBO();
        ArrayList<AgrAgreementBudgetAmtPO> agrAgreementOrderPos = new ArrayList<AgrAgreementBudgetAmtPO>();
        Date now = new Date();
        reqBO.getBudgetAmtConsumeList().forEach(bo -> {
            AgrAgreementBudgetAmtPO po = new AgrAgreementBudgetAmtPO();
            po.setId(Sequence.getInstance().nextId());
            po.setPackCode(bo.getPackCode());
            po.setOrderId(reqBO.getOrderId());
            po.setAgreementId(bo.getAgreementId());
            po.setContractId(bo.getContractId());
            po.setObjId(reqBO.getObjId());
            po.setObjType(reqBO.getObjType().getTypeCode());
            po.setConsumerBudgetAmt(bo.getUsedAmt());
            po.setCreateTime(now);
            agrAgreementOrderPos.add(po);
        });
        int inserted = this.agreementBudgetAmtMapper.insertBatch(agrAgreementOrderPos);
        if (inserted < agrAgreementOrderPos.size()) {
            throw new BusinessException("8888", "\u8bb0\u5f55\u4e0b\u5355\u91d1\u989d\u53d8\u66f4\u65e5\u5fd7\u5931\u8d25");
        }
        reqBO.getBudgetAmtConsumeList().forEach(bo -> {
            BigDecimal percentage;
            int updated;
            Boolean checkFlag = reqBO.getCheckFlag();
            if (bo.getUsedAmt().compareTo(BigDecimal.ZERO) < 0) {
                checkFlag = false;
            }
            if ((updated = this.agreementMapper.updateBudgetAmt((BudgetAmtConsumeBO)bo, checkFlag)) < 1) {
                if (!StringUtils.hasText((String)bo.getPlaAgreementCode())) {
                    AgreementPO agreementPo = new AgreementPO();
                    agreementPo.setAgreementId(bo.getAgreementId());
                    AgreementPO modelBy = this.agreementMapper.getModelBy(agreementPo);
                    bo.setPlaAgreementCode(modelBy.getPlaAgreementCode());
                }
                throw new BusinessException("8888", "\u5e73\u53f0\u534f\u8bae\u7f16\u7801[" + bo.getPlaAgreementCode() + "]\u66f4\u65b0\u9879\u76ee\u4f7f\u7528\u91d1\u989d\u5931\u8d25");
            }
            ExtSyncContractBudgetAmtReqBO extSyncContractBudgetAmtReqBO = new ExtSyncContractBudgetAmtReqBO();
            extSyncContractBudgetAmtReqBO.setPackCode(bo.getPackCode());
            extSyncContractBudgetAmtReqBO.setUsedAmt(bo.getUsedAmt());
            extSyncContractBudgetAmtReqBO.setSyncFlag("1");
            ExtSyncContractBudgetAmtRspBO contractBudgetAmtRspBO = this.extSyncContractBudgetAmtService.syncContract(extSyncContractBudgetAmtReqBO);
            if (!contractBudgetAmtRspBO.getCode().equals("0000")) {
                throw new BusinessException("8888", "\u66f4\u65b0\u5408\u540c\u5269\u4f59\u9884\u7b97\u91d1\u989d\u5931\u8d25");
            }
            BigDecimal usedAmt = bo.getMinBudgetAmt().subtract(bo.getRemBudgetAmt());
            if (usedAmt.compareTo(BigDecimal.ZERO) > 0 && (percentage = usedAmt.divide(bo.getMinBudgetAmt(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100))).compareTo(new BigDecimal("80")) > 0) {
                AgrSyncBudgetAmtBusiReqBO agrSyncBudgetAmtBusiReqBO = new AgrSyncBudgetAmtBusiReqBO();
                AgrAgreementBO agrAgreementBO = new AgrAgreementBO();
                AgreementPO agreementPo = new AgreementPO();
                agreementPo.setAgreementId(bo.getAgreementId());
                AgreementPO modelBy = this.agreementMapper.getModelBy(agreementPo);
                BeanUtils.copyProperties((Object)modelBy, (Object)agrAgreementBO);
                agrSyncBudgetAmtBusiReqBO.setAgrAgreementBO(agrAgreementBO);
                this.agrSyncBudgetAmtBusiService.dealSyncBudgetAmt(agrSyncBudgetAmtBusiReqBO);
            }
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

