/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrBusiRedoQueueBO;
import com.tydic.agreement.ability.bo.AgrBusiRedoReqBO;
import com.tydic.agreement.ability.bo.AgrBusiRedoRspBO;
import com.tydic.agreement.busi.AgrBusiRedoBusiService;
import com.tydic.agreement.constant.AgrBusiRedoStateEnum;
import com.tydic.agreement.dao.BusiRedoFailReasonMapper;
import com.tydic.agreement.dao.BusiRedoQueueMapper;
import com.tydic.agreement.dao.BusiRedoQueueSuccessMapper;
import com.tydic.agreement.dao.po.BusiRedoFailReasonPO;
import com.tydic.agreement.dao.po.BusiRedoQueuePO;
import com.tydic.agreement.dao.po.BusiRedoQueueSuccessPO;
import com.tydic.uac.exception.BusinessException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrBusiRedoBusiServiceImpl
implements AgrBusiRedoBusiService {
    @Autowired
    private BusiRedoQueueMapper busiRedoQueueMapper;
    @Autowired
    private BusiRedoQueueSuccessMapper busiRedoQueueSuccessMapper;
    @Autowired
    private BusiRedoFailReasonMapper busiRedoFailReasonMapper;

    @Override
    public AgrBusiRedoRspBO addRedoTask(AgrBusiRedoReqBO redoReqBo) {
        if (redoReqBo.getBusiRedoQueue() != null) {
            BusiRedoQueuePO po = new BusiRedoQueuePO();
            po.setId(Sequence.getInstance().nextId());
            po.setBusiType(redoReqBo.getBusiRedoQueue().getBusiType());
            po.setRequestParam(redoReqBo.getBusiRedoQueue().getRequestParam());
            po.setRunResult(AgrBusiRedoStateEnum.TO_BE_PROCESSED.getStateCode());
            po.setFailureCount(0);
            po.setFailureReason(null);
            po.setCreateTime(new Date());
            po.setUpdateTime(null);
            int insert = this.busiRedoQueueMapper.insert(po);
            if (insert < 1) {
                throw new BusinessException("8888", "\u65b0\u589e\u5f85\u5904\u7406\u8bb0\u5f55\u5931\u8d25");
            }
        }
        AgrBusiRedoRspBO rspBo = new AgrBusiRedoRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public AgrBusiRedoRspBO updateRedoTaskInProcessing(AgrBusiRedoReqBO redoReqBo) {
        AgrBusiRedoRspBO rspBo = new AgrBusiRedoRspBO();
        BusiRedoQueuePO busiRedoQueuePo = new BusiRedoQueuePO();
        busiRedoQueuePo.setFailureCountIn(Arrays.asList(0, 1, 2, 3, 4, 5));
        busiRedoQueuePo.setRunResultIn(Arrays.asList(AgrBusiRedoStateEnum.TO_BE_PROCESSED.getStateCode(), AgrBusiRedoStateEnum.PROCESSING_FAILED.getStateCode()));
        busiRedoQueuePo.setOrderBy("failure_count asc,id asc");
        Page page = new Page(1, 50);
        List<BusiRedoQueuePO> redoQueueList = this.busiRedoQueueMapper.getListPage(busiRedoQueuePo, (Page<BusiRedoQueuePO>)page);
        if (CollectionUtils.isEmpty(redoQueueList)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        BusiRedoQueuePO busiRedoQueuePoSet = new BusiRedoQueuePO();
        busiRedoQueuePoSet.setRunResult(AgrBusiRedoStateEnum.IN_PROCESS.getStateCode());
        busiRedoQueuePoSet.setUpdateTime(new Date());
        BusiRedoQueuePO busiRedoQueuePoWhere = new BusiRedoQueuePO();
        busiRedoQueuePoWhere.setIdIn(redoQueueList.stream().map(BusiRedoQueuePO::getId).distinct().collect(Collectors.toList()));
        busiRedoQueuePoWhere.setRunResultIn(Arrays.asList(AgrBusiRedoStateEnum.TO_BE_PROCESSED.getStateCode(), AgrBusiRedoStateEnum.PROCESSING_FAILED.getStateCode()));
        busiRedoQueuePoWhere.setFailureCountIn(Arrays.asList(0, 1, 2, 3, 4, 5));
        int count = this.busiRedoQueueMapper.updateBy(busiRedoQueuePoSet, busiRedoQueuePoWhere);
        if (count != busiRedoQueuePoWhere.getIdIn().size()) {
            throw new BusinessException("8888", "\u66f4\u65b0\u72b6\u6001\u4e3a[\u5904\u7406\u4e2d]\u5931\u8d25");
        }
        rspBo.setRedoQueueList(JSONArray.parseArray((String)JSONArray.toJSONString(redoQueueList), AgrBusiRedoQueueBO.class));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public AgrBusiRedoRspBO updateRedoTaskCompleted(AgrBusiRedoReqBO redoReqBo) {
        if (redoReqBo.getBusiRedoQueue() != null) {
            BusiRedoQueueSuccessPO busiRedoQueueSuccessPo = new BusiRedoQueueSuccessPO();
            busiRedoQueueSuccessPo.setId(redoReqBo.getBusiRedoQueue().getId());
            busiRedoQueueSuccessPo.setBusiType(redoReqBo.getBusiRedoQueue().getBusiType());
            busiRedoQueueSuccessPo.setRequestParam(redoReqBo.getBusiRedoQueue().getRequestParam());
            busiRedoQueueSuccessPo.setRunResult(AgrBusiRedoStateEnum.PROCESSING_COMPLETED.getStateCode());
            busiRedoQueueSuccessPo.setFailureCount(redoReqBo.getBusiRedoQueue().getFailureCount());
            busiRedoQueueSuccessPo.setFailureReason(redoReqBo.getBusiRedoQueue().getFailureReason());
            busiRedoQueueSuccessPo.setCreateTime(new Date());
            this.busiRedoQueueSuccessMapper.insert(busiRedoQueueSuccessPo);
            BusiRedoQueuePO redoQueuePODelete = new BusiRedoQueuePO();
            redoQueuePODelete.setId(redoReqBo.getBusiRedoQueue().getId());
            this.busiRedoQueueMapper.deleteBy(redoQueuePODelete);
        }
        AgrBusiRedoRspBO rspBo = new AgrBusiRedoRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public AgrBusiRedoRspBO updateRedoTaskFailed(AgrBusiRedoReqBO redoReqBo) {
        if (redoReqBo.getBusiRedoQueue() != null) {
            Date now = new Date();
            BusiRedoFailReasonPO busiRedoFailReasonPo = new BusiRedoFailReasonPO();
            busiRedoFailReasonPo.setLogId(Sequence.getInstance().nextId());
            busiRedoFailReasonPo.setRedoId(redoReqBo.getBusiRedoQueue().getId());
            busiRedoFailReasonPo.setBusiType(redoReqBo.getBusiRedoQueue().getBusiType());
            busiRedoFailReasonPo.setRequestParam(redoReqBo.getBusiRedoQueue().getRequestParam());
            busiRedoFailReasonPo.setRunResult(AgrBusiRedoStateEnum.PROCESSING_FAILED.getStateCode());
            busiRedoFailReasonPo.setFailureCount(redoReqBo.getBusiRedoQueue().getFailureCount());
            if (redoReqBo.getMsg() != null && redoReqBo.getMsg().length() > 4000) {
                redoReqBo.setMsg(redoReqBo.getMsg().substring(0, 4000));
            }
            busiRedoFailReasonPo.setFailureReason(redoReqBo.getMsg());
            busiRedoFailReasonPo.setCreateTime(now);
            this.busiRedoFailReasonMapper.insert(busiRedoFailReasonPo);
            BusiRedoQueuePO busiRedoQueuePoUpdate = new BusiRedoQueuePO();
            busiRedoQueuePoUpdate.setRunResult(AgrBusiRedoStateEnum.PROCESSING_FAILED.getStateCode());
            busiRedoQueuePoUpdate.setUpdateTime(new Date());
            busiRedoQueuePoUpdate.setFailureCountChange(redoReqBo.getBusiRedoQueue().getFinish() != false ? 6 : 1);
            busiRedoQueuePoUpdate.setFailureReason(redoReqBo.getMsg());
            busiRedoQueuePoUpdate.setId(redoReqBo.getBusiRedoQueue().getId());
            this.busiRedoQueueMapper.updateById(busiRedoQueuePoUpdate);
        }
        AgrBusiRedoRspBO rspBo = new AgrBusiRedoRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public AgrBusiRedoRspBO dealRunningTask(AgrBusiRedoReqBO redoReqBo) {
        AgrBusiRedoRspBO rspBo = new AgrBusiRedoRspBO();
        BusiRedoQueuePO redoQueuePo = new BusiRedoQueuePO();
        redoQueuePo.setRunResult(AgrBusiRedoStateEnum.IN_PROCESS.getStateCode());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(11, -3);
        redoQueuePo.setUpdateTimeEnd(calendar.getTime());
        Page page = new Page(1, 1000);
        List<BusiRedoQueuePO> redoQueueList = this.busiRedoQueueMapper.getListPage(redoQueuePo, (Page<BusiRedoQueuePO>)page);
        if (!CollectionUtils.isEmpty(redoQueueList)) {
            BusiRedoQueuePO busiRedoQueuePoSet = new BusiRedoQueuePO();
            busiRedoQueuePoSet.setRunResult(AgrBusiRedoStateEnum.PROCESSING_FAILED.getStateCode());
            busiRedoQueuePoSet.setUpdateTime(new Date());
            BusiRedoQueuePO busiRedoQueuePoWhere = new BusiRedoQueuePO();
            busiRedoQueuePoWhere.setIdIn(redoQueueList.stream().map(BusiRedoQueuePO::getId).collect(Collectors.toList()));
            busiRedoQueuePoWhere.setRunResult(AgrBusiRedoStateEnum.IN_PROCESS.getStateCode());
            this.busiRedoQueueMapper.updateBy(busiRedoQueuePoSet, busiRedoQueuePoWhere);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

