/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrInstallmentPaymentChangeBO;
import com.tydic.agreement.ability.bo.AgrRelBusiPropLabelBO;
import com.tydic.agreement.ability.bo.BreachRateBO;
import com.tydic.agreement.atom.AgrAgreementStatusChangeAtomService;
import com.tydic.agreement.atom.AgrCheckAgreementChangeExistAndStatusAtomService;
import com.tydic.agreement.atom.AgrCheckAgreementChangeTypeAtomService;
import com.tydic.agreement.atom.AgrCreateCodeAtomService;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCheckAgreementChangeExistAndStatusAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCheckAgreementChangeExistAndStatusAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCheckAgreementChangeTypeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCheckAgreementChangeTypeAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateCodeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateCodeAtomRspBO;
import com.tydic.agreement.busi.AgrCreateAgreementChangeApplyBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementChangeApplyBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementChangeApplyBusiRspBO;
import com.tydic.agreement.common.bo.AgrAgreementAttachBO;
import com.tydic.agreement.common.bo.AgrAgreementBO;
import com.tydic.agreement.common.bo.AgrAgreementChangeAttachBO;
import com.tydic.agreement.common.bo.AgrAgreementChangeBO;
import com.tydic.agreement.common.bo.AgrAgreementMajorChangeBO;
import com.tydic.agreement.common.bo.AgrAgreementScopeChangeBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.common.bo.AgrPlaAgreementChangeCodeBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgrAgreementAttachChangeMapper;
import com.tydic.agreement.dao.AgrAgreementSkuMaterialMapper;
import com.tydic.agreement.dao.AgrInstallmentPaymentChangeMapper;
import com.tydic.agreement.dao.AgrRelBusiPropLabelChangeMapper;
import com.tydic.agreement.dao.AgrRelBusiPropLabelMapper;
import com.tydic.agreement.dao.AgreementChangeAttachMapper;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementMajorChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeChangeMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.BreachRateChangeMapper;
import com.tydic.agreement.dao.SrmContractRelUpperChangeMapper;
import com.tydic.agreement.dao.po.AgrAgreementAttachChangePO;
import com.tydic.agreement.dao.po.AgrAgreementSkuMaterialPO;
import com.tydic.agreement.dao.po.AgrInstallmentPaymentChangePO;
import com.tydic.agreement.dao.po.AgrRelBusiPropLabelChangePO;
import com.tydic.agreement.dao.po.AgreementChangeAttachPO;
import com.tydic.agreement.dao.po.AgreementChangePO;
import com.tydic.agreement.dao.po.AgreementMajorChangePO;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementScopeChangePO;
import com.tydic.agreement.dao.po.AgreementSkuChangePO;
import com.tydic.agreement.dao.po.BreachRatePO;
import com.tydic.agreement.dao.po.SrmContractRelUpperChangePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrCreateAgreementChangeApplyBusiServiceImpl
implements AgrCreateAgreementChangeApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgreementChangeApplyBusiServiceImpl.class);
    @Autowired
    private AgrCheckAgreementChangeTypeAtomService agrCheckAgreementChangeTypeAtomService;
    @Autowired
    private AgrCheckAgreementChangeExistAndStatusAtomService agrCheckAgreementChangeExistAndStatusAtomService;
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private BreachRateChangeMapper breachRateChangeMapper;
    @Autowired
    private AgreementMajorChangeMapper agreementMajorChangeMapper;
    @Autowired
    private AgreementScopeChangeMapper agreementScopeChangeMapper;
    @Autowired
    private AgrAgreementAttachChangeMapper agrAgreementAttachChangeMapper;
    @Autowired
    private AgreementChangeAttachMapper agreementChangeAttachMapper;
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private AgrAgreementStatusChangeAtomService agrAgreementStatusChangeAtomService;
    @Autowired
    private AgrCreateCodeAtomService agrCreateCodeAtomService;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private SrmContractRelUpperChangeMapper srmContractRelUpperChangeMapper;
    @Autowired
    private AgrRelBusiPropLabelChangeMapper agrRelBusiPropLabelChangeMapper;
    @Autowired
    private AgrRelBusiPropLabelMapper agrRelBusiPropLabelMapper;
    @Autowired
    private AgrAgreementSkuMaterialMapper agrAgreementSkuMaterialMapper;
    @Autowired
    private AgrInstallmentPaymentChangeMapper agrInstallmentPaymentChangeMapper;

    public AgrCreateAgreementChangeApplyBusiRspBO createAgreementChangeApply(AgrCreateAgreementChangeApplyBusiReqBO busiReqBO) {
        AgrCreateAgreementChangeApplyBusiRspBO busiRspBO = new AgrCreateAgreementChangeApplyBusiRspBO();
        Boolean addFlag = busiReqBO.getChangeId() == null;
        Long changeId = busiReqBO.getChangeId() != null ? busiReqBO.getChangeId().longValue() : Sequence.getInstance().nextId();
        busiReqBO.setChangeId(changeId);
        AgrAgreementBO agrAgreementBO = this.paramValid(changeId, addFlag, busiReqBO);
        AgreementChangePO agreementChangePO = this.insertOrUpdateAgreementChangeMapper(changeId, addFlag, busiReqBO, agrAgreementBO);
        this.insertAgreementChangeAttachMapper(changeId, addFlag, busiReqBO, agreementChangePO);
        this.modifyOtherTable(changeId, addFlag, busiReqBO, agrAgreementBO, agreementChangePO);
        if (AgrCommConstant.AgrSaveOrSubmit.SUBMIT.equals(busiReqBO.getOperType())) {
            this.createProcess(agrAgreementBO, changeId, addFlag, agreementChangePO);
        }
        if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(agrAgreementBO.getAgreementMode()) && (AgrCommConstant.AgreementChangeType.OTHER.equals(agreementChangePO.getChangeType()) || AgrCommConstant.AgreementChangeType.OPS_CHANGE.equals(agreementChangePO.getChangeType()))) {
            this.insertAgrRelBusiPropLabelChangeMapper(busiReqBO, addFlag, agrAgreementBO);
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u534f\u8bae\u53d8\u66f4\u7533\u8bf7\u65b0\u589e\u6210\u529f");
        busiRspBO.setChangeId(changeId);
        return busiRspBO;
    }

    private void insertAgrRelBusiPropLabelChangeMapper(AgrCreateAgreementChangeApplyBusiReqBO busiReqBO, Boolean addFlag, AgrAgreementBO agrAgreementBO) {
        if (!addFlag.booleanValue()) {
            AgrRelBusiPropLabelChangePO changePO = new AgrRelBusiPropLabelChangePO();
            changePO.setChangeId(busiReqBO.getChangeId());
            changePO.setAgreementId(busiReqBO.getAgreementId());
            this.agrRelBusiPropLabelChangeMapper.deleteBy(changePO);
        }
        int maxVersion = this.agrRelBusiPropLabelMapper.getMaxVersion(busiReqBO.getAgreementId());
        List agrBusiPropLabelList = busiReqBO.getAgrAgreementMajorChangeBO().getBusiPropLabels();
        ArrayList<AgrRelBusiPropLabelChangePO> agrRelBusiPropLabelChangePOS = new ArrayList<AgrRelBusiPropLabelChangePO>(agrBusiPropLabelList.size());
        if (!CollectionUtils.isEmpty((Collection)agrBusiPropLabelList)) {
            for (AgrRelBusiPropLabelBO bo : agrBusiPropLabelList) {
                AgrRelBusiPropLabelChangePO po = new AgrRelBusiPropLabelChangePO();
                BeanUtils.copyProperties((Object)bo, (Object)po);
                Long relId = Sequence.getInstance().nextId();
                po.setRelId(relId);
                po.setAgreementId(agrAgreementBO.getAgreementId());
                po.setChangeCode(busiReqBO.getChangeCode());
                po.setChangeId(busiReqBO.getChangeId());
                po.setCreateUserId(busiReqBO.getUserId());
                po.setCreateUserName(busiReqBO.getUsername());
                po.setCreateTime(new Date());
                po.setVersion(maxVersion + 1);
                agrRelBusiPropLabelChangePOS.add(po);
            }
            int insert = this.agrRelBusiPropLabelChangeMapper.insertBatch(agrRelBusiPropLabelChangePOS);
            if (insert < agrRelBusiPropLabelChangePOS.size()) {
                throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u4e1a\u52a1\u5c5e\u6027\u6807\u7b7e\u5173\u8054\u53d8\u66f4\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private AgrAgreementBO paramValid(Long changeId, Boolean addFlag, AgrCreateAgreementChangeApplyBusiReqBO busiReqBO) {
        Date changeCreateTime = null;
        if (!addFlag.booleanValue()) {
            AgrCheckAgreementChangeExistAndStatusAtomReqBO atomReqBO = new AgrCheckAgreementChangeExistAndStatusAtomReqBO();
            atomReqBO.setChangeId(changeId);
            atomReqBO.setSupplierId(busiReqBO.getSupplierId());
            atomReqBO.setAgreementId(busiReqBO.getAgreementId());
            AgrCheckAgreementChangeExistAndStatusAtomRspBO atomRspBO = this.agrCheckAgreementChangeExistAndStatusAtomService.checkAgreementChangeExistAndStatus(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc() + "\u4e0d\u80fd\u4fdd\u5b58\u6216\u63d0\u4ea4");
            }
            AgrAgreementChangeBO exsitAgrAgreementChangeBO = atomRspBO.getAgrAgreementChangeBO();
            AgrAgreementChangeBO paramAgrAgreementChangeBO = busiReqBO.getAgrAgreementChangeBO();
            paramAgrAgreementChangeBO.setSupplierId(exsitAgrAgreementChangeBO.getSupplierId());
            paramAgrAgreementChangeBO.setAgreementId(exsitAgrAgreementChangeBO.getAgreementId());
            paramAgrAgreementChangeBO.setAgreementVersion(exsitAgrAgreementChangeBO.getAgreementVersion());
            paramAgrAgreementChangeBO.setChangeCode(exsitAgrAgreementChangeBO.getChangeCode());
            paramAgrAgreementChangeBO.setStatus(exsitAgrAgreementChangeBO.getStatus());
            if (paramAgrAgreementChangeBO.getCreateTime() == null) {
                AgreementChangePO agreementChangePO = new AgreementChangePO();
                agreementChangePO.setChangeId(busiReqBO.getChangeId());
                AgreementChangePO daoRsp2 = this.agreementChangeMapper.getModelBy(agreementChangePO);
                if (null == daoRsp2) {
                    throw new BusinessException("22007", "\u53d8\u66f4\u7533\u8bf7\u4e0d\u5b58\u5728");
                }
                paramAgrAgreementChangeBO.setCreateTime(daoRsp2.getCreateTime());
            }
            changeCreateTime = paramAgrAgreementChangeBO.getCreateTime();
        } else {
            AgreementChangePO agreementChangePO = new AgreementChangePO();
            agreementChangePO.setChangeCode(busiReqBO.getChangeCode());
            AgreementChangePO daoRsp = this.agreementChangeMapper.getModelBy(agreementChangePO);
            if (null != daoRsp) {
                throw new BusinessException("22007", "\u53d8\u66f4\u7533\u8bf7\u7f16\u53f7\u5df2\u5b58\u5728");
            }
        }
        AgrCheckAgreementChangeTypeAtomReqBO changeTypeAtomReqBO = new AgrCheckAgreementChangeTypeAtomReqBO();
        changeTypeAtomReqBO.setAgreementId(busiReqBO.getAgreementId());
        changeTypeAtomReqBO.setSupplierId(busiReqBO.getSupplierId());
        changeTypeAtomReqBO.setChangeType(busiReqBO.getAgrAgreementChangeBO().getChangeType());
        AgrCheckAgreementChangeTypeAtomRspBO changeTypeAtomRspBO = this.agrCheckAgreementChangeTypeAtomService.checkAgreementChangeType(changeTypeAtomReqBO);
        if (!"0000".equals(changeTypeAtomRspBO.getRespCode())) {
            throw new BusinessException(changeTypeAtomRspBO.getRespCode(), changeTypeAtomRspBO.getRespDesc());
        }
        AgrAgreementBO agrAgreementBO = changeTypeAtomRspBO.getAgrAgreementBO();
        if (addFlag.booleanValue()) {
            AgrCreateCodeAtomReqBO atomReqBO = new AgrCreateCodeAtomReqBO();
            AgrPlaAgreementChangeCodeBO plaAgreementChangeCodeBO = new AgrPlaAgreementChangeCodeBO();
            plaAgreementChangeCodeBO.setChangeType(this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "CHANGE_TYPE_PCODE", busiReqBO.getAgrAgreementChangeBO().getChangeType().toString()));
            plaAgreementChangeCodeBO.setPlaAgreementCode(agrAgreementBO.getPlaAgreementCode());
            atomReqBO.setCodeType(AgrCommConstant.CreateCodeType.CHNAGE_CODE);
            atomReqBO.setPlaAgreementChangeCodeBO(plaAgreementChangeCodeBO);
            AgrCreateCodeAtomRspBO agrCreateCodeAtomRspBO = this.agrCreateCodeAtomService.createCode(atomReqBO);
            if (!"0000".equals(agrCreateCodeAtomRspBO.getRespCode())) {
                throw new BusinessException(agrCreateCodeAtomRspBO.getRespCode(), agrCreateCodeAtomRspBO.getRespDesc());
            }
            if (!busiReqBO.getChangeCode().equals(agrCreateCodeAtomRspBO.getCode())) {
                throw new BusinessException("0002", "\u7533\u8bf7\u7f16\u53f7\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u901a\u8fc7\u7f16\u53f7\u83b7\u53d6\u63a5\u53e3\u83b7\u53d6\u7f16\u53f7");
            }
        }
        this.selfValid(busiReqBO, agrAgreementBO);
        agrAgreementBO.setChangeCreateTime(changeCreateTime);
        return agrAgreementBO;
    }

    private void selfValid(AgrCreateAgreementChangeApplyBusiReqBO busiReqBO, AgrAgreementBO agrAgreementBO) {
        AgrAgreementChangeBO agrAgreementChangeBO = busiReqBO.getAgrAgreementChangeBO();
        if (AgrCommConstant.AgreementChangeType.DELAY.equals(agrAgreementChangeBO.getChangeType())) {
            if (agrAgreementChangeBO.getPostInvalidDate().compareTo(agrAgreementBO.getExpDate()) < 0) {
                throw new BusinessException("0002", "\u53d8\u66f4\u540e\u534f\u8bae\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u534f\u8bae\u5f53\u524d\u5931\u6548\u65f6\u95f4");
            }
            agrAgreementChangeBO.setPreInvalidDate(agrAgreementBO.getExpDate());
            return;
        }
    }

    private AgreementChangePO insertOrUpdateAgreementChangeMapper(Long changeId, Boolean addFlag, AgrCreateAgreementChangeApplyBusiReqBO busiReqBO, AgrAgreementBO agrAgreementBO) {
        AgrAgreementChangeBO agrAgreementChangeBO = busiReqBO.getAgrAgreementChangeBO();
        AgreementChangePO agreementChangePO = new AgreementChangePO();
        BeanUtils.copyProperties((Object)agrAgreementChangeBO, (Object)agreementChangePO);
        if (AgrCommConstant.AgrSaveOrSubmit.SAVE.equals(busiReqBO.getOperType())) {
            agreementChangePO.setStatus(AgrCommConstant.ChangeApplyStatus.DRAFT);
        } else if (AgrCommConstant.AgrSaveOrSubmit.SUBMIT.equals(busiReqBO.getOperType())) {
            agreementChangePO.setStatus(AgrCommConstant.ChangeApplyStatus.IN_AUDIT);
        } else {
            throw new BusinessException("0002", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u652f\u6301");
        }
        int checkedWZVariety = this.agreementSkuChangeMapper.checkWZVariety(busiReqBO.getChangeCode(), busiReqBO.getAgreementId(), new HashSet<Integer>(Arrays.asList(AgrEnum.Variety.GC.getCode(), AgrEnum.Variety.FW.getCode())));
        if (addFlag.booleanValue()) {
            int count;
            agreementChangePO.setChangeCode(busiReqBO.getChangeCode());
            agreementChangePO.setAgreementId(busiReqBO.getAgreementId());
            agreementChangePO.setSupplierId(agrAgreementBO.getSupplierId());
            agreementChangePO.setAgreementVersion(agrAgreementBO.getAgreementVersion());
            agreementChangePO.setChangeId(changeId);
            agreementChangePO.setCreateTime(new Date());
            agreementChangePO.setCreateName(busiReqBO.getUsername());
            agreementChangePO.setOperateTime(new Date());
            agreementChangePO.setCreateLoginId(busiReqBO.getMemIdIn());
            if (busiReqBO.getAgrAgreementChangeBO().getChangeType().equals(AgrCommConstant.AgreementChangeType.SUPPLEMENT) && checkedWZVariety > 1 && !AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(agrAgreementBO.getRelSystem())) {
                agreementChangePO.setCorrectFlag(Byte.valueOf("1"));
            }
            if ((count = this.agreementChangeMapper.insert(agreementChangePO)) < 1) {
                throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u53d8\u66f4\u8868\u5931\u8d25\uff01");
            }
        } else {
            int count;
            agreementChangePO.setChangeId(changeId);
            agreementChangePO.setAgreementId(busiReqBO.getAgreementId());
            agreementChangePO.setSupplierId(agrAgreementBO.getSupplierId());
            agreementChangePO.setUpdateLoginId(busiReqBO.getMemIdIn());
            agreementChangePO.setUpdateTime(new Date());
            agreementChangePO.setUpdateName(busiReqBO.getUsername());
            agreementChangePO.setAgreementVersion(agrAgreementBO.getAgreementVersion());
            if (busiReqBO.getAgrAgreementChangeBO().getChangeType().equals(AgrCommConstant.AgreementChangeType.SUPPLEMENT) && checkedWZVariety > 1 && !AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(agrAgreementBO.getRelSystem())) {
                agreementChangePO.setCorrectFlag(Byte.valueOf("1"));
            }
            if ((count = this.agreementChangeMapper.updateBy(agreementChangePO)) < 1) {
                throw new BusinessException("22005", "\u4fee\u6539\u534f\u8bae\u53d8\u66f4\u7533\u8bf7\u8868\u5931\u8d25\uff01");
            }
            agreementChangePO.setCreateTime(agrAgreementBO.getChangeCreateTime());
        }
        return agreementChangePO;
    }

    private void insertAgreementChangeAttachMapper(Long changeId, Boolean addFlag, AgrCreateAgreementChangeApplyBusiReqBO busiReqBO, AgreementChangePO agreementChangePO) {
        if (!addFlag.booleanValue()) {
            AgreementChangeAttachPO agreementChangeAttachPO = new AgreementChangeAttachPO();
            agreementChangeAttachPO.setAgreementId(agreementChangePO.getAgreementId());
            agreementChangeAttachPO.setSupplierId(agreementChangePO.getSupplierId());
            agreementChangeAttachPO.setChangeCode(agreementChangePO.getChangeCode());
            agreementChangeAttachPO.setChangeId(changeId);
            this.agreementChangeAttachMapper.deleteBy(agreementChangeAttachPO);
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementChangeAttachBOs())) {
            ArrayList<AgreementChangeAttachPO> agreementChangeAttachPOS = new ArrayList<AgreementChangeAttachPO>();
            for (AgrAgreementChangeAttachBO bo : busiReqBO.getAgrAgreementChangeAttachBOs()) {
                AgreementChangeAttachPO agreementChangeAttachPO = new AgreementChangeAttachPO();
                agreementChangeAttachPO.setChangeId(changeId);
                agreementChangeAttachPO.setChangeCode(agreementChangePO.getChangeCode());
                agreementChangeAttachPO.setCreateLoginId(busiReqBO.getMemIdIn());
                agreementChangeAttachPO.setCreateName(busiReqBO.getUsername());
                agreementChangeAttachPO.setCreateTime(new Date());
                agreementChangeAttachPO.setAgreementId(agreementChangePO.getAgreementId());
                agreementChangeAttachPO.setAttachmentAddr(bo.getAttachmentAddr());
                agreementChangeAttachPO.setAttachmentName(bo.getAttachmentName());
                agreementChangeAttachPO.setRemark(bo.getRemark());
                agreementChangeAttachPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                agreementChangeAttachPO.setSupplierId(agreementChangePO.getSupplierId());
                agreementChangeAttachPO.setAttachmentType(bo.getAttachmentType());
                agreementChangeAttachPOS.add(agreementChangeAttachPO);
            }
            int isInsert3 = this.agreementChangeAttachMapper.insertBatch(agreementChangeAttachPOS);
            if (isInsert3 != agreementChangeAttachPOS.size()) {
                throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u53d8\u66f4\u9644\u4ef6\u8868\u5931\u8d25\uff01");
            }
        }
    }

    private void modifyOtherTable(Long changeId, Boolean addFlag, AgrCreateAgreementChangeApplyBusiReqBO busiReqBO, AgrAgreementBO agrAgreementBO, AgreementChangePO agreementChangePO) {
        Byte changeType = busiReqBO.getAgrAgreementChangeBO().getChangeType();
        switch (changeType) {
            case 1: {
                this.updateAgreementStatus(agreementChangePO);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.updateAgreementStatus(agreementChangePO);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.insertAgreementChangeSubject(changeId, addFlag, busiReqBO, agrAgreementBO, agreementChangePO);
                break;
            }
            case 8: {
                this.updateAgreementStatus(agreementChangePO);
                break;
            }
            case 9: {
                this.insertAgreementChangeSubject(changeId, addFlag, busiReqBO, agrAgreementBO, agreementChangePO);
                break;
            }
            case 10: {
                this.updateAgreementSkuMaterial(agreementChangePO);
                break;
            }
            case 11: {
                this.insertAgreementChangeSubject(changeId, addFlag, busiReqBO, agrAgreementBO, agreementChangePO);
                break;
            }
            default: {
                throw new BusinessException("0002", "\u53d8\u66f4\u7c7b\u578b\u3010" + changeType + "\u3011\u4e0d\u652f\u6301");
            }
        }
        this.updateAgreementSkuChangeMapper(changeId, busiReqBO, agreementChangePO);
    }

    private void updateAgreementStatus(AgreementChangePO agreementChangePO) {
        if (AgrCommConstant.ChangeApplyStatus.IN_AUDIT.equals(agreementChangePO.getStatus())) {
            AgrAgreementStatusChangeAtomReqBO atomReqBO = new AgrAgreementStatusChangeAtomReqBO();
            HashSet<Long> agreementIds = new HashSet<Long>();
            agreementIds.add(agreementChangePO.getAgreementId());
            atomReqBO.setAgreementIds(agreementIds);
            atomReqBO.setSupplierId(agreementChangePO.getSupplierId());
            atomReqBO.setMemIdIn(agreementChangePO.getCreateLoginId());
            atomReqBO.setUsername(agreementChangePO.getCreateName());
            atomReqBO.setAgreementStatusPre(AgrCommConstant.AgreementStatus.ENABLE);
            atomReqBO.setAgreementStatusPost(AgrCommConstant.AgreementStatus.FROZEN);
            atomReqBO.setUpdateTime(agreementChangePO.getCreateTime());
            AgrAgreementStatusChangeAtomRspBO atomRspBO = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
        }
    }

    private void updateAgreementSkuMaterial(AgreementChangePO agreementChangePO) {
        AgrAgreementSkuMaterialPO setPO = new AgrAgreementSkuMaterialPO();
        setPO.setChangeId(agreementChangePO.getChangeId());
        AgrAgreementSkuMaterialPO wherePO = new AgrAgreementSkuMaterialPO();
        wherePO.setExtField1(agreementChangePO.getChangeCode());
        this.agrAgreementSkuMaterialMapper.updateBy(setPO, wherePO);
    }

    private void insertAgreementChangeSubject(Long changeId, Boolean addFlag, AgrCreateAgreementChangeApplyBusiReqBO busiReqBO, AgrAgreementBO agrAgreementBO, AgreementChangePO agreementChangePO) {
        List<AgrInstallmentPaymentChangePO> agrInstallmentPaymentChangePOS;
        int count;
        AgrAgreementMajorChangeBO agrAgreementMajorChangeBO = busiReqBO.getAgrAgreementMajorChangeBO();
        if (!addFlag.booleanValue()) {
            AgreementMajorChangePO deleteAgreementMajorChangePO = new AgreementMajorChangePO();
            deleteAgreementMajorChangePO.setAgreementId(busiReqBO.getAgreementId());
            deleteAgreementMajorChangePO.setChangeId(changeId);
            deleteAgreementMajorChangePO.setSupplierId(busiReqBO.getSupplierId());
            this.agreementMajorChangeMapper.deleteBy(deleteAgreementMajorChangePO);
            AgreementScopeChangePO deleteAgreementScopeChangePO = new AgreementScopeChangePO();
            deleteAgreementScopeChangePO.setAgreementId(busiReqBO.getAgreementId());
            deleteAgreementScopeChangePO.setChangeId(changeId);
            deleteAgreementScopeChangePO.setSupplierId(busiReqBO.getSupplierId());
            this.agreementScopeChangeMapper.deleteBy(deleteAgreementScopeChangePO);
            AgrAgreementAttachChangePO deleteAgrAgreementAttachChangePO = new AgrAgreementAttachChangePO();
            deleteAgrAgreementAttachChangePO.setAgreementId(busiReqBO.getAgreementId());
            deleteAgrAgreementAttachChangePO.setChangeId(changeId);
            deleteAgrAgreementAttachChangePO.setSupplierId(busiReqBO.getSupplierId());
            this.agrAgreementAttachChangeMapper.deleteBy(deleteAgrAgreementAttachChangePO);
            if (AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(agrAgreementBO.getRelSystem())) {
                SrmContractRelUpperChangePO srmContractRelUpperChangePo = new SrmContractRelUpperChangePO();
                srmContractRelUpperChangePo.setChangeId(changeId);
                srmContractRelUpperChangePo.setAgreementId(busiReqBO.getAgreementId());
                this.srmContractRelUpperChangeMapper.deleteBy(srmContractRelUpperChangePo);
            }
            AgrInstallmentPaymentChangePO agrInstallmentPaymentChangePO = new AgrInstallmentPaymentChangePO();
            agrInstallmentPaymentChangePO.setChangeId(changeId);
            agrInstallmentPaymentChangePO.setAgreementId(busiReqBO.getAgreementId());
            this.agrInstallmentPaymentChangeMapper.deleteBy(agrInstallmentPaymentChangePO);
        }
        AgreementMajorChangePO addAgreementMajorChangePO = new AgreementMajorChangePO();
        BeanUtils.copyProperties((Object)agrAgreementBO, (Object)addAgreementMajorChangePO);
        addAgreementMajorChangePO.setChangeId(changeId);
        addAgreementMajorChangePO.setChangeCode(agreementChangePO.getChangeCode());
        addAgreementMajorChangePO.setMajorChangeId(Sequence.getInstance().nextId());
        addAgreementMajorChangePO.setUpdateLoginId(busiReqBO.getMemIdIn());
        addAgreementMajorChangePO.setUpdateName(busiReqBO.getUsername());
        addAgreementMajorChangePO.setUpdateTime(new Date());
        addAgreementMajorChangePO.setVendorContact(agrAgreementMajorChangeBO.getVendorContact());
        addAgreementMajorChangePO.setVendorPhone(agrAgreementMajorChangeBO.getVendorPhone());
        addAgreementMajorChangePO.setMatPaySup(agrAgreementMajorChangeBO.getMatPaySup());
        addAgreementMajorChangePO.setProPaySup(agrAgreementMajorChangeBO.getProPaySup());
        addAgreementMajorChangePO.setVerPaySup(agrAgreementMajorChangeBO.getVerPaySup());
        addAgreementMajorChangePO.setPilPaySup(agrAgreementMajorChangeBO.getPilPaySup());
        addAgreementMajorChangePO.setQuaPaySup(agrAgreementMajorChangeBO.getQuaPaySup());
        addAgreementMajorChangePO.setPrePaySup(agrAgreementMajorChangeBO.getPrePaySup());
        addAgreementMajorChangePO.setPayClause(agrAgreementMajorChangeBO.getPayClause());
        addAgreementMajorChangePO.setWarantty(agrAgreementMajorChangeBO.getWarantty());
        addAgreementMajorChangePO.setScopeType(agrAgreementMajorChangeBO.getScopeType());
        addAgreementMajorChangePO.setAdjustPrice(agrAgreementMajorChangeBO.getAdjustPrice());
        addAgreementMajorChangePO.setAcceptanceScale(agrAgreementMajorChangeBO.getAcceptanceScale());
        addAgreementMajorChangePO.setAdjustAcceptance(agrAgreementMajorChangeBO.getAdjustAcceptance());
        addAgreementMajorChangePO.setDifferencesAcceptance(agrAgreementMajorChangeBO.getDifferencesAcceptance());
        addAgreementMajorChangePO.setEcpPurType(agrAgreementMajorChangeBO.getEcpPurType());
        addAgreementMajorChangePO.setAcceptHigher(agrAgreementMajorChangeBO.getAcceptHigher());
        addAgreementMajorChangePO.setApproveLower(agrAgreementMajorChangeBO.getApproveLower());
        addAgreementMajorChangePO.setOrderLimit(agrAgreementMajorChangeBO.getOrderLimit());
        addAgreementMajorChangePO.setAgreementPic(agrAgreementMajorChangeBO.getAgreementPic());
        addAgreementMajorChangePO.setEcpProjectId(agrAgreementMajorChangeBO.getEcpProjectId());
        addAgreementMajorChangePO.setEcpProjectName(agrAgreementMajorChangeBO.getEcpProjectName());
        addAgreementMajorChangePO.setEntAgreementCode(agrAgreementMajorChangeBO.getEntAgreementCode());
        addAgreementMajorChangePO.setPaymentDays(agrAgreementMajorChangeBO.getPaymentDays());
        addAgreementMajorChangePO.setPaymentExtendDays(agrAgreementMajorChangeBO.getPaymentExtendDays());
        addAgreementMajorChangePO.setPayMethod(agrAgreementMajorChangeBO.getPayMethod());
        addAgreementMajorChangePO.setPaymentMethod(agrAgreementMajorChangeBO.getPaymentMethod());
        addAgreementMajorChangePO.setBreach(agrAgreementMajorChangeBO.getBreach());
        addAgreementMajorChangePO.setBreachLimit(agrAgreementMajorChangeBO.getBreachLimit());
        addAgreementMajorChangePO.setAgreementShortName(agrAgreementMajorChangeBO.getAgreementShortName());
        addAgreementMajorChangePO.setAgreementTentativeAmount(agrAgreementMajorChangeBO.getAgreementTentativeAmount());
        addAgreementMajorChangePO.setAgreementType(agrAgreementMajorChangeBO.getAgreementType());
        addAgreementMajorChangePO.setUpperContractId(agrAgreementMajorChangeBO.getUpperContractId());
        addAgreementMajorChangePO.setUpperContractCode(agrAgreementMajorChangeBO.getUpperContractCode());
        addAgreementMajorChangePO.setExtContractId(agrAgreementMajorChangeBO.getExtContractId());
        addAgreementMajorChangePO.setExtContractCode(agrAgreementMajorChangeBO.getExtContractCode());
        addAgreementMajorChangePO.setRelSystem(agrAgreementMajorChangeBO.getRelSystem());
        addAgreementMajorChangePO.setSrmPaymentTerms(agrAgreementMajorChangeBO.getSrmPaymentTerms());
        addAgreementMajorChangePO.setSrmComments(agrAgreementMajorChangeBO.getSrmComments());
        addAgreementMajorChangePO.setCentralizedCategory(agrAgreementMajorChangeBO.getCentralizedCategory());
        addAgreementMajorChangePO.setAdjustPaymentStage(agrAgreementMajorChangeBO.getAdjustPaymentStage());
        addAgreementMajorChangePO.setRemark(agrAgreementMajorChangeBO.getRemark());
        if (AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(agrAgreementBO.getRelSystem())) {
            addAgreementMajorChangePO.setPayMethod(AgrEnum.PayMethod.JDBLFK.getCode());
            addAgreementMajorChangePO.setPaymentMethod(AgrEnum.PaymentMethod.YS.getCode());
            addAgreementMajorChangePO.setPrePaySup(BigDecimal.ZERO);
            addAgreementMajorChangePO.setVerPaySup(BigDecimal.ZERO);
            addAgreementMajorChangePO.setPilPaySup(new BigDecimal("100"));
            addAgreementMajorChangePO.setQuaPaySup(BigDecimal.ZERO);
            ArrayList<AgrInstallmentPaymentChangeBO> agrInstallmentPaymentChangeBOS = new ArrayList<AgrInstallmentPaymentChangeBO>();
            AgrInstallmentPaymentChangeBO prePaySup = new AgrInstallmentPaymentChangeBO();
            prePaySup.setOrdered(Integer.valueOf(0));
            prePaySup.setStageName("\u9884\u4ed8\u6b3e");
            prePaySup.setStageValue(BigDecimal.ZERO);
            agrInstallmentPaymentChangeBOS.add(prePaySup);
            AgrInstallmentPaymentChangeBO verPaySup = new AgrInstallmentPaymentChangeBO();
            verPaySup.setOrdered(Integer.valueOf(1));
            verPaySup.setStageName("\u5230\u8d27\u6b3e");
            verPaySup.setStageValue(BigDecimal.ZERO);
            agrInstallmentPaymentChangeBOS.add(verPaySup);
            AgrInstallmentPaymentChangeBO pilPaySup = new AgrInstallmentPaymentChangeBO();
            pilPaySup.setOrdered(Integer.valueOf(2));
            pilPaySup.setStageName("\u9a8c\u6536\u6b3e");
            pilPaySup.setStageValue(new BigDecimal("100"));
            agrInstallmentPaymentChangeBOS.add(pilPaySup);
            AgrInstallmentPaymentChangeBO quaPaySup = new AgrInstallmentPaymentChangeBO();
            quaPaySup.setOrdered(Integer.valueOf(3));
            quaPaySup.setStageName("\u8d28\u4fdd\u91d1");
            quaPaySup.setStageValue(BigDecimal.ZERO);
            agrInstallmentPaymentChangeBOS.add(quaPaySup);
            busiReqBO.setAgrInstallmentPaymentChangeBOs(agrInstallmentPaymentChangeBOS);
        }
        if ((count = this.agreementMajorChangeMapper.insert(addAgreementMajorChangePO)) < 1) {
            throw new BusinessException("22005", "\u65b0\u589e\u534f\u8bae\u53d8\u66f4\u4e3b\u4f53\u8868\u5931\u8d25");
        }
        ArrayList<AgreementScopeChangePO> agreementScopeChangePOS = new ArrayList<AgreementScopeChangePO>();
        List agrAgreementScopeChangeBOs = agrAgreementMajorChangeBO.getAgrAgreementScopeBOs();
        if (!CollectionUtils.isEmpty((Collection)agrAgreementScopeChangeBOs)) {
            for (AgrAgreementScopeChangeBO bo2 : agrAgreementScopeChangeBOs) {
                AgreementScopeChangePO agreementScopeChangePO = new AgreementScopeChangePO();
                Long scopeChangeId = Sequence.getInstance().nextId();
                Long scopeId = Sequence.getInstance().nextId();
                agreementScopeChangePO.setChangeId(changeId);
                agreementScopeChangePO.setScopeChangeId(scopeChangeId);
                agreementScopeChangePO.setScopeId(scopeId);
                agreementScopeChangePO.setAgreementId(agrAgreementBO.getAgreementId());
                agreementScopeChangePO.setAgreementVersion(agrAgreementBO.getAgreementVersion());
                agreementScopeChangePO.setSupplierId(agreementChangePO.getSupplierId());
                agreementScopeChangePO.setScopeType(addAgreementMajorChangePO.getScopeType());
                agreementScopeChangePO.setScopeCode(bo2.getScopeCode());
                agreementScopeChangePO.setScopeName(bo2.getScopeName());
                agreementScopeChangePO.setScopeMode(bo2.getScopeMode() == null ? AgrCommConstant.ScopeMode.THIS_AND_ALL_UNITS_AND_DEPARTMENTS_BELOW : bo2.getScopeMode());
                agreementScopeChangePO.setVisible(bo2.getVisible());
                agreementScopeChangePO.setRemark(bo2.getRemark());
                agreementScopeChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                agreementScopeChangePO.setCreateLoginId(busiReqBO.getMemIdIn());
                agreementScopeChangePO.setCreateName(busiReqBO.getUsername());
                agreementScopeChangePO.setCreateTime(new Date());
                agreementScopeChangePO.setChangeCode(agreementChangePO.getChangeCode());
                agreementScopeChangePOS.add(agreementScopeChangePO);
            }
            int isInsert4 = this.agreementScopeChangeMapper.insertBatch(agreementScopeChangePOS);
            if (isInsert4 != agreementScopeChangePOS.size()) {
                throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u5e94\u7528\u8303\u56f4\u53d8\u66f4\u8868\u5931\u8d25\uff01");
            }
        }
        ArrayList<AgrAgreementAttachChangePO> agreementAttachChangePOS = new ArrayList<AgrAgreementAttachChangePO>();
        List agrAgreementAttachBOs = agrAgreementMajorChangeBO.getAgrAgreementAttachBOs();
        if (!CollectionUtils.isEmpty((Collection)agrAgreementAttachBOs)) {
            for (AgrAgreementAttachBO bo3 : agrAgreementAttachBOs) {
                AgrAgreementAttachChangePO agrAgreementAttachChangePO = new AgrAgreementAttachChangePO();
                agrAgreementAttachChangePO.setAttachmentChangeId(Sequence.getInstance().nextId());
                agrAgreementAttachChangePO.setAttachmentId(Sequence.getInstance().nextId());
                agrAgreementAttachChangePO.setChangeId(changeId);
                agrAgreementAttachChangePO.setChangeCode(agreementChangePO.getChangeCode());
                agrAgreementAttachChangePO.setAgreementId(agrAgreementBO.getAgreementId());
                agrAgreementAttachChangePO.setAgreementVersion(agrAgreementBO.getAgreementVersion());
                agrAgreementAttachChangePO.setSupplierId(agreementChangePO.getSupplierId());
                agrAgreementAttachChangePO.setAttachmentName(bo3.getAttachmentName());
                agrAgreementAttachChangePO.setAttachmentAddr(bo3.getAttachmentAddr());
                agrAgreementAttachChangePO.setAttachmentType(bo3.getAttachmentType());
                agrAgreementAttachChangePO.setCreateLoginId(busiReqBO.getMemIdIn());
                agrAgreementAttachChangePO.setCreateName(busiReqBO.getUsername());
                agrAgreementAttachChangePO.setCreateTime(new Date());
                agrAgreementAttachChangePO.setRemark(bo3.getRemark());
                agrAgreementAttachChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                agreementAttachChangePOS.add(agrAgreementAttachChangePO);
            }
            int isInsert5 = this.agrAgreementAttachChangeMapper.insertBatch(agreementAttachChangePOS);
            if (isInsert5 != agreementAttachChangePOS.size()) {
                throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u9644\u4ef6\u53d8\u66f4\u8868\u5931\u8d25\uff01");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)agrAgreementMajorChangeBO.getBreachRateList())) {
            this.breachRateChangeMapper.deleteByRelateId(agrAgreementMajorChangeBO.getChangeId(), null);
            ArrayList<BreachRatePO> breachRateList = new ArrayList<BreachRatePO>();
            for (BreachRateBO breachRateBO : agrAgreementMajorChangeBO.getBreachRateList()) {
                BreachRatePO breachRatePO = new BreachRatePO();
                breachRatePO.setExtField1(changeId.toString());
                breachRatePO.setExtField2(breachRateBO.getExtField2());
                breachRatePO.setExtField3(breachRateBO.getExtField3());
                breachRatePO.setRate(breachRateBO.getRate() == null ? BigDecimal.ZERO : breachRateBO.getRate());
                breachRatePO.setEnd(breachRateBO.getEnd());
                breachRatePO.setStart(breachRateBO.getStart());
                breachRatePO.setRelateId(changeId);
                breachRatePO.setRateId(Sequence.getInstance().nextId());
                breachRateList.add(breachRatePO);
            }
            this.breachRateChangeMapper.insertBatch(breachRateList);
        }
        if (AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(agrAgreementBO.getRelSystem())) {
            SrmContractRelUpperChangePO srmContractRelUpperChangePo = new SrmContractRelUpperChangePO();
            srmContractRelUpperChangePo.setChangeId(changeId);
            srmContractRelUpperChangePo.setAgreementId(busiReqBO.getAgreementId());
            srmContractRelUpperChangePo.setUpperContractCode(agrAgreementMajorChangeBO.getUpperContractCode());
            srmContractRelUpperChangePo.setUpperContractId(agrAgreementMajorChangeBO.getUpperContractId());
            srmContractRelUpperChangePo.setCreateTime(new Date());
            srmContractRelUpperChangePo.setCreateOperId(busiReqBO.getUserId());
            srmContractRelUpperChangePo.setCreateOperName(busiReqBO.getUsername());
            this.srmContractRelUpperChangeMapper.insert(srmContractRelUpperChangePo);
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrInstallmentPaymentChangeBOs()) && !CollectionUtils.isEmpty(agrInstallmentPaymentChangePOS = busiReqBO.getAgrInstallmentPaymentChangeBOs().stream().map(bo -> {
            AgrInstallmentPaymentChangePO changePO = new AgrInstallmentPaymentChangePO();
            changePO.setId(Sequence.getInstance().nextId());
            changePO.setChangeCode(agreementChangePO.getChangeCode());
            changePO.setChangeId(changeId);
            changePO.setAgreementId(busiReqBO.getAgreementId());
            changePO.setStageName(bo.getStageName());
            changePO.setStageValue(bo.getStageValue());
            changePO.setStageClause(bo.getStageClause());
            changePO.setOrdered(bo.getOrdered());
            changePO.setPaymentDays(bo.getPaymentDays());
            return changePO;
        }).collect(Collectors.toList()))) {
            this.agrInstallmentPaymentChangeMapper.insertBatch(agrInstallmentPaymentChangePOS);
        }
    }

    private void updateAgreementSkuChangeMapper(Long changeId, AgrCreateAgreementChangeApplyBusiReqBO busiReqBO, AgreementChangePO agreementChangePO) {
        this.insertAgreementSkuChange(busiReqBO, agreementChangePO);
        AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
        agreementSkuChangePO.setChangeId(changeId);
        agreementSkuChangePO.setAgreementVersion(agreementChangePO.getAgreementVersion());
        agreementSkuChangePO.setSupplierId(agreementChangePO.getSupplierId());
        agreementSkuChangePO.setAgreementId(agreementChangePO.getAgreementId());
        agreementSkuChangePO.setChangeCode(agreementChangePO.getChangeCode());
        this.agreementSkuChangeMapper.updateChangeInfoBy(agreementSkuChangePO);
    }

    private void createProcess(AgrAgreementBO agrAgreementBO, Long changeId, Boolean addFlag, AgreementChangePO agreementChangePO) {
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_ADD_AUDIT);
        approvalObjBO.setObjId(changeId.toString());
        approvalObjInfo.add(approvalObjBO);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> uacNoTaskAuditCreateInfoReqBOs = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_ADD_AUDIT);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(agreementChangePO.getAgreementId());
        uacNoTaskAuditCreateInfoReqBO.setRemark("\u534f\u8bae\u53d8\u66f4\u7533\u8bf7\u65b0\u589e\u5ba1\u6279");
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateInfoReqBOs.add(uacNoTaskAuditCreateInfoReqBO);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(agrAgreementBO.getAgreementMode())) {
            uacNoTaskAuditCreateReqBO.setProcDefKey("agreementPlatChangeAudit");
        } else if (AgrCommConstant.agreementMode.UNIT_AGREEMENT.equals(agrAgreementBO.getAgreementMode())) {
            uacNoTaskAuditCreateReqBO.setProcDefKey("agreementPurchaseChangeAudit");
        }
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setCreateOperDept("");
        if (addFlag.booleanValue()) {
            uacNoTaskAuditCreateReqBO.setCreateOperId(agreementChangePO.getCreateLoginId().toString());
            uacNoTaskAuditCreateReqBO.setCreateOperName(agreementChangePO.getCreateName());
        } else {
            uacNoTaskAuditCreateReqBO.setCreateOperId(agreementChangePO.getUpdateLoginId().toString());
            uacNoTaskAuditCreateReqBO.setCreateOperName(agreementChangePO.getUpdateName());
        }
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacNoTaskAuditCreateInfoReqBOs);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.debug("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setSupplierId(agreementChangePO.getSupplierId());
        agreementPO.setAgreementId(agreementChangePO.getAgreementId());
        agreementPO.setMaterialNameSum(changeId.toString());
        int count = this.agreementMapper.updateByCondition(agreementPO);
        if (count != 1) {
            throw new BusinessException("22005", "\u5c06\u53d8\u66f4Id\u66f4\u65b0\u5230\u534f\u8bae\u8868\u5931\u8d25");
        }
        AgreementMajorChangePO agreementMajorChangePO = new AgreementMajorChangePO();
        agreementMajorChangePO.setAgreementId(agreementChangePO.getAgreementId());
        agreementMajorChangePO.setChangeId(agreementChangePO.getChangeId());
        agreementMajorChangePO.setSupplierId(agreementChangePO.getSupplierId());
        agreementMajorChangePO.setAgreementVersion(agreementChangePO.getAgreementVersion());
        this.agreementMajorChangeMapper.updateBy(agreementMajorChangePO);
        AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
        agreementSkuChangePO.setAgreementId(agreementChangePO.getAgreementId());
        agreementSkuChangePO.setChangeId(agreementChangePO.getChangeId());
        agreementSkuChangePO.setSupplierId(agreementChangePO.getSupplierId());
        agreementSkuChangePO.setAgreementVersion(agreementChangePO.getAgreementVersion());
        this.agreementSkuChangeMapper.updateBy(agreementSkuChangePO);
        AgreementScopeChangePO agreementScopeChangePO = new AgreementScopeChangePO();
        agreementScopeChangePO.setAgreementId(agreementChangePO.getAgreementId());
        agreementScopeChangePO.setChangeId(agreementChangePO.getChangeId());
        agreementScopeChangePO.setSupplierId(agreementChangePO.getSupplierId());
        agreementScopeChangePO.setAgreementVersion(agreementChangePO.getAgreementVersion());
        this.agreementScopeChangeMapper.updateBy(agreementScopeChangePO);
        AgrAgreementAttachChangePO agrAgreementAttachChangePO = new AgrAgreementAttachChangePO();
        agrAgreementAttachChangePO.setAgreementId(agreementChangePO.getAgreementId());
        agrAgreementAttachChangePO.setChangeId(agreementChangePO.getChangeId());
        agrAgreementAttachChangePO.setSupplierId(agreementChangePO.getSupplierId());
        agrAgreementAttachChangePO.setAgreementVersion(agreementChangePO.getAgreementVersion());
        this.agrAgreementAttachChangeMapper.updateBy(agrAgreementAttachChangePO);
    }

    private void insertAgreementSkuChange(AgrCreateAgreementChangeApplyBusiReqBO busiReqBO, AgreementChangePO agreementChangePO) {
        ArrayList<AgreementSkuChangePO> agreementSkuChangePOs = new ArrayList<AgreementSkuChangePO>();
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementSkuChangeBOs())) {
            int isInsert;
            ArrayList<Long> agreementSkuIds = new ArrayList<Long>();
            for (AgrAgreementSkuChangeBO bo : busiReqBO.getAgrAgreementSkuChangeBOs()) {
                if (null != bo.getAgreementSkuId()) {
                    agreementSkuIds.add(bo.getAgreementSkuId());
                }
                AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
                BeanUtils.copyProperties((Object)bo, (Object)agreementSkuChangePO);
                agreementSkuChangePO.setSkuChangeId(Sequence.getInstance().nextId());
                agreementSkuChangePO.setAgreementId(agreementChangePO.getAgreementId());
                agreementSkuChangePO.setSupplierId(agreementChangePO.getSupplierId());
                agreementSkuChangePO.setAgreementVersion(agreementChangePO.getAgreementVersion());
                agreementSkuChangePO.setChangeCode(agreementChangePO.getChangeCode());
                agreementSkuChangePO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
                agreementSkuChangePO.setCreateLoginId(busiReqBO.getMemIdIn());
                agreementSkuChangePO.setCreateName(busiReqBO.getUsername());
                agreementSkuChangePO.setCreateTime(new Date());
                agreementSkuChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                if (agreementSkuChangePO.getMarkupValue() != null) {
                    agreementSkuChangePO.setSalePrice(agreementSkuChangePO.getSalePrice() + new BigDecimal(agreementSkuChangePO.getMarkupValue()).multiply(new BigDecimal("10000")).longValue());
                }
                agreementSkuChangePOs.add(agreementSkuChangePO);
            }
            if (!CollectionUtils.isEmpty(agreementSkuIds)) {
                AgreementSkuChangePO agreementSkuChangePO1 = new AgreementSkuChangePO();
                agreementSkuChangePO1.setChangeCode(busiReqBO.getChangeCode());
                agreementSkuChangePO1.setSupplierId(agreementChangePO.getSupplierId());
                agreementSkuChangePO1.setAgreementId(busiReqBO.getAgreementId());
                agreementSkuChangePO1.setAgreementSkuIds(agreementSkuIds);
                this.agreementSkuChangeMapper.deleteBy(agreementSkuChangePO1);
            }
            if ((isInsert = this.agreementSkuChangeMapper.insertBatch(agreementSkuChangePOs)) != agreementSkuChangePOs.size()) {
                throw new BusinessException("22003", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u8868\u65b0\u589e\u5931\u8d25\uff01");
            }
        }
    }
}

