/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.EcpContractHasCreateAgreementCheckAbilityService;
import com.tydic.agreement.ability.OpsContractHasCreateAgreementCheckAbilityService;
import com.tydic.agreement.ability.SrmContractBindCheckAbilityService;
import com.tydic.agreement.ability.SrmContractHasCreateAgreementCheckAbilityService;
import com.tydic.agreement.ability.bo.EcpContractHasCreateAgreementCheckAbilityReqBO;
import com.tydic.agreement.ability.bo.EcpContractHasCreateAgreementCheckAbilityRspBO;
import com.tydic.agreement.ability.bo.OpsContractHasCreateAgreementCheckAbilityReqBO;
import com.tydic.agreement.ability.bo.OpsContractHasCreateAgreementCheckAbilityRspBO;
import com.tydic.agreement.ability.bo.SrmContractBindCheckReqBO;
import com.tydic.agreement.ability.bo.SrmContractBindCheckRspBO;
import com.tydic.agreement.ability.bo.SrmContractHasCreateAgreementCheckAbilityReqBO;
import com.tydic.agreement.ability.bo.SrmContractHasCreateAgreementCheckAbilityRspBO;
import com.tydic.agreement.atom.AgrCreateAgreementOtherAtomService;
import com.tydic.agreement.atom.AgrCreateAgreementRelBusiPropLabelAtomService;
import com.tydic.agreement.atom.AgrCreateAgreementSkuAtomService;
import com.tydic.agreement.atom.AgrCreateCodeAtomService;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementRelBusiPropLabelAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementRelBusiPropLabeltomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomRspBO;
import com.tydic.agreement.busi.AgrCreateAgreementSubjectBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSubjectBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSubjectBusiRspBO;
import com.tydic.agreement.common.bo.AgrAgreementBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgrInstallmentPaymentMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.SrmContractMapper;
import com.tydic.agreement.dao.SrmContractRelUpperMapper;
import com.tydic.agreement.dao.po.AgrInstallmentPaymentPO;
import com.tydic.agreement.dao.po.AgrRelBusiPropLabelPO;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.SrmContractPO;
import com.tydic.agreement.dao.po.SrmContractRelUpperPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrCreateAgreementSubjectBusiServiceImpl
implements AgrCreateAgreementSubjectBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateAgreementSubjectBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrCreateAgreementSkuAtomService agrCreateAgreementSkuAtomService;
    @Autowired
    private AgrCreateAgreementOtherAtomService agrCreateAgreementOtherAtomService;
    @Autowired
    private AgrCreateCodeAtomService agrCreateCodeAtomService;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private SrmContractBindCheckAbilityService srmContractBindCheckAbilityService;
    @Autowired
    private SrmContractHasCreateAgreementCheckAbilityService srmContractHasCreateAgreementCheckAbilityService;
    @Autowired
    private EcpContractHasCreateAgreementCheckAbilityService ecpContractHasCreateAgreementCheckAbilityService;
    @Autowired
    private OpsContractHasCreateAgreementCheckAbilityService opsContractHasCreateAgreementCheckAbilityService;
    @Autowired
    private SrmContractRelUpperMapper srmContractRelUpperMapper;
    @Autowired
    private SrmContractMapper srmContractMapper;
    @Autowired
    private AgrInstallmentPaymentMapper agrInstallmentPaymentMapper;
    @Autowired
    private AgrCreateAgreementRelBusiPropLabelAtomService agrCreateAgreementRelBusiPropLabelAtomService;
    @Autowired
    private CacheClient cacheService;
    @Value(value="${contractExpTime:1800}")
    private Integer contractExpTime;

    public AgrCreateAgreementSubjectBusiRspBO createAgreementSubjectInfo(AgrCreateAgreementSubjectBusiReqBO busiReqBO) {
        AgrCreateAgreementSubjectBusiRspBO rsp = new AgrCreateAgreementSubjectBusiRspBO();
        this.validPlaAgreementCode(busiReqBO);
        String conCodeAndUserId = "contractCode_" + busiReqBO.getAgrAgreementBO().getExtField2();
        String conCodeAndUserIdStr = (String)this.cacheService.get(conCodeAndUserId, String.class);
        if (StringUtils.hasText((String)conCodeAndUserIdStr)) {
            String[] conCodeAndUserIdStrList = conCodeAndUserIdStr.split("_");
            if (conCodeAndUserIdStrList.length == 2 && !conCodeAndUserIdStrList[1].equals(busiReqBO.getUserIdIn().toString())) {
                throw new BusinessException("22002", "\u5408\u540c\u7f16\u7801\u4e3a\u3010" + busiReqBO.getAgrAgreementBO().getExtField2() + "\u3011\u7684\u5408\u540c\u6b63\u5728\u4f7f\u7528\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            }
        } else {
            String vailue = "userIdIn_" + busiReqBO.getUserIdIn();
            this.cacheService.set(conCodeAndUserId, (Object)vailue, this.contractExpTime.intValue());
        }
        String conCode = "contractCode_" + busiReqBO.getAgrAgreementBO().getExtField2() + "_createAgreementSubjectInfo";
        String conCodeStr = (String)this.cacheService.get(conCode, String.class);
        if (StringUtils.hasText((String)conCodeStr)) {
            throw new BusinessException("22002", conCodeStr);
        }
        String vailue = "\u5408\u540c\u7f16\u7801\u4e3a\u3010" + busiReqBO.getAgrAgreementBO().getExtField2() + "\u7684\u5408\u540c\u6b63\u5728\u521b\u5efa\u5e73\u53f0\u534f\u8bae\u7f16\u53f7\u4e3a\u3010" + busiReqBO.getAgrAgreementBO().getPlaAgreementCode() + "\u3011\u7684\u534f\u8bae\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01";
        this.cacheService.set(conCode, (Object)vailue, 10);
        try {
            Long agreementId = Sequence.getInstance().nextId();
            AgreementPO agreementPO = this.insertAgreement(busiReqBO, agreementId);
            log.debug(JSON.toJSONString((Object)agreementPO));
            if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementAttachBOs()) || !CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs())) {
                this.insertAgreementOther(busiReqBO, agreementPO);
            }
            if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementSkuBOs())) {
                this.insertAgreementSku(busiReqBO, agreementPO);
            }
            if (StringUtils.hasText((String)busiReqBO.getAgrAgreementBO().getUpperContractId())) {
                SrmContractBindCheckReqBO srmContractBindCheckReqBo = new SrmContractBindCheckReqBO();
                BeanUtils.copyProperties((Object)busiReqBO, (Object)srmContractBindCheckReqBo);
                srmContractBindCheckReqBo.setUpperContractCode(busiReqBO.getAgrAgreementBO().getUpperContractCode());
                SrmContractBindCheckRspBO srmContractBindCheckRspBo = this.srmContractBindCheckAbilityService.dealSrmContractBindCheck(srmContractBindCheckReqBo);
                if (!"0000".equals(srmContractBindCheckRspBo.getRespCode())) {
                    throw new BusinessException("8888", "\u4e0a\u7ea7\u5408\u540c\u6821\u9a8c\u5931\u8d25");
                }
                if (srmContractBindCheckRspBo.getCheckResult() == null || srmContractBindCheckRspBo.getCheckResult().booleanValue()) {
                    throw new BusinessException("8888", "\u8bf7\u9009\u62e9\u7ed1\u5b9a\u5176\u4ed6\u4e0a\u7ea7\u534f\u8bae");
                }
                SrmContractPO srmContractPo = new SrmContractPO();
                srmContractPo.setContractId(busiReqBO.getAgrAgreementBO().getUpperContractId());
                srmContractPo.setContractCode(busiReqBO.getAgrAgreementBO().getUpperContractCode());
                srmContractPo = this.srmContractMapper.getModelBy(srmContractPo);
                if (srmContractPo == null) {
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u4e0a\u7ea7\u5408\u540c\u4fe1\u606f");
                }
                SrmContractRelUpperPO srmContractRelUpperPo = new SrmContractRelUpperPO();
                srmContractRelUpperPo.setAgreementId(agreementId);
                srmContractRelUpperPo.setUpperContractId(srmContractPo.getContractId());
                srmContractRelUpperPo.setUpperContractCode(srmContractPo.getContractCode());
                srmContractRelUpperPo.setCreateTime(new Date());
                srmContractRelUpperPo.setCreateOperId(busiReqBO.getMemIdIn());
                srmContractRelUpperPo.setCreateOperName(busiReqBO.getUsername());
                this.srmContractRelUpperMapper.insert(srmContractRelUpperPo);
            }
            AgrCreateAgreementRelBusiPropLabeltomReqBO labelAtomReqBO = new AgrCreateAgreementRelBusiPropLabeltomReqBO();
            List agrBusiPropLabelList = busiReqBO.getAgrAgreementBO().getBusiPropLabels();
            List busiPropLabelList = JSON.parseArray((String)JSON.toJSONString((Object)agrBusiPropLabelList), AgrRelBusiPropLabelPO.class);
            BeanUtils.copyProperties((Object)busiReqBO, (Object)((Object)labelAtomReqBO));
            labelAtomReqBO.setBusiPropLabelLsit(busiPropLabelList);
            labelAtomReqBO.setOperType("add");
            labelAtomReqBO.setAgreementId(agreementId);
            AgrCreateAgreementRelBusiPropLabelAtomRspBO labelAtomRspBO = this.agrCreateAgreementRelBusiPropLabelAtomService.createAgreementRelBusiPropLabel(labelAtomReqBO);
            if (!"0000".equals(labelAtomRspBO.getRespCode())) {
                throw new BusinessException(labelAtomRspBO.getRespCode(), labelAtomRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrInstallmentPaymentBOs())) {
                List<AgrInstallmentPaymentPO> installmentPaymentPos = busiReqBO.getAgrInstallmentPaymentBOs().stream().map(bo -> {
                    AgrInstallmentPaymentPO po = new AgrInstallmentPaymentPO();
                    po.setId(Sequence.getInstance().nextId());
                    po.setAgreementId(agreementId);
                    po.setStageName(bo.getStageName());
                    po.setStageValue(bo.getStageValue());
                    po.setStageClause(bo.getStageClause());
                    po.setPaymentDays(bo.getPaymentDays());
                    po.setOrdered(bo.getOrdered());
                    return po;
                }).collect(Collectors.toList());
                this.agrInstallmentPaymentMapper.insertBatch(installmentPaymentPos);
            }
            if (AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(busiReqBO.getAgrAgreementBO().getRelSystem()) && StringUtils.hasText((String)busiReqBO.getAgrAgreementBO().getExtContractCode())) {
                SrmContractHasCreateAgreementCheckAbilityReqBO srmContractHasCreateAgreementCheckAbilityReqBo = new SrmContractHasCreateAgreementCheckAbilityReqBO();
                srmContractHasCreateAgreementCheckAbilityReqBo.setAgreementId(agreementId);
                srmContractHasCreateAgreementCheckAbilityReqBo.setSrmContractCode(busiReqBO.getAgrAgreementBO().getExtContractCode());
                srmContractHasCreateAgreementCheckAbilityReqBo.setUserIdIn(busiReqBO.getUserIdIn());
                SrmContractHasCreateAgreementCheckAbilityRspBO srmContractHasCreateAgreementCheckAbilityRspBo = this.srmContractHasCreateAgreementCheckAbilityService.dealSrmAgreementCheck(srmContractHasCreateAgreementCheckAbilityReqBo);
                if (!"0000".equals(srmContractHasCreateAgreementCheckAbilityRspBo.getRespCode())) {
                    throw new BusinessException("8888", "\u5173\u8054SRM\u5408\u540c\u6821\u9a8c\u5931\u8d25");
                }
                if (srmContractHasCreateAgreementCheckAbilityRspBo.getCheckResult() == null || srmContractHasCreateAgreementCheckAbilityRspBo.getCheckResult().booleanValue()) {
                    throw new BusinessException("8888", "\u8bf7\u9009\u62e9\u5173\u8054\u5176\u4ed6SRM\u5408\u540c");
                }
            }
            if (AgrEnum.RelSystem.ECP.toString().equalsIgnoreCase(busiReqBO.getAgrAgreementBO().getRelSystem()) && StringUtils.hasText((String)busiReqBO.getAgrAgreementBO().getExtContractCode())) {
                EcpContractHasCreateAgreementCheckAbilityReqBO ecpContractHasCreateAgreementCheckAbilityReqBO = new EcpContractHasCreateAgreementCheckAbilityReqBO();
                ecpContractHasCreateAgreementCheckAbilityReqBO.setAgreementId(agreementId);
                ecpContractHasCreateAgreementCheckAbilityReqBO.setEcpContractCode(busiReqBO.getAgrAgreementBO().getExtContractCode());
                ecpContractHasCreateAgreementCheckAbilityReqBO.setUserIdIn(busiReqBO.getUserIdIn());
                EcpContractHasCreateAgreementCheckAbilityRspBO ecpContractHasCreateAgreementCheckAbilityRspBO = this.ecpContractHasCreateAgreementCheckAbilityService.dealEcpAgreementCheck(ecpContractHasCreateAgreementCheckAbilityReqBO);
                if (!"0000".equals(ecpContractHasCreateAgreementCheckAbilityRspBO.getRespCode())) {
                    throw new BusinessException("8888", "\u5173\u8054ECP\u5408\u540c\u6821\u9a8c\u5931\u8d25");
                }
                if (ecpContractHasCreateAgreementCheckAbilityRspBO.getCheckResult() == null || ecpContractHasCreateAgreementCheckAbilityRspBO.getCheckResult().booleanValue()) {
                    throw new BusinessException("8888", "\u8bf7\u9009\u62e9\u5173\u8054\u5176\u4ed6ECP\u5408\u540c");
                }
            }
            if (AgrEnum.RelSystem.OPS.toString().equalsIgnoreCase(busiReqBO.getAgrAgreementBO().getRelSystem()) && StringUtils.hasText((String)busiReqBO.getAgrAgreementBO().getExtContractCode())) {
                OpsContractHasCreateAgreementCheckAbilityReqBO opsContractHasCreateAgreementCheckAbilityReqBO = new OpsContractHasCreateAgreementCheckAbilityReqBO();
                opsContractHasCreateAgreementCheckAbilityReqBO.setAgreementId(agreementId);
                opsContractHasCreateAgreementCheckAbilityReqBO.setOpsContractCode(busiReqBO.getAgrAgreementBO().getExtContractCode());
                opsContractHasCreateAgreementCheckAbilityReqBO.setUserIdIn(busiReqBO.getUserIdIn());
                OpsContractHasCreateAgreementCheckAbilityRspBO opsContractHasCreateAgreementCheckAbilityRspBO = this.opsContractHasCreateAgreementCheckAbilityService.dealOpsAgreementCheck(opsContractHasCreateAgreementCheckAbilityReqBO);
                if (!"0000".equals(opsContractHasCreateAgreementCheckAbilityRspBO.getRespCode())) {
                    throw new BusinessException("8888", "\u5173\u8054OPS\u5408\u540c\u6821\u9a8c\u5931\u8d25");
                }
                if (opsContractHasCreateAgreementCheckAbilityRspBO.getCheckResult() == null || opsContractHasCreateAgreementCheckAbilityRspBO.getCheckResult().booleanValue()) {
                    throw new BusinessException("8888", "\u8bf7\u9009\u62e9\u5173\u8054\u5176\u4ed6OPS\u5408\u540c");
                }
            }
            rsp.setAgreementId(agreementId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("8888", "\u65b0\u589e\u5931\u8d25,\u8bf7\u68c0\u67e5\u586b\u5199\u7684\u53c2\u6570\u662f\u5426\u6709\u8bef!");
        }
        this.cacheService.delete(conCodeAndUserId);
        this.cacheService.delete(conCode);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u4e3b\u4f53\u521b\u5efa\u6210\u529f\uff01");
        return rsp;
    }

    private AgreementPO insertAgreement(AgrCreateAgreementSubjectBusiReqBO busiReqBO, Long agreementId) {
        AgreementPO agreementPO = new AgreementPO();
        BeanUtils.copyProperties((Object)busiReqBO.getAgrAgreementBO(), (Object)agreementPO);
        String agreementVersion = "V10000000";
        agreementPO.setAgreementId(agreementId);
        agreementPO.setAgreementVersion(agreementVersion);
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setSupplierName(busiReqBO.getSupplierName());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.DRAFT);
        agreementPO.setAssignStatus(AgrCommConstant.AssignStatus.BE_ASSIGN);
        agreementPO.setProducerId(busiReqBO.getMemIdIn());
        agreementPO.setProducerName(busiReqBO.getName());
        agreementPO.setProduceTime(new Date());
        agreementPO.setSupplierOrgPath(busiReqBO.getOrgPath());
        if (AgrEnum.YesOrNo.YES.getCode().toString().equals(agreementPO.getCreateOrder()) && AgrEnum.EcpContractType.GDZJ.getCode().equals(agreementPO.getEcpContractType())) {
            agreementPO.setAdjustPrice(AgrCommConstant.AdjustPrice.NO_ADJUST_PRICE);
            agreementPO.setApproveLower((int)AgrEnum.YesOrNo.NO.getCode());
            agreementPO.setAcceptHigher((int)AgrEnum.YesOrNo.NO.getCode());
        }
        try {
            int n = this.agreementMapper.insert(agreementPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("0101", "\u534f\u8bae\u65b0\u589e\u5931\u8d25!\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u53c2\u6570!");
        }
        return agreementPO;
    }

    private void insertAgreementOther(AgrCreateAgreementSubjectBusiReqBO busiReqBO, AgreementPO agreementPO) {
        AgrCreateAgreementOtherAtomReqBO atomReqBO = new AgrCreateAgreementOtherAtomReqBO();
        atomReqBO.setMemIdIn(busiReqBO.getMemIdIn());
        atomReqBO.setSupplierId(busiReqBO.getSupplierId());
        atomReqBO.setUsername(busiReqBO.getUsername());
        atomReqBO.setAgreementId(agreementPO.getAgreementId());
        atomReqBO.setAgreementVersion(agreementPO.getAgreementVersion());
        atomReqBO.setAgrAgreementAttachBOs(busiReqBO.getAgrAgreementAttachBOs());
        atomReqBO.setAgrAgreementScopeBOs(busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs());
        atomReqBO.setScopeType(agreementPO.getScopeType());
        atomReqBO.setBreachRateList(busiReqBO.getAgrAgreementBO().getBreachRateList());
        atomReqBO.setOperType("add");
        AgrCreateAgreementOtherAtomRspBO atomRspBO = this.agrCreateAgreementOtherAtomService.createAgreementOtherInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }

    private void insertAgreementSku(AgrCreateAgreementSubjectBusiReqBO busiReqBO, AgreementPO agreementPO) {
        AgrCreateAgreementSkuAtomReqBO agrCreateAgreementSkuAtomReqBO = new AgrCreateAgreementSkuAtomReqBO();
        agrCreateAgreementSkuAtomReqBO.setAgrAgreementSkuBOs(busiReqBO.getAgrAgreementSkuBOs());
        agrCreateAgreementSkuAtomReqBO.setSupplierId(busiReqBO.getSupplierId());
        agrCreateAgreementSkuAtomReqBO.setAgreementVersion(agreementPO.getAgreementVersion());
        agrCreateAgreementSkuAtomReqBO.setAgreementId(agreementPO.getAgreementId());
        AgrCreateAgreementSkuAtomRspBO agrCreateAgreementSkuAtomRspBO = this.agrCreateAgreementSkuAtomService.createAgreementSku(agrCreateAgreementSkuAtomReqBO);
        if (!"0000".equals(agrCreateAgreementSkuAtomRspBO.getRespCode())) {
            throw new BusinessException(agrCreateAgreementSkuAtomRspBO.getRespCode(), agrCreateAgreementSkuAtomRspBO.getRespDesc());
        }
    }

    private void validPlaAgreementCode(AgrCreateAgreementSubjectBusiReqBO busiReqBO) {
        AgrAgreementBO agrAgreementBO = busiReqBO.getAgrAgreementBO();
        AgreementPO checkAgreementPO = new AgreementPO();
        checkAgreementPO.setPlaAgreementCode(agrAgreementBO.getPlaAgreementCode());
        AgreementPO checkAgreement = this.agreementMapper.getModelBy(checkAgreementPO);
        if (null != checkAgreement) {
            throw new BusinessException("22053", "\u534f\u8bae\u7f16\u53f7\u3010" + checkAgreement.getPlaAgreementCode() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
    }
}

