/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrCreateCrossScopeRecordAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrCreateCrossScopeRecordAbilityRspBO;
import com.tydic.agreement.busi.AgrCreateCrossScopeRecordBusiService;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.CrossAgrScopeRecordMapper;
import com.tydic.agreement.dao.po.AgreementScopePO;
import com.tydic.agreement.dao.po.CrossAgrScopeRecordPO;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgAbilityBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgAbilityReqPageBO;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrCreateCrossScopeRecordBusiServiceImpl
implements AgrCreateCrossScopeRecordBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrCreateCrossScopeRecordBusiServiceImpl.class);
    @Autowired
    private CrossAgrScopeRecordMapper crossAgrScopeRecordMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;

    public AgrCreateCrossScopeRecordAbilityRspBO createCrossScopeRecord(AgrCreateCrossScopeRecordAbilityReqBO reqBo) {
        AgrCreateCrossScopeRecordAbilityRspBO rspBo = new AgrCreateCrossScopeRecordAbilityRspBO();
        try {
            List<AgreementScopePO> skuPurchaseScope = this.agreementScopeMapper.getSkuPurchaseScope(Collections.singletonList(reqBo.getAgreementId()));
            if (CollectionUtils.isEmpty(skuPurchaseScope)) {
                this.insertRecord(reqBo);
            } else {
                boolean crossScopeFlag = true;
                for (AgreementScopePO agreementScopePo : skuPurchaseScope) {
                    if (0L != (long)agreementScopePo.getScopeType().byteValue()) {
                        String orgTreePath;
                        if (reqBo.getOrgPath().contains(agreementScopePo.getScopeCode().toString())) {
                            crossScopeFlag = false;
                            break;
                        }
                        UmcZhEnterpriseOrgAbilityReqPageBO umcZhEnterpriseOrgAbilityReqPageBo = new UmcZhEnterpriseOrgAbilityReqPageBO();
                        umcZhEnterpriseOrgAbilityReqPageBo.setProjectOwnership("ZH");
                        umcZhEnterpriseOrgAbilityReqPageBo.setOrgIdWeb(agreementScopePo.getScopeCode());
                        UmcRspListBO umcZhEnterpriseOrgAbilityBOUmcRspListBo = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgList(umcZhEnterpriseOrgAbilityReqPageBo);
                        if (null == umcZhEnterpriseOrgAbilityBOUmcRspListBo || CollectionUtils.isEmpty((Collection)umcZhEnterpriseOrgAbilityBOUmcRspListBo.getRows()) || !StringUtils.hasText((String)(orgTreePath = ((UmcZhEnterpriseOrgAbilityBO)umcZhEnterpriseOrgAbilityBOUmcRspListBo.getRows().get(0)).getOrgTreePath())) || !orgTreePath.contains(reqBo.getOrgPath())) continue;
                        crossScopeFlag = false;
                        break;
                    }
                    crossScopeFlag = false;
                    break;
                }
                if (crossScopeFlag) {
                    this.insertRecord(reqBo);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void insertRecord(AgrCreateCrossScopeRecordAbilityReqBO reqBo) {
        CrossAgrScopeRecordPO crossAgrScopeRecordPo = new CrossAgrScopeRecordPO();
        crossAgrScopeRecordPo.setId(Sequence.getInstance().nextId());
        crossAgrScopeRecordPo.setSkuId(reqBo.getSkuId());
        crossAgrScopeRecordPo.setAgreementId(reqBo.getAgreementId());
        crossAgrScopeRecordPo.setOrgPath(reqBo.getOrgPath());
        crossAgrScopeRecordPo.setCreateTime(new Date());
        this.crossAgrScopeRecordMapper.insert(crossAgrScopeRecordPo);
    }
}

