/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.busi.AgrDeleteAgreementSkuBusiService;
import com.tydic.agreement.busi.bo.AgrDeleteAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrDeleteAgreementSkuBusiRspBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrDeleteAgreementSkuBusiServiceImpl
implements AgrDeleteAgreementSkuBusiService {
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;

    public AgrDeleteAgreementSkuBusiRspBO deleteAgreementSku(AgrDeleteAgreementSkuBusiReqBO busiReqBO) {
        AgrDeleteAgreementSkuBusiRspBO rsp = new AgrDeleteAgreementSkuBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        if (!AgrCommConstant.AgreementStatus.DRAFT.equals(agreement.getAgreementStatus()) && !AgrCommConstant.AgreementStatus.REJECT.equals(agreement.getAgreementStatus())) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u5220\u9664\u534f\u8bae\u660e\u7ec6\uff01");
        }
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)agreementSkuPO);
        agreementSkuPO.setUpdateLoginId(busiReqBO.getMemIdIn());
        agreementSkuPO.setUpdateName(busiReqBO.getUsername());
        agreementSkuPO.setUpdateTime(new Date());
        agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.DELETED);
        int isUpdate = this.agreementSkuMapper.updateBy(agreementSkuPO);
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgreementSkuIds())) {
            this.agreementSkuMapper.updateSkuClearSpuInfo(busiReqBO.getAgreementSkuIds());
        } else {
            AgreementSkuPO skuPO = new AgreementSkuPO();
            skuPO.setAgreementId(busiReqBO.getAgreementId());
            List<AgreementSkuPO> agreementSkuPOS = this.agreementSkuMapper.getList(skuPO);
            if (!CollectionUtils.isEmpty(agreementSkuPOS)) {
                this.agreementSkuMapper.updateSkuClearSpuInfo(agreementSkuPOS.stream().map(AgreementSkuPO::getAgreementSkuId).collect(Collectors.toList()));
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u5220\u9664\u6210\u529f\uff01");
        return rsp;
    }
}

