/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.atom.AgrCreateCodeAtomService;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrCreateCodeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateCodeAtomRspBO;
import com.tydic.agreement.busi.AgrImportAgreementInfoBusiService;
import com.tydic.agreement.busi.bo.AgrImportAgreementInfoBusiReqBO;
import com.tydic.agreement.busi.bo.AgrImportAgreementInfoBusiRspBO;
import com.tydic.agreement.common.bo.AgrImoprtTemplateBO;
import com.tydic.agreement.common.bo.AgrPlaAgreementCodeBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.agreement.utils.ExcelUtils;
import com.tydic.agreement.utils.HttpUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AgrImportAgreementInfoBusiServiceImpl
implements AgrImportAgreementInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrImportAgreementInfoBusiServiceImpl.class);
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrCreateCodeAtomService agrCreateCodeAtomService;

    public AgrImportAgreementInfoBusiRspBO createAgreementMajorInfo(AgrImportAgreementInfoBusiReqBO busiReqBO) {
        String jsonStr = this.analysisFile(busiReqBO.getUrl(), "3");
        List agreementPOList = JSON.parseArray((String)jsonStr, AgreementPO.class);
        for (AgreementPO po : agreementPOList) {
            po.setAgreementId(Sequence.getInstance().nextId());
            this.setDefaultValue(po);
            po.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            po.setAgreementStatus(AgrCommConstant.AgreementStatus.DRAFT);
            po.setAssignStatus(AgrCommConstant.AssignStatus.BE_ASSIGN);
            AgrCreateCodeAtomReqBO atomReqBO = new AgrCreateCodeAtomReqBO();
            AgrPlaAgreementCodeBO plaAgreementCodeBO = new AgrPlaAgreementCodeBO();
            plaAgreementCodeBO.setOrgShortName(busiReqBO.getOrgShortName());
            plaAgreementCodeBO.setAgreementType(this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_TYPE_PCODE", po.getAgreementType().toString()));
            plaAgreementCodeBO.setAgreementVariety(this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_VARIETY_PCODE", po.getAgreementVariety().toString()));
            atomReqBO.setCodeType(AgrCommConstant.CreateCodeType.PLA_CODE);
            atomReqBO.setPlaAgreementCodeBO(plaAgreementCodeBO);
            AgrCreateCodeAtomRspBO agrCreateCodeAtomRspBO = this.agrCreateCodeAtomService.createCode(atomReqBO);
            if (!"0000".equals(agrCreateCodeAtomRspBO.getRespCode())) {
                throw new BusinessException(agrCreateCodeAtomRspBO.getRespCode(), agrCreateCodeAtomRspBO.getRespDesc());
            }
            po.setAgreementVersion("V10000000");
            po.setPlaAgreementCode(agrCreateCodeAtomRspBO.getCode());
            po.setSupplierMode(new Byte("2"));
            po.setAgreementSrc(new Byte("1"));
            int isInsert = this.agreementMapper.insert(po);
            if (isInsert >= 1) continue;
            throw new BusinessException("0101", "\u63d2\u5165\u534f\u8bae\u8868\u5931\u8d25\uff01");
        }
        AgrImportAgreementInfoBusiRspBO busiRspBO = new AgrImportAgreementInfoBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u534f\u8bae\u5bfc\u5165\u6210\u529f");
        return busiRspBO;
    }

    public AgrImportAgreementInfoBusiRspBO createAgreementSkuInfo(AgrImportAgreementInfoBusiReqBO busiReqBO) {
        String jsonStr = this.analysisFile(busiReqBO.getUrl(), "2");
        List agreementSkuPOs = JSON.parseArray((String)jsonStr, AgreementSkuPO.class);
        for (AgreementSkuPO po : agreementSkuPOs) {
            if (po.getMarkupRate() == null) {
                po.setMarkupRate(new BigDecimal("0").divide(new BigDecimal(100)).doubleValue());
            }
            po.setAgreementSkuId(Sequence.getInstance().nextId());
            po.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            po.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            po.setCreateTime(new Date());
            po.setAgreementVersion("V10000000");
            po.setAgreementId(12L);
            po.setSupplierId(12L);
            po.setBuyPriceSum(new BigDecimal(po.getBuyPrice()).multiply(po.getBuyNumber()).longValue());
            po.setSalePrice(new BigDecimal(po.getBuyPrice()).add(new BigDecimal(po.getBuyPrice()).multiply(new BigDecimal(po.getMarkupRate().toString()))).longValue());
            if (po.getMarkupValue() != null) {
                po.setSalePrice(po.getSalePrice() + new BigDecimal(po.getMarkupValue()).multiply(new BigDecimal("10000")).longValue());
            }
            po.setSalePriceSum(new BigDecimal(po.getSalePrice()).multiply(po.getBuyNumber()).longValue());
            po.setMarkupRate(new BigDecimal(po.getMarkupRate().toString()).multiply(new BigDecimal(100)).doubleValue());
        }
        this.agreementSkuMapper.insertBatch(agreementSkuPOs);
        AgrImportAgreementInfoBusiRspBO busiRspBO = new AgrImportAgreementInfoBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6210\u529f");
        return busiRspBO;
    }

    private String analysisFile(String url, String code) {
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            HttpUtil.deleteFile("temporaryfile/content.xlsx");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(url, file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            ExcelUtils.getExcelDate((MultipartFile)multipartFile, data, title);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("22052", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>();
        String importTemplateStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IMPORT_TEMPLATE_PCODE", code);
        List templateBOs = JSON.parseArray((String)importTemplateStr, AgrImoprtTemplateBO.class);
        block2: for (Object bo : templateBOs) {
            for (int i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(bo.getFieldName())) continue;
                dateMapIndex.put(bo.getFieldNameEng(), i);
                continue block2;
            }
        }
        ArrayList dateMaps = new ArrayList();
        for (List list : data) {
            HashMap dataMap = new HashMap();
            for (AgrImoprtTemplateBO bo : templateBOs) {
                Integer sheetKey = (Integer)dateMapIndex.get(bo.getFieldNameEng());
                if (null != sheetKey) {
                    Object content = list.get(sheetKey);
                    if ("null".equals(content)) {
                        content = null;
                    }
                    if (bo.getIsMustFill().booleanValue() && null == content) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010" + bo.getFieldNameEng() + "\u3011\u5fc5\u586b\uff01");
                    }
                    if ((StringUtils.isEmpty(content) || "null".equals(content)) && null != bo.getDefaultValue()) {
                        content = bo.getDefaultValue();
                    }
                    if ("markupRate".equals(bo.getFieldNameEng())) {
                        String markupRate = (String)content;
                        if (StringUtils.isEmpty((Object)markupRate)) {
                            markupRate = "0";
                        }
                        markupRate = new BigDecimal(markupRate).divide(new BigDecimal(100)).toString();
                        content = markupRate;
                    }
                    if ("buyPrice".equals(bo.getFieldNameEng())) {
                        String buyPrice = (String)content;
                        if (StringUtils.isEmpty((Object)buyPrice) || "null".equals(buyPrice)) {
                            buyPrice = "0";
                        }
                        if ((buyPrice = new BigDecimal(buyPrice).multiply(new BigDecimal(10000)).toString()).endsWith(".0")) {
                            buyPrice = buyPrice.substring(0, buyPrice.lastIndexOf(".0"));
                        }
                        if (buyPrice.endsWith(".000")) {
                            buyPrice = buyPrice.substring(0, buyPrice.lastIndexOf(".000"));
                        }
                        if (buyPrice.endsWith(".00")) {
                            buyPrice = buyPrice.substring(0, buyPrice.lastIndexOf(".00"));
                        }
                        content = buyPrice;
                    }
                    dataMap.put(bo.getFieldNameEng(), content);
                    continue;
                }
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u3010" + bo.getFieldNameEng() + "\u3011\u4e3a\u7a7a\uff01");
            }
            dateMaps.add(dataMap);
        }
        String jsonStr = JSON.toJSONString(dateMaps);
        return jsonStr;
    }

    private void setDefaultValue(AgreementPO agreementPO) {
        if (null == agreementPO.getTaxRate()) {
            agreementPO.setTaxRate(AgrCommConstant.TaxRate.SEVENTEEN);
        }
        if (null == agreementPO.getCurrency()) {
            agreementPO.setCurrency(AgrCommConstant.Currency.RMB);
        }
        if (null == agreementPO.getWarantty()) {
            agreementPO.setWarantty(AgrCommConstant.Warantty.TWELVE);
        }
        if (null == agreementPO.getIsDispatch()) {
            agreementPO.setIsDispatch(AgrCommConstant.IsDispatch.YES);
        }
        if (null == agreementPO.getAdjustPrice()) {
            agreementPO.setAdjustPrice(AgrCommConstant.AdjustPrice.NO_ADJUST_PRICE);
        }
        if (null == agreementPO.getIsAdjustPriceFormula()) {
            agreementPO.setIsAdjustPriceFormula(AgrCommConstant.IsAdjustPriceFormula.NO);
        }
        if (null == agreementPO.getIsModifyBuyPrice()) {
            agreementPO.setIsModifyBuyPrice(AgrCommConstant.IsModifyBuyPrice.NO);
        }
        if (null == agreementPO.getSignTime()) {
            agreementPO.setSignTime(new Date());
        }
        if (null == agreementPO.getIsAddPrice()) {
            agreementPO.setIsAddPrice(AgrCommConstant.IsAddPrice.NO);
        }
        if (null == agreementPO.getIsPurchase()) {
            agreementPO.setIsPurchase(AgrCommConstant.isPurchase.AVALIABLE_CONTRACT);
        }
        if (null == agreementPO.getIsSale()) {
            agreementPO.setIsSale(AgrCommConstant.isSale.AVALIABLE_CONTRACT);
        }
    }
}

