/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.busi.AgrModifyAgreementSkuBusiService;
import com.tydic.agreement.busi.bo.AgrModifyAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrModifyAgreementSkuBusiRspBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrModifyAgreementSkuBusiServiceImpl
implements AgrModifyAgreementSkuBusiService {
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;

    public AgrModifyAgreementSkuBusiRspBO modifyAgreementSku(AgrModifyAgreementSkuBusiReqBO busiReqBO) {
        AgrModifyAgreementSkuBusiRspBO rsp = new AgrModifyAgreementSkuBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgrAgreementSkuBO().getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        if (!AgrCommConstant.AgreementStatus.DRAFT.equals(agreement.getAgreementStatus()) && !AgrCommConstant.AgreementStatus.REJECT.equals(agreement.getAgreementStatus())) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u4fee\u6539\u534f\u8bae\u660e\u7ec6\uff01");
        }
        if (null == busiReqBO.getAgrAgreementSkuBO().getFormulaIdFlag() && AgrEnum.RelSystem.ECP.toString().equalsIgnoreCase(agreement.getRelSystem())) {
            if (null != busiReqBO.getAgrAgreementSkuBO().getSupplyCycle() && BigDecimal.ZERO.compareTo(new BigDecimal(busiReqBO.getAgrAgreementSkuBO().getSupplyCycle())) >= 0) {
                throw new BusinessException("0101", "\u8bf7\u586b\u5199\u5927\u4e8e0\u7684\u6b63\u6574\u6570\uff01");
            }
            if (!AgrEnum.EcpContractType.GDZJ.getCode().equals(agreement.getEcpContractType()) && !Arrays.asList(AgrEnum.Variety.GC.getCode(), AgrEnum.Variety.FW.getCode()).contains(busiReqBO.getAgrAgreementSkuBO().getCatalogVariety())) {
                if (null == busiReqBO.getAgrAgreementSkuBO().getSupplyCycle()) {
                    throw new BusinessException("0101", "\u4f9b\u8d27\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            } else if (null == busiReqBO.getAgrAgreementSkuBO().getSupplyCycle()) {
                busiReqBO.getAgrAgreementSkuBO().setSupplyCycleFlag(Integer.valueOf(1));
            }
        }
        AgreementSkuPO updateAgreementSkuPO = new AgreementSkuPO();
        BeanUtils.copyProperties((Object)busiReqBO.getAgrAgreementSkuBO(), (Object)updateAgreementSkuPO);
        updateAgreementSkuPO.setUpdateLoginId(busiReqBO.getMemIdIn());
        updateAgreementSkuPO.setUpdateName(busiReqBO.getUsername());
        updateAgreementSkuPO.setUpdateTime(new Date());
        if (busiReqBO.getAgrAgreementSkuBO().getFormulaId() != null) {
            this.agreementSkuMapper.emptyConstantValue(updateAgreementSkuPO.getAgreementId(), updateAgreementSkuPO.getAgreementSkuId(), updateAgreementSkuPO.getAgreementSkuIds());
        }
        if (null != busiReqBO.getAgrAgreementSkuBO().getBatchUpdateRateFlag() && busiReqBO.getAgrAgreementSkuBO().getBatchUpdateRateFlag().booleanValue()) {
            AgreementSkuPO skuPO = new AgreementSkuPO();
            skuPO.setAgreementId(busiReqBO.getAgrAgreementSkuBO().getAgreementId());
            skuPO.setAgreementSkuIds(busiReqBO.getAgrAgreementSkuBO().getAgreementSkuIds());
            skuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            List<AgreementSkuPO> agreementSkuPOS = this.agreementSkuMapper.getList(skuPO);
            ArrayList<AgreementSkuPO> skuPOS = new ArrayList<AgreementSkuPO>();
            if (!CollectionUtils.isEmpty(agreementSkuPOS)) {
                Double rate = busiReqBO.getAgrAgreementSkuBO().getMarkupRate();
                for (AgreementSkuPO agreementSkuPO : agreementSkuPOS) {
                    AgreementSkuPO po = new AgreementSkuPO();
                    po.setAgreementSkuId(agreementSkuPO.getAgreementSkuId());
                    po.setAgreementId(agreementSkuPO.getAgreementId());
                    po.setMarkupRate(rate);
                    BigDecimal markupRate = new BigDecimal(rate).divide(new BigDecimal("100"));
                    Long salePrice = new BigDecimal(agreementSkuPO.getBuyPrice()).add(new BigDecimal(agreementSkuPO.getBuyPrice()).multiply(markupRate)).add(new BigDecimal(agreementSkuPO.getMarkupValue()).multiply(new BigDecimal("10000"))).longValue();
                    Long salePriceSum = new BigDecimal(salePrice).multiply(agreementSkuPO.getBuyNumber()).longValue();
                    po.setSalePrice(salePrice);
                    po.setSalePriceSum(salePriceSum);
                    skuPOS.add(po);
                }
            }
            if (!CollectionUtils.isEmpty(skuPOS)) {
                this.agreementSkuMapper.updateBatchAgreementSku(skuPOS);
            }
        }
        this.agreementSkuMapper.updateBy(updateAgreementSkuPO);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u4fee\u6539\u6210\u529f\uff01");
        return rsp;
    }
}

