/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.atom.AgrCreateAgreementOtherAtomService;
import com.tydic.agreement.atom.AgrCreateAgreementRelBusiPropLabelAtomService;
import com.tydic.agreement.atom.AgrCreateAgreementSkuAtomService;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementRelBusiPropLabelAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementRelBusiPropLabeltomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSkuAtomRspBO;
import com.tydic.agreement.busi.AgrModifyAgreementSubjectBusiService;
import com.tydic.agreement.busi.bo.AgrModifyAgreementSubjectBusiReqBO;
import com.tydic.agreement.busi.bo.AgrModifyAgreementSubjectBusiRspBO;
import com.tydic.agreement.common.bo.AgrAgreementBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgrInstallmentPaymentMapper;
import com.tydic.agreement.dao.AgrOrderInfoMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.EcpContractItemMapper;
import com.tydic.agreement.dao.EcpContractMapper;
import com.tydic.agreement.dao.OpsContractItemMapper;
import com.tydic.agreement.dao.OpsContractMapper;
import com.tydic.agreement.dao.SrmContractItemMapper;
import com.tydic.agreement.dao.SrmContractMapper;
import com.tydic.agreement.dao.po.AgrInstallmentPaymentPO;
import com.tydic.agreement.dao.po.AgrOrderInfoPO;
import com.tydic.agreement.dao.po.AgrRelBusiPropLabelPO;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.agreement.dao.po.EcpContractItemPO;
import com.tydic.agreement.dao.po.EcpContractPO;
import com.tydic.agreement.dao.po.OpsContractItemPO;
import com.tydic.agreement.dao.po.OpsContractPO;
import com.tydic.agreement.dao.po.SrmContractItemPO;
import com.tydic.agreement.dao.po.SrmContractPO;
import com.tydic.agreement.utils.MoneyUtil;
import com.tydic.commodity.enumType.YesNoEnum;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleReqBO;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleRspBO;
import com.tydic.contract.api.maintenance.service.QryContractSupplierListSaleService;
import com.tydic.uccext.bo.CnncBatchQryMaterialByCodeAbilityBo;
import com.tydic.uccext.bo.CnncBatchQryMaterialByCodeAbilityReqBo;
import com.tydic.uccext.bo.CnncBatchQryMaterialByCodeAbilityRspBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityReqBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityRspBo;
import com.tydic.uccext.bo.UccMaterialCommodityTypeBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialReqBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialRspBO;
import com.tydic.uccext.service.CnncBatchQryMaterialByCodeAbilityService;
import com.tydic.uccext.service.CnncQryCommodityTypeListAbilityService;
import com.tydic.uccext.service.UccQryCommodityTypeByMaterialService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrModifyAgreementSubjectBusiServiceImpl
implements AgrModifyAgreementSubjectBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrModifyAgreementSubjectBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrCreateAgreementOtherAtomService agrCreateAgreementOtherAtomService;
    @Autowired
    private AgrCreateAgreementRelBusiPropLabelAtomService agrCreateAgreementRelBusiPropLabelAtomService;
    @Autowired
    private AgrOrderInfoMapper agrOrderInfoMapper;
    @Autowired
    private AgrInstallmentPaymentMapper agrInstallmentPaymentMapper;
    @Autowired
    private SrmContractMapper srmContractMapper;
    @Autowired
    private SrmContractItemMapper srmContractItemMapper;
    @Autowired
    private UccQryCommodityTypeByMaterialService uccQryCommodityTypeByMaterialService;
    @Autowired
    private QryContractSupplierListSaleService qryContractSupplierListSaleService;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private EcpContractItemMapper ecpContractItemMapper;
    @Autowired
    private OpsContractMapper opsContractMapper;
    @Autowired
    private OpsContractItemMapper opsContractItemMapper;
    @Autowired
    private EcpContractMapper ecpContractMapper;
    @Autowired
    private CnncBatchQryMaterialByCodeAbilityService cnncBatchQryMaterialByCodeAbilityService;
    @Autowired
    private CnncQryCommodityTypeListAbilityService cnncQryCommodityTypeListAbilityService;
    @Autowired
    private AgrCreateAgreementSkuAtomService agrCreateAgreementSkuAtomService;

    public AgrModifyAgreementSubjectBusiRspBO modifyAgreementSubjectInfo(AgrModifyAgreementSubjectBusiReqBO busiReqBO) {
        AgrModifyAgreementSubjectBusiRspBO rsp = new AgrModifyAgreementSubjectBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        if (!AgrCommConstant.AgreementStatus.DRAFT.equals(agreement.getAgreementStatus()) && !AgrCommConstant.AgreementStatus.REJECT.equals(agreement.getAgreementStatus())) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u4fee\u6539\uff01");
        }
        if (!Objects.equals(agreement.getExtField2(), busiReqBO.getAgrAgreementBO().getExtField2())) {
            AgreementSkuPO skuPO = new AgreementSkuPO();
            skuPO.setAgreementId(agreement.getAgreementId());
            skuPO.setIsDelete(AgrCommConstant.IsDelete.DELETED);
            this.agreementSkuMapper.updateBy(skuPO);
            if (AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(busiReqBO.getAgrAgreementBO().getRelSystem()) && org.springframework.util.StringUtils.hasText((String)busiReqBO.getAgrAgreementBO().getExtContractId())) {
                this.createSrmAgrItem(busiReqBO);
            }
            if (AgrEnum.RelSystem.ECP.toString().equalsIgnoreCase(busiReqBO.getAgrAgreementBO().getRelSystem()) && org.springframework.util.StringUtils.hasText((String)busiReqBO.getAgrAgreementBO().getExtContractId())) {
                this.createEcpAgrItem(busiReqBO);
            }
            if (AgrEnum.RelSystem.OPS.toString().equalsIgnoreCase(busiReqBO.getAgrAgreementBO().getRelSystem()) && org.springframework.util.StringUtils.hasText((String)busiReqBO.getAgrAgreementBO().getExtContractId())) {
                this.createOpsAgrItem(busiReqBO);
            }
            if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementSkuBOs())) {
                this.insertAgreementSku(busiReqBO, agreement);
            }
        }
        AgreementPO updateAgreementPO = agreement;
        this.setUpdateValue(updateAgreementPO, busiReqBO.getAgrAgreementBO());
        updateAgreementPO.setEntAgreementCode(agreement.getEntAgreementCode());
        updateAgreementPO.setUpdateLoginId(busiReqBO.getMemIdIn());
        updateAgreementPO.setUpdateName(busiReqBO.getUsername());
        updateAgreementPO.setUpdateTime(new Date());
        if (AgrEnum.YesOrNo.YES.getCode().toString().equals(agreementPO.getCreateOrder()) && AgrEnum.EcpContractType.GDZJ.getCode().equals(agreementPO.getEcpContractType())) {
            updateAgreementPO.setAdjustPrice(AgrCommConstant.AdjustPrice.NO_ADJUST_PRICE);
            updateAgreementPO.setApproveLower((int)AgrEnum.YesOrNo.NO.getCode());
            updateAgreementPO.setAcceptHigher((int)AgrEnum.YesOrNo.NO.getCode());
        }
        try {
            int n = this.agreementMapper.updateBy(updateAgreementPO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("0101", "\u534f\u8bae\u66f4\u65b0\u5931\u8d25!\u8bf7\u68c0\u67e5\u8f93\u5165\u7684\u53c2\u6570!");
        }
        AgrCreateAgreementOtherAtomReqBO atomReqBO = new AgrCreateAgreementOtherAtomReqBO();
        atomReqBO.setMemIdIn(busiReqBO.getMemIdIn());
        atomReqBO.setSupplierId(agreement.getSupplierId());
        atomReqBO.setUsername(busiReqBO.getUsername());
        atomReqBO.setAgreementId(agreement.getAgreementId());
        atomReqBO.setAgreementVersion(agreement.getAgreementVersion());
        atomReqBO.setAgrAgreementAttachBOs(busiReqBO.getAgrAgreementAttachBOs());
        atomReqBO.setAgrAgreementScopeBOs(busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs());
        atomReqBO.setScopeType(busiReqBO.getAgrAgreementBO().getScopeType());
        atomReqBO.setBreachRateList(busiReqBO.getAgrAgreementBO().getBreachRateList());
        atomReqBO.setOperType("update");
        AgrCreateAgreementOtherAtomRspBO atomRspBO = this.agrCreateAgreementOtherAtomService.createAgreementOtherInfo(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
        if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(agreement.getAgreementMode())) {
            List agrBusiPropLabelList = busiReqBO.getAgrAgreementBO().getBusiPropLabels();
            List propLabelList = JSON.parseArray((String)JSON.toJSONString((Object)agrBusiPropLabelList), AgrRelBusiPropLabelPO.class);
            AgrCreateAgreementRelBusiPropLabeltomReqBO labelAtomReqBO = new AgrCreateAgreementRelBusiPropLabeltomReqBO();
            BeanUtils.copyProperties((Object)busiReqBO, (Object)((Object)labelAtomReqBO));
            labelAtomReqBO.setAgreementId(agreement.getAgreementId());
            labelAtomReqBO.setOperType("update");
            labelAtomReqBO.setBusiPropLabelLsit(propLabelList);
            AgrCreateAgreementRelBusiPropLabelAtomRspBO labelAtomRspBO = this.agrCreateAgreementRelBusiPropLabelAtomService.createAgreementRelBusiPropLabel(labelAtomReqBO);
            if (!"0000".equals(labelAtomRspBO.getRespCode())) {
                throw new BusinessException(labelAtomRspBO.getRespCode(), labelAtomRspBO.getRespDesc());
            }
        }
        if (busiReqBO.getAgrOrderInfo() != null) {
            AgrOrderInfoPO orderInfoPO = new AgrOrderInfoPO();
            BeanUtils.copyProperties((Object)busiReqBO.getAgrOrderInfo(), (Object)orderInfoPO);
            orderInfoPO.setAgreementId(busiReqBO.getAgreementId());
            AgrOrderInfoPO agrOrderInfoPo = new AgrOrderInfoPO();
            agrOrderInfoPo.setAgreementId(busiReqBO.getAgreementId());
            AgrOrderInfoPO agrOrderInfoPO = this.agrOrderInfoMapper.getModelBy(agrOrderInfoPo);
            if (agrOrderInfoPO != null) {
                this.agrOrderInfoMapper.updateBy(orderInfoPO, agrOrderInfoPO);
            } else {
                this.agrOrderInfoMapper.insert(orderInfoPO);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrInstallmentPaymentBOs())) {
            AgrInstallmentPaymentPO agrInstallmentPaymentPO = new AgrInstallmentPaymentPO();
            agrInstallmentPaymentPO.setAgreementId(busiReqBO.getAgreementId());
            this.agrInstallmentPaymentMapper.deleteBy(agrInstallmentPaymentPO);
            List<AgrInstallmentPaymentPO> installmentPaymentPos = busiReqBO.getAgrInstallmentPaymentBOs().stream().map(bo -> {
                AgrInstallmentPaymentPO po = new AgrInstallmentPaymentPO();
                po.setId(Sequence.getInstance().nextId());
                po.setAgreementId(busiReqBO.getAgreementId());
                po.setStageName(bo.getStageName());
                po.setStageValue(bo.getStageValue());
                po.setStageClause(bo.getStageClause());
                po.setOrdered(bo.getOrdered());
                po.setPaymentDays(bo.getPaymentDays());
                return po;
            }).collect(Collectors.toList());
            this.agrInstallmentPaymentMapper.insertBatch(installmentPaymentPos);
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u4e3b\u4f53\u4fee\u6539\u6210\u529f\uff01");
        return rsp;
    }

    private void setUpdateValue(AgreementPO updateAgreementPO, AgrAgreementBO agrAgreementBO) {
        updateAgreementPO.setAgreementMode(agrAgreementBO.getAgreementMode());
        updateAgreementPO.setAgreementVariety(agrAgreementBO.getAgreementVariety());
        updateAgreementPO.setEntAgreementCode(agrAgreementBO.getEntAgreementCode());
        updateAgreementPO.setAgreementName(agrAgreementBO.getAgreementName());
        updateAgreementPO.setMatterName(agrAgreementBO.getMatterName());
        updateAgreementPO.setAgreementSrc(agrAgreementBO.getAgreementSrc());
        updateAgreementPO.setVendorId(agrAgreementBO.getVendorId());
        updateAgreementPO.setVendorName(agrAgreementBO.getVendorName());
        updateAgreementPO.setVendorContact(agrAgreementBO.getVendorContact());
        updateAgreementPO.setVendorPhone(agrAgreementBO.getVendorPhone());
        updateAgreementPO.setAgreementType(agrAgreementBO.getAgreementType());
        updateAgreementPO.setEffDate(agrAgreementBO.getEffDate());
        updateAgreementPO.setExpDate(agrAgreementBO.getExpDate());
        updateAgreementPO.setTaxRate(agrAgreementBO.getTaxRate());
        updateAgreementPO.setPrePayEnt(agrAgreementBO.getPrePayEnt());
        updateAgreementPO.setMatPayEnt(agrAgreementBO.getMatPayEnt());
        updateAgreementPO.setProPayEnt(agrAgreementBO.getProPayEnt());
        updateAgreementPO.setVerPayEnt(agrAgreementBO.getVerPayEnt());
        updateAgreementPO.setPilPayEnt(agrAgreementBO.getPilPayEnt());
        updateAgreementPO.setQuaPayEnt(agrAgreementBO.getQuaPayEnt());
        updateAgreementPO.setMatPaySup(agrAgreementBO.getMatPaySup());
        updateAgreementPO.setProPaySup(agrAgreementBO.getProPaySup());
        updateAgreementPO.setVerPaySup(agrAgreementBO.getVerPaySup());
        updateAgreementPO.setPilPaySup(agrAgreementBO.getPilPaySup());
        updateAgreementPO.setQuaPaySup(agrAgreementBO.getQuaPaySup());
        updateAgreementPO.setPrePaySup(agrAgreementBO.getPrePaySup());
        updateAgreementPO.setPayClause(agrAgreementBO.getPayClause());
        updateAgreementPO.setWarantty(agrAgreementBO.getWarantty());
        updateAgreementPO.setSignTime(agrAgreementBO.getSignTime());
        updateAgreementPO.setScopeType(agrAgreementBO.getScopeType());
        updateAgreementPO.setPriceType(agrAgreementBO.getPriceType());
        updateAgreementPO.setAdjustPrice(agrAgreementBO.getAdjustPrice());
        updateAgreementPO.setTradeMode(agrAgreementBO.getTradeMode());
        updateAgreementPO.setRemark(agrAgreementBO.getRemark());
        updateAgreementPO.setExtField1(agrAgreementBO.getExtField1());
        updateAgreementPO.setExtField2(agrAgreementBO.getExtField2());
        updateAgreementPO.setExtField3(agrAgreementBO.getExtField3());
        updateAgreementPO.setVendorDepartmentId(agrAgreementBO.getVendorDepartmentId());
        updateAgreementPO.setVendorDepartmentName(agrAgreementBO.getVendorDepartmentName());
        updateAgreementPO.setContractId(agrAgreementBO.getContractId());
        updateAgreementPO.setContractName(agrAgreementBO.getContractName());
        updateAgreementPO.setDifferencesAcceptance(agrAgreementBO.getDifferencesAcceptance());
        updateAgreementPO.setAcceptanceScale(agrAgreementBO.getAcceptanceScale());
        updateAgreementPO.setAdjustAcceptance(agrAgreementBO.getAdjustAcceptance());
        updateAgreementPO.setEcpPurType(agrAgreementBO.getEcpPurType());
        updateAgreementPO.setAgreementPic(agrAgreementBO.getAgreementPic());
        updateAgreementPO.setPaymentMethod(agrAgreementBO.getPaymentMethod());
        updateAgreementPO.setPaymentExtendDays(agrAgreementBO.getPaymentExtendDays());
        updateAgreementPO.setPayMethod(agrAgreementBO.getPayMethod());
        updateAgreementPO.setPaymentDays(agrAgreementBO.getPaymentDays());
        updateAgreementPO.setEcpContractId(agrAgreementBO.getEcpContractId());
        updateAgreementPO.setEcpProjectName(agrAgreementBO.getEcpProjectName());
        updateAgreementPO.setEcpProjectId(agrAgreementBO.getEcpProjectId());
        updateAgreementPO.setEcpProjectCode(agrAgreementBO.getEcpProjectCode());
        updateAgreementPO.setAgreementShortName(agrAgreementBO.getAgreementShortName());
        updateAgreementPO.setAgreementTentativeAmount(agrAgreementBO.getAgreementTentativeAmount());
        updateAgreementPO.setEcpContractType(agrAgreementBO.getEcpContractType());
        updateAgreementPO.setEcpIsOnlineContract(agrAgreementBO.getEcpIsOnlineContract());
        updateAgreementPO.setEcpVendorSource(agrAgreementBO.getEcpVendorSource());
        updateAgreementPO.setEcpProcurement(agrAgreementBO.getEcpProcurement());
        updateAgreementPO.setRelSystem(agrAgreementBO.getRelSystem());
        updateAgreementPO.setSrmPaymentTerms(agrAgreementBO.getSrmPaymentTerms());
        updateAgreementPO.setSrmComments(agrAgreementBO.getSrmComments());
        updateAgreementPO.setExtContractId(agrAgreementBO.getExtContractId());
        updateAgreementPO.setExtContractCode(agrAgreementBO.getExtContractCode());
        updateAgreementPO.setUpperContractId(agrAgreementBO.getUpperContractId());
        updateAgreementPO.setUpperContractCode(agrAgreementBO.getUpperContractCode());
        updateAgreementPO.setCentralizedCategory(agrAgreementBO.getCentralizedCategory());
        updateAgreementPO.setCreateOrder(agrAgreementBO.getCreateOrder());
        updateAgreementPO.setAdjustPaymentStage(agrAgreementBO.getAdjustPaymentStage());
    }

    private void createSrmAgrItem(AgrModifyAgreementSubjectBusiReqBO busiReqBO) {
        List agrAgreementScopeBOs;
        SrmContractPO srmContractPo = new SrmContractPO();
        srmContractPo.setContractId(busiReqBO.getAgrAgreementBO().getExtContractId());
        srmContractPo.setContractCode(busiReqBO.getAgrAgreementBO().getExtContractCode());
        srmContractPo = this.srmContractMapper.getModelBy(srmContractPo);
        if (srmContractPo == null) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5173\u8054SRM\u5408\u540c\u4fe1\u606f");
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs())) {
            busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs().forEach(bo -> bo.setScopeMode(AgrCommConstant.ScopeMode.THIS_AND_ITS_DEPARTMENT));
        }
        if (CollectionUtils.isEmpty((Collection)(agrAgreementScopeBOs = busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs()))) {
            throw new BusinessException("8888", "\u5e94\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SrmContractItemPO srmContractItemPo = new SrmContractItemPO();
        srmContractItemPo.setContractId(busiReqBO.getAgrAgreementBO().getExtContractId());
        srmContractItemPo.setContractCode(busiReqBO.getAgrAgreementBO().getExtContractCode());
        List<SrmContractItemPO> srmContractItemPos = this.srmContractItemMapper.getList(srmContractItemPo);
        if (!CollectionUtils.isEmpty(srmContractItemPos)) {
            ArrayList<AgrAgreementSkuBO> agrAgreementSkuBOs;
            List materialCodes = srmContractItemPos.stream().map(SrmContractItemPO::getMaterialId).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            Map<Object, Object> collectByMaterialCode = new HashMap();
            Map<Object, Object> materialByCodeAbilityBoMap = new HashMap();
            if (!CollectionUtils.isEmpty(materialCodes)) {
                UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                uccQryCommodityTypeByMaterialReqBo.setMaterialCodes(materialCodes);
                UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByMaterial(uccQryCommodityTypeByMaterialReqBo);
                if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                    throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u7f16\u7801\u5931\u8d25");
                }
                collectByMaterialCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getMaterialCode, bo -> bo, (a, b) -> a));
                CnncBatchQryMaterialByCodeAbilityReqBo cnncBatchQryMaterialByCodeAbilityReqBo = new CnncBatchQryMaterialByCodeAbilityReqBo();
                cnncBatchQryMaterialByCodeAbilityReqBo.setMaterialCodes(materialCodes);
                cnncBatchQryMaterialByCodeAbilityReqBo.setFreezeFlag(null);
                CnncBatchQryMaterialByCodeAbilityRspBo materialByCodeAbilityRspBo = this.cnncBatchQryMaterialByCodeAbilityService.getMaterialByCode(cnncBatchQryMaterialByCodeAbilityReqBo);
                if (!"0000".equals(materialByCodeAbilityRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)materialByCodeAbilityRspBo.getRows())) {
                    throw new ZTBusinessException("\u901a\u8fc7\u7269\u6599\u7f16\u7801\u6279\u91cf\u67e5\u7269\u6599\u4fe1\u606f\u5931\u8d25");
                }
                materialByCodeAbilityBoMap = materialByCodeAbilityRspBo.getRows().stream().collect(Collectors.toMap(CnncBatchQryMaterialByCodeAbilityBo::getMaterialCode, bo -> bo, (a, b) -> a));
            }
            List<String> catalogCodes = srmContractItemPos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getMaterialId())).map(SrmContractItemPO::getThirdCatalogId).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            HashMap collectByCatalogCode = new HashMap();
            if (!CollectionUtils.isEmpty(catalogCodes)) {
                UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                uccQryCommodityTypeByMaterialReqBo.setCatalogCodes(catalogCodes);
                UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByAnyCatalogCode(uccQryCommodityTypeByMaterialReqBo);
                if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                    throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u5206\u7c7b\u5931\u8d25");
                }
                HashMap<String, List> existsCatalogCodes = new HashMap<String, List>(catalogCodes.size());
                catalogCodes.forEach(catalogCode -> {
                    for (UccMaterialCommodityTypeBO typeBo : uccQryCommodityTypeByMaterialRspBo.getMaterialTypes()) {
                        if (!catalogCode.equals(typeBo.getL3CatalogCode()) && !catalogCode.equals(typeBo.getL2CatalogCode())) continue;
                        if (existsCatalogCodes.containsKey(catalogCode)) {
                            ((List)existsCatalogCodes.get(catalogCode)).add(typeBo);
                            continue;
                        }
                        ArrayList<UccMaterialCommodityTypeBO> list = new ArrayList<UccMaterialCommodityTypeBO>();
                        list.add(typeBo);
                        existsCatalogCodes.put((String)catalogCode, list);
                    }
                });
                existsCatalogCodes.forEach((catalogCode, typeBos) -> {
                    UccMaterialCommodityTypeBO reduced = (UccMaterialCommodityTypeBO)typeBos.stream().reduce(typeBos.get(0), this::mergeTypeMap);
                    collectByCatalogCode.put(catalogCode, reduced);
                });
            }
            Map supplierSaleRspBOMap = null;
            if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(busiReqBO.getAgrAgreementBO().getAgreementMode()) && busiReqBO.getAgrAgreementBO().getContractId() != null) {
                ContractSupplierSaleReqBO contractSupplierSaleReqBO = new ContractSupplierSaleReqBO();
                contractSupplierSaleReqBO.setContractId(busiReqBO.getAgrAgreementBO().getContractId());
                contractSupplierSaleReqBO.setPageNo(-1);
                contractSupplierSaleReqBO.setPageSize(-1);
                RspPage contractSupplierSalePage = this.qryContractSupplierListSaleService.selecContractSupplierList(contractSupplierSaleReqBO);
                if (contractSupplierSalePage != null && !CollectionUtils.isEmpty((Collection)contractSupplierSalePage.getRows())) {
                    supplierSaleRspBOMap = contractSupplierSalePage.getRows().stream().collect(Collectors.toMap(ContractSupplierSaleRspBO::getCategoryId, Function.identity(), (key1, key2) -> key2));
                } else {
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5165\u9a7b\u5408\u540c\u4fe1\u606f");
                }
            }
            if ((agrAgreementSkuBOs = busiReqBO.getAgrAgreementSkuBOs()) == null) {
                agrAgreementSkuBOs = new ArrayList<AgrAgreementSkuBO>();
            }
            Map<String, String> conversionScaleMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "MEASURE_CONVERSION_RELATIONSHIPS");
            for (SrmContractItemPO srmItemPo : srmContractItemPos) {
                UccMaterialCommodityTypeBO uccMaterialCommodityTypeBo;
                AgrAgreementSkuBO bo2 = new AgrAgreementSkuBO();
                if (StringUtils.isBlank((CharSequence)srmItemPo.getMaterialId())) {
                    uccMaterialCommodityTypeBo = (UccMaterialCommodityTypeBO)collectByCatalogCode.get(srmItemPo.getThirdCatalogId());
                } else {
                    uccMaterialCommodityTypeBo = (UccMaterialCommodityTypeBO)collectByMaterialCode.get(srmItemPo.getMaterialId());
                    CnncBatchQryMaterialByCodeAbilityBo cnncBatchQryMaterialByCodeAbilityBo = (CnncBatchQryMaterialByCodeAbilityBo)materialByCodeAbilityBoMap.get(srmItemPo.getMaterialId());
                    if (null != cnncBatchQryMaterialByCodeAbilityBo) {
                        if (!Objects.equals(cnncBatchQryMaterialByCodeAbilityBo.getFreezeFlag(), YesNoEnum.NO.getType()) || !Objects.equals(cnncBatchQryMaterialByCodeAbilityBo.getIsDelete(), YesNoEnum.NO.getType())) {
                            bo2.setFreezeFlag(AgrCommConstant.IsDelete.DELETED);
                        } else {
                            bo2.setFreezeFlag(AgrCommConstant.IsDelete.NORMAL);
                        }
                    }
                }
                bo2.setMeasureName(srmItemPo.getMeasureName());
                if (uccMaterialCommodityTypeBo != null && !CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) {
                    List collect = uccMaterialCommodityTypeBo.getTypeIdAndName().keySet().stream().sorted().collect(Collectors.toList());
                    for (Long item2 : collect) {
                        bo2.setCatalogId(item2.toString());
                        bo2.setCatalogName((String)uccMaterialCommodityTypeBo.getTypeIdAndName().get(item2));
                        bo2.setCatalogVariety(uccMaterialCommodityTypeBo.getVariety());
                        if (CollectionUtils.isEmpty(supplierSaleRspBOMap)) {
                            bo2.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.YES.getCode().byteValue()));
                            break;
                        }
                        ContractSupplierSaleRspBO contractSupplierSaleRspBo = (ContractSupplierSaleRspBO)supplierSaleRspBOMap.get(item2);
                        if (contractSupplierSaleRspBo == null) {
                            bo2.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.NO.getCode().byteValue()));
                            continue;
                        }
                        bo2.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.YES.getCode().byteValue()));
                        break;
                    }
                    bo2.setMaterialMeasureName(uccMaterialCommodityTypeBo.getMeasureName());
                    if (StringUtils.isNotBlank((CharSequence)srmItemPo.getMaterialId())) {
                        if (StringUtils.isNotBlank((CharSequence)bo2.getMeasureName()) && StringUtils.isNotBlank((CharSequence)bo2.getMaterialMeasureName())) {
                            if (bo2.getMeasureName().equals(bo2.getMaterialMeasureName())) {
                                bo2.setUnitOfMeasureScale(Integer.valueOf(1));
                                bo2.setMaterialUnitOfMeasureScale(Integer.valueOf(1));
                            } else {
                                String[] split;
                                String conversionScale = conversionScaleMap.get(bo2.getMeasureName() + ":" + bo2.getMaterialMeasureName());
                                if (StringUtils.isNotBlank((CharSequence)conversionScale) && (split = conversionScale.split(":")).length == 2) {
                                    bo2.setUnitOfMeasureScale(Integer.valueOf(split[0]));
                                    bo2.setMaterialUnitOfMeasureScale(Integer.valueOf(split[1]));
                                }
                            }
                        }
                    } else {
                        bo2.setUnitOfMeasureScale(Integer.valueOf(1));
                        bo2.setMaterialUnitOfMeasureScale(Integer.valueOf(1));
                    }
                } else {
                    bo2.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.NO.getCode().byteValue()));
                }
                bo2.setScMaterialCode(srmItemPo.getScMaterialCode());
                bo2.setWarrantyLevel(srmItemPo.getWarrantyLevel());
                bo2.setNuclearSafetyLevel(srmItemPo.getNuclearSafetyLevel());
                bo2.setMaterialId(srmItemPo.getMaterialId());
                bo2.setMaterialName(srmItemPo.getMaterialName());
                bo2.setModel(srmItemPo.getModel());
                bo2.setFigure(srmItemPo.getFigure());
                bo2.setSpec(srmItemPo.getSpec());
                bo2.setTexture(srmItemPo.getTexture());
                bo2.setBuyNumber(srmItemPo.getBuyNumber());
                try {
                    bo2.setBuyPrice(MoneyUtil.b2l(srmItemPo.getBuyPrice()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bo2.setTaxRate(Byte.valueOf(srmItemPo.getTaxRate().byteValue()));
                bo2.setThirdCatalogId(srmItemPo.getThirdCatalogId());
                bo2.setComments(srmItemPo.getComments());
                bo2.setOrderedQuantity(BigDecimal.ZERO);
                bo2.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
                bo2.setExtItemCode(srmItemPo.getContractItemCode());
                bo2.setExtItemId(srmItemPo.getContractItemId());
                bo2.setMarkupRate(Double.valueOf(0.0));
                bo2.setMarkupValue("0");
                bo2.setItemName(org.springframework.util.StringUtils.hasText((String)bo2.getMaterialName()) ? bo2.getMaterialName() : bo2.getCatalogName());
                bo2.setBrandName(srmContractPo.getVendorName());
                bo2.setManufacturer(srmContractPo.getVendorName());
                bo2.setIsOil(AgrEnum.YesOrNo.NO.getCode());
                bo2.setProducingArea(srmItemPo.getProducingArea());
                bo2.setWarantty(busiReqBO.getAgrAgreementBO().getWarantty());
                bo2.setDifferencesAcceptance(Integer.valueOf(null != busiReqBO.getAgrAgreementBO().getDifferencesAcceptance() ? busiReqBO.getAgrAgreementBO().getDifferencesAcceptance() : 0));
                bo2.setAcceptanceScale(busiReqBO.getAgrAgreementBO().getAcceptanceScale());
                bo2.setAdjustAcceptance(busiReqBO.getAgrAgreementBO().getAdjustAcceptance());
                bo2.setAdjustPrice(busiReqBO.getAgrAgreementBO().getAdjustPrice());
                agrAgreementSkuBOs.add(bo2);
            }
            this.setRateTypeCode(agrAgreementSkuBOs);
            busiReqBO.setAgrAgreementSkuBOs(agrAgreementSkuBOs);
        }
    }

    private UccMaterialCommodityTypeBO mergeTypeMap(UccMaterialCommodityTypeBO bo1, UccMaterialCommodityTypeBO bo2) {
        if (bo1.getTypeIdAndName() == null) {
            bo1.setTypeIdAndName(new LinkedHashMap());
        }
        if (!CollectionUtils.isEmpty((Map)bo2.getTypeIdAndName())) {
            bo2.getTypeIdAndName().forEach((typeId, typeName) -> {
                if (!bo1.getTypeIdAndName().containsKey(typeId)) {
                    bo1.getTypeIdAndName().put(typeId, typeName);
                }
            });
        }
        return bo1;
    }

    private void createEcpAgrItem(AgrModifyAgreementSubjectBusiReqBO busiReqBO) {
        EcpContractPO ecpContractPO = new EcpContractPO();
        ecpContractPO.setContractId(busiReqBO.getAgrAgreementBO().getExtContractId());
        ecpContractPO.setContractCode(busiReqBO.getAgrAgreementBO().getExtContractCode());
        ecpContractPO = this.ecpContractMapper.getModelBy(ecpContractPO);
        if (ecpContractPO == null) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5173\u8054ECP\u5408\u540c\u4fe1\u606f");
        }
        AgrEnum.ExtScopeType scopeType = AgrEnum.ExtScopeType.getByCode((String)ecpContractPO.getScopeType().toString());
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs()) && scopeType != null) {
            busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs().forEach(bo -> bo.setScopeMode(scopeType.getScopeMode()));
        }
        EcpContractItemPO ecpContractItemPo = new EcpContractItemPO();
        ecpContractItemPo.setEcpContractId(busiReqBO.getAgrAgreementBO().getExtContractId());
        List<EcpContractItemPO> ecpContractItemPos = this.ecpContractItemMapper.getList(ecpContractItemPo);
        if (!CollectionUtils.isEmpty(ecpContractItemPos)) {
            ArrayList<AgrAgreementSkuBO> agrAgreementSkuBOs = busiReqBO.getAgrAgreementSkuBOs();
            if (agrAgreementSkuBOs == null) {
                agrAgreementSkuBOs = new ArrayList<AgrAgreementSkuBO>();
            }
            List materialCodes = ecpContractItemPos.stream().map(EcpContractItemPO::getMaterialCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            Map<Object, Object> collectByMaterialCode = new HashMap();
            Map<Object, Object> materialByCodeAbilityBoMap = new HashMap();
            if (!CollectionUtils.isEmpty(materialCodes)) {
                UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                uccQryCommodityTypeByMaterialReqBo.setMaterialCodes(materialCodes);
                UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByMaterial(uccQryCommodityTypeByMaterialReqBo);
                if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                    throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u7f16\u7801\u5931\u8d25");
                }
                collectByMaterialCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getMaterialCode, bo -> bo, (a, b) -> a));
                CnncBatchQryMaterialByCodeAbilityReqBo cnncBatchQryMaterialByCodeAbilityReqBo = new CnncBatchQryMaterialByCodeAbilityReqBo();
                cnncBatchQryMaterialByCodeAbilityReqBo.setMaterialCodes(materialCodes);
                cnncBatchQryMaterialByCodeAbilityReqBo.setFreezeFlag(null);
                CnncBatchQryMaterialByCodeAbilityRspBo materialByCodeAbilityRspBo = this.cnncBatchQryMaterialByCodeAbilityService.getMaterialByCode(cnncBatchQryMaterialByCodeAbilityReqBo);
                if (!"0000".equals(materialByCodeAbilityRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)materialByCodeAbilityRspBo.getRows())) {
                    throw new ZTBusinessException("\u901a\u8fc7\u7269\u6599\u7f16\u7801\u6279\u91cf\u67e5\u7269\u6599\u4fe1\u606f\u5931\u8d25");
                }
                materialByCodeAbilityBoMap = materialByCodeAbilityRspBo.getRows().stream().collect(Collectors.toMap(CnncBatchQryMaterialByCodeAbilityBo::getMaterialCode, bo -> bo, (a, b) -> a));
            }
            List catalogCodes = ecpContractItemPos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getMaterialCode())).map(EcpContractItemPO::getCatalogCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            Map<Object, Object> collectByCatalogCode = new HashMap();
            if (!CollectionUtils.isEmpty(catalogCodes)) {
                UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                uccQryCommodityTypeByMaterialReqBo.setSecondCatalogs(catalogCodes);
                UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByl2CatalogCode(uccQryCommodityTypeByMaterialReqBo);
                if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                    throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u5206\u7c7b\u5931\u8d25");
                }
                collectByCatalogCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getL2CatalogCode, bo -> bo, (a, b) -> a));
            }
            Map<Object, Object> supplierSaleRspBOMap = new HashMap();
            if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(busiReqBO.getAgrAgreementBO().getAgreementMode()) && busiReqBO.getAgrAgreementBO().getContractId() != null) {
                ContractSupplierSaleReqBO contractSupplierSaleReqBO = new ContractSupplierSaleReqBO();
                contractSupplierSaleReqBO.setContractId(busiReqBO.getAgrAgreementBO().getContractId());
                contractSupplierSaleReqBO.setPageNo(-1);
                contractSupplierSaleReqBO.setPageSize(-1);
                RspPage contractSupplierSalePage = this.qryContractSupplierListSaleService.selecContractSupplierList(contractSupplierSaleReqBO);
                if (contractSupplierSalePage != null && !CollectionUtils.isEmpty((Collection)contractSupplierSalePage.getRows())) {
                    supplierSaleRspBOMap = contractSupplierSalePage.getRows().stream().collect(Collectors.toMap(ContractSupplierSaleRspBO::getCategoryId, Function.identity(), (key1, key2) -> key2));
                } else {
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5165\u9a7b\u5408\u540c\u4fe1\u606f");
                }
            }
            Map<String, String> conversionScaleMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "MEASURE_CONVERSION_RELATIONSHIPS");
            for (EcpContractItemPO ecpContractItem : ecpContractItemPos) {
                UccMaterialCommodityTypeBO uccMaterialCommodityTypeBo;
                AgrAgreementSkuBO bo2 = new AgrAgreementSkuBO();
                if (StringUtils.isBlank((CharSequence)ecpContractItem.getMaterialCode())) {
                    uccMaterialCommodityTypeBo = (UccMaterialCommodityTypeBO)collectByCatalogCode.get(ecpContractItem.getCatalogCode());
                } else {
                    uccMaterialCommodityTypeBo = (UccMaterialCommodityTypeBO)collectByMaterialCode.get(ecpContractItem.getMaterialCode());
                    CnncBatchQryMaterialByCodeAbilityBo cnncBatchQryMaterialByCodeAbilityBo = (CnncBatchQryMaterialByCodeAbilityBo)materialByCodeAbilityBoMap.get(ecpContractItem.getMaterialCode());
                    if (null != cnncBatchQryMaterialByCodeAbilityBo) {
                        if (!Objects.equals(cnncBatchQryMaterialByCodeAbilityBo.getFreezeFlag(), YesNoEnum.NO.getType()) || !Objects.equals(cnncBatchQryMaterialByCodeAbilityBo.getIsDelete(), YesNoEnum.NO.getType())) {
                            bo2.setFreezeFlag(AgrCommConstant.IsDelete.DELETED);
                        } else {
                            bo2.setFreezeFlag(AgrCommConstant.IsDelete.NORMAL);
                        }
                    }
                }
                bo2.setMeasureName(ecpContractItem.getMeasureName());
                if (uccMaterialCommodityTypeBo != null && !CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) {
                    List collect = uccMaterialCommodityTypeBo.getTypeIdAndName().keySet().stream().sorted().collect(Collectors.toList());
                    for (Long item2 : collect) {
                        bo2.setCatalogId(item2.toString());
                        bo2.setCatalogName((String)uccMaterialCommodityTypeBo.getTypeIdAndName().get(item2));
                        bo2.setMaterialName(uccMaterialCommodityTypeBo.getLongDesc());
                        if (StringUtils.isBlank((CharSequence)ecpContractItem.getVariety())) {
                            bo2.setCatalogVariety(uccMaterialCommodityTypeBo.getVariety());
                        }
                        if (!org.springframework.util.StringUtils.hasText((String)ecpContractItem.getThirdCatalogCode())) {
                            ecpContractItem.setThirdCatalogCode(uccMaterialCommodityTypeBo.getL3CatalogCode());
                        }
                        if (CollectionUtils.isEmpty(supplierSaleRspBOMap)) {
                            bo2.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.YES.getCode().byteValue()));
                            break;
                        }
                        ContractSupplierSaleRspBO contractSupplierSaleRspBo = (ContractSupplierSaleRspBO)supplierSaleRspBOMap.get(item2);
                        if (contractSupplierSaleRspBo == null) {
                            bo2.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.NO.getCode().byteValue()));
                            continue;
                        }
                        bo2.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.YES.getCode().byteValue()));
                        break;
                    }
                    bo2.setMaterialMeasureName(uccMaterialCommodityTypeBo.getMeasureName());
                    if (StringUtils.isNotBlank((CharSequence)ecpContractItem.getMaterialCode())) {
                        if (StringUtils.isNotBlank((CharSequence)bo2.getMeasureName()) && StringUtils.isNotBlank((CharSequence)bo2.getMaterialMeasureName())) {
                            if (bo2.getMeasureName().equals(bo2.getMaterialMeasureName())) {
                                bo2.setUnitOfMeasureScale(Integer.valueOf(1));
                                bo2.setMaterialUnitOfMeasureScale(Integer.valueOf(1));
                            } else {
                                String[] split;
                                String conversionScale = conversionScaleMap.get(bo2.getMeasureName() + ":" + bo2.getMaterialMeasureName());
                                if (StringUtils.isNotBlank((CharSequence)conversionScale) && (split = conversionScale.split(":")).length == 2) {
                                    bo2.setUnitOfMeasureScale(Integer.valueOf(split[0]));
                                    bo2.setMaterialUnitOfMeasureScale(Integer.valueOf(split[1]));
                                }
                            }
                        }
                    } else {
                        bo2.setUnitOfMeasureScale(Integer.valueOf(1));
                        bo2.setMaterialUnitOfMeasureScale(Integer.valueOf(1));
                    }
                } else {
                    bo2.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.NO.getCode().byteValue()));
                }
                bo2.setScMaterialCode(ecpContractItem.getScMaterialCode());
                bo2.setWarrantyLevel(ecpContractItem.getWarrantyLevel());
                bo2.setNuclearSafetyLevel(ecpContractItem.getNuclearSafetyLevel());
                if (StringUtils.isNotBlank((CharSequence)ecpContractItem.getMaterialCode())) {
                    bo2.setMaterialId(ecpContractItem.getMaterialCode());
                }
                bo2.setModel(ecpContractItem.getModel());
                bo2.setSpec(ecpContractItem.getSpec());
                if (ecpContractItem.getBuyNumber() == null) {
                    bo2.setBuyNumber(BigDecimal.ZERO);
                } else {
                    bo2.setBuyNumber(ecpContractItem.getBuyNumber());
                }
                try {
                    if (ecpContractItem.getBuyPrice() == null) {
                        bo2.setBuyPrice(Long.valueOf(0L));
                    } else {
                        bo2.setBuyPrice(MoneyUtil.b2l(ecpContractItem.getBuyPrice()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ecpContractItem.getTaxRate() != null) {
                    bo2.setTaxRate(Byte.valueOf(ecpContractItem.getTaxRate().byteValue()));
                }
                if (StringUtils.isNotBlank((CharSequence)ecpContractItem.getThirdCatalogCode())) {
                    bo2.setThirdCatalogId(ecpContractItem.getThirdCatalogCode());
                }
                bo2.setComments(ecpContractItem.getComments());
                bo2.setOrderedQuantity(BigDecimal.ZERO);
                bo2.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
                bo2.setExtItemCode(ecpContractItem.getContractItemCode());
                bo2.setExtItemId(ecpContractItem.getContractItemId());
                bo2.setMarkupRate(Double.valueOf(0.0));
                bo2.setMarkupValue("0");
                bo2.setItemName(ecpContractItem.getItemName());
                if (StringUtils.isBlank((CharSequence)ecpContractItem.getBrandName())) {
                    bo2.setBrandName(busiReqBO.getAgrAgreementBO().getVendorName());
                } else {
                    bo2.setBrandName(ecpContractItem.getBrandName());
                }
                if (StringUtils.isBlank((CharSequence)ecpContractItem.getManufacturer())) {
                    bo2.setManufacturer(busiReqBO.getAgrAgreementBO().getVendorName());
                } else {
                    bo2.setManufacturer(ecpContractItem.getManufacturer());
                }
                bo2.setIsOil(AgrEnum.YesOrNo.NO.getCode());
                bo2.setProducingArea(ecpContractItem.getProducingArea());
                bo2.setWarantty(busiReqBO.getAgrAgreementBO().getWarantty());
                bo2.setDifferencesAcceptance(Integer.valueOf(null != busiReqBO.getAgrAgreementBO().getDifferencesAcceptance() ? busiReqBO.getAgrAgreementBO().getDifferencesAcceptance() : 0));
                bo2.setAcceptanceScale(busiReqBO.getAgrAgreementBO().getAcceptanceScale());
                bo2.setAdjustAcceptance(busiReqBO.getAgrAgreementBO().getAdjustAcceptance());
                bo2.setAdjustPrice(busiReqBO.getAgrAgreementBO().getAdjustPrice());
                if (StringUtils.isNotBlank((CharSequence)ecpContractItem.getVariety())) {
                    bo2.setCatalogVariety(Integer.valueOf(ecpContractItem.getVariety()));
                }
                agrAgreementSkuBOs.add(bo2);
            }
            this.setRateTypeCode(agrAgreementSkuBOs);
            busiReqBO.setAgrAgreementSkuBOs(agrAgreementSkuBOs);
        }
    }

    private void createOpsAgrItem(AgrModifyAgreementSubjectBusiReqBO busiReqBO) {
        OpsContractPO opsContractPo = new OpsContractPO();
        opsContractPo.setContractId(busiReqBO.getAgrAgreementBO().getExtContractId());
        opsContractPo.setContractCode(busiReqBO.getAgrAgreementBO().getExtContractCode());
        opsContractPo = this.opsContractMapper.getModelBy(opsContractPo);
        if (opsContractPo == null) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5173\u8054\u5408\u540c\u4fe1\u606f");
        }
        AgrEnum.ExtScopeType scopeType = AgrEnum.ExtScopeType.getByCode((String)opsContractPo.getScopeType());
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs()) && scopeType != null) {
            busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs().forEach(bo -> bo.setScopeMode(scopeType.getScopeMode()));
        }
        busiReqBO.getAgrAgreementBO().setPlanType(opsContractPo.getPlanType());
        busiReqBO.getAgrAgreementBO().setContractualRelationship(opsContractPo.getContractualRelationship());
        OpsContractItemPO opsContractItemPo = new OpsContractItemPO();
        opsContractItemPo.setContractId(busiReqBO.getAgrAgreementBO().getExtContractId());
        List<OpsContractItemPO> opsContractItemPos = this.opsContractItemMapper.getList(opsContractItemPo);
        if (!CollectionUtils.isEmpty(opsContractItemPos)) {
            ArrayList<AgrAgreementSkuBO> agrAgreementSkuBOs = busiReqBO.getAgrAgreementSkuBOs();
            if (agrAgreementSkuBOs == null) {
                agrAgreementSkuBOs = new ArrayList<AgrAgreementSkuBO>();
            }
            List materialCodes = opsContractItemPos.stream().map(OpsContractItemPO::getMaterialCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            Map<Object, Object> collectByMaterialCode = new HashMap();
            if (!CollectionUtils.isEmpty(materialCodes)) {
                UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                uccQryCommodityTypeByMaterialReqBo.setMaterialCodes(materialCodes);
                UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByMaterial(uccQryCommodityTypeByMaterialReqBo);
                if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                    throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u7f16\u7801\u5931\u8d25");
                }
                collectByMaterialCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getMaterialCode, bo -> bo, (a, b) -> a));
            }
            List catalogCodes = opsContractItemPos.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getMaterialCode())).map(OpsContractItemPO::getCatalogCode).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            Map<Object, Object> collectByCatalogCode = new HashMap();
            Map<Object, Object> materialByCodeAbilityBoMap = new HashMap();
            if (!CollectionUtils.isEmpty(catalogCodes)) {
                UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                uccQryCommodityTypeByMaterialReqBo.setSecondCatalogs(catalogCodes);
                UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByl2CatalogCode(uccQryCommodityTypeByMaterialReqBo);
                if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                    throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u5206\u7c7b\u5931\u8d25");
                }
                collectByCatalogCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getL2CatalogCode, bo -> bo, (a, b) -> a));
                CnncBatchQryMaterialByCodeAbilityReqBo cnncBatchQryMaterialByCodeAbilityReqBo = new CnncBatchQryMaterialByCodeAbilityReqBo();
                cnncBatchQryMaterialByCodeAbilityReqBo.setMaterialCodes(materialCodes);
                cnncBatchQryMaterialByCodeAbilityReqBo.setFreezeFlag(null);
                CnncBatchQryMaterialByCodeAbilityRspBo materialByCodeAbilityRspBo = this.cnncBatchQryMaterialByCodeAbilityService.getMaterialByCode(cnncBatchQryMaterialByCodeAbilityReqBo);
                if (!"0000".equals(materialByCodeAbilityRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)materialByCodeAbilityRspBo.getRows())) {
                    throw new ZTBusinessException("\u901a\u8fc7\u7269\u6599\u7f16\u7801\u6279\u91cf\u67e5\u7269\u6599\u4fe1\u606f\u5931\u8d25");
                }
                materialByCodeAbilityBoMap = materialByCodeAbilityRspBo.getRows().stream().collect(Collectors.toMap(CnncBatchQryMaterialByCodeAbilityBo::getMaterialCode, bo -> bo, (a, b) -> a));
            }
            Map<Object, Object> supplierSaleRspBOMap = new HashMap();
            if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(busiReqBO.getAgrAgreementBO().getAgreementMode()) && busiReqBO.getAgrAgreementBO().getContractId() != null) {
                ContractSupplierSaleReqBO contractSupplierSaleReqBO = new ContractSupplierSaleReqBO();
                contractSupplierSaleReqBO.setContractId(busiReqBO.getAgrAgreementBO().getContractId());
                contractSupplierSaleReqBO.setPageNo(-1);
                contractSupplierSaleReqBO.setPageSize(-1);
                RspPage contractSupplierSalePage = this.qryContractSupplierListSaleService.selecContractSupplierList(contractSupplierSaleReqBO);
                if (contractSupplierSalePage != null && !CollectionUtils.isEmpty((Collection)contractSupplierSalePage.getRows())) {
                    supplierSaleRspBOMap = contractSupplierSalePage.getRows().stream().collect(Collectors.toMap(ContractSupplierSaleRspBO::getCategoryId, Function.identity(), (key1, key2) -> key2));
                } else {
                    throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5165\u9a7b\u5408\u540c\u4fe1\u606f");
                }
            }
            Map<String, String> conversionScaleMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "MEASURE_CONVERSION_RELATIONSHIPS");
            for (OpsContractItemPO opsContractItem : opsContractItemPos) {
                UccMaterialCommodityTypeBO uccMaterialCommodityTypeBo;
                AgrAgreementSkuBO bo2 = new AgrAgreementSkuBO();
                if (StringUtils.isBlank((CharSequence)opsContractItem.getMaterialCode())) {
                    uccMaterialCommodityTypeBo = (UccMaterialCommodityTypeBO)collectByCatalogCode.get(opsContractItem.getCatalogCode());
                } else {
                    uccMaterialCommodityTypeBo = (UccMaterialCommodityTypeBO)collectByMaterialCode.get(opsContractItem.getMaterialCode());
                    CnncBatchQryMaterialByCodeAbilityBo cnncBatchQryMaterialByCodeAbilityBo = (CnncBatchQryMaterialByCodeAbilityBo)materialByCodeAbilityBoMap.get(opsContractItem.getMaterialCode());
                    if (null != cnncBatchQryMaterialByCodeAbilityBo) {
                        if (!Objects.equals(cnncBatchQryMaterialByCodeAbilityBo.getFreezeFlag(), YesNoEnum.NO.getType()) || !Objects.equals(cnncBatchQryMaterialByCodeAbilityBo.getIsDelete(), YesNoEnum.NO.getType())) {
                            bo2.setFreezeFlag(AgrCommConstant.IsDelete.DELETED);
                        } else {
                            bo2.setFreezeFlag(AgrCommConstant.IsDelete.NORMAL);
                        }
                    }
                }
                bo2.setMeasureName(opsContractItem.getMeasureName());
                if (uccMaterialCommodityTypeBo != null && !CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) {
                    List collect = uccMaterialCommodityTypeBo.getTypeIdAndName().keySet().stream().sorted().collect(Collectors.toList());
                    for (Long item2 : collect) {
                        bo2.setCatalogId(item2.toString());
                        bo2.setCatalogName((String)uccMaterialCommodityTypeBo.getTypeIdAndName().get(item2));
                        bo2.setMaterialName(uccMaterialCommodityTypeBo.getLongDesc());
                        if (StringUtils.isBlank((CharSequence)opsContractItem.getPurchaseType())) {
                            bo2.setCatalogVariety(uccMaterialCommodityTypeBo.getVariety());
                        }
                        if (!org.springframework.util.StringUtils.hasText((String)opsContractItem.getCatalogCode())) {
                            opsContractItem.setCatalogCode(uccMaterialCommodityTypeBo.getL3CatalogCode());
                        }
                        if (CollectionUtils.isEmpty(supplierSaleRspBOMap)) {
                            bo2.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.YES.getCode().byteValue()));
                            break;
                        }
                        ContractSupplierSaleRspBO contractSupplierSaleRspBo = (ContractSupplierSaleRspBO)supplierSaleRspBOMap.get(item2);
                        if (contractSupplierSaleRspBo == null) {
                            bo2.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.NO.getCode().byteValue()));
                            continue;
                        }
                        bo2.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.YES.getCode().byteValue()));
                        break;
                    }
                    bo2.setMaterialMeasureName(uccMaterialCommodityTypeBo.getMeasureName());
                    if (StringUtils.isNotBlank((CharSequence)opsContractItem.getMaterialCode())) {
                        if (StringUtils.isNotBlank((CharSequence)bo2.getMeasureName()) && StringUtils.isNotBlank((CharSequence)bo2.getMaterialMeasureName())) {
                            if (bo2.getMeasureName().equals(bo2.getMaterialMeasureName())) {
                                bo2.setUnitOfMeasureScale(Integer.valueOf(1));
                                bo2.setMaterialUnitOfMeasureScale(Integer.valueOf(1));
                            } else {
                                String[] split;
                                String conversionScale = conversionScaleMap.get(bo2.getMeasureName() + ":" + bo2.getMaterialMeasureName());
                                if (StringUtils.isNotBlank((CharSequence)conversionScale) && (split = conversionScale.split(":")).length == 2) {
                                    bo2.setUnitOfMeasureScale(Integer.valueOf(split[0]));
                                    bo2.setMaterialUnitOfMeasureScale(Integer.valueOf(split[1]));
                                }
                            }
                        }
                    } else {
                        bo2.setUnitOfMeasureScale(Integer.valueOf(1));
                        bo2.setMaterialUnitOfMeasureScale(Integer.valueOf(1));
                    }
                } else {
                    bo2.setContractCovered(Integer.valueOf(AgrEnum.YesOrNo.NO.getCode().byteValue()));
                }
                bo2.setScMaterialCode(opsContractItem.getScMaterialCode());
                bo2.setWarrantyLevel(opsContractItem.getWarrantyLevel());
                bo2.setNuclearSafetyLevel(opsContractItem.getNuclearSafetyLevel());
                if (StringUtils.isNotBlank((CharSequence)opsContractItem.getMaterialCode())) {
                    bo2.setMaterialId(opsContractItem.getMaterialCode());
                }
                bo2.setModel(opsContractItem.getSpecModel());
                bo2.setSpec(opsContractItem.getSpecModel());
                if (opsContractItem.getBuyNumber() == null) {
                    bo2.setBuyNumber(BigDecimal.ZERO);
                } else {
                    bo2.setBuyNumber(new BigDecimal(opsContractItem.getBuyNumber()));
                }
                try {
                    if (opsContractItem.getBuyPrice() == null) {
                        bo2.setBuyPrice(Long.valueOf(0L));
                    } else {
                        bo2.setBuyPrice(MoneyUtil.b2l(new BigDecimal(opsContractItem.getBuyPrice())));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtils.isNotBlank((CharSequence)opsContractItem.getTaxRate())) {
                    bo2.setTaxRate(Byte.valueOf(opsContractItem.getTaxRate()));
                }
                if (StringUtils.isNotBlank((CharSequence)opsContractItem.getCatalogCode())) {
                    bo2.setThirdCatalogId(opsContractItem.getCatalogCode());
                }
                bo2.setComments(opsContractItem.getComments());
                bo2.setOrderedQuantity(BigDecimal.ZERO);
                bo2.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
                bo2.setExtItemCode(opsContractItem.getContractItemCode());
                bo2.setExtItemId(opsContractItem.getContractItemId());
                bo2.setMarkupRate(Double.valueOf(0.0));
                bo2.setMarkupValue("0");
                bo2.setItemName(opsContractItem.getItemName());
                if (StringUtils.isBlank((CharSequence)opsContractItem.getBrand())) {
                    bo2.setBrandName(busiReqBO.getAgrAgreementBO().getVendorName());
                } else {
                    bo2.setBrandName(opsContractItem.getBrand());
                }
                if (StringUtils.isBlank((CharSequence)opsContractItem.getManufacturer())) {
                    bo2.setManufacturer(busiReqBO.getAgrAgreementBO().getVendorName());
                } else {
                    bo2.setManufacturer(opsContractItem.getManufacturer());
                }
                bo2.setIsOil(AgrEnum.YesOrNo.NO.getCode());
                bo2.setProducingArea(opsContractItem.getProducingArea());
                if (StringUtils.isNotBlank((CharSequence)opsContractItem.getPurchaseType())) {
                    bo2.setCatalogVariety(Integer.valueOf(opsContractItem.getPurchaseType()));
                }
                bo2.setPurchaseSubType(opsContractItem.getPurchaseSubType());
                bo2.setSupplyCycle(opsContractItem.getSupplyCycle());
                bo2.setWarantty(busiReqBO.getAgrAgreementBO().getWarantty());
                bo2.setDifferencesAcceptance(StringUtils.isBlank((CharSequence)opsContractItem.getDifferencesAcceptance()) ? busiReqBO.getAgrAgreementBO().getDifferencesAcceptance() : Integer.valueOf(opsContractItem.getDifferencesAcceptance()));
                bo2.setAcceptanceScale(opsContractItem.getAcceptanceScale());
                if (Arrays.asList(AgrEnum.PurchaseType.GC.getCode(), AgrEnum.PurchaseType.FW.getCode()).contains(opsContractItem.getPurchaseType()) && AgrEnum.YesOrNo.YES.getCode().toString().equals(bo2.getDifferencesAcceptance().toString())) {
                    bo2.setAdjustAcceptance(Integer.valueOf(AgrEnum.YesOrNo.YES.getCode().byteValue()));
                } else {
                    bo2.setAdjustAcceptance(Integer.valueOf(AgrEnum.YesOrNo.NO.getCode().byteValue()));
                }
                bo2.setAdjustPrice(busiReqBO.getAgrAgreementBO().getAdjustPrice());
                agrAgreementSkuBOs.add(bo2);
            }
            this.setRateTypeCode(agrAgreementSkuBOs);
            busiReqBO.setAgrAgreementSkuBOs(agrAgreementSkuBOs);
        }
    }

    private void setRateTypeCode(List<AgrAgreementSkuBO> agreementSkuList) {
        List commodityTypeIds = agreementSkuList.stream().map(AgrAgreementSkuBO::getCatalogId).filter(org.springframework.util.StringUtils::hasText).map(Long::valueOf).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(commodityTypeIds)) {
            CnncQryCommodityTypeListAbilityReqBo cnncQryCommodityTypeListAbilityReqBo = new CnncQryCommodityTypeListAbilityReqBo();
            cnncQryCommodityTypeListAbilityReqBo.setCommodityTypeIds(commodityTypeIds);
            cnncQryCommodityTypeListAbilityReqBo.setPageSize(-1);
            cnncQryCommodityTypeListAbilityReqBo.setPageNo(-1);
            cnncQryCommodityTypeListAbilityReqBo.setQueryHaveSku(Boolean.valueOf(false));
            CnncQryCommodityTypeListAbilityRspBo cnncQryCommodityTypeListAbilityRspBo = this.cnncQryCommodityTypeListAbilityService.qryCommodityTypeList(cnncQryCommodityTypeListAbilityReqBo);
            if (!"0000".equals(cnncQryCommodityTypeListAbilityRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)cnncQryCommodityTypeListAbilityRspBo.getRows())) {
                throw new BusinessException("8888", "\u56db\u7ea7\u5206\u7c7b\u5217\u8868\u67e5\u8be2\u5931\u8d25");
            }
            List commodityTypeListAbilityBos = JSONArray.parseArray((String)JSONArray.toJSONString((Object)cnncQryCommodityTypeListAbilityRspBo.getRows()), CnncQryCommodityTypeListAbilityBo.class);
            Map<Long, CnncQryCommodityTypeListAbilityBo> commodityTypeListAbilityBoMap = commodityTypeListAbilityBos.stream().collect(Collectors.toMap(CnncQryCommodityTypeListAbilityBo::getCommodityTypeId, obj -> obj, (a, b) -> a));
            agreementSkuList.stream().filter(agreementSku -> org.springframework.util.StringUtils.hasText((String)agreementSku.getCatalogId())).forEach(agreementSku -> {
                CnncQryCommodityTypeListAbilityBo cnncQryCommodityTypeListAbilityBo = (CnncQryCommodityTypeListAbilityBo)commodityTypeListAbilityBoMap.get(Long.parseLong(agreementSku.getCatalogId()));
                if (null != cnncQryCommodityTypeListAbilityBo) {
                    agreementSku.setTaxCatalog(cnncQryCommodityTypeListAbilityBo.getRateTypeCode());
                }
            });
        }
    }

    private void insertAgreementSku(AgrModifyAgreementSubjectBusiReqBO busiReqBO, AgreementPO agreementPO) {
        AgrCreateAgreementSkuAtomReqBO agrCreateAgreementSkuAtomReqBO = new AgrCreateAgreementSkuAtomReqBO();
        agrCreateAgreementSkuAtomReqBO.setAgrAgreementSkuBOs(busiReqBO.getAgrAgreementSkuBOs());
        agrCreateAgreementSkuAtomReqBO.setSupplierId(agreementPO.getSupplierId());
        agrCreateAgreementSkuAtomReqBO.setAgreementVersion(agreementPO.getAgreementVersion());
        agrCreateAgreementSkuAtomReqBO.setAgreementId(agreementPO.getAgreementId());
        AgrCreateAgreementSkuAtomRspBO agrCreateAgreementSkuAtomRspBO = this.agrCreateAgreementSkuAtomService.createAgreementSku(agrCreateAgreementSkuAtomReqBO);
        if (!"0000".equals(agrCreateAgreementSkuAtomRspBO.getRespCode())) {
            throw new BusinessException(agrCreateAgreementSkuAtomRspBO.getRespCode(), agrCreateAgreementSkuAtomRspBO.getRespDesc());
        }
    }
}

