/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.busi.AgrModifyDispatchInfoBusiService;
import com.tydic.agreement.busi.bo.AgrModifyDispatchInfoAbilityRspBO;
import com.tydic.agreement.busi.bo.AgrModifyDispatchInfoServiceReqBO;
import com.tydic.agreement.common.bo.AgrProjectDispatchItemConfigBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.OpsContractMapper;
import com.tydic.agreement.dao.ProjectDispatchConfigChangeMapper;
import com.tydic.agreement.dao.ProjectDispatchConfigMapper;
import com.tydic.agreement.dao.ProjectDispatchItemConfigChangeMapper;
import com.tydic.agreement.dao.ProjectDispatchItemConfigMapper;
import com.tydic.agreement.dao.po.OpsContractPO;
import com.tydic.agreement.dao.po.ProjectDispatchConfigChangePO;
import com.tydic.agreement.dao.po.ProjectDispatchConfigPO;
import com.tydic.agreement.dao.po.ProjectDispatchItemConfigChangePO;
import com.tydic.agreement.dao.po.ProjectDispatchItemConfigPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrModifyDispatchInfoBusiServiceImpl
implements AgrModifyDispatchInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrModifyDispatchInfoBusiServiceImpl.class);
    @Autowired
    private OpsContractMapper opsContractMapper;
    @Autowired
    private ProjectDispatchConfigMapper projectDispatchConfigMapper;
    @Autowired
    private ProjectDispatchConfigChangeMapper projectDispatchConfigChangeMapper;
    @Autowired
    private ProjectDispatchItemConfigMapper projectDispatchItemConfigMapper;
    @Autowired
    private ProjectDispatchItemConfigChangeMapper projectDispatchItemConfigChangeMapper;

    public AgrModifyDispatchInfoAbilityRspBO modifyDispatch(AgrModifyDispatchInfoServiceReqBO reqBO) {
        AgrModifyDispatchInfoAbilityRspBO rspBO = new AgrModifyDispatchInfoAbilityRspBO();
        ProjectDispatchConfigPO modelPO = new ProjectDispatchConfigPO();
        modelPO.setProjectCode(reqBO.getProjectDispatchConfigBO().getProjectCode());
        ProjectDispatchConfigPO dispatchConfigPO = this.projectDispatchConfigMapper.getModelBy(modelPO);
        this.saveProjectDispatchConfigChange(reqBO, dispatchConfigPO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getProjectDispatchItemConfigBOS())) {
            this.saveProjectDispatchItemConfigChange(reqBO, dispatchConfigPO);
        }
        rspBO.setRespCode("8888");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveProjectDispatchConfigChange(AgrModifyDispatchInfoServiceReqBO reqBO, ProjectDispatchConfigPO dispatchConfigPO) {
        ProjectDispatchConfigChangePO dispatchConfigChangePO = new ProjectDispatchConfigChangePO();
        dispatchConfigChangePO.setId(Sequence.getInstance().nextId());
        dispatchConfigChangePO.setProjectCode(reqBO.getProjectDispatchConfigBO().getProjectCode());
        dispatchConfigChangePO.setProjectName(reqBO.getProjectDispatchConfigBO().getProjectName());
        dispatchConfigChangePO.setDispatchType(reqBO.getProjectDispatchConfigBO().getDispatchType());
        dispatchConfigChangePO.setProjectHandlerId(reqBO.getProjectDispatchConfigBO().getProjectHandlerId());
        dispatchConfigChangePO.setProjectHandlerName(reqBO.getProjectDispatchConfigBO().getProjectHandlerName());
        dispatchConfigChangePO.setUseSelectState(reqBO.getProjectDispatchConfigBO().getUseSelectState());
        dispatchConfigChangePO.setRejectTimesLimit(reqBO.getProjectDispatchConfigBO().getRejectTimesLimit());
        dispatchConfigChangePO.setDispatchCode(reqBO.getProjectDispatchConfigBO().getProjectCode() + "-PD");
        dispatchConfigChangePO.setState(AgrCommConstant.DISPATCH_STATE.WAITE_APPROVAL);
        dispatchConfigChangePO.setCreateTime(new Date());
        if (!CollectionUtils.isEmpty((Collection)reqBO.getProjectDispatchItemConfigBOS())) {
            Integer newCurrentRounds = dispatchConfigPO.getCurrentRounds() + 1;
            Integer newVersion = dispatchConfigPO.getVersion() + 1;
            dispatchConfigChangePO.setLastExecutionSeq(0);
            dispatchConfigChangePO.setCurrentRounds(newCurrentRounds);
            dispatchConfigChangePO.setVersion(newVersion);
        } else {
            dispatchConfigChangePO.setLastExecutionSeq(dispatchConfigPO.getLastExecutionSeq());
            dispatchConfigChangePO.setCurrentRounds(dispatchConfigPO.getCurrentRounds());
            dispatchConfigChangePO.setVersion(dispatchConfigPO.getVersion());
        }
        int insertCnt = this.projectDispatchConfigChangeMapper.insert(dispatchConfigChangePO);
        if (insertCnt < 1) {
            throw new BusinessException("8888", "\u4fee\u6539\u9879\u76ee\u4e3b\u4f53\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6838\u67e5\uff01");
        }
    }

    private void saveProjectDispatchItemConfigChange(AgrModifyDispatchInfoServiceReqBO reqBO, ProjectDispatchConfigPO dispatchConfigPO) {
        ProjectDispatchItemConfigPO dispatchItemConfigPO = new ProjectDispatchItemConfigPO();
        dispatchItemConfigPO.setProjectCode(reqBO.getProjectDispatchConfigBO().getProjectCode());
        List<ProjectDispatchItemConfigPO> dispatchItemConfigPOList = this.projectDispatchItemConfigMapper.getList(dispatchItemConfigPO);
        Map<String, ProjectDispatchItemConfigPO> dispatchItemConfigPOMap = dispatchItemConfigPOList.stream().collect(Collectors.toMap(ProjectDispatchItemConfigPO::getContractCode, po -> po, (key1, key2) -> key1));
        List<String> contractCodes = reqBO.getProjectDispatchItemConfigBOS().stream().map(AgrProjectDispatchItemConfigBO::getContractCode).collect(Collectors.toList());
        Map<String, String> contractCodeMap = this.queryContractCode(contractCodes);
        ArrayList<ProjectDispatchItemConfigChangePO> dispatchItemConfigChangePOS = new ArrayList<ProjectDispatchItemConfigChangePO>();
        reqBO.getProjectDispatchItemConfigBOS().forEach(bo -> {
            BigDecimal remainExecutableAmount;
            ProjectDispatchItemConfigChangePO dispatchItemConfigChangePO = new ProjectDispatchItemConfigChangePO();
            Integer newCurrentRounds = dispatchConfigPO.getCurrentRounds() + 1;
            Integer newVersion = dispatchConfigPO.getVersion() + 1;
            dispatchItemConfigChangePO.setProjectCode(dispatchConfigPO.getProjectCode());
            dispatchItemConfigChangePO.setId(Sequence.getInstance().nextId());
            dispatchItemConfigChangePO.setDispatchSequence(bo.getDispatchSequence());
            dispatchItemConfigChangePO.setContractCode(bo.getContractCode());
            dispatchItemConfigChangePO.setContractName(bo.getContractName());
            dispatchItemConfigChangePO.setEntAgreementCode(bo.getEntAgreementCode());
            dispatchItemConfigChangePO.setSupplierId(bo.getSupplierId());
            dispatchItemConfigChangePO.setSupplierName(bo.getSupplierName());
            dispatchItemConfigChangePO.setRoundsState(AgrCommConstant.IsDelete.NORMAL.intValue());
            dispatchItemConfigChangePO.setDispatchRounds(newCurrentRounds);
            dispatchItemConfigChangePO.setAmountLimit(bo.getAmountLimit());
            String agreementTentativeAmount = (String)contractCodeMap.get(bo.getContractCode());
            if (!StringUtils.hasText((String)agreementTentativeAmount)) {
                throw new BusinessException("8888", "\u9879\u76ee\u8f6e\u6b21\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u5408\u540c\u4fe1\u606f\u7684\u6682\u5b9a\u91d1\u989d\u4e3a\u7a7a\uff01");
            }
            try {
                remainExecutableAmount = dispatchItemConfigPOMap.get(bo.getContractCode()) != null ? ((ProjectDispatchItemConfigPO)dispatchItemConfigPOMap.get(bo.getContractCode())).getRemainExecutableAmount() : new BigDecimal(agreementTentativeAmount);
            }
            catch (Exception e) {
                log.error("\u9879\u76ee\u8f6e\u6b21\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u91d1\u989d\u8f6c\u5316\u5931\u8d25\uff1a", (Throwable)e);
                throw new BusinessException("8888", "\u9879\u76ee\u8f6e\u6b21\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u5408\u540c\u4fe1\u606f\u7684\u6682\u5b9a\u91d1\u989d\u8f6c\u6362\u5931\u8d25\uff01");
            }
            if (remainExecutableAmount.compareTo(bo.getAmountLimit()) < 0) {
                throw new BusinessException("8888", "\u9879\u76ee\u8f6e\u6b21\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u4e0a\u9650\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u6682\u5b9a\u603b\u989d\uff01");
            }
            dispatchItemConfigChangePO.setRemainExecutableAmount(remainExecutableAmount);
            dispatchItemConfigChangePO.setExecutedAmount(BigDecimal.ZERO);
            dispatchItemConfigChangePO.setCycleRejectCnt(0);
            dispatchItemConfigChangePO.setWhetherExecutionCompleted(AgrCommConstant.PROJECT_ROUNDS_EXECUTE.IN_EXECUTION);
            dispatchItemConfigChangePO.setVersion(newVersion);
            dispatchItemConfigChangePOS.add(dispatchItemConfigChangePO);
        });
        int insertCnt = this.projectDispatchItemConfigChangeMapper.insertBatch(dispatchItemConfigChangePOS);
        if (insertCnt < 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u9879\u76ee\u8f6e\u6b21\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6838\u67e5\uff01");
        }
    }

    private Map<String, String> queryContractCode(List<String> contractCodes) {
        OpsContractPO opsContractPO = new OpsContractPO();
        opsContractPO.setContractCodeIn(contractCodes);
        List<OpsContractPO> opsContractPOList = this.opsContractMapper.getList(opsContractPO);
        if (CollectionUtils.isEmpty(opsContractPOList)) {
            throw new BusinessException("8888", "\u9879\u76ee\u65b0\u589e\u8f6e\u6b21\u4fe1\u606f\u5165\u5e93\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5408\u540c\u4fe1\u606f\uff01");
        }
        return opsContractPOList.stream().collect(Collectors.toMap(OpsContractPO::getContractCode, OpsContractPO::getContractAmount, (key1, key2) -> key1));
    }
}

