/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrModifyProjectExecuteAmountAndRejectOrderServiceReqBO;
import com.tydic.agreement.ability.bo.AgrModifyProjectExecuteAmountAndRejectOrderServiceRspBO;
import com.tydic.agreement.busi.AgrModifyProjectExecuteAmountAndRejectOrderBusiService;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.OpsContractMapper;
import com.tydic.agreement.dao.ProjectAmountChangeLogMapper;
import com.tydic.agreement.dao.ProjectDispatchConfigMapper;
import com.tydic.agreement.dao.ProjectDispatchItemConfigLogMapper;
import com.tydic.agreement.dao.ProjectDispatchItemConfigMapper;
import com.tydic.agreement.dao.po.OpsContractPO;
import com.tydic.agreement.dao.po.ProjectAmountChangeLogPO;
import com.tydic.agreement.dao.po.ProjectDispatchConfigPO;
import com.tydic.agreement.dao.po.ProjectDispatchItemConfigLogPO;
import com.tydic.agreement.dao.po.ProjectDispatchItemConfigPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrModifyProjectExecuteAmountAndRejectOrderBusiServiceImpl
implements AgrModifyProjectExecuteAmountAndRejectOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrModifyProjectExecuteAmountAndRejectOrderBusiServiceImpl.class);
    @Autowired
    private OpsContractMapper opsContractMapper;
    @Autowired
    private ProjectAmountChangeLogMapper projectAmountChangeLogMapper;
    @Autowired
    private ProjectDispatchConfigMapper projectDispatchConfigMapper;
    @Autowired
    private ProjectDispatchItemConfigMapper projectDispatchItemConfigMapper;
    @Autowired
    private ProjectDispatchItemConfigLogMapper projectDispatchItemConfigLogMapper;

    public AgrModifyProjectExecuteAmountAndRejectOrderServiceRspBO modifyProjectAmountOrRejectTimes(AgrModifyProjectExecuteAmountAndRejectOrderServiceReqBO reqBO) {
        AgrModifyProjectExecuteAmountAndRejectOrderServiceRspBO rspBO = new AgrModifyProjectExecuteAmountAndRejectOrderServiceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.recordAmountChangeLog(reqBO);
        ProjectDispatchConfigPO dispatchConfigPO = this.queryProjectDispatch(reqBO);
        ProjectDispatchItemConfigPO dispatchItemConfigPO = this.queryDispatchItemConfig(reqBO);
        ProjectDispatchItemConfigLogPO dispatchItemConfigLogPO = null;
        boolean isHistoryRounds = false;
        if (dispatchItemConfigPO == null) {
            dispatchItemConfigLogPO = this.queryDispatchItemConfigLog(reqBO);
            isHistoryRounds = true;
        }
        if (isHistoryRounds) {
            this.historyRoundsCalcType(reqBO, dispatchConfigPO, dispatchItemConfigLogPO);
            return rspBO;
        }
        this.currentRoundsCalc(reqBO, dispatchConfigPO, dispatchItemConfigPO);
        return rspBO;
    }

    private void recordAmountChangeLog(AgrModifyProjectExecuteAmountAndRejectOrderServiceReqBO reqBO) {
        ProjectAmountChangeLogPO projectAmountChangeLogPO = new ProjectAmountChangeLogPO();
        projectAmountChangeLogPO.setId(Sequence.getInstance().nextId());
        projectAmountChangeLogPO.setProjectCode(reqBO.getProjectCode());
        projectAmountChangeLogPO.setOpeType(reqBO.getOpeType());
        String jsonString = JSONObject.toJSONString((Object)reqBO);
        projectAmountChangeLogPO.setContentInfo(jsonString);
        projectAmountChangeLogPO.setReceiveTime(new Date());
        int insertLogCnt = this.projectAmountChangeLogMapper.insert(projectAmountChangeLogPO);
        if (insertLogCnt < 1) {
            throw new BusinessException("8888", "\u5165\u5e93\u9879\u76ee\u7f16\u53f7[" + reqBO.getProjectCode() + "]\u91d1\u989d\u53d8\u66f4\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25!");
        }
    }

    private ProjectDispatchConfigPO queryProjectDispatch(AgrModifyProjectExecuteAmountAndRejectOrderServiceReqBO reqBO) {
        ProjectDispatchConfigPO projectDispatchConfigPO = new ProjectDispatchConfigPO();
        projectDispatchConfigPO.setProjectCode(reqBO.getProjectCode());
        projectDispatchConfigPO = this.projectDispatchConfigMapper.getModelBy(projectDispatchConfigPO);
        if (projectDispatchConfigPO == null) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7f16\u53f7[" + reqBO.getProjectCode() + "]\u5bf9\u5e94\u7684\u9879\u76ee\u6d3e\u5355\u4fe1\u606f");
        }
        return projectDispatchConfigPO;
    }

    private ProjectDispatchItemConfigPO queryDispatchItemConfig(AgrModifyProjectExecuteAmountAndRejectOrderServiceReqBO reqBO) {
        ProjectDispatchItemConfigPO projectDispatchItemConfigPO = new ProjectDispatchItemConfigPO();
        projectDispatchItemConfigPO.setProjectCode(reqBO.getProjectCode());
        projectDispatchItemConfigPO.setId(reqBO.getId());
        projectDispatchItemConfigPO = this.projectDispatchItemConfigMapper.getModelBy(projectDispatchItemConfigPO);
        return projectDispatchItemConfigPO;
    }

    private ProjectDispatchItemConfigLogPO queryDispatchItemConfigLog(AgrModifyProjectExecuteAmountAndRejectOrderServiceReqBO reqBO) {
        ProjectDispatchItemConfigLogPO projectDispatchItemConfigLogPO = new ProjectDispatchItemConfigLogPO();
        projectDispatchItemConfigLogPO.setProjectCode(reqBO.getProjectCode());
        projectDispatchItemConfigLogPO.setId(reqBO.getId());
        projectDispatchItemConfigLogPO = this.projectDispatchItemConfigLogMapper.getModelBy(projectDispatchItemConfigLogPO);
        if (projectDispatchItemConfigLogPO == null) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u9879\u76ee\u7f16\u53f7[" + reqBO.getProjectCode() + "]\u4e0b\u8f6e\u6b21[" + reqBO.getId() + "]\u7684\u5177\u4f53\u4fe1\u606f!");
        }
        return projectDispatchItemConfigLogPO;
    }

    private void historyRoundsCalcType(AgrModifyProjectExecuteAmountAndRejectOrderServiceReqBO reqBO, ProjectDispatchConfigPO dispatchConfigPO, ProjectDispatchItemConfigLogPO dispatchItemConfigLogPO) {
        int updateItemLogCnt;
        if ((reqBO.getDiffInspectFlag() == null || !reqBO.getDiffInspectFlag().booleanValue()) && AgrCommConstant.PROJECT_OPE_TYPE.DEDUCT_EXECUTE_AMOUNT.equals(reqBO.getOpeType())) {
            throw new BusinessException("8888", "\u5f53\u524d\u8f6e\u6b21[" + reqBO.getId() + "]\u662f\u5386\u53f2\u8f6e\u6b21\uff0c\u4e0d\u80fd\u8fdb\u884c\u6263\u6b3e\u64cd\u4f5c");
        }
        ProjectDispatchItemConfigLogPO setItemConfigLogPO = new ProjectDispatchItemConfigLogPO();
        ProjectDispatchItemConfigLogPO whereItemConfigLogPO = new ProjectDispatchItemConfigLogPO();
        whereItemConfigLogPO.setId(dispatchItemConfigLogPO.getId());
        whereItemConfigLogPO.setRemainExecutableAmount(dispatchItemConfigLogPO.getRemainExecutableAmount());
        whereItemConfigLogPO.setExecutedAmount(dispatchItemConfigLogPO.getExecutedAmount());
        whereItemConfigLogPO.setCycleRejectCnt(dispatchItemConfigLogPO.getCycleRejectCnt());
        if (AgrCommConstant.PROJECT_OPE_TYPE.REFUND_EXECUTE_AMOUNT.equals(reqBO.getOpeType()) || AgrCommConstant.PROJECT_OPE_TYPE.UPDATE_REJECT_TIMES.equals(reqBO.getOpeType())) {
            BigDecimal newRemainExecutableAmount = dispatchItemConfigLogPO.getRemainExecutableAmount().add(reqBO.getExecutedAmount());
            BigDecimal newExecutedAmount = dispatchItemConfigLogPO.getExecutedAmount().subtract(reqBO.getExecutedAmount());
            setItemConfigLogPO.setRemainExecutableAmount(newRemainExecutableAmount);
            setItemConfigLogPO.setExecutedAmount(newExecutedAmount);
        }
        if (AgrCommConstant.PROJECT_OPE_TYPE.UPDATE_REJECT_TIMES.equals(reqBO.getOpeType())) {
            Integer newCycleRejectCnt = dispatchItemConfigLogPO.getCycleRejectCnt() + 1;
            setItemConfigLogPO.setCycleRejectCnt(newCycleRejectCnt);
        }
        if ((updateItemLogCnt = this.projectDispatchItemConfigLogMapper.updateBy(setItemConfigLogPO, whereItemConfigLogPO)) < 1) {
            throw new BusinessException("8888", "\u5386\u53f2\u8f6e\u6b21[" + reqBO.getId() + "]\u66f4\u65b0\u5269\u4f59\u91d1\u989d\u548c\u5df2\u6267\u884c\u91d1\u989d\u5931\u8d25!");
        }
        if (!AgrCommConstant.PROJECT_OPE_TYPE.UPDATE_REJECT_TIMES.equals(reqBO.getOpeType())) {
            ProjectDispatchItemConfigPO projectDispatchItemConfigPO = new ProjectDispatchItemConfigPO();
            projectDispatchItemConfigPO.setProjectCode(reqBO.getProjectCode());
            projectDispatchItemConfigPO.setDispatchRounds(dispatchConfigPO.getCurrentRounds());
            projectDispatchItemConfigPO.setContractCode(dispatchItemConfigLogPO.getContractCode());
            projectDispatchItemConfigPO = this.projectDispatchItemConfigMapper.getModelBy(projectDispatchItemConfigPO);
            if (projectDispatchItemConfigPO != null) {
                ProjectDispatchItemConfigPO setItemConfigPO = new ProjectDispatchItemConfigPO();
                ProjectDispatchItemConfigPO whereItemConfigPO = new ProjectDispatchItemConfigPO();
                whereItemConfigPO.setId(projectDispatchItemConfigPO.getId());
                whereItemConfigPO.setRemainExecutableAmount(projectDispatchItemConfigPO.getRemainExecutableAmount());
                BigDecimal currentRemainExecutableAmount = projectDispatchItemConfigPO.getRemainExecutableAmount().add(reqBO.getExecutedAmount());
                setItemConfigPO.setRemainExecutableAmount(currentRemainExecutableAmount);
                int updateItemCnt = this.projectDispatchItemConfigMapper.updateBy(setItemConfigPO, whereItemConfigPO);
                if (updateItemCnt < 1) {
                    throw new BusinessException("8888", "\u5386\u53f2\u8f6e\u6b21[" + reqBO.getId() + "]\u66f4\u65b0\u5bf9\u5e94\u5f53\u524d\u8f6e\u6b21[" + projectDispatchItemConfigPO.getId() + "]\u5269\u4f59\u91d1\u989d\u5931\u8d25!");
                }
            }
        }
    }

    private void currentRoundsCalc(AgrModifyProjectExecuteAmountAndRejectOrderServiceReqBO reqBO, ProjectDispatchConfigPO dispatchConfigPO, ProjectDispatchItemConfigPO dispatchItemConfigPO) {
        int updateItemCnt;
        ProjectDispatchItemConfigPO setItemConfigPO = new ProjectDispatchItemConfigPO();
        ProjectDispatchItemConfigPO whereItemConfigPO = new ProjectDispatchItemConfigPO();
        whereItemConfigPO.setId(dispatchItemConfigPO.getId());
        whereItemConfigPO.setRemainExecutableAmount(dispatchItemConfigPO.getRemainExecutableAmount());
        whereItemConfigPO.setExecutedAmount(dispatchItemConfigPO.getExecutedAmount());
        whereItemConfigPO.setCycleRejectCnt(dispatchItemConfigPO.getCycleRejectCnt());
        if (AgrCommConstant.PROJECT_OPE_TYPE.DEDUCT_EXECUTE_AMOUNT.equals(reqBO.getOpeType())) {
            BigDecimal agreementTentativeAmount;
            if (dispatchItemConfigPO.getExecutedAmount().compareTo(dispatchItemConfigPO.getAmountLimit()) >= 0) {
                throw new BusinessException("8888", "\u5f53\u524d\u8f6e\u6b21[" + reqBO.getId() + "]\u5df2\u8fbe\u5230\u4e0a\u9650\u91d1\u989d\uff0c\u4e0d\u80fd\u5728\u8fdb\u884c\u6d3e\u5355\u64cd\u4f5c!");
            }
            OpsContractPO opsContractPO = new OpsContractPO();
            opsContractPO.setContractCode(dispatchItemConfigPO.getContractCode());
            opsContractPO = this.opsContractMapper.getModelBy(opsContractPO);
            if (opsContractPO == null || !StringUtils.hasText((String)opsContractPO.getContractAmount())) {
                throw new BusinessException("8888", "\u5f53\u524d\u8f6e\u6b21[" + reqBO.getId() + "]\u672a\u67e5\u8be2\u5230\u5176\u5bf9\u5e94\u7684\u5408\u540c\u4fe1\u606f\u6216\u5176\u5bf9\u5e94\u5408\u540c\u7684\u6682\u5b9a\u603b\u989d\u6570\u503c!");
            }
            BigDecimal newExecutedAmount = dispatchItemConfigPO.getExecutedAmount().add(reqBO.getExecutedAmount());
            BigDecimal statisticsAllHistoryExecutedAmount = this.statisticsAllHistoryExecutedAmount(reqBO, dispatchItemConfigPO);
            try {
                agreementTentativeAmount = new BigDecimal(opsContractPO.getContractAmount());
            }
            catch (Exception e) {
                log.error("\u5f53\u524d\u8f6e\u6b21[" + reqBO.getId() + "]\u67e5\u8be2\u5230\u5408\u540c\u4e2d\u6682\u5b9a\u603b\u989d\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("8888", "\u5f53\u524d\u8f6e\u6b21[" + reqBO.getId() + "]\u67e5\u8be2\u5230\u5408\u540c\u4e2d\u6682\u5b9a\u603b\u989d\u8f6c\u6362\u5f02\u5e38");
            }
            if (agreementTentativeAmount.compareTo(BigDecimal.ZERO) <= 0) {
                throw new BusinessException("8888", "\u5f53\u524d\u8f6e\u6b21[" + reqBO.getId() + "]\u67e5\u8be2\u5230\u5408\u540c\u4e2d\u6682\u5b9a\u603b\u989d\u4e3a0\u6216\u5c0f\u4e8e0");
            }
            BigDecimal newRemainExecutableAmount = agreementTentativeAmount.subtract(statisticsAllHistoryExecutedAmount).subtract(newExecutedAmount);
            if (newRemainExecutableAmount.compareTo(BigDecimal.ZERO) < 0) {
                throw new BusinessException("8888", "\u5f53\u524d\u8f6e\u6b21[" + reqBO.getId() + "]\u6d3e\u5355\u91d1\u989d\u5df2\u8d85\u8fc7\u5269\u4f59\u53ef\u6267\u884c\u91d1\u989d");
            }
            if (newExecutedAmount.compareTo(dispatchItemConfigPO.getAmountLimit()) >= 0) {
                setItemConfigPO.setWhetherExecutionCompleted(AgrCommConstant.PROJECT_ROUNDS_EXECUTE.COMPLETED);
            }
            setItemConfigPO.setRemainExecutableAmount(newRemainExecutableAmount);
            setItemConfigPO.setExecutedAmount(newExecutedAmount);
        }
        if (AgrCommConstant.PROJECT_OPE_TYPE.UPDATE_REJECT_TIMES.equals(reqBO.getOpeType()) || AgrCommConstant.PROJECT_OPE_TYPE.REFUND_EXECUTE_AMOUNT.equals(reqBO.getOpeType())) {
            BigDecimal newExecutedAmount = dispatchItemConfigPO.getExecutedAmount().subtract(reqBO.getExecutedAmount());
            BigDecimal newRemainExecutableAmount = dispatchItemConfigPO.getRemainExecutableAmount().add(reqBO.getExecutedAmount());
            setItemConfigPO.setRemainExecutableAmount(newRemainExecutableAmount);
            setItemConfigPO.setExecutedAmount(newExecutedAmount);
        }
        if (AgrCommConstant.PROJECT_OPE_TYPE.UPDATE_REJECT_TIMES.equals(reqBO.getOpeType())) {
            Integer newCycleRejectCnt = dispatchItemConfigPO.getCycleRejectCnt() + 1;
            Integer rejectTimes = dispatchConfigPO.getRejectTimesLimit();
            if (rejectTimes.equals(newCycleRejectCnt)) {
                setItemConfigPO.setWhetherExecutionCompleted(AgrCommConstant.PROJECT_ROUNDS_EXECUTE.COMPLETED);
            }
            setItemConfigPO.setCycleRejectCnt(newCycleRejectCnt);
        }
        if ((updateItemCnt = this.projectDispatchItemConfigMapper.updateBy(setItemConfigPO, whereItemConfigPO)) < 1) {
            throw new BusinessException("8888", "\u5f53\u524d\u8f6e\u6b21[" + reqBO.getId() + "]\u66f4\u65b0\u5269\u4f59\u91d1\u989d\u548c\u5df2\u6267\u884c\u91d1\u989d\u6216\u62d2\u5355\u6b21\u6570\u5931\u8d25!");
        }
        if (AgrCommConstant.PROJECT_OPE_TYPE.DEDUCT_EXECUTE_AMOUNT.equals(reqBO.getOpeType()) || AgrCommConstant.PROJECT_OPE_TYPE.UPDATE_REJECT_TIMES.equals(reqBO.getOpeType())) {
            this.updateDispatchConfigLastSequence(dispatchItemConfigPO, dispatchConfigPO);
        }
    }

    private BigDecimal statisticsAllHistoryExecutedAmount(AgrModifyProjectExecuteAmountAndRejectOrderServiceReqBO reqBO, ProjectDispatchItemConfigPO dispatchItemConfigPO) {
        BigDecimal statisticsAllHistoryExecutedAmount = BigDecimal.ZERO;
        ProjectDispatchItemConfigLogPO dispatchItemConfigLogPO = new ProjectDispatchItemConfigLogPO();
        dispatchItemConfigLogPO.setProjectCode(reqBO.getProjectCode());
        dispatchItemConfigLogPO.setContractCode(dispatchItemConfigPO.getContractCode());
        List<ProjectDispatchItemConfigLogPO> itemConfigLogPOList = this.projectDispatchItemConfigLogMapper.getList(dispatchItemConfigLogPO);
        if (CollectionUtils.isEmpty(itemConfigLogPOList)) {
            return statisticsAllHistoryExecutedAmount;
        }
        for (ProjectDispatchItemConfigLogPO po : itemConfigLogPOList) {
            statisticsAllHistoryExecutedAmount = statisticsAllHistoryExecutedAmount.add(po.getExecutedAmount());
        }
        return statisticsAllHistoryExecutedAmount;
    }

    private void updateDispatchConfigLastSequence(ProjectDispatchItemConfigPO dispatchItemConfigPO, ProjectDispatchConfigPO dispatchConfigPO) {
        if (AgrCommConstant.DISPATCH_TYPE.POLLING.equals(dispatchConfigPO.getDispatchType())) {
            ProjectDispatchConfigPO setConfigPO = new ProjectDispatchConfigPO();
            setConfigPO.setLastExecutionSeq(dispatchItemConfigPO.getDispatchSequence());
            ProjectDispatchConfigPO whereConfigPO = new ProjectDispatchConfigPO();
            whereConfigPO.setId(dispatchConfigPO.getId());
            whereConfigPO.setProjectCode(dispatchConfigPO.getProjectCode());
            int updateConfigCnt = this.projectDispatchConfigMapper.updateBy(setConfigPO, whereConfigPO);
            if (updateConfigCnt < 1) {
                throw new BusinessException("8888", "\u5f53\u524d\u8f6e\u6b21[" + dispatchItemConfigPO.getId() + "]\u66f4\u65b0\u5df2\u6267\u884c\u8f6e\u6b21\u5931\u8d25!");
            }
        }
    }
}

