/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrOrderAmountConsumeReqBO;
import com.tydic.agreement.ability.bo.AgrOrderAmountConsumeRspBO;
import com.tydic.agreement.ability.bo.OrderAmountConsumeBO;
import com.tydic.agreement.busi.AgrOrderAmountConsumeBusiService;
import com.tydic.agreement.dao.AgrAgreementOrderMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.po.AgrAgreementOrderPO;
import com.tydic.agreement.dao.po.AgreementPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AgrOrderAmountConsumeBusiServiceImpl
implements AgrOrderAmountConsumeBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrOrderAmountConsumeBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementOrderMapper agrAgreementOrderMapper;

    public AgrOrderAmountConsumeRspBO updateOrderConsume(AgrOrderAmountConsumeReqBO reqBO) {
        AgrOrderAmountConsumeRspBO rspBO = new AgrOrderAmountConsumeRspBO();
        ArrayList<AgrAgreementOrderPO> agrAgreementOrderPos = new ArrayList<AgrAgreementOrderPO>();
        Date now = new Date();
        reqBO.getOrderAmountConsumeList().forEach(bo -> {
            AgrAgreementOrderPO po = new AgrAgreementOrderPO();
            po.setId(Sequence.getInstance().nextId());
            po.setAgreementId(bo.getAgreementId());
            po.setOrderId(reqBO.getOrderId());
            po.setObjId(reqBO.getObjId());
            po.setObjType(reqBO.getObjType().getTypeCode());
            po.setOrderAmount(bo.getUsedAmount());
            po.setCreateTime(now);
            agrAgreementOrderPos.add(po);
        });
        int inserted = this.agrAgreementOrderMapper.insertBatch(agrAgreementOrderPos);
        if (inserted < agrAgreementOrderPos.size()) {
            throw new BusinessException("8888", "\u8bb0\u5f55\u4e0b\u5355\u91d1\u989d\u53d8\u66f4\u65e5\u5fd7\u5931\u8d25");
        }
        reqBO.getOrderAmountConsumeList().forEach(bo -> {
            int updated;
            Boolean checkFlag = reqBO.getCheckFlag();
            if (bo.getUsedAmount().compareTo(BigDecimal.ZERO) < 0) {
                checkFlag = false;
            }
            if ((updated = this.agreementMapper.updateOrderAmount((OrderAmountConsumeBO)bo, checkFlag)) < 1) {
                if (!StringUtils.hasText((String)bo.getPlaAgreementCode())) {
                    AgreementPO agreementPo = new AgreementPO();
                    agreementPo.setAgreementId(bo.getAgreementId());
                    AgreementPO modelBy = this.agreementMapper.getModelBy(agreementPo);
                    bo.setPlaAgreementCode(modelBy.getPlaAgreementCode());
                }
                throw new BusinessException("8888", "\u5e73\u53f0\u534f\u8bae\u7f16\u7801[" + bo.getPlaAgreementCode() + "]\u66f4\u65b0\u534f\u8bae\u4f7f\u7528\u91d1\u989d\u5931\u8d25");
            }
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

