/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.AgrQryAgreementSkuChangeBusiService;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuChangeBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuChangeBusiRspBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgrFormulaVariableMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgrFormulaVariablePO;
import com.tydic.agreement.dao.po.AgreementSkuChangePO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrQryAgreementSkuChangeBusiServiceImpl
implements AgrQryAgreementSkuChangeBusiService {
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgrFormulaVariableMapper agrFormulaVariableMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;

    public AgrQryAgreementSkuChangeBusiRspBO qryAgreementSkuChange(AgrQryAgreementSkuChangeBusiReqBO busiReqBO) {
        List<AgreementSkuChangePO> agreementSkuChangePOs;
        AgrQryAgreementSkuChangeBusiRspBO rsp = new AgrQryAgreementSkuChangeBusiRspBO();
        ArrayList<AgrAgreementSkuChangeBO> rows = new ArrayList<AgrAgreementSkuChangeBO>();
        ArrayList<Long> formulaIds = new ArrayList<Long>();
        AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)agreementSkuChangePO);
        agreementSkuChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        if (busiReqBO.getPageQueryFlag().booleanValue()) {
            Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
            agreementSkuChangePOs = this.agreementSkuChangeMapper.getListPage(agreementSkuChangePO, (Page<AgreementSkuChangePO>)page);
            rsp.setTotal(Integer.valueOf(page.getTotalPages()));
            rsp.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rsp.setPageNo(Integer.valueOf(page.getPageNo()));
        } else {
            agreementSkuChangePOs = this.agreementSkuChangeMapper.getList(agreementSkuChangePO);
        }
        if (CollectionUtils.isEmpty(agreementSkuChangePOs)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        for (AgreementSkuChangePO po : agreementSkuChangePOs) {
            AgrAgreementSkuChangeBO agrAgreementSkuChangeBO = new AgrAgreementSkuChangeBO();
            BeanUtils.copyProperties((Object)po, (Object)agrAgreementSkuChangeBO);
            rows.add(agrAgreementSkuChangeBO);
            if (agrAgreementSkuChangeBO.getFormulaId() == null) continue;
            formulaIds.add(agrAgreementSkuChangeBO.getFormulaId());
        }
        if (!CollectionUtils.isEmpty(formulaIds)) {
            AgrFormulaVariablePO agrFormulaVariablePO = new AgrFormulaVariablePO();
            agrFormulaVariablePO.setFormulaIds(formulaIds);
            List<AgrFormulaVariablePO> agrFormulaVariablePOS = this.agrFormulaVariableMapper.selectByCondition(agrFormulaVariablePO);
            Map agrFormulaVariablePOMap = agrFormulaVariablePOS.stream().collect(Collectors.toMap(AgrFormulaVariablePO::getFormulaId, Function.identity(), (key1, key2) -> key2));
            for (AgrAgreementSkuChangeBO agrAgreementSkuBO : rows) {
                AgrFormulaVariablePO variablePO = (AgrFormulaVariablePO)agrFormulaVariablePOMap.get(agrAgreementSkuBO.getFormulaId());
                if (variablePO == null) continue;
                this.setConstantValue(agrAgreementSkuBO, variablePO);
            }
        }
        Map<String, String> isOilMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_OIL_PCODE");
        Map<String, String> extField1Str = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "EXT_FIELD1_PCODE");
        Map<String, String> producingAreaMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGR_PRODUCING_AREA");
        Map<String, String> catalogVarietyStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGREEMENT_VARIETY_PCODE");
        for (AgrAgreementSkuChangeBO bo : rows) {
            if (null != bo.getIsOil()) {
                bo.setIsOilStr(isOilMap.get(bo.getIsOil().toString()));
            }
            if (null != bo.getPurchaseType()) {
                bo.setPurchaseTypeStr(extField1Str.get(bo.getPurchaseType()));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getProducingArea())) {
                bo.setProducingAreaStr(producingAreaMap.get(bo.getProducingArea()));
            }
            if (null == bo.getCatalogVariety()) continue;
            bo.setCatalogVarietyStr(catalogVarietyStr.get(bo.getCatalogVariety().toString()));
        }
        if (null == busiReqBO.getCheckSkuChg()) {
            busiReqBO.setCheckSkuChg(Boolean.valueOf(false));
        }
        if (busiReqBO.getCheckSkuChg().booleanValue()) {
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            agreementSkuPO.setAgreementId(busiReqBO.getAgreementId());
            List<AgreementSkuPO> agreementSkuPOS = this.agreementSkuMapper.getList(agreementSkuPO);
            HashMap<String, List> agreementSkuMap = new HashMap<String, List>(agreementSkuPOS.size());
            if (!CollectionUtils.isEmpty(agreementSkuPOS)) {
                for (AgreementSkuPO skuPO : agreementSkuPOS) {
                    String splitStr = skuPO.getItemName() + skuPO.getMaterialId() + skuPO.getModel() + skuPO.getSpec() + skuPO.getTexture() + skuPO.getBuyNumber().toPlainString() + skuPO.getBuyPrice().toString();
                    List agreementSkuIds = (List)agreementSkuMap.get(splitStr);
                    if (!CollectionUtils.isEmpty((Collection)agreementSkuIds)) {
                        agreementSkuIds.add(skuPO.getAgreementSkuId().toString());
                        agreementSkuMap.put(splitStr, agreementSkuIds);
                        continue;
                    }
                    ArrayList<String> skuIds = new ArrayList<String>();
                    skuIds.add(skuPO.getAgreementSkuId().toString());
                    agreementSkuMap.put(splitStr, skuIds);
                }
            }
            HashMap<String, List> agreementSkuChangePOMap = new HashMap<String, List>(agreementSkuChangePOs.size());
            for (AgrAgreementSkuChangeBO bo : rows) {
                if (!AgrCommConstant.AgreementSkuChangeType.ADD.equals(bo.getChangeType())) continue;
                String splitStr = bo.getItemName() + bo.getMaterialId() + bo.getModel() + bo.getSpec() + bo.getTexture() + bo.getBuyNumber().toPlainString() + bo.getBuyPrice().toString();
                bo.setSplitStr(splitStr);
                List agreementSkuChangeIds = (List)agreementSkuChangePOMap.get(splitStr);
                if (!CollectionUtils.isEmpty((Collection)agreementSkuChangeIds)) {
                    agreementSkuChangeIds.add(bo.getSkuChangeId().toString());
                    agreementSkuChangePOMap.put(splitStr, agreementSkuChangeIds);
                    continue;
                }
                ArrayList<String> skuIds = new ArrayList<String>();
                skuIds.add(bo.getSkuChangeId().toString());
                agreementSkuChangePOMap.put(splitStr, skuIds);
            }
            for (AgrAgreementSkuChangeBO row : rows) {
                List skuChangeIds;
                if (!AgrCommConstant.AgreementSkuChangeType.ADD.equals(row.getChangeType())) continue;
                List skuIds = (List)agreementSkuMap.get(row.getSplitStr());
                row.setRepeatFlag(Boolean.valueOf(false));
                if (!CollectionUtils.isEmpty((Collection)skuIds)) {
                    row.setRepeatFlag(Boolean.valueOf(true));
                    row.setRepeatSkuIds(skuIds);
                }
                if (CollectionUtils.isEmpty((Collection)(skuChangeIds = (List)agreementSkuChangePOMap.get(row.getSplitStr()))) || skuChangeIds.size() <= 1) continue;
                ArrayList skuChangeIdList = new ArrayList();
                skuChangeIdList.addAll(skuChangeIds);
                skuChangeIdList.remove(row.getSkuChangeId().toString());
                row.setRepeatFlag(Boolean.valueOf(true));
                row.setRepeatSkuChangeIds(skuChangeIdList);
            }
        }
        rsp.setRows(rows);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    private void setConstantValue(AgrAgreementSkuChangeBO agrAgreementSkuBO, AgrFormulaVariablePO variablePO) {
        StringBuilder constantValueStrBuilder = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)agrAgreementSkuBO.getConstantValue1())) {
            constantValueStrBuilder.append(variablePO.getConstantValue1()).append(":").append(agrAgreementSkuBO.getConstantValue1()).append("\n");
        }
        if (!StringUtils.isBlank((CharSequence)agrAgreementSkuBO.getConstantValue2())) {
            constantValueStrBuilder.append(variablePO.getConstantValue2()).append(":").append(agrAgreementSkuBO.getConstantValue2()).append("\n");
        }
        if (!StringUtils.isBlank((CharSequence)agrAgreementSkuBO.getConstantValue3())) {
            constantValueStrBuilder.append(variablePO.getConstantValue3()).append(":").append(agrAgreementSkuBO.getConstantValue3()).append("\n");
        }
        if (!StringUtils.isBlank((CharSequence)agrAgreementSkuBO.getConstantValue4())) {
            constantValueStrBuilder.append(variablePO.getConstantValue4()).append(":").append(agrAgreementSkuBO.getConstantValue4()).append("\n");
        }
        if (!StringUtils.isBlank((CharSequence)agrAgreementSkuBO.getConstantValue5())) {
            constantValueStrBuilder.append(variablePO.getConstantValue5()).append(":").append(agrAgreementSkuBO.getConstantValue5()).append("\n");
        }
        if (!StringUtils.isBlank((CharSequence)agrAgreementSkuBO.getConstantValue6())) {
            constantValueStrBuilder.append(variablePO.getConstantValue6()).append(":").append(agrAgreementSkuBO.getConstantValue6()).append("\n");
        }
        if (!StringUtils.isBlank((CharSequence)agrAgreementSkuBO.getConstantValue7())) {
            constantValueStrBuilder.append(variablePO.getConstantValue7()).append(":").append(agrAgreementSkuBO.getConstantValue7()).append("\n");
        }
        if (!StringUtils.isBlank((CharSequence)agrAgreementSkuBO.getConstantValue8())) {
            constantValueStrBuilder.append(variablePO.getConstantValue8()).append(":").append(agrAgreementSkuBO.getConstantValue8()).append("\n");
        }
        if (!StringUtils.isBlank((CharSequence)agrAgreementSkuBO.getConstantValue9())) {
            constantValueStrBuilder.append(variablePO.getConstantValue9()).append(":").append(agrAgreementSkuBO.getConstantValue9()).append("\n");
        }
        if (!StringUtils.isBlank((CharSequence)agrAgreementSkuBO.getConstantValue10())) {
            constantValueStrBuilder.append(variablePO.getConstantValue10()).append(":").append(agrAgreementSkuBO.getConstantValue10()).append("\n");
        }
        agrAgreementSkuBO.setConstantValueStr(constantValueStrBuilder.toString());
    }
}

