/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.AgrQryAgreementSkuDetailsBusiService;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuDetailsBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuDetailsBusiRspBO;
import com.tydic.agreement.common.bo.AgrAgreementBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.EcpContractItemMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.agreement.dao.po.EcpContractItemPO;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrQryAgreementSkuDetailsBusiServiceImpl
implements AgrQryAgreementSkuDetailsBusiService {
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private EcpContractItemMapper ecpContractItemMapper;

    public AgrQryAgreementSkuDetailsBusiRspBO qryAgreementSkuDetails(AgrQryAgreementSkuDetailsBusiReqBO busiReqBO) {
        AgrQryAgreementSkuDetailsBusiRspBO rsp = new AgrQryAgreementSkuDetailsBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        BeanUtils.copyProperties((Object)busiReqBO, (Object)agreementSkuPO);
        agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementSkuPO agreementSku = this.agreementSkuMapper.getModelBy(agreementSkuPO);
        if (null == agreementSku) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        AgrAgreementSkuBO agrAgreementSkuBO = new AgrAgreementSkuBO();
        BeanUtils.copyProperties((Object)agreementSku, (Object)agrAgreementSkuBO);
        AgrAgreementBO agrAgreementBO = new AgrAgreementBO();
        BeanUtils.copyProperties((Object)agreement, (Object)agrAgreementBO);
        this.tanslate(agrAgreementBO);
        agrAgreementSkuBO.setAgrAgreementBO(agrAgreementBO);
        if (agrAgreementSkuBO.getIsOil() != null) {
            String isOilStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_OIL_PCODE", agrAgreementSkuBO.getIsOil().toString());
            agrAgreementSkuBO.setIsOilStr(isOilStr);
        }
        if (null != agrAgreementSkuBO.getPurchaseType()) {
            String purchaseTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "EXT_FIELD1_PCODE", agrAgreementSkuBO.getPurchaseType());
            agrAgreementSkuBO.setPurchaseTypeStr(purchaseTypeStr);
        }
        if (StringUtils.isNotBlank((CharSequence)agrAgreementSkuBO.getProducingArea())) {
            agrAgreementSkuBO.setProducingAreaStr(this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGR_PRODUCING_AREA", agrAgreementSkuBO.getProducingArea()));
        }
        if (null != agrAgreementSkuBO.getCatalogVariety()) {
            agrAgreementSkuBO.setCatalogVarietyStr(this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_VARIETY_PCODE", agrAgreementSkuBO.getCatalogVariety().toString()));
        }
        if (null != agrAgreementSkuBO.getDifferencesAcceptance()) {
            agrAgreementSkuBO.setDifferencesAcceptanceStr(AgrEnum.YesOrNo.getDesc((Byte)agrAgreementSkuBO.getDifferencesAcceptance().byteValue()));
        }
        if (null != agrAgreementSkuBO.getAdjustAcceptance()) {
            agrAgreementSkuBO.setAdjustAcceptanceStr(AgrEnum.YesOrNo.getDesc((Byte)agrAgreementSkuBO.getAdjustAcceptance().byteValue()));
        }
        if (AgrEnum.RelSystem.ECP.toString().equalsIgnoreCase(agreement.getRelSystem())) {
            try {
                EcpContractItemPO ecpContractItemPo = new EcpContractItemPO();
                ecpContractItemPo.setContractItemId(agreementSku.getExtItemId());
                ecpContractItemPo.setEcpContractId(agreement.getExtContractId());
                ecpContractItemPo = this.ecpContractItemMapper.getModelBy(ecpContractItemPo);
                if (ecpContractItemPo != null) {
                    agrAgreementSkuBO.setBrandModify(Boolean.valueOf(StringUtils.isBlank((CharSequence)ecpContractItemPo.getBrandName())));
                    agrAgreementSkuBO.setManufacturerModify(Boolean.valueOf(StringUtils.isBlank((CharSequence)ecpContractItemPo.getManufacturer())));
                    agrAgreementSkuBO.setBuyNumberModify(Boolean.valueOf(Objects.isNull(ecpContractItemPo.getBuyNumber())));
                    agrAgreementSkuBO.setBuyPriceModify(Boolean.valueOf(Objects.isNull(ecpContractItemPo.getBuyPrice())));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        rsp.setAgrAgreementSkuBO(agrAgreementSkuBO);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u8be6\u60c5\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    private void tanslate(AgrAgreementBO agrAgreementBO) {
        if (null != agrAgreementBO.getAgreementMode()) {
            String agreementModeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_MODE_PCODE", agrAgreementBO.getAgreementMode().toString());
            agrAgreementBO.setAgreementModeStr(agreementModeStr);
        }
        if (null != agrAgreementBO.getPriceType()) {
            String priceTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "PRICE_TYPE_PCODE", agrAgreementBO.getPriceType().toString());
            agrAgreementBO.setPriceTypeStr(priceTypeStr);
        }
        if (null != agrAgreementBO.getAgreementType()) {
            String agreementTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_TYPE_PCODE", agrAgreementBO.getAgreementType().toString());
            agrAgreementBO.setAgreementTypeStr(agreementTypeStr);
        }
        if (null != agrAgreementBO.getAgreementSrc()) {
            String agreementSrcStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_SRC_PCODE", agrAgreementBO.getAgreementSrc().toString());
            agrAgreementBO.setAgreementSrcStr(agreementSrcStr);
        }
        if (null != agrAgreementBO.getAgreementVariety()) {
            String agreementVarietyStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_VARIETY_PCODE", agrAgreementBO.getAgreementVariety().toString());
            agrAgreementBO.setAgreementVarietyStr(agreementVarietyStr);
        }
        if (null != agrAgreementBO.getCurrency()) {
            String currencyStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "CURRENCY_PCODE", agrAgreementBO.getCurrency().toString());
            agrAgreementBO.setCurrencyStr(currencyStr);
        }
        if (null != agrAgreementBO.getIsDispatch()) {
            String isDispatchStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_DISPATCH_PCODE", agrAgreementBO.getIsDispatch().toString());
            agrAgreementBO.setIsDispatchStr(isDispatchStr);
        }
        if (null != agrAgreementBO.getAdjustPrice()) {
            String adjustPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "ADJUST_PRICE_PCODE", agrAgreementBO.getAdjustPrice().toString());
            agrAgreementBO.setAdjustPriceStr(adjustPriceStr);
        }
        if (null != agrAgreementBO.getIsAdjustPriceFormula()) {
            String isAdjustPriceFormulaStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_ADJUST_PRICE_FORMULA_PCODE", agrAgreementBO.getIsAdjustPriceFormula().toString());
            agrAgreementBO.setIsAdjustPriceFormulaStr(isAdjustPriceFormulaStr);
        }
        if (null != agrAgreementBO.getIsModifyBuyPrice()) {
            String isModifyBuyPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_MODIFY_BUY_PRICE_PCODE", agrAgreementBO.getIsModifyBuyPrice().toString());
            agrAgreementBO.setIsModifyBuyPriceStr(isModifyBuyPriceStr);
        }
        if (null != agrAgreementBO.getIsAddPrice()) {
            String isAddPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_ADD_PRICE_PCODE", agrAgreementBO.getIsAddPrice().toString());
            agrAgreementBO.setIsAddPriceStr(isAddPriceStr);
        }
        if (null != agrAgreementBO.getAgrLocation()) {
            String agrLocationStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGR_LOCATION_PCODE", agrAgreementBO.getAgrLocation().toString());
            agrAgreementBO.setAgrLocationStr(agrLocationStr);
        }
        if (null != agrAgreementBO.getAgreementStatus()) {
            String agreementStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGREEMENT_STATUS_PCODE", agrAgreementBO.getAgreementStatus().toString());
            agrAgreementBO.setAgreementStatusStr(agreementStatusStr);
        }
        if (null != agrAgreementBO.getAssignStatus()) {
            String assignStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "ASSIGN_STATUS_PCODE", agrAgreementBO.getAssignStatus().toString());
            agrAgreementBO.setAssignStatusStr(assignStatusStr);
        }
        if (null != agrAgreementBO.getSupplierMode()) {
            String supplierModeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "SUPPLIER_MODE_PCODE", agrAgreementBO.getSupplierMode().toString());
            agrAgreementBO.setSupplierModeStr(supplierModeStr);
        }
        if (null != agrAgreementBO.getTradeMode()) {
            String tradeModeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "TRADE_MODE_PCODE", agrAgreementBO.getTradeMode().toString());
            agrAgreementBO.setTradeModeStr(tradeModeStr);
        }
        if (null != agrAgreementBO.getScopeType()) {
            String scopeTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "EXT_SCOPE_TYPE_PCODE", agrAgreementBO.getScopeType().toString());
            agrAgreementBO.setScopeTypeStr(scopeTypeStr);
        }
    }
}

