/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.tydic.agreement.busi.AgrQryExtContractPurchaseTypeBusiService;
import com.tydic.agreement.busi.bo.AgrQryExtContractPurchaseTypeBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryExtContractPurchaseTypeBusiRspBO;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.EcpContractMapper;
import com.tydic.agreement.dao.OpsContractMapper;
import com.tydic.agreement.dao.SrmContractMapper;
import com.tydic.agreement.dao.po.EcpContractPO;
import com.tydic.agreement.dao.po.OpsContractPO;
import com.tydic.agreement.dao.po.SrmContractPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AgrQryExtContractPurchaseTypeBusiServiceImpl
implements AgrQryExtContractPurchaseTypeBusiService {
    @Autowired
    private EcpContractMapper ecpContractMapper;
    @Autowired
    private SrmContractMapper srmContractMapper;
    @Autowired
    private OpsContractMapper opsContractMapper;

    public AgrQryExtContractPurchaseTypeBusiRspBO qryExtContractPurchaseType(AgrQryExtContractPurchaseTypeBusiReqBO busiReqBO) {
        AgrQryExtContractPurchaseTypeBusiRspBO rsp = new AgrQryExtContractPurchaseTypeBusiRspBO();
        if (busiReqBO == null) {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u8bf7\u6c42\u5bf9\u8c61\u4e3a\u7a7a");
            return rsp;
        }
        String relSystem = busiReqBO.getRelSystem();
        if (relSystem == null) {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u5173\u8054\u7cfb\u7edf\u7684\u503c\u4e3a\u7a7a");
            return rsp;
        }
        String extContractId = busiReqBO.getExtContractId();
        String extContractCode = busiReqBO.getExtContractCode();
        if (AgrEnum.RelSystem.OPS.toString().equalsIgnoreCase(busiReqBO.getRelSystem())) {
            OpsContractPO opsContractPO = new OpsContractPO();
            opsContractPO.setContractId(extContractId);
            opsContractPO.setContractCode(extContractCode);
            OpsContractPO opsContractPo = this.opsContractMapper.getModelBy(opsContractPO);
            if (null == opsContractPo) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u672a\u67e5\u8be2\u5230\u5173\u8054\u5408\u540c\u4fe1\u606f");
                return rsp;
            }
            rsp.setPurchaseType(opsContractPo.getPurchaseType());
            if (StringUtils.hasText((String)opsContractPo.getPurchaseType())) {
                rsp.setPurchaseTypeStr(AgrEnum.PurchaseType.getDescByCode((String)opsContractPo.getPurchaseType()));
            }
        } else if (AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(busiReqBO.getRelSystem())) {
            SrmContractPO srmContractPO = new SrmContractPO();
            srmContractPO.setContractId(extContractId);
            srmContractPO.setContractCode(extContractCode);
            SrmContractPO srmContractPo = this.srmContractMapper.getModelBy(srmContractPO);
            if (null == srmContractPo) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u672a\u67e5\u8be2\u5230\u5173\u8054\u5408\u540c\u4fe1\u606f");
                return rsp;
            }
            rsp.setPurchaseType(srmContractPo.getPurchaseType().toString());
            if (StringUtils.hasText((String)srmContractPo.getPurchaseType().toString())) {
                rsp.setPurchaseTypeStr(AgrEnum.PurchaseType.getDescByCode((String)srmContractPo.getPurchaseType().toString()));
            }
        } else if (AgrEnum.RelSystem.ECP.toString().equalsIgnoreCase(busiReqBO.getRelSystem())) {
            EcpContractPO ecpContractPO = new EcpContractPO();
            ecpContractPO.setContractId(extContractId);
            ecpContractPO.setContractCode(extContractCode);
            EcpContractPO ecpContractPo = this.ecpContractMapper.getModelBy(ecpContractPO);
            if (null == ecpContractPo) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u672a\u67e5\u8be2\u5230\u5173\u8054\u5408\u540c\u4fe1\u606f");
                return rsp;
            }
            rsp.setPurchaseType(ecpContractPo.getPurchaseType().toString());
            if (StringUtils.hasText((String)ecpContractPo.getPurchaseType().toString())) {
                rsp.setPurchaseTypeStr(AgrEnum.PurchaseType.getDescByCode((String)ecpContractPo.getPurchaseType().toString()));
            }
        } else {
            rsp.setRespCode("LABEL_SYNC_EXPIRED");
            rsp.setRespDesc("\u4e0d\u5b58\u5728\u8be5\u5173\u8054\u7cfb\u7edf");
            return rsp;
        }
        rsp.setExtContractId(extContractId);
        rsp.setExtContractCode(extContractCode);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }
}

