/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.tydic.agreement.ability.bo.AgrQrySmmQuotaCurrentDataReqBO;
import com.tydic.agreement.ability.bo.AgrQrySmmQuotaCurrentDataRspBO;
import com.tydic.agreement.ability.bo.AgrQrySmmQuotaDataListPageReqBO;
import com.tydic.agreement.ability.bo.AgrQrySmmQuotaDataListPageRspBO;
import com.tydic.agreement.ability.bo.QuotaDataOriginBO;
import com.tydic.agreement.ability.bo.QuotaDataOriginPageBO;
import com.tydic.agreement.ability.bo.QuotaListBO;
import com.tydic.agreement.busi.AgrQrySmmQuotaDataListPageBusiService;
import com.tydic.agreement.dao.QuotaDataOriginMapper;
import com.tydic.agreement.dao.QuotaListMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrQrySmmQuotaDataListPageBusiServiceImpl
implements AgrQrySmmQuotaDataListPageBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrQrySmmQuotaDataListPageBusiServiceImpl.class);
    @Value(value="${SSM_COPPER_QUOTA:s20015437/s20015439/s20015438/s20015440/s20015441}")
    private String SSM_COPPER_QUOTA;
    @Value(value="${SSM_COPPER_QUOTA:s20016448/s20016450/s20016449/s20016451/s20016452}")
    private String SSM_AL_QUOTA;
    private static final String COPPER = "1";
    private static final String AL = "2";
    private static final String[] SSM_COPPER_QUOTA_IDS = new String[]{"s20015437", "s20015439", "s20015438", "s20015440", "s20015441"};
    private static final String[] SSM_AL_QUOTA_IDS = new String[]{"s20016448", "s20016450", "s20016449", "s20016451", "s20016452"};
    @Autowired
    private QuotaListMapper quotaListMapper;
    @Autowired
    private QuotaDataOriginMapper quotaDataOriginMapper;

    public AgrQrySmmQuotaDataListPageRspBO qrySmmQuotaDataListPage(AgrQrySmmQuotaDataListPageReqBO reqBO) {
        AgrQrySmmQuotaDataListPageRspBO rspBO = new AgrQrySmmQuotaDataListPageRspBO();
        ArrayList<QuotaDataOriginPageBO> quotaDataOriginPageBOS = new ArrayList<QuotaDataOriginPageBO>();
        ArrayList<String> quotaIds = new ArrayList<String>();
        String sortQuotaId = "";
        rspBO.setRows(quotaDataOriginPageBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getDataType().equals(COPPER)) {
            quotaIds.addAll(Arrays.asList(SSM_COPPER_QUOTA_IDS));
            sortQuotaId = "s20015437";
        } else if (reqBO.getDataType().equals(AL)) {
            quotaIds.addAll(Arrays.asList(SSM_AL_QUOTA_IDS));
            sortQuotaId = "s20016448";
        } else {
            return rspBO;
        }
        if (reqBO.getStartDate() == null && reqBO.getEndDate() == null) {
            Calendar current = Calendar.getInstance();
            current.add(2, -2);
            reqBO.setStartDate(current.getTime());
            reqBO.setEndDate(new Date());
        }
        HashMap dateQuotaDataBOMap = new HashMap();
        for (String string : quotaIds) {
            reqBO.setQuotaId(string);
            List<QuotaDataOriginBO> quotaDataOriginBOS = this.quotaDataOriginMapper.selectListPageByCondition(reqBO);
            for (QuotaDataOriginBO quotaDataOriginBO : quotaDataOriginBOS) {
                String key = quotaDataOriginBO.getDate();
                if (dateQuotaDataBOMap.containsKey(key)) {
                    ((List)dateQuotaDataBOMap.get(key)).add(quotaDataOriginBO);
                    continue;
                }
                ArrayList<QuotaDataOriginBO> list = new ArrayList<QuotaDataOriginBO>();
                list.add(quotaDataOriginBO);
                dateQuotaDataBOMap.put(key, list);
            }
            if (!string.equals(sortQuotaId)) continue;
            BigDecimal max = new BigDecimal(quotaDataOriginBOS.get(0).getValue());
            BigDecimal min = new BigDecimal(quotaDataOriginBOS.get(0).getValue());
            for (QuotaDataOriginBO quotaDataOriginBO : quotaDataOriginBOS) {
                BigDecimal v = new BigDecimal(quotaDataOriginBO.getValue());
                max = v.max(max);
                min = v.min(min);
            }
            rspBO.setMax(this.getUpperLimit(max));
            rspBO.setMin(this.getLowerLimit(min));
        }
        if (!CollectionUtils.isEmpty(dateQuotaDataBOMap)) {
            for (Map.Entry entry : dateQuotaDataBOMap.entrySet()) {
                String date = (String)entry.getKey();
                QuotaDataOriginPageBO quotaDataOriginPageBO = new QuotaDataOriginPageBO();
                quotaDataOriginPageBO.setDate(date);
                quotaDataOriginPageBO.setQuotaDataOriginData((List)entry.getValue());
                for (QuotaDataOriginBO quotaDataOriginBO : (List)entry.getValue()) {
                    if (quotaDataOriginBO.getQuotaId().equals("s20015437") || quotaDataOriginBO.getQuotaId().equals("s20016448")) {
                        quotaDataOriginPageBO.setJj(quotaDataOriginBO.getValue());
                    }
                    if (quotaDataOriginBO.getQuotaId().equals("s20015439") || quotaDataOriginBO.getQuotaId().equals("s20016450")) {
                        quotaDataOriginPageBO.setZdj(quotaDataOriginBO.getValue());
                    }
                    if (quotaDataOriginBO.getQuotaId().equals("s20015438") || quotaDataOriginBO.getQuotaId().equals("s20016449")) {
                        quotaDataOriginPageBO.setZgj(quotaDataOriginBO.getValue());
                    }
                    if (quotaDataOriginBO.getQuotaId().equals("s20015440") || quotaDataOriginBO.getQuotaId().equals("s20016451")) {
                        quotaDataOriginPageBO.setZd(quotaDataOriginBO.getValue());
                    }
                    if (!quotaDataOriginBO.getQuotaId().equals("s20015441") && !quotaDataOriginBO.getQuotaId().equals("s20016452")) continue;
                    quotaDataOriginPageBO.setZdf(quotaDataOriginBO.getValue());
                }
                quotaDataOriginPageBOS.add(quotaDataOriginPageBO);
            }
            quotaDataOriginPageBOS.sort(Comparator.comparing(QuotaDataOriginPageBO::getDate).reversed());
        }
        return rspBO;
    }

    public AgrQrySmmQuotaCurrentDataRspBO qrySmmQuotaCurrentData(AgrQrySmmQuotaCurrentDataReqBO reqBO) {
        AgrQrySmmQuotaCurrentDataRspBO rspBO = new AgrQrySmmQuotaCurrentDataRspBO();
        List<Object> quotaListBOS = new ArrayList();
        rspBO.setQuotaListBOList(quotaListBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getDataType().equals(COPPER)) {
            reqBO.setQuotaIds(Arrays.asList(SSM_COPPER_QUOTA_IDS));
        } else if (reqBO.getDataType().equals(AL)) {
            reqBO.setQuotaIds(Arrays.asList(SSM_AL_QUOTA_IDS));
        } else {
            return rspBO;
        }
        quotaListBOS = this.quotaListMapper.selectListByCondition(reqBO.getQuotaIds());
        if (CollectionUtils.isEmpty(quotaListBOS)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        rspBO.setQuotaListBOList(quotaListBOS);
        try {
            Date date;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar current = Calendar.getInstance();
            current.add(5, 1);
            List<QuotaDataOriginBO> quotaDataOriginBOS = null;
            do {
                current.add(5, -1);
                String s = sdf.format(current.getTime());
                date = sdf.parse(s);
            } while (CollectionUtils.isEmpty(quotaDataOriginBOS = this.quotaDataOriginMapper.selectListByDate(null, reqBO.getQuotaIds(), date)));
            if (!CollectionUtils.isEmpty(quotaDataOriginBOS)) {
                for (QuotaListBO quotaListBO : quotaListBOS) {
                    for (QuotaDataOriginBO quotaDataOriginBO : quotaDataOriginBOS) {
                        if (!quotaListBO.getQuotaId().equals(quotaDataOriginBO.getQuotaId())) continue;
                        if (quotaListBO.getData() == null) {
                            quotaListBO.setData(new ArrayList());
                        }
                        quotaListBO.getData().add(quotaDataOriginBO);
                        if (quotaDataOriginBO.getQuotaId().equals("s20015437") || quotaDataOriginBO.getQuotaId().equals("s20016448")) {
                            rspBO.setJj(quotaDataOriginBO.getValue());
                        }
                        if (quotaDataOriginBO.getQuotaId().equals("s20015439") || quotaDataOriginBO.getQuotaId().equals("s20016450")) {
                            rspBO.setZdj(quotaDataOriginBO.getValue());
                        }
                        if (quotaDataOriginBO.getQuotaId().equals("s20015438") || quotaDataOriginBO.getQuotaId().equals("s20016449")) {
                            rspBO.setZgj(quotaDataOriginBO.getValue());
                        }
                        if (quotaDataOriginBO.getQuotaId().equals("s20015440") || quotaDataOriginBO.getQuotaId().equals("s20016451")) {
                            rspBO.setZd(quotaDataOriginBO.getValue());
                        }
                        if (!quotaDataOriginBO.getQuotaId().equals("s20015441") && !quotaDataOriginBO.getQuotaId().equals("s20016452")) continue;
                        rspBO.setZdf(quotaDataOriginBO.getValue());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u83b7\u53d6\u5f53\u5929\u6307\u6807\u6570\u636e\u9519\u8bef:" + e.toString());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u83b7\u53d6\u5f53\u5929\u6307\u6807\u6570\u636e\u9519\u8bef:" + e.toString());
        }
        return rspBO;
    }

    private String getUpperLimit(BigDecimal maxValue) {
        BigDecimal integerPart = maxValue.setScale(0, RoundingMode.DOWN);
        int maxLength = integerPart.toString().length();
        StringBuilder step = new StringBuilder();
        StringBuilder init = new StringBuilder();
        step.append(COPPER);
        init.append(integerPart.toString().charAt(0));
        for (int i = 1; i < maxLength - 1; ++i) {
            step.append("0");
            init.append("0");
        }
        init.append("0");
        BigDecimal output = new BigDecimal(init.toString());
        while ((output = output.add(new BigDecimal(step.toString()))).compareTo(maxValue) <= 0) {
        }
        return output.toString();
    }

    private String getLowerLimit(BigDecimal minValue) {
        BigDecimal integerPart = minValue.setScale(0, RoundingMode.DOWN);
        int maxLength = integerPart.toString().length();
        StringBuilder step = new StringBuilder();
        StringBuilder init = new StringBuilder();
        step.append(COPPER);
        for (int i = 1; i < maxLength - 1; ++i) {
            step.append("0");
        }
        int initLength = maxLength - step.length() + 1;
        for (int i = 0; i < initLength; ++i) {
            init.append(integerPart.toString().charAt(i));
        }
        int appendLength = maxLength - init.length();
        for (int i = 0; i < appendLength; ++i) {
            init.append("0");
        }
        BigDecimal output = new BigDecimal(init.toString());
        while ((output = output.subtract(new BigDecimal(step.toString()))).compareTo(minValue) >= 0) {
        }
        return output.toString();
    }
}

