/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.tydic.agreement.busi.AgrSyncMaterialFreezeBusiService;
import com.tydic.agreement.busi.AgrSyncMaterialFreezeConsumerBusiService;
import com.tydic.agreement.busi.bo.AgrSyncMaterialFreezeBusiReqBO;
import com.tydic.agreement.busi.bo.AgrSyncMaterialFreezeConsumerBusiReqBO;
import com.tydic.agreement.busi.bo.AgrSyncMaterialFreezeConsumerBusiRspBO;
import com.tydic.agreement.common.bo.AgrAgreementBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementSkuChangePO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.umc.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umcext.ability.member.UmcZhQryMemByManagementAbilityService;
import com.tydic.umcext.ability.member.bo.UmcZhQryMemByManagementAbilityReqBO;
import com.tydic.umcext.ability.member.bo.UmcZhQryMemByManagementAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrSyncMaterialFreezeConsumerBusiServiceImpl
implements AgrSyncMaterialFreezeConsumerBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrSyncMaterialFreezeConsumerBusiServiceImpl.class);
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSkuChangeMapper agreementChangeMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrSyncMaterialFreezeBusiService agrSyncMaterialFreezeBusiService;
    @Autowired
    private UmcZhQryMemByManagementAbilityService umcZhQryMemByManagementAbilityService;

    public AgrSyncMaterialFreezeConsumerBusiRspBO syncMaterialFreeze(AgrSyncMaterialFreezeConsumerBusiReqBO busiReqBO) {
        AgrSyncMaterialFreezeConsumerBusiRspBO rspBO = new AgrSyncMaterialFreezeConsumerBusiRspBO();
        Date date = new Date();
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getEnableMaterialCodes())) {
            Set enableMaterialCodes = busiReqBO.getEnableMaterialCodes();
            this.updateSku(date, AgrCommConstant.IsDelete.NORMAL, enableMaterialCodes);
            this.updateSkuChange(date, AgrCommConstant.IsDelete.NORMAL, enableMaterialCodes);
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBO.getFreezeMaterialCodes())) {
            Set freezeMaterialCodes = busiReqBO.getFreezeMaterialCodes();
            this.updateSku(date, AgrCommConstant.IsDelete.DELETED, freezeMaterialCodes);
            this.updateSkuChange(date, AgrCommConstant.IsDelete.DELETED, freezeMaterialCodes);
            AgreementSkuPO po = new AgreementSkuPO();
            po.setMaterialIds(new ArrayList<String>(freezeMaterialCodes));
            po.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            List<AgreementSkuPO> agreementSkuPOS = this.agreementSkuMapper.getList(po);
            if (!CollectionUtils.isEmpty(agreementSkuPOS)) {
                Set agreementIds = agreementSkuPOS.stream().map(AgreementSkuPO::getAgreementId).collect(Collectors.toSet());
                AgreementPO agreementPO = new AgreementPO();
                agreementPO.setAgreementIds(new ArrayList<Long>(agreementIds));
                agreementPO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
                agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                List<AgreementPO> mapperMaterialFreezeList = this.agreementMapper.getList(agreementPO);
                HashMap managementAbilityRspBOMap = new HashMap();
                if (!CollectionUtils.isEmpty(mapperMaterialFreezeList)) {
                    Set memIds = mapperMaterialFreezeList.stream().map(AgreementPO::getProducerId).collect(Collectors.toSet());
                    if (!CollectionUtils.isEmpty(memIds)) {
                        UmcZhQryMemByManagementAbilityReqBO umcReqBo = new UmcZhQryMemByManagementAbilityReqBO();
                        umcReqBo.setMemIds(new ArrayList(memIds));
                        umcReqBo.setPageNo(Integer.valueOf(-1));
                        umcReqBo.setPageSize(Integer.valueOf(-1));
                        UmcZhQryMemByManagementAbilityRspBO managementAbilityRspBO = this.umcZhQryMemByManagementAbilityService.qryMem(umcReqBo);
                        if ("0000".equals(managementAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)managementAbilityRspBO.getRows())) {
                            managementAbilityRspBO.getRows().forEach(item -> managementAbilityRspBOMap.put(item.getMemId(), item));
                        }
                    }
                    mapperMaterialFreezeList.forEach(item -> {
                        UmcMemDetailInfoAbilityBO umcMemDetailInfoAbilityBO;
                        AgrSyncMaterialFreezeBusiReqBO freezeBusiReqBO = new AgrSyncMaterialFreezeBusiReqBO();
                        AgrAgreementBO agrAgreementBO = new AgrAgreementBO();
                        BeanUtils.copyProperties((Object)item, (Object)agrAgreementBO);
                        if (!CollectionUtils.isEmpty((Map)managementAbilityRspBOMap) && null != (umcMemDetailInfoAbilityBO = (UmcMemDetailInfoAbilityBO)managementAbilityRspBOMap.get(item.getProducerId()))) {
                            agrAgreementBO.setProducerId(umcMemDetailInfoAbilityBO.getUserId());
                            agrAgreementBO.setProducerName(umcMemDetailInfoAbilityBO.getMemName2());
                        }
                        freezeBusiReqBO.setAgrAgreementBO(agrAgreementBO);
                        this.agrSyncMaterialFreezeBusiService.dealSyncMaterialFreeze(freezeBusiReqBO);
                    });
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7269\u8d44\u7f16\u7801\u505c\u7528\u540c\u6b65\u6210\u529f\uff01");
        return rspBO;
    }

    private void updateSkuChange(Date date, Byte freezeFlag, Set<String> materialIds) {
        AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
        agreementSkuChangePO.setUpdateTime(date);
        agreementSkuChangePO.setFreezeFlag(freezeFlag);
        agreementSkuChangePO.setMaterialIds(new ArrayList<String>(materialIds));
        this.agreementChangeMapper.updateByMaterialFreezeConsumer(agreementSkuChangePO);
    }

    private void updateSku(Date date, Byte freezeFlag, Set<String> materialIds) {
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setUpdateTime(date);
        agreementSkuPO.setFreezeFlag(freezeFlag);
        agreementSkuPO.setMaterialIds(new ArrayList<String>(materialIds));
        this.agreementSkuMapper.updateByMaterialFreezeConsumer(agreementSkuPO);
    }
}

