/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.atom.AgrAgreementStatusChangeAtomService;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomRspBO;
import com.tydic.agreement.busi.AgrUnfreezeAgreementBusiService;
import com.tydic.agreement.busi.bo.AgrUnfreezeAgreementBusiReqBO;
import com.tydic.agreement.busi.bo.AgrUnfreezeAgreementBusiRspBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.po.AgreementChangePO;
import com.tydic.agreement.dao.po.AgreementPO;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrUnfreezeAgreementBusiServiceImpl
implements AgrUnfreezeAgreementBusiService {
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private AgrAgreementStatusChangeAtomService agrAgreementStatusChangeAtomService;

    public AgrUnfreezeAgreementBusiRspBO unfreezeAgreementInfo(AgrUnfreezeAgreementBusiReqBO busiReqBO) {
        AgrUnfreezeAgreementBusiRspBO rsp = new AgrUnfreezeAgreementBusiRspBO();
        for (Long agreementId : busiReqBO.getAgreementIds()) {
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setAgreementId(agreementId);
            agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
            if (null == agreement) {
                throw new BusinessException("22001", "\u8be5\u534f\u8bae\u3010" + agreementId + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            if (!AgrCommConstant.AgreementStatus.FROZEN.equals(agreement.getAgreementStatus())) {
                throw new BusinessException("22002", "\u8be5\u534f\u8bae\u3010" + agreementId + "\u3011\u4e0d\u4e3a\u51bb\u7ed3\u72b6\u6001\uff01");
            }
            AgreementChangePO agreementChangePO = new AgreementChangePO();
            agreementChangePO.setAgreementId(agreementId);
            agreementChangePO.setCreateTime(agreement.getUpdateTime());
            AgreementChangePO agreementChange = this.agreementChangeMapper.getModelBy(agreementChangePO);
            if (null == agreementChange) {
                throw new BusinessException("22001", "\u8be5\u534f\u8bae\u3010" + agreementId + "\u3011\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u53d8\u66f4\u7533\u8bf7\u6570\u636e\uff01");
            }
            if (!AgrCommConstant.AgreementChangeType.CHANGE_PRICE.equals(agreementChange.getChangeType()) && !AgrCommConstant.AgreementChangeType.STOCK_CHANGE.equals(agreementChange.getChangeType())) {
                throw new BusinessException("22002", "\u8be5\u534f\u8bae\u3010" + agreementId + "\u3011\u5bf9\u5e94\u7684\u53d8\u66f4\u7533\u8bf7\u7c7b\u578b\u4e0d\u4e3a\u8c03\u4ef7\u7c7b\u578b\u6216\u8005\u5e93\u5b58\u53d8\u66f4\uff01");
            }
            if (!AgrCommConstant.ChangeApplyStatus.NO_PASS.equals(agreementChange.getStatus())) {
                throw new BusinessException("22002", "\u8be5\u534f\u8bae\u3010" + agreementId + "\u3011\u5bf9\u5e94\u7684\u53d8\u66f4\u7533\u8bf7\u72b6\u6001\u4e0d\u4e3a\u4e0d\u901a\u8fc7\u72b6\u6001\uff01");
            }
            AgrAgreementStatusChangeAtomReqBO agrAgreementStatusChangeAtomReqBO = new AgrAgreementStatusChangeAtomReqBO();
            agrAgreementStatusChangeAtomReqBO.setMemIdIn(busiReqBO.getMemIdIn());
            agrAgreementStatusChangeAtomReqBO.setUsername(busiReqBO.getUsername());
            HashSet<Long> agreementIds = new HashSet<Long>();
            agreementIds.add(agreementId);
            agrAgreementStatusChangeAtomReqBO.setAgreementIds(agreementIds);
            agrAgreementStatusChangeAtomReqBO.setAgreementStatusPre(AgrCommConstant.AgreementStatus.FROZEN);
            agrAgreementStatusChangeAtomReqBO.setAgreementStatusPost(AgrCommConstant.AgreementStatus.ENABLE);
            AgrAgreementStatusChangeAtomRspBO agrAgreementStatusChangeAtomRspBO = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(agrAgreementStatusChangeAtomReqBO);
            if ("0000".equals(agrAgreementStatusChangeAtomRspBO.getRespCode())) continue;
            throw new BusinessException(agrAgreementStatusChangeAtomRspBO.getRespCode(), agrAgreementStatusChangeAtomRspBO.getRespDesc());
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u89e3\u51bb\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

