/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.atom.AgrAgreementStatusChangeAtomService;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomRspBO;
import com.tydic.agreement.busi.AgrUpdateBeOverdueAgreementStatusTimeTaskBusiService;
import com.tydic.agreement.busi.bo.AgrUpdateBeOverdueAgreementStatusTimeTaskBusiReqBO;
import com.tydic.agreement.busi.bo.AgrUpdateBeOverdueAgreementStatusTimeTaskBusiRspBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrUpdateBeOverdueAgreementStatusTimeTaskBusiServiceImpl
implements AgrUpdateBeOverdueAgreementStatusTimeTaskBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrUpdateBeOverdueAgreementStatusTimeTaskBusiServiceImpl.class);
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementStatusChangeAtomService agrAgreementStatusChangeAtomService;

    public AgrUpdateBeOverdueAgreementStatusTimeTaskBusiRspBO execute(AgrUpdateBeOverdueAgreementStatusTimeTaskBusiReqBO busiReqBO) {
        String configShardValue;
        AgrUpdateBeOverdueAgreementStatusTimeTaskBusiRspBO rsp = new AgrUpdateBeOverdueAgreementStatusTimeTaskBusiRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u6210\u529f");
        if (log.isInfoEnabled()) {
            log.debug("==========\u5f00\u59cb\u6267\u884c\u8fc7\u671f\u542f\u7528\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u5b9a\u65f6\u4efb\u52a1\uff0ccurrentShardValue:[" + busiReqBO.getShardingItem() + "]==========");
        }
        if (StringUtils.isBlank((CharSequence)(configShardValue = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "AGR_TOTAL_SHARD_COUNT", "1")))) {
            log.error("\u8fd8\u672a\u5728\u5b57\u5178\u4e2d\u914d\u7f6e\u603b\u5206\u7247\u503c");
            return rsp;
        }
        List<Long> agreementIds = this.agreementMapper.getBeOverdueAgreementIdsTimeTask(new Date(), configShardValue, busiReqBO.getShardingItem());
        if (!CollectionUtils.isEmpty(agreementIds)) {
            AgrAgreementStatusChangeAtomReqBO agrAgreementStatusChangeAtomReqBO = new AgrAgreementStatusChangeAtomReqBO();
            agrAgreementStatusChangeAtomReqBO.setAgreementIds(new HashSet<Long>(agreementIds));
            agrAgreementStatusChangeAtomReqBO.setAgreementStatusPre(AgrCommConstant.AgreementStatus.ENABLE);
            agrAgreementStatusChangeAtomReqBO.setAgreementStatusPost(AgrCommConstant.AgreementStatus.BE_OVERDUE);
            AgrAgreementStatusChangeAtomRspBO agrAgreementStatusChangeAtomRspBO = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(agrAgreementStatusChangeAtomReqBO);
            if (!"0000".equals(agrAgreementStatusChangeAtomRspBO.getRespCode())) {
                throw new BusinessException(agrAgreementStatusChangeAtomRspBO.getRespCode(), agrAgreementStatusChangeAtomRspBO.getRespDesc());
            }
            rsp.setAgrIds(agreementIds);
        }
        if (log.isInfoEnabled()) {
            log.debug("==========\u8fc7\u671f\u542f\u7528\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5\uff0ccurrentShardValue:[" + busiReqBO.getShardingItem() + "]==========");
        }
        return rsp;
    }
}

