/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgreementDetailOrderedQuantityUpdateReqBO;
import com.tydic.agreement.ability.bo.AgreementDetailOrderedQuantityUpdateRspBO;
import com.tydic.agreement.busi.AgreementDetailOrderedQuantityUpdateBusiService;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementSkuBuyNumberChangeLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgreementSkuBuyNumberChangeLogPO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AgreementDetailOrderedQuantityUpdateBusiServiceImpl
implements AgreementDetailOrderedQuantityUpdateBusiService {
    @Autowired
    private AgreementSkuBuyNumberChangeLogMapper agreementSkuBuyNumberChangeLogMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;

    @Override
    public AgreementDetailOrderedQuantityUpdateRspBO updateAgreementDetailOrderedQuantity(AgreementDetailOrderedQuantityUpdateReqBO reqBo) {
        AgreementDetailOrderedQuantityUpdateRspBO rspBo = new AgreementDetailOrderedQuantityUpdateRspBO();
        ArrayList<AgreementSkuBuyNumberChangeLogPO> buyNumberChangeLogPoList = new ArrayList<AgreementSkuBuyNumberChangeLogPO>();
        ArrayList agreementSkuPos = new ArrayList();
        Date now = new Date();
        reqBo.getAgreementBuyList().forEach(agr -> agr.getDetailBuyList().forEach(detail -> {
            AgreementSkuBuyNumberChangeLogPO buyNumberChangeLogPo = new AgreementSkuBuyNumberChangeLogPO();
            buyNumberChangeLogPo.setLogId(Sequence.getInstance().nextId());
            buyNumberChangeLogPo.setAgreementId(agr.getAgreementId());
            buyNumberChangeLogPo.setAgreementSkuId(detail.getAgreementDetailId());
            buyNumberChangeLogPo.setChangeNum(detail.getQuantity());
            buyNumberChangeLogPo.setOrderId(reqBo.getOrderId());
            buyNumberChangeLogPo.setObjId(reqBo.getObjId());
            buyNumberChangeLogPo.setObjType(reqBo.getObjType().getTypeCode());
            buyNumberChangeLogPo.setCreateTime(now);
            buyNumberChangeLogPoList.add(buyNumberChangeLogPo);
            AgreementSkuPO agreementSkuPo = new AgreementSkuPO();
            agreementSkuPo.setAgreementSkuId(detail.getAgreementDetailId());
            agreementSkuPo.setOrderedQuantity(detail.getQuantity());
            agreementSkuPo.setSkuId(detail.getSkuId());
            if (reqBo.getOrderFlag() != null && reqBo.getOrderFlag().booleanValue() && StringUtils.hasText((String)reqBo.getOrderNo())) {
                if (StringUtils.hasText((String)detail.getPlanDetailNo())) {
                    agreementSkuPo.setComments(reqBo.getOrderNo() + "-" + detail.getPlanDetailNo());
                } else {
                    agreementSkuPo.setComments(reqBo.getOrderNo());
                }
                agreementSkuPo.setItemSource(AgrEnum.ItemSource.FROM_PLAN.getType());
            }
            agreementSkuPos.add(agreementSkuPo);
        }));
        int inserted = this.agreementSkuBuyNumberChangeLogMapper.insertBatch(buyNumberChangeLogPoList);
        if (inserted < buyNumberChangeLogPoList.size()) {
            throw new BusinessException("8888", "\u8bb0\u5f55\u4e0b\u5355\u6570\u91cf\u53d8\u66f4\u65e5\u5fd7\u5931\u8d25");
        }
        agreementSkuPos.forEach(po -> {
            int updated;
            Boolean checkFlag = reqBo.getCheckFlag();
            if (po.getOrderedQuantity().compareTo(BigDecimal.ZERO) < 0) {
                checkFlag = false;
            }
            if ((updated = this.agreementSkuMapper.updateOrderedQuantityAndComments(po.getAgreementSkuId(), po.getOrderedQuantity(), po.getItemSource(), po.getComments(), checkFlag)) < 1) {
                String codeName = po.getSkuId() == null ? "\u534f\u8bae\u660e\u7ec6\u7f16\u7801" : "\u5546\u54c1\u7f16\u7801";
                Long id = po.getSkuId() == null ? po.getAgreementSkuId() : po.getSkuId();
                throw new BusinessException("8888", codeName + "[" + id + "]\u66f4\u65b0\u534f\u8bae\u4e0b\u5355\u6570\u91cf\u5931\u8d25,\u8bf7\u786e\u8ba4\u4f59\u91cf!");
            }
        });
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

