/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.EcpContractOperateReqBO;
import com.tydic.agreement.ability.bo.EcpContractOperateRspBO;
import com.tydic.agreement.busi.EcpContractOperateBusiService;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.EcpContractItemLogMapper;
import com.tydic.agreement.dao.EcpContractItemMapper;
import com.tydic.agreement.dao.EcpContractLogMapper;
import com.tydic.agreement.dao.EcpContractMapper;
import com.tydic.agreement.dao.EcpContractScopeLogMapper;
import com.tydic.agreement.dao.EcpContractScopeMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.EcpContractItemLogPO;
import com.tydic.agreement.dao.po.EcpContractItemPO;
import com.tydic.agreement.dao.po.EcpContractLogPO;
import com.tydic.agreement.dao.po.EcpContractPO;
import com.tydic.agreement.dao.po.EcpContractScopeLogPO;
import com.tydic.agreement.dao.po.EcpContractScopePO;
import com.tydic.contract.api.ecp.ExtSyncContractService;
import com.tydic.contract.api.ecp.bo.ExtSyncContractReqBO;
import com.tydic.contract.api.ecp.bo.ExtSyncContractRspBO;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class EcpContractOperateBusiServiceImpl
implements EcpContractOperateBusiService {
    private static final Logger log = LoggerFactory.getLogger(EcpContractOperateBusiServiceImpl.class);
    @Autowired
    private EcpContractMapper ecpContractMapper;
    @Autowired
    private EcpContractScopeMapper ecpContractScopeMapper;
    @Autowired
    private EcpContractLogMapper ecpContractLogMapper;
    @Autowired
    private EcpContractScopeLogMapper ecpContractScopeLogMapper;
    @Autowired
    private EcpContractItemMapper ecpContractItemMapper;
    @Autowired
    private EcpContractItemLogMapper ecpContractItemLogMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private ExtSyncContractService extSyncContractService;

    @Override
    public EcpContractOperateRspBO syncEcpContract(EcpContractOperateReqBO reqBO) {
        int result;
        EcpContractPO checkEcpContractPO;
        EcpContractOperateRspBO rspBO = new EcpContractOperateRspBO();
        EcpContractPO ecpContractPO = (EcpContractPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), EcpContractPO.class);
        ecpContractPO.setScopeCodes(null);
        ecpContractPO.setUpdateTime(new Date());
        Calendar calendar = Calendar.getInstance();
        if (ecpContractPO.getEffDate() != null) {
            calendar.setTime(ecpContractPO.getEffDate());
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            ecpContractPO.setEffDate(calendar.getTime());
        }
        if (ecpContractPO.getExpDate() != null) {
            calendar.setTime(ecpContractPO.getExpDate());
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            ecpContractPO.setExpDate(calendar.getTime());
        }
        List ecpContractScopePOList = null;
        if (!CollectionUtils.isEmpty((Collection)reqBO.getScopeCodeBoList())) {
            ecpContractScopePOList = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getScopeCodeBoList()), EcpContractScopePO.class);
            for (EcpContractScopePO ecpContractScopePO : ecpContractScopePOList) {
                ecpContractScopePO.setEcpContractId(reqBO.getEcpContractId());
            }
        }
        List ecpContractItemPos = null;
        Date now = new Date();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getItemList())) {
            ecpContractItemPos = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getItemList()), EcpContractItemPO.class);
            ecpContractItemPos.forEach(po -> po.setPushTime(now));
        }
        if ((checkEcpContractPO = this.ecpContractMapper.selectByContractId(reqBO.getEcpContractId())) != null) {
            if (!CollectionUtils.isEmpty((Collection)ecpContractScopePOList)) {
                this.ecpContractScopeMapper.deleteByContractId(reqBO.getEcpContractId());
                this.ecpContractScopeMapper.insertBatch(ecpContractScopePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)ecpContractItemPos)) {
                EcpContractItemPO ecpContractItemPo = new EcpContractItemPO();
                ecpContractItemPo.setEcpContractId(reqBO.getEcpContractId());
                this.ecpContractItemMapper.deleteBy(ecpContractItemPo);
                this.ecpContractItemMapper.insertBatch(ecpContractItemPos);
            }
            if ((result = this.ecpContractMapper.updateByPrimaryKeySelective(ecpContractPO)) < 0) {
                throw new RuntimeException("\u66f4\u65b0ECP\u5408\u540c\u5931\u8d25!");
            }
            this.saveLog(ecpContractPO, ecpContractScopePOList, ecpContractItemPos);
        } else {
            result = this.ecpContractMapper.insert(ecpContractPO);
            if (result < 0) {
                throw new RuntimeException("\u65b0\u589eECP\u5408\u540c\u5931\u8d25!");
            }
            if (!CollectionUtils.isEmpty((Collection)ecpContractScopePOList)) {
                this.ecpContractScopeMapper.insertBatch(ecpContractScopePOList);
            }
            if (!CollectionUtils.isEmpty((Collection)ecpContractItemPos)) {
                this.ecpContractItemMapper.insertBatch(ecpContractItemPos);
            }
            this.saveLog(ecpContractPO, ecpContractScopePOList, ecpContractItemPos);
        }
        ExtSyncContractReqBO extSyncContractReqBO = (ExtSyncContractReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ExtSyncContractReqBO.class);
        extSyncContractReqBO.setContractId(reqBO.getEcpContractId());
        extSyncContractReqBO.setRelSystem(AgrEnum.RelSystem.ECP.toString());
        ExtSyncContractRspBO extSyncContractRspBO = this.extSyncContractService.syncContract(extSyncContractReqBO);
        if (StringUtils.hasText((String)reqBO.getEcpContractId())) {
            AgreementPO agreementPO = new AgreementPO();
            agreementPO.setEcpContractId(reqBO.getEcpContractId());
            agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            List<AgreementPO> agreementPOS = this.agreementMapper.getList(agreementPO);
            if (!CollectionUtils.isEmpty(agreementPOS)) {
                agreementPO.setAgreementVariety(ecpContractPO.getPurchaseType());
                if (ecpContractPO.getCenterPurchaseType() != null) {
                    agreementPO.setEcpPurType(ecpContractPO.getCenterPurchaseType().toString());
                }
                agreementPO.setAgreementName(ecpContractPO.getContractName());
                agreementPO.setSignTime(ecpContractPO.getSginTime());
                agreementPO.setExtField2(ecpContractPO.getContractCode());
                agreementPO.setEcpContractId(reqBO.getEcpContractId());
                agreementPO.setExtContractId(reqBO.getEcpContractId());
                agreementPO.setExtContractCode(reqBO.getContractCode());
                agreementPO.setEcpProjectId(reqBO.getEcpProjectId());
                agreementPO.setPurImpUnitOrgId(reqBO.getPurImpUnitOrgId());
                agreementPO.setPurImpUnitOrgName(reqBO.getPurImpUnitOrgName());
                agreementPO.setVendorName(reqBO.getVendorName());
                if (reqBO.getIsOnlineContract() != null) {
                    agreementPO.setEcpIsOnlineContract(Byte.valueOf(reqBO.getIsOnlineContract().toString()));
                }
                if (reqBO.getIsElePurchase() != null) {
                    agreementPO.setEcpProcurement(Byte.valueOf(reqBO.getIsElePurchase().toString()));
                }
                if (reqBO.getVendorSource() != null) {
                    agreementPO.setEcpVendorSource(reqBO.getVendorSource().toString());
                }
                if (reqBO.getContractType() != null) {
                    agreementPO.setEcpContractType(reqBO.getContractType().toString());
                }
                if (reqBO.getPurchaseWay() != null) {
                    agreementPO.setExtField1(reqBO.getPurchaseWay().toString());
                }
                if (reqBO.getEcpProjectCode() != null && reqBO.getEcpProjectName() != null) {
                    agreementPO.setEcpProjectName(reqBO.getEcpProjectCode() + "-" + reqBO.getEcpProjectName());
                }
                for (AgreementPO agreementPO1 : agreementPOS) {
                    agreementPO.setAgreementId(agreementPO1.getAgreementId());
                    this.agreementMapper.updateByCondition(agreementPO);
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveLog(EcpContractPO ecpContractPO, List<EcpContractScopePO> ecpContractScopePOList, List<EcpContractItemPO> ecpContractItemPos) {
        EcpContractLogPO ecpContractLogPO = (EcpContractLogPO)JSON.parseObject((String)JSON.toJSONString((Object)ecpContractPO), EcpContractLogPO.class);
        ecpContractLogPO.setLogId(Sequence.getInstance().nextId());
        Date logTime = new Date();
        ecpContractLogPO.setUpdateTime(logTime);
        this.ecpContractLogMapper.insert(ecpContractLogPO);
        if (!CollectionUtils.isEmpty(ecpContractScopePOList)) {
            List ecpContractScopeLogPOS = JSON.parseArray((String)JSON.toJSONString(ecpContractScopePOList), EcpContractScopeLogPO.class);
            ecpContractScopeLogPOS.forEach(ecpContractScopeLogPO -> ecpContractScopeLogPO.setLogId(ecpContractLogPO.getLogId()));
            this.ecpContractScopeLogMapper.insertBatch(ecpContractScopeLogPOS);
        }
        if (!CollectionUtils.isEmpty(ecpContractItemPos)) {
            List ecpContractItemLogPos = JSON.parseArray((String)JSON.toJSONString(ecpContractItemPos), EcpContractItemLogPO.class);
            ecpContractItemLogPos.forEach(po -> {
                po.setLogTime(logTime);
                po.setLogId(Sequence.getInstance().nextId());
            });
            this.ecpContractItemLogMapper.insertBatch(ecpContractItemLogPos);
        }
    }
}

