/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementScopeSyncQueueReqBO;
import com.tydic.agreement.ability.bo.AgrOpsContractInstallmentPaymentBO;
import com.tydic.agreement.ability.bo.OpsContractBO;
import com.tydic.agreement.ability.bo.OpsContractItemBO;
import com.tydic.agreement.ability.bo.OpsContractScopeBO;
import com.tydic.agreement.ability.bo.OpsContractSyncAbilityReqBO;
import com.tydic.agreement.ability.bo.OpsContractSyncAbilityRspBO;
import com.tydic.agreement.atom.AgrAgreementStatusChangeAtomService;
import com.tydic.agreement.atom.AgrCreateCodeAtomService;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.AgrSyncSkuStatusToCommidityAtomService;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateCodeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateCodeAtomRspBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomReqBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomRspBO;
import com.tydic.agreement.busi.AgrAgreementScopeSyncQueueBusiService;
import com.tydic.agreement.busi.AgrOpsAutoCreateAgreementSubjectBusiService;
import com.tydic.agreement.busi.OpsContractSyncBusiService;
import com.tydic.agreement.busi.bo.AgrOpsAutoCreateAgreementSubjectBusiReqBO;
import com.tydic.agreement.busi.bo.AgrOpsAutoCreateAgreementSubjectBusiRspBO;
import com.tydic.agreement.common.bo.AgrMaterialSyncBO;
import com.tydic.agreement.common.bo.AgrPlaAgreementCodeBO;
import com.tydic.agreement.common.bo.AgrskuChangePriceBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgrAgreementBudgetAmtMapper;
import com.tydic.agreement.dao.AgrAgreementSkuMaterialMapper;
import com.tydic.agreement.dao.AgrAgreementSkuOldMaterialMapper;
import com.tydic.agreement.dao.AgrInstallmentPaymentMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.OpsContractInstallmentPaymentLogMapper;
import com.tydic.agreement.dao.OpsContractInstallmentPaymentMapper;
import com.tydic.agreement.dao.OpsContractItemLogMapper;
import com.tydic.agreement.dao.OpsContractItemMapper;
import com.tydic.agreement.dao.OpsContractLogMapper;
import com.tydic.agreement.dao.OpsContractMapper;
import com.tydic.agreement.dao.OpsContractScopeLogMapper;
import com.tydic.agreement.dao.OpsContractScopeMapper;
import com.tydic.agreement.dao.po.AgrInstallmentPaymentPO;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementScopePO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.agreement.dao.po.OpsContractInstallmentPaymentLogPO;
import com.tydic.agreement.dao.po.OpsContractInstallmentPaymentPO;
import com.tydic.agreement.dao.po.OpsContractItemLogPO;
import com.tydic.agreement.dao.po.OpsContractItemPO;
import com.tydic.agreement.dao.po.OpsContractLogPO;
import com.tydic.agreement.dao.po.OpsContractPO;
import com.tydic.agreement.dao.po.OpsContractScopeLogPO;
import com.tydic.agreement.dao.po.OpsContractScopePO;
import com.tydic.contract.api.ecp.ExtSyncContractBudgetAmtService;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleReqBO;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleRspBO;
import com.tydic.contract.api.maintenance.service.QryContractSupplierListSaleService;
import com.tydic.uccext.bo.CnncCatalogPathQryAbilityReqBo;
import com.tydic.uccext.bo.CnncCatalogPathQryAbilityRspBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityReqBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityRspBo;
import com.tydic.uccext.bo.CnncUccEMdmCatalogAllBO;
import com.tydic.uccext.bo.UccMaterialCommodityTypeBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialReqBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialRspBO;
import com.tydic.uccext.service.CnncCatalogPathQryAbilityService;
import com.tydic.uccext.service.CnncQryCommodityTypeListAbilityService;
import com.tydic.uccext.service.UccQryCommodityTypeByMaterialService;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgAbilityBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgQueryAbilityReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class OpsContractSyncBusiServiceImpl
implements OpsContractSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(OpsContractSyncBusiServiceImpl.class);
    @Autowired
    private OpsContractMapper opsContractMapper;
    @Autowired
    private OpsContractLogMapper opsContractLogMapper;
    @Autowired
    private OpsContractItemMapper opsContractItemMapper;
    @Autowired
    private OpsContractItemLogMapper opsContractItemLogMapper;
    @Autowired
    private OpsContractScopeMapper opsContractScopeMapper;
    @Autowired
    private OpsContractScopeLogMapper opsContractScopeLogMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgrInstallmentPaymentMapper agrInstallmentPaymentMapper;
    @Autowired
    private AgrAgreementBudgetAmtMapper agreementBudgetAmountMapper;
    @Autowired
    private AgrAgreementScopeSyncQueueBusiService agrAgreementScopeSyncQueueBusiService;
    @Autowired
    private AgrSyncSkuStatusToCommidityAtomService agrSyncSkuStatusToCommidityAtomService;
    @Autowired
    private AgrAgreementStatusChangeAtomService agrAgreementStatusChangeAtomService;
    @Autowired
    private UccQryCommodityTypeByMaterialService uccQryCommodityTypeByMaterialService;
    @Autowired
    private QryContractSupplierListSaleService qryContractSupplierListSaleService;
    @Autowired
    private CnncQryCommodityTypeListAbilityService cnncQryCommodityTypeListAbilityService;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private CnncCatalogPathQryAbilityService cnncCatalogPathQryAbilityService;
    @Autowired
    private AgrAgreementSkuOldMaterialMapper agrAgreementSkuOldMaterialMapper;
    @Autowired
    private AgrAgreementSkuMaterialMapper agrAgreementSkuMaterialMapper;
    @Autowired
    private OpsContractInstallmentPaymentMapper opsContractInstallmentPaymentMapper;
    @Autowired
    private OpsContractInstallmentPaymentLogMapper opsContractInstallmentPaymentLogMapper;
    @Autowired
    private AgrOpsAutoCreateAgreementSubjectBusiService agrOpsAutoCreateAgreementSubjectBusiService;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    private AgrCreateCodeAtomService agrCreateCodeAtomService;
    @Autowired
    private ExtSyncContractBudgetAmtService extSyncContractBudgetAmtService;

    @Override
    public OpsContractSyncAbilityRspBO syncOpsContract(OpsContractSyncAbilityReqBO reqBo) {
        OpsContractSyncAbilityRspBO rspBo = new OpsContractSyncAbilityRspBO();
        String datePattern = "yyyyMMdd";
        Calendar calendar = Calendar.getInstance();
        if (StringUtils.hasText((String)reqBo.getSignDate())) {
            Date parseSign = DateUtils.strToDate((String)reqBo.getSignDate(), (String)"yyyyMMdd");
            calendar.setTime(parseSign);
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            reqBo.setSignDateTrans(calendar.getTime());
        }
        if (StringUtils.hasText((String)reqBo.getEffDate())) {
            Date parseEff = DateUtils.strToDate((String)reqBo.getEffDate(), (String)"yyyyMMdd");
            calendar.setTime(parseEff);
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            reqBo.setEffDateTrans(calendar.getTime());
        }
        if (StringUtils.hasText((String)reqBo.getExpDate())) {
            Date parseExp = DateUtils.strToDate((String)reqBo.getExpDate(), (String)"yyyyMMdd");
            calendar.setTime(parseExp);
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            reqBo.setExpDateTrans(calendar.getTime());
        }
        String contractAmount = reqBo.getContractAmount();
        reqBo.setContractAmount(reqBo.getAgreementTentativeAmount());
        reqBo.setAgreementTentativeAmount(contractAmount);
        Date now = new Date();
        this.saveLog(reqBo, now);
        boolean containsFlag = Arrays.asList(AgrEnum.OpsCenterPurchaseType.EJJC.getCode(), AgrEnum.OpsCenterPurchaseType.FJZCG.getCode()).contains(reqBo.getCenterPurchaseType());
        AgrOpsAutoCreateAgreementSubjectBusiReqBO agrOpsAutoCreateAgreementSubjectBusiReqBO = new AgrOpsAutoCreateAgreementSubjectBusiReqBO();
        if (AgrEnum.OpsSyncOperType.oper_create.getType().equals(reqBo.getReqOperType())) {
            this.saveContract(reqBo, now, agrOpsAutoCreateAgreementSubjectBusiReqBO, containsFlag);
            this.autoCreatAgreement(reqBo, rspBo, agrOpsAutoCreateAgreementSubjectBusiReqBO, containsFlag, true);
        } else if (AgrEnum.OpsSyncOperType.oper_modify.getType().equals(reqBo.getReqOperType())) {
            AgreementPO po = new AgreementPO();
            po.setExtField2(reqBo.getContractCode());
            po.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            List<AgreementPO> agreementPOS = this.agreementMapper.getList(po);
            boolean agrCreatedFlag = CollectionUtils.isEmpty(agreementPOS);
            OpsContractItemPO contractItemPo = new OpsContractItemPO();
            contractItemPo.setContractCode(reqBo.getContractCode());
            List<OpsContractItemPO> contractItemList = this.opsContractItemMapper.getList(contractItemPo);
            this.modifyContract(reqBo, now, agrOpsAutoCreateAgreementSubjectBusiReqBO, containsFlag);
            if (agrCreatedFlag) {
                this.autoCreatAgreement(reqBo, rspBo, agrOpsAutoCreateAgreementSubjectBusiReqBO, containsFlag, agrCreatedFlag);
            }
            this.modifyAgreement(reqBo, now, contractItemList, rspBo);
        } else {
            throw new BusinessException("8888", "\u672a\u77e5\u7684\u8bf7\u6c42\u64cd\u4f5c\u7c7b\u578b");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void autoCreatAgreement(OpsContractSyncAbilityReqBO reqBo, OpsContractSyncAbilityRspBO rspBo, AgrOpsAutoCreateAgreementSubjectBusiReqBO agrOpsAutoCreateAgreementSubjectBusiReqBO, boolean containsFlag, boolean agrCreatedFlag) {
        if (containsFlag) {
            agrOpsAutoCreateAgreementSubjectBusiReqBO.setContractId(reqBo.getContractId());
            agrOpsAutoCreateAgreementSubjectBusiReqBO.setContractCode(reqBo.getContractCode());
            agrOpsAutoCreateAgreementSubjectBusiReqBO.setAutoCreateFlag(Boolean.valueOf(true));
            AgrOpsAutoCreateAgreementSubjectBusiRspBO busiRspBO = this.agrOpsAutoCreateAgreementSubjectBusiService.opsAutoCreateAgreementSubjectInfo(agrOpsAutoCreateAgreementSubjectBusiReqBO);
            if (!"0000".equals(busiRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u81ea\u52a8\u751f\u6210\u6846\u67b6\u534f\u8bae\u5931\u8d25\uff0c" + busiRspBO.getRespDesc());
            }
            rspBo.setAgreementId(busiRspBO.getAgreementId());
        }
    }

    private void saveLog(OpsContractSyncAbilityReqBO reqBo, Date now) {
        OpsContractLogPO contractLogPo = new OpsContractLogPO();
        contractLogPo.setLogId(Sequence.getInstance().nextId());
        contractLogPo.setReqOperType(reqBo.getReqOperType());
        contractLogPo.setContractCode(reqBo.getContractCode());
        contractLogPo.setContractId(reqBo.getContractId());
        contractLogPo.setContractName(reqBo.getContractName());
        contractLogPo.setContractVersion(reqBo.getContractVersion());
        contractLogPo.setPlanType(reqBo.getPlanType());
        contractLogPo.setCustomerContractCode(reqBo.getCustomerContractCode());
        contractLogPo.setIsOnlineContract(reqBo.getIsOnlineContract());
        contractLogPo.setContractType(AgrEnum.OpsContractType.getCode((String)reqBo.getContractType()));
        contractLogPo.setPurchaseType(reqBo.getPurchaseType());
        contractLogPo.setCenterPurchaseType(reqBo.getCenterPurchaseType());
        if (StringUtils.hasText((String)reqBo.getPurchaseWay())) {
            contractLogPo.setPurchaseWay(AgrEnum.OpsPurchaseWay.getCode((String)reqBo.getPurchaseWay()));
        }
        contractLogPo.setVendorSource(reqBo.getVendorSource());
        contractLogPo.setVendorCode(reqBo.getVendorCode());
        contractLogPo.setVendorId(reqBo.getVendorId());
        contractLogPo.setVendorName(reqBo.getVendorName());
        contractLogPo.setSignDate(reqBo.getSignDate());
        contractLogPo.setEffDate(reqBo.getEffDate());
        contractLogPo.setExpDate(reqBo.getExpDate());
        contractLogPo.setPackCode(reqBo.getPackCode());
        contractLogPo.setPackName(reqBo.getPackName());
        contractLogPo.setIsElePurchase(reqBo.getIsElePurchase());
        contractLogPo.setContractAmount(reqBo.getContractAmount());
        contractLogPo.setAgreementTentativeAmount(reqBo.getAgreementTentativeAmount());
        contractLogPo.setBudgetAmt(reqBo.getBudgetAmt());
        contractLogPo.setCreator(reqBo.getCreator());
        contractLogPo.setCreatorOrgCode(reqBo.getCreatorOrgCode());
        contractLogPo.setCreatorOrgId(reqBo.getCreatorOrgId());
        contractLogPo.setCreatorOrgName(reqBo.getCreatorOrgName());
        if (StringUtils.hasText((String)reqBo.getScopeType())) {
            contractLogPo.setScopeType(AgrEnum.OpsScopeType.getByCode((String)reqBo.getScopeType()).getScopeTypeCode());
        }
        contractLogPo.setPushTime(now);
        contractLogPo.setLogTime(now);
        contractLogPo.setContractSigningAmount(reqBo.getContractSigningAmount());
        contractLogPo.setCurrencyCode(reqBo.getCurrencyCode());
        contractLogPo.setInternalProcurementType(reqBo.getInternalProcurementType());
        contractLogPo.setProjectImportance(reqBo.getProjectImportance());
        contractLogPo.setBidSectionCode(reqBo.getBidSectionCode());
        contractLogPo.setIsConstructionProject(reqBo.getIsConstructionProject());
        contractLogPo.setIsEleProductsBidding(reqBo.getIsEleProductsBidding());
        contractLogPo.setIsIndustryRegulation(reqBo.getIsIndustryRegulation());
        contractLogPo.setIsRegulatoryDepartment(reqBo.getIsRegulatoryDepartment());
        contractLogPo.setIsUrgentProcurement(reqBo.getIsUrgentProcurement());
        contractLogPo.setIsProcurementCatalog(reqBo.getIsProcurementCatalog());
        contractLogPo.setIsContractBudget(reqBo.getIsContractBudget());
        contractLogPo.setIsMajorContracts(reqBo.getIsMajorContracts());
        if (StringUtils.hasText((String)reqBo.getPayMethod())) {
            contractLogPo.setPayMethod(AgrEnum.OpsPayMethod.getCode((String)reqBo.getPayMethod()));
        }
        if (StringUtils.hasText((String)reqBo.getPayMethod())) {
            contractLogPo.setPaymentMethod(AgrEnum.OpsPaymentMethod.getCode((String)reqBo.getPaymentMethod()));
        }
        contractLogPo.setPaymentDays(reqBo.getPaymentDays());
        contractLogPo.setContractStatus(reqBo.getContractStatus());
        contractLogPo.setPerformanceMethod(reqBo.getPerformanceMethod());
        contractLogPo.setPerformanceLocation(reqBo.getPerformanceLocation());
        contractLogPo.setSigningMethod(reqBo.getSigningMethod());
        contractLogPo.setSupplierName(reqBo.getSupplierName());
        contractLogPo.setSupplierPhone(reqBo.getSupplierPhone());
        contractLogPo.setAdjustPrice(reqBo.getAdjustPrice());
        contractLogPo.setPurImpUnitOrgId(reqBo.getPurImpUnitOrgId());
        contractLogPo.setPurImpUnitOrgName(reqBo.getPurImpUnitOrgName());
        contractLogPo.setContractualRelationship(reqBo.getContractualRelationship());
        this.opsContractLogMapper.insert(contractLogPo);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getItemList())) {
            ArrayList<OpsContractItemLogPO> contractItemLogPos = new ArrayList<OpsContractItemLogPO>();
            reqBo.getItemList().forEach(item -> {
                OpsContractItemLogPO contractItemLogPo = new OpsContractItemLogPO();
                contractItemLogPo.setLogId(Sequence.getInstance().nextId());
                contractItemLogPo.setContractCode(reqBo.getContractCode());
                contractItemLogPo.setContractId(reqBo.getContractId());
                contractItemLogPo.setContractVersion(reqBo.getContractVersion());
                contractItemLogPo.setContractItemCode(item.getContractItemCode());
                contractItemLogPo.setContractItemId(item.getContractItemId());
                contractItemLogPo.setItemName(item.getItemName());
                contractItemLogPo.setPurchaseType(item.getPurchaseType());
                contractItemLogPo.setPurchaseSubType(item.getPurchaseSubType());
                contractItemLogPo.setCatalogCode(item.getCatalogCode());
                contractItemLogPo.setMaterialCode(item.getMaterialCode());
                contractItemLogPo.setScMaterialCode(item.getScMaterialCode());
                contractItemLogPo.setScMaterialName(item.getScMaterialName());
                contractItemLogPo.setMeasureName(item.getMeasureName());
                contractItemLogPo.setTaxRate(item.getTaxRate());
                contractItemLogPo.setBuyNumber(item.getBuyNumber());
                contractItemLogPo.setBuyPrice(item.getBuyPrice());
                contractItemLogPo.setTotalPrice(item.getTotalPrice());
                contractItemLogPo.setProducingArea(item.getProducingArea());
                contractItemLogPo.setComments(item.getComments());
                contractItemLogPo.setBrand(item.getBrand());
                contractItemLogPo.setSpecModel(item.getSpecModel());
                contractItemLogPo.setManufacturer(item.getManufacturer());
                contractItemLogPo.setManufacturerAddress(item.getManufacturerAddress());
                contractItemLogPo.setWarrantyLevel(item.getWarrantyLevel());
                contractItemLogPo.setNuclearSafetyLevel(item.getNuclearSafetyLevel());
                contractItemLogPo.setSupplyCycle(Integer.valueOf(item.getSupplyCycle()));
                contractItemLogPo.setPushTime(now);
                contractItemLogPo.setLogTime(now);
                contractItemLogPo.setCurrency(item.getCurrency());
                contractItemLogPo.setWarantty(Integer.valueOf(item.getWarantty()));
                contractItemLogPo.setDifferencesAcceptance(item.getDifferencesAcceptance());
                if (StringUtils.hasText((String)item.getAcceptanceScale())) {
                    contractItemLogPo.setAcceptanceScale(new BigDecimal(item.getAcceptanceScale()));
                }
                contractItemLogPo.setConstructionProjectCode(item.getConstructionProjectCode());
                contractItemLogPo.setConstructionProjectName(item.getConstructionProjectName());
                contractItemLogPos.add(contractItemLogPo);
            });
            this.opsContractItemLogMapper.insertBatch(contractItemLogPos);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getScopeList())) {
            ArrayList<OpsContractScopeLogPO> contractScopeLogPos = new ArrayList<OpsContractScopeLogPO>();
            reqBo.getScopeList().forEach(scope -> {
                OpsContractScopeLogPO contractScopeLogPo = new OpsContractScopeLogPO();
                contractScopeLogPo.setLogId(Sequence.getInstance().nextId());
                contractScopeLogPo.setContractCode(reqBo.getContractCode());
                contractScopeLogPo.setContractId(reqBo.getContractId());
                contractScopeLogPo.setContractVersion(reqBo.getContractVersion());
                contractScopeLogPo.setOrgCode(scope.getOrgCode());
                contractScopeLogPo.setOrgId(scope.getOrgId());
                contractScopeLogPo.setOrgName(scope.getOrgName());
                contractScopeLogPo.setPushTime(now);
                contractScopeLogPo.setLogTime(now);
                contractScopeLogPos.add(contractScopeLogPo);
            });
            this.opsContractScopeLogMapper.insertBatch(contractScopeLogPos);
        }
    }

    private void saveContract(OpsContractSyncAbilityReqBO reqBo, Date now, AgrOpsAutoCreateAgreementSubjectBusiReqBO agrOpsAutoCreateAgreementSubjectBusiReqBO, boolean containsFlag) {
        AgrEnum.OpsScopeType opsScopeType;
        OpsContractPO contractPo = new OpsContractPO();
        contractPo.setContractCode(reqBo.getContractCode());
        contractPo.setContractId(reqBo.getContractId());
        contractPo.setContractName(reqBo.getContractName());
        contractPo.setContractVersion(reqBo.getContractVersion());
        contractPo.setPlanType(reqBo.getPlanType());
        contractPo.setCustomerContractCode(reqBo.getCustomerContractCode());
        contractPo.setIsOnlineContract(reqBo.getIsOnlineContract());
        contractPo.setContractType(AgrEnum.OpsContractType.getCode((String)reqBo.getContractType()));
        contractPo.setPurchaseType(reqBo.getPurchaseType());
        contractPo.setCenterPurchaseType(reqBo.getCenterPurchaseType());
        if (StringUtils.hasText((String)reqBo.getPurchaseWay())) {
            contractPo.setPurchaseWay(AgrEnum.OpsPurchaseWay.getCode((String)reqBo.getPurchaseWay()));
        }
        contractPo.setVendorSource(reqBo.getVendorSource());
        contractPo.setVendorCode(reqBo.getVendorCode());
        contractPo.setVendorId(reqBo.getVendorId());
        contractPo.setVendorName(reqBo.getVendorName());
        contractPo.setSignDate(reqBo.getSignDate());
        contractPo.setEffDate(reqBo.getEffDate());
        contractPo.setExpDate(reqBo.getExpDate());
        contractPo.setPackCode(reqBo.getPackCode());
        contractPo.setPackName(reqBo.getPackName());
        contractPo.setIsElePurchase(reqBo.getIsElePurchase());
        contractPo.setContractAmount(reqBo.getContractAmount());
        contractPo.setAgreementTentativeAmount(reqBo.getAgreementTentativeAmount());
        contractPo.setBudgetAmt(reqBo.getBudgetAmt());
        contractPo.setCreator(reqBo.getCreator());
        contractPo.setCreatorOrgCode(reqBo.getCreatorOrgCode());
        contractPo.setCreatorOrgId(reqBo.getCreatorOrgId());
        contractPo.setCreatorOrgName(reqBo.getCreatorOrgName());
        if (StringUtils.hasText((String)reqBo.getScopeType()) && (opsScopeType = AgrEnum.OpsScopeType.getByCode((String)reqBo.getScopeType())) != null) {
            contractPo.setScopeType(opsScopeType.getScopeTypeCode());
        }
        contractPo.setPushTime(now);
        contractPo.setContractSigningAmount(reqBo.getContractSigningAmount());
        contractPo.setCurrencyCode(reqBo.getCurrencyCode());
        contractPo.setInternalProcurementType(reqBo.getInternalProcurementType());
        contractPo.setProjectImportance(reqBo.getProjectImportance());
        contractPo.setBidSectionCode(reqBo.getBidSectionCode());
        contractPo.setIsConstructionProject(reqBo.getIsConstructionProject());
        contractPo.setIsEleProductsBidding(reqBo.getIsEleProductsBidding());
        contractPo.setIsIndustryRegulation(reqBo.getIsIndustryRegulation());
        contractPo.setIsRegulatoryDepartment(reqBo.getIsRegulatoryDepartment());
        contractPo.setIsUrgentProcurement(reqBo.getIsUrgentProcurement());
        contractPo.setIsProcurementCatalog(reqBo.getIsProcurementCatalog());
        contractPo.setIsContractBudget(reqBo.getIsContractBudget());
        contractPo.setIsMajorContracts(reqBo.getIsMajorContracts());
        if (StringUtils.hasText((String)reqBo.getPayMethod())) {
            contractPo.setPayMethod(AgrEnum.OpsPayMethod.getCode((String)reqBo.getPayMethod()));
        }
        if (StringUtils.hasText((String)reqBo.getPaymentMethod())) {
            contractPo.setPaymentMethod(AgrEnum.OpsPaymentMethod.getCode((String)reqBo.getPaymentMethod()));
        }
        contractPo.setPaymentDays(reqBo.getPaymentDays());
        contractPo.setContractStatus(reqBo.getContractStatus());
        contractPo.setPerformanceMethod(reqBo.getPerformanceMethod());
        contractPo.setPerformanceLocation(reqBo.getPerformanceLocation());
        contractPo.setSigningMethod(reqBo.getSigningMethod());
        contractPo.setSupplierName(reqBo.getSupplierName());
        contractPo.setSupplierPhone(reqBo.getSupplierPhone());
        contractPo.setAdjustPrice(reqBo.getAdjustPrice());
        contractPo.setPurImpUnitOrgId(reqBo.getPurImpUnitOrgId());
        contractPo.setPurImpUnitOrgName(reqBo.getPurImpUnitOrgName());
        contractPo.setContractualRelationship(reqBo.getContractualRelationship());
        this.opsContractMapper.insert(contractPo);
        if (containsFlag) {
            OpsContractBO opsContractBO = new OpsContractBO();
            BeanUtils.copyProperties((Object)contractPo, (Object)opsContractBO);
            opsContractBO.setVendorOrgCode(reqBo.getVendorOrgCode());
            agrOpsAutoCreateAgreementSubjectBusiReqBO.setContractBO(opsContractBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getItemList())) {
            ArrayList<OpsContractItemPO> contractItemPos = new ArrayList<OpsContractItemPO>();
            reqBo.getItemList().forEach(item -> {
                OpsContractItemPO contractItemPo = new OpsContractItemPO();
                contractItemPo.setContractCode(reqBo.getContractCode());
                contractItemPo.setContractId(reqBo.getContractId());
                contractItemPo.setContractVersion(reqBo.getContractVersion());
                contractItemPo.setContractItemCode(item.getContractItemCode());
                contractItemPo.setContractItemId(item.getContractItemId());
                contractItemPo.setItemName(item.getItemName());
                contractItemPo.setPurchaseType(item.getPurchaseType());
                contractItemPo.setPurchaseSubType(item.getPurchaseSubType());
                contractItemPo.setCatalogCode(item.getCatalogCode());
                contractItemPo.setMaterialCode(item.getMaterialCode());
                contractItemPo.setScMaterialCode(item.getScMaterialCode());
                contractItemPo.setScMaterialName(item.getScMaterialName());
                contractItemPo.setMeasureName(item.getMeasureName());
                contractItemPo.setTaxRate(item.getTaxRate());
                contractItemPo.setBuyNumber(item.getBuyNumber());
                contractItemPo.setBuyPrice(item.getBuyPrice());
                contractItemPo.setTotalPrice(item.getTotalPrice());
                contractItemPo.setProducingArea(item.getProducingArea());
                contractItemPo.setComments(item.getComments());
                contractItemPo.setBrand(item.getBrand());
                contractItemPo.setSpecModel(item.getSpecModel());
                contractItemPo.setManufacturer(item.getManufacturer());
                contractItemPo.setManufacturerAddress(item.getManufacturerAddress());
                contractItemPo.setWarrantyLevel(item.getWarrantyLevel());
                contractItemPo.setNuclearSafetyLevel(item.getNuclearSafetyLevel());
                contractItemPo.setSupplyCycle(Integer.valueOf(item.getSupplyCycle()));
                contractItemPo.setPushTime(now);
                contractItemPo.setCurrency(item.getCurrency());
                contractItemPo.setWarantty(Integer.valueOf(item.getWarantty()));
                contractItemPo.setDifferencesAcceptance(item.getDifferencesAcceptance());
                if (StringUtils.hasText((String)item.getAcceptanceScale())) {
                    contractItemPo.setAcceptanceScale(new BigDecimal(item.getAcceptanceScale()));
                }
                contractItemPo.setConstructionProjectCode(item.getConstructionProjectCode());
                contractItemPo.setConstructionProjectName(item.getConstructionProjectName());
                contractItemPos.add(contractItemPo);
            });
            this.opsContractItemMapper.insertBatch(contractItemPos);
            if (containsFlag) {
                agrOpsAutoCreateAgreementSubjectBusiReqBO.setOpsContractItemBOS(JSONObject.parseArray((String)JSON.toJSONString(contractItemPos), OpsContractItemBO.class));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getScopeList())) {
            ArrayList<OpsContractScopePO> contractScopePos = new ArrayList<OpsContractScopePO>();
            reqBo.getScopeList().forEach(scope -> {
                OpsContractScopePO contractScopePo = new OpsContractScopePO();
                contractScopePo.setScopeId(Sequence.getInstance().nextId());
                contractScopePo.setContractCode(reqBo.getContractCode());
                contractScopePo.setContractId(reqBo.getContractId());
                contractScopePo.setContractVersion(reqBo.getContractVersion());
                contractScopePo.setOrgCode(scope.getOrgCode());
                contractScopePo.setOrgId(scope.getOrgId());
                contractScopePo.setOrgName(scope.getOrgName());
                contractScopePo.setPushTime(now);
                contractScopePos.add(contractScopePo);
            });
            this.opsContractScopeMapper.insertBatch(contractScopePos);
            if (containsFlag) {
                agrOpsAutoCreateAgreementSubjectBusiReqBO.setOpsContractScopeBOS(JSONObject.parseArray((String)JSON.toJSONString(contractScopePos), OpsContractScopeBO.class));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPaymentList())) {
            ArrayList<OpsContractInstallmentPaymentPO> paymentPOS = new ArrayList<OpsContractInstallmentPaymentPO>();
            ArrayList<OpsContractInstallmentPaymentLogPO> paymentLogPOS = new ArrayList<OpsContractInstallmentPaymentLogPO>();
            Date date = new Date();
            reqBo.getPaymentList().forEach(payment -> {
                OpsContractInstallmentPaymentPO paymentPaymentPo = new OpsContractInstallmentPaymentPO();
                paymentPaymentPo.setId(Sequence.getInstance().nextId());
                paymentPaymentPo.setContractCode(reqBo.getContractCode());
                paymentPaymentPo.setPaymentName(payment.getPaymentName());
                paymentPaymentPo.setPaymentValue(payment.getPaymentValue());
                paymentPaymentPo.setPaymentPlause(payment.getPaymentClause());
                paymentPaymentPo.setOrdered(payment.getOrdered());
                paymentPOS.add(paymentPaymentPo);
                OpsContractInstallmentPaymentLogPO opsContractInstallmentPaymentLogPO = new OpsContractInstallmentPaymentLogPO();
                opsContractInstallmentPaymentLogPO.setLogId(Sequence.getInstance().nextId());
                opsContractInstallmentPaymentLogPO.setContractCode(reqBo.getContractId());
                opsContractInstallmentPaymentLogPO.setPaymentName(payment.getPaymentName());
                opsContractInstallmentPaymentLogPO.setPaymentValue(payment.getPaymentValue());
                opsContractInstallmentPaymentLogPO.setPaymentPlause(payment.getPaymentClause());
                opsContractInstallmentPaymentLogPO.setOrdered(payment.getOrdered());
                opsContractInstallmentPaymentLogPO.setPushTime(date);
                opsContractInstallmentPaymentLogPO.setLogTime(date);
                paymentLogPOS.add(opsContractInstallmentPaymentLogPO);
            });
            this.opsContractInstallmentPaymentMapper.insertBatch(paymentPOS);
            this.opsContractInstallmentPaymentLogMapper.insertBatch(paymentLogPOS);
            if (containsFlag) {
                agrOpsAutoCreateAgreementSubjectBusiReqBO.setPaymentPOS(JSONObject.parseArray((String)JSON.toJSONString(paymentPOS), AgrOpsContractInstallmentPaymentBO.class));
            }
        }
    }

    private void modifyContract(OpsContractSyncAbilityReqBO reqBo, Date now, AgrOpsAutoCreateAgreementSubjectBusiReqBO agrOpsAutoCreateAgreementSubjectBusiReqBO, boolean containsFlag) {
        OpsContractPO contractPo = new OpsContractPO();
        contractPo.setContractCode(reqBo.getContractCode());
        this.opsContractMapper.deleteBy(contractPo);
        OpsContractItemPO contractItemPo = new OpsContractItemPO();
        contractItemPo.setContractCode(reqBo.getContractCode());
        this.opsContractItemMapper.deleteBy(contractItemPo);
        OpsContractScopePO contractScopePo = new OpsContractScopePO();
        contractScopePo.setContractCode(reqBo.getContractCode());
        this.opsContractScopeMapper.deleteBy(contractScopePo);
        OpsContractInstallmentPaymentPO opsContractInstallmentPaymentPO = new OpsContractInstallmentPaymentPO();
        opsContractInstallmentPaymentPO.setContractCode(reqBo.getContractCode());
        this.opsContractInstallmentPaymentMapper.deleteBy(opsContractInstallmentPaymentPO);
        this.saveContract(reqBo, now, agrOpsAutoCreateAgreementSubjectBusiReqBO, containsFlag);
    }

    private void modifyAgreement(OpsContractSyncAbilityReqBO reqBo, Date now, List<OpsContractItemPO> originItemList, OpsContractSyncAbilityRspBO rspBo) {
        AgreementPO agreementPo = new AgreementPO();
        agreementPo.setExtContractCode(reqBo.getContractCode());
        agreementPo.setRelSystem(AgrEnum.RelSystem.OPS.toString());
        agreementPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> agreementPos = this.agreementMapper.getList(agreementPo);
        if (!CollectionUtils.isEmpty(agreementPos)) {
            List<Byte> agreementStatusList;
            AgrEnum.OpsScopeType scopeType;
            AgreementPO agreementPO = agreementPos.get(0);
            Byte agreementStatus = agreementPO.getAgreementStatus();
            List<Long> agreementIds = agreementPos.stream().map(AgreementPO::getAgreementId).collect(Collectors.toList());
            AgreementPO agreementPoUpdate = new AgreementPO();
            agreementPoUpdate.setAgreementIds(agreementIds);
            agreementPoUpdate.setAgreementName(reqBo.getContractName());
            agreementPoUpdate.setEntAgreementCode(reqBo.getCustomerContractCode());
            if (reqBo.getEffDateTrans() != null) {
                agreementPoUpdate.setEffDate(reqBo.getEffDateTrans());
            }
            if (reqBo.getExpDateTrans() != null) {
                agreementPoUpdate.setExpDate(reqBo.getExpDateTrans());
            }
            agreementPoUpdate.setAgreementVariety(Byte.valueOf(reqBo.getPurchaseType()));
            agreementPoUpdate.setSignTime(reqBo.getSignDateTrans());
            agreementPoUpdate.setUpdateLoginId(0L);
            agreementPoUpdate.setUpdateName("ops");
            agreementPoUpdate.setUpdateTime(now);
            agreementPoUpdate.setExtField1(AgrEnum.OpsPurchaseWay.getCode((String)reqBo.getPurchaseWay()));
            agreementPoUpdate.setAgreementTentativeAmount(new BigDecimal(reqBo.getContractAmount()));
            agreementPoUpdate.setBudgetAmt(reqBo.getBudgetAmt());
            agreementPoUpdate.setEcpContractType(AgrEnum.OpsContractType.getCode((String)reqBo.getContractType()));
            agreementPoUpdate.setEcpIsOnlineContract(Byte.valueOf(reqBo.getIsOnlineContract()));
            agreementPoUpdate.setEcpVendorSource(reqBo.getVendorSource());
            agreementPoUpdate.setEcpProcurement(Byte.valueOf(reqBo.getIsElePurchase()));
            agreementPoUpdate.setExtContractId(reqBo.getContractId());
            agreementPoUpdate.setPlanType(reqBo.getPlanType());
            agreementPoUpdate.setExtContractStatus(reqBo.getContractStatus());
            agreementPoUpdate.setContractualRelationship(reqBo.getContractualRelationship());
            agreementPoUpdate.setIsConstructionProject(reqBo.getIsConstructionProject());
            if (StringUtils.hasText((String)reqBo.getScopeType())) {
                AgrEnum.OpsScopeType anEnumByCode = AgrEnum.OpsScopeType.getByCode((String)reqBo.getScopeType());
                if (anEnumByCode != null) {
                    agreementPoUpdate.setAgreementType(anEnumByCode.getAgreementType());
                }
            } else {
                agreementPoUpdate.setAgreementType(AgrCommConstant.agreementType.AREA_AGREEMENT);
            }
            agreementPoUpdate.setVendorContact(reqBo.getSupplierName());
            agreementPoUpdate.setVendorPhone(reqBo.getSupplierPhone());
            agreementPoUpdate.setVendorName(reqBo.getVendorName());
            agreementPoUpdate.setAdjustPrice(Byte.valueOf(reqBo.getAdjustPrice()));
            if (AgrEnum.OpsAdjustPrice.PRICE_ADJUSTMENT_IN_BUSINESS.getCode().equals(reqBo.getAdjustPrice())) {
                agreementPoUpdate.setAcceptHigher((int)AgrEnum.YesOrNo.YES.getCode());
            } else {
                agreementPoUpdate.setAcceptHigher((int)AgrEnum.YesOrNo.NO.getCode());
            }
            if (Arrays.asList(AgrEnum.EcpCenterPurchaseType.EJJC.getCode(), AgrEnum.EcpCenterPurchaseType.FJZCG.getCode()).contains(agreementPO.getEcpPurType())) {
                agreementPoUpdate.setApproveLower((int)AgrEnum.YesOrNo.NO.getCode());
            } else if (AgrEnum.EcpCenterPurchaseType.YIJI.getCode().equals(agreementPO.getEcpPurType())) {
                if (AgrEnum.OpsAdjustPrice.PRICE_ADJUSTMENT_IN_BUSINESS.getCode().equals(reqBo.getAdjustPrice())) {
                    agreementPoUpdate.setApproveLower((int)AgrEnum.YesOrNo.YES.getCode());
                } else {
                    agreementPoUpdate.setApproveLower((int)AgrEnum.YesOrNo.NO.getCode());
                }
            }
            if (StringUtils.hasText((String)reqBo.getPaymentDays())) {
                agreementPoUpdate.setPaymentDays(Integer.valueOf(reqBo.getPaymentDays()));
            }
            if (StringUtils.hasText((String)reqBo.getPayMethod())) {
                agreementPoUpdate.setPayMethod(Byte.valueOf(AgrEnum.OpsPayMethod.getCode((String)reqBo.getPayMethod())));
            }
            if (StringUtils.hasText((String)reqBo.getPaymentMethod())) {
                agreementPoUpdate.setPaymentMethod(Byte.valueOf(AgrEnum.OpsPaymentMethod.getCode((String)reqBo.getPaymentMethod())));
            }
            if (StringUtils.hasText((String)reqBo.getScopeType()) && (scopeType = AgrEnum.OpsScopeType.getByCode((String)reqBo.getScopeType())) != null) {
                agreementPoUpdate.setAgreementType(scopeType.getAgreementType());
                agreementPoUpdate.setScopeType(Byte.valueOf(scopeType.getScopeTypeCode()));
                if (AgrEnum.ExtScopeType.GROUP.getScopeTypeCode().equals(scopeType.getScopeTypeCode())) {
                    AgreementScopePO deleteScopePo = new AgreementScopePO();
                    deleteScopePo.setAgreementIds(agreementPos.stream().map(AgreementPO::getAgreementId).collect(Collectors.toSet()));
                    deleteScopePo.setVisible(0);
                    deleteScopePo.setIsDelete(AgrCommConstant.IsDelete.DELETED);
                    this.agreementScopeMapper.updateBy(deleteScopePo);
                    AgreementScopePO agreementScopePO = new AgreementScopePO();
                    agreementScopePO.setAgreementId(agreementPO.getAgreementId());
                    agreementScopePO.setAgreementVersion(agreementPO.getAgreementVersion());
                    agreementScopePO.setSupplierId(agreementPO.getSupplierId());
                    agreementScopePO.setScopeType(Byte.valueOf(AgrEnum.ExtScopeType.GROUP.getScopeTypeCode()));
                    agreementScopePO.setScopeCode(0L);
                    agreementScopePO.setScopeName("\u5168\u56fd");
                    agreementScopePO.setScopeMode(AgrEnum.ExtScopeType.GROUP.getScopeMode());
                    agreementScopePO.setVisible(AgrEnum.YesOrNo.NO.getCode().intValue());
                    agreementScopePO.setCreateLoginId(0L);
                    agreementScopePO.setCreateName("ops");
                    agreementScopePO.setCreateTime(now);
                    agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                    this.agreementScopeMapper.insert(agreementScopePO);
                }
                if (!agreementPoUpdate.getAgreementVariety().equals(agreementPO.getAgreementVariety()) || !agreementPoUpdate.getAgreementType().equals(agreementPO.getAgreementType())) {
                    UmcZhEnterpriseOrgAbilityBO enterpriseOrgAbilityBO = this.getUmcZhEnterpriseOrgAbilityBO(reqBo.getCreatorOrgId());
                    Map<String, String> agreementTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGREEMENT_TYPE_PCODE");
                    AgrPlaAgreementCodeBO agrPlaAgreementCodeBO = new AgrPlaAgreementCodeBO();
                    AgrCreateCodeAtomReqBO agrCreateCodeAtomReqBO = new AgrCreateCodeAtomReqBO();
                    agrPlaAgreementCodeBO.setAgreementVariety(AgrEnum.Variety.getDesc((Integer)Integer.parseInt(reqBo.getPurchaseType())));
                    agrPlaAgreementCodeBO.setAgreementType(AgrEnum.ExtScopeType.GROUP.getScopeTypeCode().equals(agreementPoUpdate.getScopeType()) ? agreementTypeStr.get("0") : agreementTypeStr.get("1"));
                    agrPlaAgreementCodeBO.setOrgShortName(enterpriseOrgAbilityBO.getCompanyNameAlias());
                    agrCreateCodeAtomReqBO.setCodeType(Byte.valueOf("1"));
                    agrCreateCodeAtomReqBO.setPlaAgreementCodeBO(agrPlaAgreementCodeBO);
                    AgrCreateCodeAtomRspBO createCodeAtomRspBO = this.agrCreateCodeAtomService.createCode(agrCreateCodeAtomReqBO);
                    if (!"0000".equals(createCodeAtomRspBO.getRespCode())) {
                        throw new BusinessException("8888", "\u7f16\u53f7\u751f\u6210\u5931\u8d25\uff0c" + createCodeAtomRspBO.getRespDesc());
                    }
                    AgreementPO checkAgreementPO = new AgreementPO();
                    checkAgreementPO.setPlaAgreementCode(createCodeAtomRspBO.getCode());
                    AgreementPO checkAgreement = this.agreementMapper.getModelBy(checkAgreementPO);
                    if (null != checkAgreement) {
                        throw new BusinessException("22053", "\u534f\u8bae\u7f16\u53f7\u3010" + checkAgreement.getPlaAgreementCode() + "\u3011\u5df2\u5b58\u5728\uff01");
                    }
                    agreementPoUpdate.setPlaAgreementCode(createCodeAtomRspBO.getCode());
                }
            }
            this.agreementMapper.updateByOpsSync(agreementPoUpdate);
            HashSet<Long> beOverdueAgrIds = new HashSet<Long>();
            HashSet<Long> beTerminationAgrIds = new HashSet<Long>();
            HashSet<Long> beSuspendAgrIds = new HashSet<Long>();
            HashSet<Long> beEnableAgrIds = new HashSet<Long>();
            agreementPos.forEach(agreement -> {
                if (AgrCommConstant.AgreementStatus.BE_OVERDUE.equals(agreement.getAgreementStatus())) {
                    Date effDate = agreement.getEffDate();
                    Date expDate = agreement.getExpDate();
                    if (reqBo.getEffDateTrans() != null) {
                        effDate = reqBo.getEffDateTrans();
                    }
                    if (reqBo.getExpDateTrans() != null) {
                        expDate = reqBo.getExpDateTrans();
                    }
                    if (effDate.before(now) && expDate.after(now)) {
                        beOverdueAgrIds.add(agreement.getAgreementId());
                    }
                }
                if (Arrays.asList("100", "110").contains(reqBo.getContractStatus())) {
                    beTerminationAgrIds.add(agreement.getAgreementId());
                }
                if ("120".equals(reqBo.getContractStatus())) {
                    beSuspendAgrIds.add(agreement.getAgreementId());
                }
                if ("80".equals(reqBo.getContractStatus()) && !AgrCommConstant.AgreementStatus.BE_OVERDUE.equals(agreement.getAgreementStatus())) {
                    beEnableAgrIds.add(agreement.getAgreementId());
                }
            });
            if (!CollectionUtils.isEmpty(beOverdueAgrIds)) {
                this.updateAgreementStatus(beOverdueAgrIds, AgrCommConstant.AgreementStatus.BE_OVERDUE, AgrCommConstant.AgreementStatus.ENABLE);
            }
            if (!(agreementStatusList = Arrays.asList(AgrCommConstant.AgreementStatus.DRAFT, AgrCommConstant.AgreementStatus.REJECT, AgrCommConstant.AgreementStatus.IN_AUDIT, AgrCommConstant.AgreementStatus.TO_CONFIRM)).contains(agreementStatus)) {
                if (!CollectionUtils.isEmpty(beTerminationAgrIds) && !agreementStatus.equals(AgrCommConstant.AgreementStatus.TERMINATION)) {
                    this.updateAgreementStatus(beTerminationAgrIds, agreementStatus, AgrCommConstant.AgreementStatus.TERMINATION);
                }
                if (!CollectionUtils.isEmpty(beSuspendAgrIds) && !agreementStatus.equals(AgrCommConstant.AgreementStatus.SUSPEND)) {
                    this.updateAgreementStatus(beSuspendAgrIds, agreementStatus, AgrCommConstant.AgreementStatus.SUSPEND);
                }
                if (!CollectionUtils.isEmpty(beEnableAgrIds) && !agreementStatus.equals(AgrCommConstant.AgreementStatus.ENABLE)) {
                    this.updateAgreementStatus(beEnableAgrIds, agreementStatus, AgrCommConstant.AgreementStatus.ENABLE);
                }
            }
            this.modifyItemAndScope(agreementPos, reqBo, now, originItemList, rspBo);
        }
    }

    private void updateAgreementStatus(Set<Long> agreementIds, Byte agreementStatusPre, Byte agreementStatusPost) {
        AgrAgreementStatusChangeAtomReqBO agrAgreementStatusChangeAtomReqBo = new AgrAgreementStatusChangeAtomReqBO();
        agrAgreementStatusChangeAtomReqBo.setAgreementIds(agreementIds);
        agrAgreementStatusChangeAtomReqBo.setAgreementStatusPre(agreementStatusPre);
        agrAgreementStatusChangeAtomReqBo.setAgreementStatusPost(agreementStatusPost);
        AgrAgreementStatusChangeAtomRspBO agrAgreementStatusChangeAtomRspBo = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(agrAgreementStatusChangeAtomReqBo);
        if (!"0000".equals(agrAgreementStatusChangeAtomRspBo.getRespCode())) {
            throw new BusinessException(agrAgreementStatusChangeAtomRspBo.getRespCode(), "\u5931\u6548\u534f\u8bae\u66f4\u65b0\u4e3a\u751f\u6548\u5931\u8d25." + agrAgreementStatusChangeAtomRspBo.getRespDesc());
        }
    }

    private void modifyItemAndScope(List<AgreementPO> agreementPos, OpsContractSyncAbilityReqBO reqBo, Date now, List<OpsContractItemPO> originItemList, OpsContractSyncAbilityRspBO rspBo) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getScopeList())) {
            String scopeType;
            Integer scopeMode;
            AgreementScopePO deleteScopePo = new AgreementScopePO();
            deleteScopePo.setAgreementIds(agreementPos.stream().map(AgreementPO::getAgreementId).collect(Collectors.toSet()));
            deleteScopePo.setIsDelete(AgrCommConstant.IsDelete.DELETED);
            deleteScopePo.setVisible(0);
            this.agreementScopeMapper.updateBy(deleteScopePo);
            AgrEnum.ExtScopeType scopeTypeEnum = AgrEnum.ExtScopeType.getByCode((String)reqBo.getScopeType());
            if (scopeTypeEnum != null) {
                scopeMode = scopeTypeEnum.getScopeMode();
                scopeType = scopeTypeEnum.getScopeTypeCode();
            } else {
                scopeType = AgrEnum.OpsScopeType.MEMBER.getScopeTypeCode();
                scopeMode = AgrCommConstant.ScopeMode.THIS_AND_ITS_DEPARTMENT;
            }
            agreementPos.forEach(agreement -> {
                ArrayList<AgreementScopePO> agreementScopePos = new ArrayList<AgreementScopePO>();
                reqBo.getScopeList().forEach(scope -> {
                    AgreementScopePO scopePo = new AgreementScopePO();
                    scopePo.setScopeId(Sequence.getInstance().nextId());
                    scopePo.setAgreementId(agreement.getAgreementId());
                    scopePo.setAgreementVersion(agreement.getAgreementVersion());
                    scopePo.setSupplierId(agreement.getSupplierId());
                    scopePo.setScopeType(Byte.valueOf(scopeType));
                    scopePo.setScopeCode(scope.getOrgId());
                    scopePo.setScopeName(scope.getOrgName());
                    scopePo.setScopeMode(scopeMode);
                    scopePo.setVisible((int)AgrEnum.YesOrNo.NO.getCode());
                    scopePo.setCreateLoginId(0L);
                    scopePo.setCreateName("ops");
                    scopePo.setCreateTime(now);
                    scopePo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                    agreementScopePos.add(scopePo);
                });
                if (!CollectionUtils.isEmpty(agreementScopePos)) {
                    this.agreementScopeMapper.insertBatch(agreementScopePos);
                }
            });
            AgrAgreementScopeSyncQueueReqBO agrAgreementScopeSyncQueueReqBo = new AgrAgreementScopeSyncQueueReqBO();
            agrAgreementScopeSyncQueueReqBo.setAgreementIds(agreementPos.stream().map(AgreementPO::getAgreementId).collect(Collectors.toList()));
            this.agrAgreementScopeSyncQueueBusiService.addScopeSyncQueue(agrAgreementScopeSyncQueueReqBo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getItemList())) {
            ArrayList insertItems = new ArrayList();
            ArrayList updateItems = new ArrayList();
            ArrayList deleteItems = new ArrayList();
            ArrayList contractItemPos = new ArrayList();
            reqBo.getItemList().forEach(item -> {
                OpsContractItemPO contractItemPo = new OpsContractItemPO();
                contractItemPo.setContractCode(reqBo.getContractCode());
                contractItemPo.setContractId(reqBo.getContractId());
                contractItemPo.setContractVersion(reqBo.getContractVersion());
                contractItemPo.setContractItemCode(item.getContractItemCode());
                contractItemPo.setContractItemId(item.getContractItemId());
                contractItemPo.setItemName(item.getItemName());
                contractItemPo.setPurchaseType(item.getPurchaseType());
                contractItemPo.setPurchaseSubType(item.getPurchaseSubType());
                contractItemPo.setCatalogCode(item.getCatalogCode());
                contractItemPo.setMaterialCode(item.getMaterialCode());
                contractItemPo.setScMaterialCode(item.getScMaterialCode());
                contractItemPo.setScMaterialName(item.getScMaterialName());
                contractItemPo.setMeasureName(item.getMeasureName());
                contractItemPo.setTaxRate(item.getTaxRate());
                contractItemPo.setBuyNumber(item.getBuyNumber());
                contractItemPo.setBuyPrice(item.getBuyPrice());
                contractItemPo.setTotalPrice(item.getTotalPrice());
                contractItemPo.setProducingArea(item.getProducingArea());
                contractItemPo.setComments(item.getComments());
                contractItemPo.setBrand(item.getBrand());
                contractItemPo.setSpecModel(item.getSpecModel());
                contractItemPo.setManufacturer(item.getManufacturer());
                contractItemPo.setManufacturerAddress(item.getManufacturerAddress());
                contractItemPo.setWarrantyLevel(item.getWarrantyLevel());
                contractItemPo.setNuclearSafetyLevel(item.getNuclearSafetyLevel());
                contractItemPo.setSupplyCycle(Integer.valueOf(item.getSupplyCycle()));
                contractItemPo.setCurrency(item.getCurrency());
                contractItemPo.setWarantty(Integer.valueOf(item.getWarantty()));
                contractItemPo.setDifferencesAcceptance(item.getDifferencesAcceptance());
                if (StringUtils.hasText((String)item.getAcceptanceScale())) {
                    contractItemPo.setAcceptanceScale(new BigDecimal(item.getAcceptanceScale()));
                }
                contractItemPo.setConstructionProjectCode(item.getConstructionProjectCode());
                contractItemPo.setConstructionProjectName(item.getConstructionProjectName());
                contractItemPo.setPushTime(now);
                contractItemPos.add(contractItemPo);
            });
            if (!CollectionUtils.isEmpty(originItemList)) {
                Map<String, OpsContractItemPO> exitsItemMap = originItemList.stream().collect(Collectors.toMap(OpsContractItemPO::getContractItemCode, obj -> obj, (a, b) -> a));
                contractItemPos.forEach(item -> {
                    if (exitsItemMap.containsKey(item.getContractItemCode())) {
                        updateItems.add(item);
                    } else {
                        insertItems.add(item);
                    }
                });
                exitsItemMap.keySet().forEach(itemCode -> {
                    if (!reqBo.getItemList().stream().map(OpsContractItemBO::getContractItemCode).collect(Collectors.toSet()).contains(itemCode)) {
                        deleteItems.add(exitsItemMap.get(itemCode));
                    }
                });
            } else {
                insertItems.addAll(contractItemPos);
            }
            if (!CollectionUtils.isEmpty(deleteItems)) {
                agreementPos.forEach(agreement -> {
                    AgreementSkuPO agreementSkuPo = new AgreementSkuPO();
                    agreementSkuPo.setAgreementId(agreement.getAgreementId());
                    agreementSkuPo.setExtItemCodeIn(deleteItems.stream().map(OpsContractItemPO::getContractItemCode).collect(Collectors.toList()));
                    agreementSkuPo.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
                    List<AgreementSkuPO> list = this.agreementSkuMapper.getList(agreementSkuPo);
                    if (!CollectionUtils.isEmpty(list)) {
                        agreementSkuPo.setUpdateLoginId(0L);
                        agreementSkuPo.setUpdateName("ops");
                        agreementSkuPo.setUpdateTime(now);
                        agreementSkuPo.setIsDelete(AgrCommConstant.IsDelete.DELETED);
                        this.agreementSkuMapper.updateBy(agreementSkuPo);
                        AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
                        atomReqBO.setSkuStatus(AgrCommConstant.CommiditySkuStatus.INVALID);
                        atomReqBO.setAgreementSkuIds(list.stream().map(AgreementSkuPO::getAgreementSkuId).collect(Collectors.toSet()));
                        AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
                        if (!"0000".equals(atomRspBO.getRespCode())) {
                            throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
                        }
                        if (CollectionUtils.isEmpty((Collection)rspBo.getDeleteAgrSkuIds())) {
                            rspBo.setDeleteAgrSkuIds(list.stream().map(AgreementSkuPO::getAgreementSkuId).collect(Collectors.toList()));
                        } else {
                            rspBo.getDeleteAgrSkuIds().addAll(list.stream().map(AgreementSkuPO::getAgreementSkuId).collect(Collectors.toList()));
                        }
                    }
                });
            }
            if (!CollectionUtils.isEmpty(insertItems)) {
                agreementPos.forEach(agreement -> {
                    AgreementSkuPO agreementSkuPo = new AgreementSkuPO();
                    agreementSkuPo.setAgreementId(agreement.getAgreementId());
                    agreementSkuPo.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
                    agreementSkuPo.setExtItemCodeIn(insertItems.stream().map(OpsContractItemPO::getContractItemCode).collect(Collectors.toList()));
                    agreementSkuPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                    List<AgreementSkuPO> agrItemlist = this.agreementSkuMapper.getList(agreementSkuPo);
                    List itemInsertList = insertItems;
                    if (!CollectionUtils.isEmpty(agrItemlist)) {
                        List existItemCodes = agrItemlist.stream().map(AgreementSkuPO::getExtItemCode).collect(Collectors.toList());
                        itemInsertList = itemInsertList.stream().filter(po -> !existItemCodes.contains(po.getContractItemCode())).collect(Collectors.toList());
                        List itemUpdateList = insertItems.stream().filter(po -> existItemCodes.contains(po.getContractItemCode())).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(itemUpdateList)) {
                            updateItems.addAll(itemUpdateList);
                        }
                    }
                    this.dealItemInsert((AgreementPO)agreement, itemInsertList, now);
                });
            }
            if (!CollectionUtils.isEmpty(updateItems)) {
                agreementPos.forEach(agreement -> this.dealItemUpdate((AgreementPO)agreement, updateItems, now, originItemList, rspBo));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPaymentList())) {
            AgrInstallmentPaymentPO agrInstallmentPaymentPO = new AgrInstallmentPaymentPO();
            agrInstallmentPaymentPO.setAgreementIdIn(agreementPos.stream().map(AgreementPO::getAgreementId).collect(Collectors.toList()));
            this.agrInstallmentPaymentMapper.deleteBy(agrInstallmentPaymentPO);
            agreementPos.forEach(agreement -> {
                int inserted;
                ArrayList<AgrInstallmentPaymentPO> installmentPaymentPOS = new ArrayList<AgrInstallmentPaymentPO>();
                reqBo.getPaymentList().forEach(item -> {
                    AgrInstallmentPaymentPO po = new AgrInstallmentPaymentPO();
                    po.setId(Sequence.getInstance().nextId());
                    po.setAgreementId(agreement.getAgreementId());
                    po.setStageName(item.getPaymentName());
                    po.setStageValue(StringUtils.hasText((String)item.getPaymentValue()) ? new BigDecimal(item.getPaymentValue()) : null);
                    po.setStageClause(item.getPaymentClause());
                    po.setOrdered(StringUtils.hasText((String)item.getOrdered()) ? Integer.valueOf(item.getOrdered()) : 0);
                    po.setPaymentDays(StringUtils.hasText((String)reqBo.getPaymentDays()) ? Integer.valueOf(reqBo.getPaymentDays()) : 0);
                    installmentPaymentPOS.add(po);
                });
                if (!CollectionUtils.isEmpty(installmentPaymentPOS) && (inserted = this.agrInstallmentPaymentMapper.insertBatch(installmentPaymentPOS)) != installmentPaymentPOS.size()) {
                    throw new BusinessException("22005", "\u53d8\u66f4\u5206\u9636\u6bb5\u4ed8\u6b3e\u660e\u7ec6\u6570\u636e\u5931\u8d25");
                }
            });
        }
    }

    private Result getResult(AgreementPO agreement, List<OpsContractItemPO> itemList) {
        List materialCodes = itemList.stream().map(OpsContractItemPO::getMaterialCode).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
        HashMap<String, UccMaterialCommodityTypeBO> collectByMaterialCode = new HashMap();
        if (!CollectionUtils.isEmpty(materialCodes)) {
            UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
            uccQryCommodityTypeByMaterialReqBo.setMaterialCodes(materialCodes);
            UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByMaterial(uccQryCommodityTypeByMaterialReqBo);
            if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u7f16\u7801\u5931\u8d25");
            }
            collectByMaterialCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getMaterialCode, bo -> bo, (a, b) -> a));
        }
        List catalogCodes = itemList.stream().filter(item -> !StringUtils.hasText((String)item.getMaterialCode())).map(OpsContractItemPO::getCatalogCode).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
        Map<String, UccMaterialCommodityTypeBO> collectByCatalogCode = new HashMap<String, UccMaterialCommodityTypeBO>();
        if (!CollectionUtils.isEmpty(catalogCodes)) {
            UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
            uccQryCommodityTypeByMaterialReqBo.setSecondCatalogs(catalogCodes);
            UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByl2CatalogCode(uccQryCommodityTypeByMaterialReqBo);
            if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u5206\u7c7b\u5931\u8d25");
            }
            collectByCatalogCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getL2CatalogCode, bo -> bo, (a, b) -> a));
        }
        Map<Long, Object> supplierSaleRspBOMap = new HashMap<Long, ContractSupplierSaleRspBO>();
        if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(agreement.getAgreementMode()) && agreement.getContractId() != null) {
            ContractSupplierSaleReqBO contractSupplierSaleReqBO = new ContractSupplierSaleReqBO();
            contractSupplierSaleReqBO.setContractId(agreement.getContractId());
            contractSupplierSaleReqBO.setPageNo(-1);
            contractSupplierSaleReqBO.setPageSize(-1);
            RspPage contractSupplierSalePage = this.qryContractSupplierListSaleService.selecContractSupplierList(contractSupplierSaleReqBO);
            if (contractSupplierSalePage != null && !CollectionUtils.isEmpty((Collection)contractSupplierSalePage.getRows())) {
                supplierSaleRspBOMap = contractSupplierSalePage.getRows().stream().collect(Collectors.toMap(ContractSupplierSaleRspBO::getCategoryId, Function.identity(), (key1, key2) -> key2));
            } else {
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5165\u9a7b\u5408\u540c\u4fe1\u606f");
            }
        }
        return new Result(collectByMaterialCode, collectByCatalogCode, supplierSaleRspBOMap);
    }

    private void dealItemInsert(AgreementPO agreement, List<OpsContractItemPO> itemInsertList, Date now) {
        Result result = this.getResult(agreement, itemInsertList);
        ArrayList<AgreementSkuPO> insertList = new ArrayList<AgreementSkuPO>();
        Map<String, String> conversionScaleMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "MEASURE_CONVERSION_RELATIONSHIPS");
        for (OpsContractItemPO itemPo : itemInsertList) {
            AgreementSkuPO po = new AgreementSkuPO();
            po.setAgreementSkuId(Sequence.getInstance().nextId());
            po.setEffectiveFlag(AgrCommConstant.IsDelete.NORMAL);
            UccMaterialCommodityTypeBO uccMaterialCommodityTypeBo = !StringUtils.hasText((String)itemPo.getMaterialCode()) ? result.collectByCatalogCode.get(itemPo.getCatalogCode()) : result.collectByMaterialCode.get(itemPo.getMaterialCode());
            if (uccMaterialCommodityTypeBo != null && !CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) {
                List collect = uccMaterialCommodityTypeBo.getTypeIdAndName().keySet().stream().sorted().collect(Collectors.toList());
                for (Long item : collect) {
                    po.setCatalogId(item.toString());
                    po.setCatalogName((String)uccMaterialCommodityTypeBo.getTypeIdAndName().get(item));
                    po.setMaterialName(uccMaterialCommodityTypeBo.getLongDesc());
                    if (!StringUtils.hasText((String)itemPo.getCatalogCode())) {
                        itemPo.setCatalogCode(uccMaterialCommodityTypeBo.getL3CatalogCode());
                    }
                    if (CollectionUtils.isEmpty(result.supplierSaleRspBOMap)) {
                        po.setContractCovered((int)AgrEnum.YesOrNo.YES.getCode());
                    } else {
                        ContractSupplierSaleRspBO contractSupplierSaleRspBo = result.supplierSaleRspBOMap.get(item);
                        if (contractSupplierSaleRspBo == null) {
                            po.setContractCovered((int)AgrEnum.YesOrNo.NO.getCode());
                            continue;
                        }
                        po.setContractCovered((int)AgrEnum.YesOrNo.YES.getCode());
                    }
                    break;
                }
            } else {
                po.setContractCovered((int)AgrEnum.YesOrNo.NO.getCode());
            }
            po.setMaterialMeasureName(uccMaterialCommodityTypeBo.getMeasureName());
            if (StringUtils.hasText((String)itemPo.getMaterialCode())) {
                this.handleMaterialCode(itemPo, po, conversionScaleMap);
            } else {
                this.setDefaultScales(po);
            }
            po.setFreezeFlag(AgrCommConstant.IsDelete.NORMAL);
            po.setAgreementId(agreement.getAgreementId());
            po.setAgreementVersion(agreement.getAgreementVersion());
            po.setMaterialId(itemPo.getMaterialCode());
            po.setModel(itemPo.getSpecModel());
            po.setSpec(itemPo.getSpecModel());
            po.setMeasureName(itemPo.getMeasureName());
            po.setBuyNumber(new BigDecimal(itemPo.getBuyNumber()));
            try {
                po.setBuyPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(itemPo.getBuyPrice())));
                po.setBuyPriceSum(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(itemPo.getBuyNumber()).multiply(new BigDecimal(itemPo.getBuyPrice()))));
                po.setSalePrice(po.getBuyPrice());
                po.setSalePriceSum(po.getBuyPriceSum());
            }
            catch (Exception collect) {
                // empty catch block
            }
            po.setMarkupRate(0.0);
            po.setSupplierId(agreement.getSupplierId());
            po.setVendorId(agreement.getVendorId());
            po.setVendorName(agreement.getVendorName());
            po.setTaxRate(Byte.valueOf(itemPo.getTaxRate()));
            po.setCreateLoginId(0L);
            po.setCreateName("ops");
            po.setCreateTime(now);
            po.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            po.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            po.setWarrantyLevel(itemPo.getWarrantyLevel());
            po.setNuclearSafetyLevel(itemPo.getNuclearSafetyLevel());
            po.setScMaterialCode(itemPo.getScMaterialCode());
            po.setThirdCatalogId(itemPo.getCatalogCode());
            po.setComments(itemPo.getComments());
            po.setOrderedQuantity(BigDecimal.ZERO);
            po.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
            po.setExtItemCode(itemPo.getContractItemCode());
            po.setExtItemId(itemPo.getContractItemId());
            po.setProducingArea(itemPo.getProducingArea());
            po.setPurchaseSubType(itemPo.getPurchaseSubType());
            po.setBrandName(agreement.getVendorName());
            po.setManufacturer(agreement.getVendorName());
            po.setIsOil(AgrEnum.YesOrNo.NO.getCode());
            po.setItemName(itemPo.getItemName());
            po.setSupplyCycle(itemPo.getSupplyCycle());
            po.setCurrency(itemPo.getCurrency());
            po.setWarantty(itemPo.getWarantty());
            po.setDifferencesAcceptance(Integer.valueOf(itemPo.getDifferencesAcceptance()));
            po.setAcceptanceScale(itemPo.getAcceptanceScale());
            if (Arrays.asList(AgrEnum.PurchaseType.GC.getCode(), AgrEnum.PurchaseType.FW.getCode()).contains(itemPo.getPurchaseType()) && AgrEnum.YesOrNo.YES.getCode().toString().equals(po.getDifferencesAcceptance().toString())) {
                po.setAdjustAcceptance((int)AgrEnum.YesOrNo.YES.getCode());
            } else {
                po.setAdjustAcceptance((int)AgrEnum.YesOrNo.NO.getCode());
            }
            po.setConstructionProjectCode(itemPo.getConstructionProjectCode());
            po.setConstructionProjectName(itemPo.getConstructionProjectName());
            if (StringUtils.hasText((String)itemPo.getPurchaseType())) {
                po.setCatalogVariety(Integer.valueOf(itemPo.getPurchaseType()));
            }
            insertList.add(po);
        }
        List commodityTypeIds = insertList.stream().map(AgreementSkuPO::getCatalogId).filter(StringUtils::hasText).map(Long::valueOf).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(commodityTypeIds)) {
            CnncQryCommodityTypeListAbilityReqBo cnncQryCommodityTypeListAbilityReqBo = new CnncQryCommodityTypeListAbilityReqBo();
            cnncQryCommodityTypeListAbilityReqBo.setCommodityTypeIds(commodityTypeIds);
            cnncQryCommodityTypeListAbilityReqBo.setPageSize(-1);
            cnncQryCommodityTypeListAbilityReqBo.setPageNo(-1);
            cnncQryCommodityTypeListAbilityReqBo.setQueryHaveSku(Boolean.valueOf(false));
            CnncQryCommodityTypeListAbilityRspBo cnncQryCommodityTypeListAbilityRspBo = this.cnncQryCommodityTypeListAbilityService.qryCommodityTypeList(cnncQryCommodityTypeListAbilityReqBo);
            if (!"0000".equals(cnncQryCommodityTypeListAbilityRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)cnncQryCommodityTypeListAbilityRspBo.getRows())) {
                throw new BusinessException("8888", "\u56db\u7ea7\u5206\u7c7b\u5217\u8868\u67e5\u8be2\u5931\u8d25");
            }
            List commodityTypeListAbilityBos = JSONArray.parseArray((String)JSONArray.toJSONString((Object)cnncQryCommodityTypeListAbilityRspBo.getRows()), CnncQryCommodityTypeListAbilityBo.class);
            Map<Long, CnncQryCommodityTypeListAbilityBo> commodityTypeListAbilityBoMap = commodityTypeListAbilityBos.stream().collect(Collectors.toMap(CnncQryCommodityTypeListAbilityBo::getCommodityTypeId, obj -> obj, (a, b) -> a));
            insertList.stream().filter(agreementSkuPO -> StringUtils.hasText((String)agreementSkuPO.getCatalogId()) && agreementSkuPO.getTaxRate() != null).forEach(agreementSkuPO -> {
                CnncQryCommodityTypeListAbilityBo cnncQryCommodityTypeListAbilityBo = (CnncQryCommodityTypeListAbilityBo)commodityTypeListAbilityBoMap.get(Long.parseLong(agreementSkuPO.getCatalogId()));
                if (null != cnncQryCommodityTypeListAbilityBo) {
                    agreementSkuPO.setTaxCatalog(cnncQryCommodityTypeListAbilityBo.getRateTypeCode());
                }
            });
        }
        if (!CollectionUtils.isEmpty(insertList)) {
            this.checkTaxCodeAndRate(insertList);
            this.agreementSkuMapper.insertBatch(insertList);
        }
    }

    private void dealItemUpdate(AgreementPO agreement, List<OpsContractItemPO> updateItems, Date now, List<OpsContractItemPO> originItemList, OpsContractSyncAbilityRspBO rspBo) {
        AgreementSkuPO agreementSkuPo = new AgreementSkuPO();
        agreementSkuPo.setAgreementId(agreement.getAgreementId());
        agreementSkuPo.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
        agreementSkuPo.setExtItemCodeIn(updateItems.stream().map(OpsContractItemPO::getContractItemCode).collect(Collectors.toList()));
        List<AgreementSkuPO> list = this.agreementSkuMapper.getList(agreementSkuPo);
        HashMap opsItemMap = new HashMap();
        if (!CollectionUtils.isEmpty(originItemList)) {
            originItemList.forEach(item -> opsItemMap.put(item.getContractItemCode(), item));
        }
        if (!CollectionUtils.isEmpty(list)) {
            AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO;
            AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO;
            List split;
            List commodityTypeIds;
            Result result = this.getResult(agreement, updateItems);
            Map<String, List<AgreementSkuPO>> agreementSkuPOMap = list.stream().collect(Collectors.groupingBy(AgreementSkuPO::getExtItemCode));
            ArrayList<AgreementSkuPO> updateList = new ArrayList<AgreementSkuPO>();
            ArrayList<AgreementSkuPO> updateMaterialList = new ArrayList<AgreementSkuPO>();
            ArrayList<AgrskuChangePriceBO> skuChangePriceBOs = new ArrayList<AgrskuChangePriceBO>();
            ArrayList<AgrMaterialSyncBO> agrMaterialSyncBOs = new ArrayList<AgrMaterialSyncBO>();
            Map<String, String> conversionScaleMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "MEASURE_CONVERSION_RELATIONSHIPS");
            for (OpsContractItemPO itemUpdate : updateItems) {
                List<AgreementSkuPO> agreementSkuPos = agreementSkuPOMap.get(itemUpdate.getContractItemCode());
                if (CollectionUtils.isEmpty(agreementSkuPos)) continue;
                for (AgreementSkuPO po : agreementSkuPos) {
                    UccMaterialCommodityTypeBO uccMaterialCommodityTypeBo;
                    OpsContractItemPO contractItemPO;
                    boolean materialCodeOrNameChangeFlag = false;
                    if (!(CollectionUtils.isEmpty(opsItemMap) || null == (contractItemPO = (OpsContractItemPO)opsItemMap.get(itemUpdate.getContractItemCode())) || Objects.equals(contractItemPO.getMaterialCode(), itemUpdate.getMaterialCode()) && Objects.equals(contractItemPO.getMeasureName(), itemUpdate.getMeasureName()))) {
                        materialCodeOrNameChangeFlag = true;
                    }
                    if ((uccMaterialCommodityTypeBo = !StringUtils.hasText((String)itemUpdate.getMaterialCode()) ? result.collectByCatalogCode.get(itemUpdate.getCatalogCode()) : result.collectByMaterialCode.get(itemUpdate.getMaterialCode())) != null && !CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) {
                        List collect = uccMaterialCommodityTypeBo.getTypeIdAndName().keySet().stream().sorted().collect(Collectors.toList());
                        for (Long item2 : collect) {
                            itemUpdate.setCatalogId(item2.toString());
                            itemUpdate.setCatalogName((String)uccMaterialCommodityTypeBo.getTypeIdAndName().get(item2));
                            itemUpdate.setMaterialMeasureName(uccMaterialCommodityTypeBo.getMeasureName());
                            itemUpdate.setMaterialName(uccMaterialCommodityTypeBo.getMaterialName());
                            if (materialCodeOrNameChangeFlag) {
                                // empty if block
                            }
                            if (!StringUtils.hasText((String)itemUpdate.getCatalogCode())) {
                                itemUpdate.setCatalogCode(uccMaterialCommodityTypeBo.getL3CatalogCode());
                            }
                            if (CollectionUtils.isEmpty(result.supplierSaleRspBOMap)) {
                                po.setContractCovered((int)AgrEnum.YesOrNo.YES.getCode());
                            } else {
                                ContractSupplierSaleRspBO contractSupplierSaleRspBo = result.supplierSaleRspBOMap.get(item2);
                                if (contractSupplierSaleRspBo == null) {
                                    po.setContractCovered((int)AgrEnum.YesOrNo.NO.getCode());
                                    continue;
                                }
                                po.setContractCovered((int)AgrEnum.YesOrNo.YES.getCode());
                            }
                            break;
                        }
                    } else {
                        po.setContractCovered((int)AgrEnum.YesOrNo.NO.getCode());
                    }
                    boolean changeFlag = false;
                    AgrskuChangePriceBO bo = new AgrskuChangePriceBO();
                    bo.setAgreementId(po.getAgreementId());
                    bo.setAgreementSkuId(po.getAgreementSkuId());
                    bo.setMarkupRate(Double.valueOf(0.0));
                    bo.setMarkupPrice(BigDecimal.ZERO);
                    boolean materialChangFlag = false;
                    if (materialCodeOrNameChangeFlag) {
                        po.setMaterialId(itemUpdate.getMaterialCode());
                        po.setMeasureName(itemUpdate.getMeasureName());
                        po.setCatalogId(itemUpdate.getCatalogId());
                        po.setCatalogName(itemUpdate.getCatalogName());
                        po.setMaterialName(itemUpdate.getMaterialName());
                        po.setThirdCatalogId(itemUpdate.getCatalogCode());
                        po.setMaterialMeasureName(itemUpdate.getMaterialMeasureName());
                        String conversionScale = conversionScaleMap.get(itemUpdate.getMeasureName() + ":" + itemUpdate.getMaterialMeasureName());
                        if (StringUtils.hasText((String)conversionScale)) {
                            String[] split2 = conversionScale.split(":");
                            if (split2.length == 2) {
                                po.setUnitOfMeasureScale(Integer.valueOf(split2[0]));
                                po.setMaterialUnitOfMeasureScale(Integer.valueOf(split2[1]));
                            }
                        } else {
                            po.setUnitOfMeasureScale(1);
                            po.setMaterialUnitOfMeasureScale(1);
                        }
                        materialChangFlag = true;
                    }
                    po.setExtItemId(itemUpdate.getContractItemId());
                    po.setScMaterialCode(itemUpdate.getScMaterialCode());
                    if (StringUtils.hasText((String)itemUpdate.getTaxRate())) {
                        po.setTaxRate(Byte.valueOf(itemUpdate.getTaxRate()));
                    }
                    if (StringUtils.hasText((String)itemUpdate.getBuyNumber())) {
                        if (po.getBuyNumber().compareTo(new BigDecimal(itemUpdate.getBuyNumber())) != 0) {
                            changeFlag = true;
                            bo.setBuyNumber(new BigDecimal(itemUpdate.getBuyNumber()).subtract(po.getBuyNumber()));
                        }
                        po.setBuyNumber(new BigDecimal(itemUpdate.getBuyNumber()));
                        if (StringUtils.hasText((String)itemUpdate.getBuyPrice())) {
                            try {
                                Long buyPriceLong = MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(itemUpdate.getBuyPrice()));
                                if (!po.getBuyPrice().equals(buyPriceLong)) {
                                    changeFlag = true;
                                    bo.setBuyPrice(buyPriceLong);
                                    bo.setSalePrice(buyPriceLong);
                                }
                                po.setBuyPrice(buyPriceLong);
                                po.setBuyPriceSum(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(itemUpdate.getBuyNumber()).multiply(new BigDecimal(itemUpdate.getBuyPrice()))));
                                po.setSalePrice(po.getBuyPrice());
                                po.setSalePriceSum(po.getBuyPriceSum());
                                if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(agreement.getAgreementMode())) {
                                    if (null != po.getMarkupRate() || StringUtils.hasText((String)po.getMarkupValue())) {
                                        Long salePrice = new BigDecimal(po.getBuyPrice()).add(new BigDecimal(po.getBuyPrice()).multiply(new BigDecimal(po.getMarkupRate().toString())).divide(new BigDecimal("100"))).longValue();
                                        salePrice = salePrice + new BigDecimal(po.getMarkupValue()).multiply(new BigDecimal("10000")).longValue();
                                        po.setSalePrice(salePrice);
                                        po.setSalePriceSum(new BigDecimal(po.getSalePrice()).multiply(po.getBuyNumber()).longValue());
                                    } else {
                                        po.setSalePrice(po.getBuyPrice());
                                        po.setSalePriceSum(po.getBuyPriceSum());
                                    }
                                }
                            }
                            catch (Exception buyPriceLong) {
                                // empty catch block
                            }
                        }
                    }
                    po.setComments(itemUpdate.getComments());
                    po.setModel(itemUpdate.getSpecModel());
                    po.setSpec(itemUpdate.getSpecModel());
                    po.setWarrantyLevel(itemUpdate.getWarrantyLevel());
                    po.setNuclearSafetyLevel(itemUpdate.getNuclearSafetyLevel());
                    po.setProducingArea(itemUpdate.getProducingArea());
                    po.setPurchaseSubType(itemUpdate.getPurchaseSubType());
                    po.setBrandName(agreement.getVendorName());
                    po.setManufacturer(agreement.getVendorName());
                    po.setUpdateLoginId(0L);
                    po.setUpdateName("ops");
                    po.setUpdateTime(now);
                    po.setEffectiveFlag(AgrCommConstant.IsDelete.NORMAL);
                    po.setSupplyCycle(itemUpdate.getSupplyCycle());
                    po.setCurrency(itemUpdate.getCurrency());
                    po.setWarantty(itemUpdate.getWarantty());
                    po.setDifferencesAcceptance(Integer.valueOf(itemUpdate.getDifferencesAcceptance()));
                    po.setAcceptanceScale(itemUpdate.getAcceptanceScale());
                    po.setConstructionProjectCode(itemUpdate.getConstructionProjectCode());
                    po.setConstructionProjectName(itemUpdate.getConstructionProjectName());
                    if (StringUtils.hasText((String)itemUpdate.getPurchaseType())) {
                        po.setCatalogVariety(Integer.valueOf(itemUpdate.getPurchaseType()));
                    }
                    if (Arrays.asList(AgrEnum.PurchaseType.GC.getCode(), AgrEnum.PurchaseType.FW.getCode()).contains(itemUpdate.getPurchaseType()) && AgrEnum.YesOrNo.YES.getCode().toString().equals(po.getDifferencesAcceptance().toString())) {
                        po.setAdjustAcceptance((int)AgrEnum.YesOrNo.YES.getCode());
                    } else {
                        po.setAdjustAcceptance((int)AgrEnum.YesOrNo.NO.getCode());
                    }
                    if (materialChangFlag) {
                        AgrMaterialSyncBO agrMaterialSyncBO = new AgrMaterialSyncBO();
                        agrMaterialSyncBO.setAgreementId(po.getAgreementId());
                        agrMaterialSyncBO.setAgreementDetailId(po.getAgreementSkuId());
                        agrMaterialSyncBO.setMaterialCode(po.getMaterialId());
                        if (!StringUtils.isEmpty((Object)itemUpdate.getCatalogId())) {
                            agrMaterialSyncBO.setCommodityTypeId(Long.valueOf(Long.parseLong(itemUpdate.getCatalogId())));
                        }
                        agrMaterialSyncBOs.add(agrMaterialSyncBO);
                        po.setCatalogId(itemUpdate.getCatalogId());
                        po.setCatalogName(itemUpdate.getCatalogName());
                        po.setMeasureName(itemUpdate.getMeasureName());
                        updateMaterialList.add(po);
                    }
                    updateList.add(po);
                    if (!changeFlag) continue;
                    skuChangePriceBOs.add(bo);
                }
            }
            if (!CollectionUtils.isEmpty(updateMaterialList) && !CollectionUtils.isEmpty(commodityTypeIds = updateMaterialList.stream().map(AgreementSkuPO::getCatalogId).filter(StringUtils::hasText).map(Long::valueOf).distinct().collect(Collectors.toList()))) {
                CnncQryCommodityTypeListAbilityReqBo cnncQryCommodityTypeListAbilityReqBo = new CnncQryCommodityTypeListAbilityReqBo();
                cnncQryCommodityTypeListAbilityReqBo.setCommodityTypeIds(commodityTypeIds);
                cnncQryCommodityTypeListAbilityReqBo.setPageSize(-1);
                cnncQryCommodityTypeListAbilityReqBo.setPageNo(-1);
                cnncQryCommodityTypeListAbilityReqBo.setQueryHaveSku(Boolean.valueOf(false));
                CnncQryCommodityTypeListAbilityRspBo cnncQryCommodityTypeListAbilityRspBo = this.cnncQryCommodityTypeListAbilityService.qryCommodityTypeList(cnncQryCommodityTypeListAbilityReqBo);
                if (!"0000".equals(cnncQryCommodityTypeListAbilityRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)cnncQryCommodityTypeListAbilityRspBo.getRows())) {
                    throw new BusinessException("8888", "\u56db\u7ea7\u5206\u7c7b\u5217\u8868\u67e5\u8be2\u5931\u8d25");
                }
                List commodityTypeListAbilityBos = JSONArray.parseArray((String)JSONArray.toJSONString((Object)cnncQryCommodityTypeListAbilityRspBo.getRows()), CnncQryCommodityTypeListAbilityBo.class);
                Map<Long, CnncQryCommodityTypeListAbilityBo> commodityTypeListAbilityBoMap = commodityTypeListAbilityBos.stream().collect(Collectors.toMap(CnncQryCommodityTypeListAbilityBo::getCommodityTypeId, obj -> obj, (a, b) -> a));
                updateMaterialList.stream().filter(agreementSkuPO -> StringUtils.hasText((String)agreementSkuPO.getCatalogId()) && agreementSkuPO.getTaxRate() != null).forEach(agreementSkuPO -> {
                    CnncQryCommodityTypeListAbilityBo cnncQryCommodityTypeListAbilityBo = (CnncQryCommodityTypeListAbilityBo)commodityTypeListAbilityBoMap.get(Long.parseLong(agreementSkuPO.getCatalogId()));
                    if (null != cnncQryCommodityTypeListAbilityBo) {
                        agreementSkuPO.setTaxCatalog(cnncQryCommodityTypeListAbilityBo.getRateTypeCode());
                    }
                });
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                this.checkTaxCodeAndRate(updateList);
                split = ListUtil.split(updateList, (int)500);
                split.forEach(splistList -> this.agreementSkuMapper.updateBatchOpsAgreement((List<AgreementSkuPO>)splistList));
            }
            if (!CollectionUtils.isEmpty(updateMaterialList)) {
                split = ListUtil.split(updateMaterialList, (int)500);
                split.forEach(splistList -> this.agreementSkuMapper.updateBatchAgreementSku((List<AgreementSkuPO>)splistList));
            }
            if (!CollectionUtils.isEmpty(skuChangePriceBOs)) {
                atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
                atomReqBO.setSkuChangePriceBOs(skuChangePriceBOs);
                atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    throw new BusinessException(atomRspBO.getRespCode(), "\u66f4\u65b0\u5173\u8054\u5546\u54c1\u4fe1\u606f\u5f02\u5e38!" + atomRspBO.getRespDesc());
                }
                if (CollectionUtils.isEmpty((Collection)rspBo.getPriceChangeAgrSkuIds())) {
                    rspBo.setPriceChangeAgrSkuIds(skuChangePriceBOs.stream().map(AgrskuChangePriceBO::getAgreementSkuId).collect(Collectors.toList()));
                } else {
                    rspBo.getPriceChangeAgrSkuIds().addAll(skuChangePriceBOs.stream().map(AgrskuChangePriceBO::getAgreementSkuId).collect(Collectors.toList()));
                }
            }
            if (!CollectionUtils.isEmpty(agrMaterialSyncBOs)) {
                atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
                atomReqBO.setAgrMaterialSyncBOs(agrMaterialSyncBOs);
                atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    throw new BusinessException(atomRspBO.getRespCode(), "\u66f4\u65b0\u5173\u8054\u5546\u54c1\u4fe1\u606f\u5f02\u5e38!" + atomRspBO.getRespDesc());
                }
            }
        }
    }

    private void checkTaxCodeAndRate(List<AgreementSkuPO> agreementSkuList) {
        List commodityTypeIds = agreementSkuList.stream().map(AgreementSkuPO::getCatalogId).filter(StringUtils::hasText).map(Long::valueOf).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(commodityTypeIds)) {
            CnncQryCommodityTypeListAbilityReqBo cnncQryCommodityTypeListAbilityReqBo = new CnncQryCommodityTypeListAbilityReqBo();
            cnncQryCommodityTypeListAbilityReqBo.setCommodityTypeIds(commodityTypeIds);
            cnncQryCommodityTypeListAbilityReqBo.setQueryHaveSku(Boolean.valueOf(false));
            cnncQryCommodityTypeListAbilityReqBo.setPageSize(-1);
            cnncQryCommodityTypeListAbilityReqBo.setPageNo(-1);
            CnncQryCommodityTypeListAbilityRspBo cnncQryCommodityTypeListAbilityRspBo = this.cnncQryCommodityTypeListAbilityService.qryCommodityTypeList(cnncQryCommodityTypeListAbilityReqBo);
            if (!"0000".equals(cnncQryCommodityTypeListAbilityRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)cnncQryCommodityTypeListAbilityRspBo.getRows())) {
                throw new BusinessException("8888", "\u56db\u7ea7\u5206\u7c7b\u5217\u8868\u67e5\u8be2\u5931\u8d25");
            }
            List commodityTypeListAbilityBos = JSONArray.parseArray((String)JSONArray.toJSONString((Object)cnncQryCommodityTypeListAbilityRspBo.getRows()), CnncQryCommodityTypeListAbilityBo.class);
            Map<Long, CnncQryCommodityTypeListAbilityBo> commodityTypeListAbilityBoMap = commodityTypeListAbilityBos.stream().collect(Collectors.toMap(CnncQryCommodityTypeListAbilityBo::getCommodityTypeId, obj -> obj, (a, b) -> a));
            agreementSkuList.stream().filter(agreementSkuPO -> StringUtils.hasText((String)agreementSkuPO.getCatalogId()) && agreementSkuPO.getTaxRate() != null).forEach(agreementSkuPO -> {
                CnncQryCommodityTypeListAbilityBo cnncQryCommodityTypeListAbilityBo = (CnncQryCommodityTypeListAbilityBo)commodityTypeListAbilityBoMap.get(Long.parseLong(agreementSkuPO.getCatalogId()));
                if (null != cnncQryCommodityTypeListAbilityBo) {
                    agreementSkuPO.setTaxCatalog(cnncQryCommodityTypeListAbilityBo.getRateTypeCode());
                }
            });
        }
    }

    private Map<String, CnncUccEMdmCatalogAllBO> getUccCatalogPath(List<Long> typeIds) {
        HashMap<String, CnncUccEMdmCatalogAllBO> catalogAllBOMap = new HashMap<String, CnncUccEMdmCatalogAllBO>();
        CnncCatalogPathQryAbilityReqBo cnncCatalogPathQryAbilityReqBo = new CnncCatalogPathQryAbilityReqBo();
        cnncCatalogPathQryAbilityReqBo.setTypeIds(typeIds);
        CnncCatalogPathQryAbilityRspBo cnncCatalogPathQryAbilityRspBo = this.cnncCatalogPathQryAbilityService.catalogPathQry(cnncCatalogPathQryAbilityReqBo);
        if (!"0000".equals(cnncCatalogPathQryAbilityRspBo.getRespCode())) {
            throw new ZTBusinessException("\u5546\u54c1\u7c7b\u76ee\u67e5\u8be2\u9519\u8bef!");
        }
        cnncCatalogPathQryAbilityRspBo.getCatalogList().forEach(cnncUccEMdmCatalogAllBO -> catalogAllBOMap.put(cnncUccEMdmCatalogAllBO.getCommodityTypeId().toString(), (CnncUccEMdmCatalogAllBO)cnncUccEMdmCatalogAllBO));
        return catalogAllBOMap;
    }

    private void handleMaterialCode(OpsContractItemPO itemPo, AgreementSkuPO po, Map<String, String> conversionScaleMap) {
        if (Objects.equals(itemPo.getMeasureName(), po.getMaterialMeasureName())) {
            po.setSupplyCycle(0);
            this.setDefaultScales(po);
        } else {
            String key = String.format("%s:%s", itemPo.getMeasureName(), po.getMaterialMeasureName());
            String conversionScale = conversionScaleMap.get(key);
            if (StringUtils.hasText((String)conversionScale)) {
                String[] split = conversionScale.split(":");
                if (split.length == 2) {
                    try {
                        po.setUnitOfMeasureScale(Integer.parseInt(split[0]));
                        po.setMaterialUnitOfMeasureScale(Integer.parseInt(split[1]));
                        po.setSupplyCycle(0);
                    }
                    catch (NumberFormatException e) {
                        this.setDefaultScales(po);
                    }
                } else {
                    this.setDefaultScales(po);
                }
            } else {
                this.setDefaultScales(po);
            }
        }
    }

    private UmcZhEnterpriseOrgAbilityBO getUmcZhEnterpriseOrgAbilityBO(Long creatorOrgId) {
        UmcZhEnterpriseOrgQueryAbilityReqBO umcEnterpriseOrgStartStopDelAbilityReqBO = new UmcZhEnterpriseOrgQueryAbilityReqBO();
        umcEnterpriseOrgStartStopDelAbilityReqBO.setOrgIdWeb(creatorOrgId);
        log.debug("\u67e5\u8be2\u4f1a\u5458\u673a\u6784\u8be6\u60c5\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)umcEnterpriseOrgStartStopDelAbilityReqBO));
        UmcZhEnterpriseOrgDetailAbilityRspBO umcRspPageBO = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcEnterpriseOrgStartStopDelAbilityReqBO);
        log.debug("\u67e5\u8be2\u4f1a\u5458\u673a\u6784\u8be6\u60c5\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)umcRspPageBO));
        if (!"0000".equals(umcRspPageBO.getRespCode())) {
            throw new BusinessException("8888", "\u67e5\u8be2\u4f1a\u5458\u673a\u6784\u8be6\u60c5\u5931\u8d25\uff0c" + umcRspPageBO.getRespDesc());
        }
        UmcZhEnterpriseOrgAbilityBO enterpriseOrgAbilityBO = umcRspPageBO.getUmcEnterpriseOrgAbilityBO();
        if (null == enterpriseOrgAbilityBO) {
            throw new BusinessException("8888", "\u67e5\u8be2\u5408\u540c\u8d77\u8349\u4eba[" + creatorOrgId + "]\u673a\u6784\u8be6\u60c5\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)enterpriseOrgAbilityBO.getCompanyNameAlias())) {
            throw new BusinessException("0001", "OPS\u5408\u540c\u540c\u6b65\u81ea\u52a8\u521b\u5efa\u534f\u8baeAPI\u5165\u53c2\u3010orgShortName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return enterpriseOrgAbilityBO;
    }

    private void setDefaultScales(AgreementSkuPO po) {
        po.setUnitOfMeasureScale(1);
        po.setMaterialUnitOfMeasureScale(1);
    }

    private static class Result {
        public final Map<String, UccMaterialCommodityTypeBO> collectByMaterialCode;
        public final Map<String, UccMaterialCommodityTypeBO> collectByCatalogCode;
        public final Map<Long, ContractSupplierSaleRspBO> supplierSaleRspBOMap;

        public Result(Map<String, UccMaterialCommodityTypeBO> collectByMaterialCode, Map<String, UccMaterialCommodityTypeBO> collectByCatalogCode, Map<Long, ContractSupplierSaleRspBO> supplierSaleRspBOMap) {
            this.collectByMaterialCode = collectByMaterialCode;
            this.collectByCatalogCode = collectByCatalogCode;
            this.supplierSaleRspBOMap = supplierSaleRspBOMap;
        }
    }
}

