/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.SrmContractInfoBO;
import com.tydic.agreement.ability.bo.SrmContractScopeBO;
import com.tydic.agreement.busi.SrmContractRePushBusiService;
import com.tydic.agreement.busi.bo.SrmContractScopeOrgCheckReqBO;
import com.tydic.agreement.busi.bo.SrmContractScopeOrgCheckRspBO;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.SrmContracRePushLogMapper;
import com.tydic.agreement.dao.po.SrmContracRePushLogPO;
import com.tydic.agreement.external.srm.SrmContractSyncCallBackService;
import com.tydic.agreement.external.srm.bo.SrmContractSyncCallBackReqBO;
import com.tydic.umc.common.EnterpriseOrgExtMapBO;
import com.tydic.umcext.ability.org.UmcOrgExtMapOperateAbilityService;
import com.tydic.umcext.ability.org.bo.UmcOrgExtMapOperateAbilityReqBO;
import com.tydic.umcext.ability.org.bo.UmcOrgExtMapOperateAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SrmContractRePushBusiServiceImpl
implements SrmContractRePushBusiService {
    private static final Logger log = LoggerFactory.getLogger(SrmContractRePushBusiServiceImpl.class);
    @Autowired
    private SrmContracRePushLogMapper srmContracRePushLogMapper;
    @Autowired
    private UmcOrgExtMapOperateAbilityService umcOrgExtMapOperateAbilityService;
    @Value(value="${srm_callback:true}")
    private Boolean srmCallback;
    @Autowired
    private SrmContractSyncCallBackService srmContractSyncCallBackService;

    public SrmContractScopeOrgCheckRspBO dealSrmContractScopeCheck(SrmContractScopeOrgCheckReqBO reqBo) {
        SrmContractScopeOrgCheckRspBO rspBO = new SrmContractScopeOrgCheckRspBO();
        Boolean notSyncFlag = false;
        Map<Object, Object> orgListMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getContractList())) {
            List fieldValueList = reqBo.getContractList().stream().flatMap(srmContractInfoBO -> srmContractInfoBO.getScopeList().stream()).filter(srmContractScopeBO -> StringUtils.hasText((String)srmContractScopeBO.getOrgCode())).map(SrmContractScopeBO::getOrgCode).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(fieldValueList)) {
                ArrayList orgExtMapList = new ArrayList();
                List splistList = ListUtil.split(fieldValueList, (int)500);
                for (Object fieldValue : splistList) {
                    if (CollectionUtils.isEmpty((Collection)fieldValue)) continue;
                    UmcOrgExtMapOperateAbilityReqBO umcOrgExtMapOperateAbilityReqBO = new UmcOrgExtMapOperateAbilityReqBO();
                    umcOrgExtMapOperateAbilityReqBO.setFieldCode("esbOrgCode");
                    umcOrgExtMapOperateAbilityReqBO.setOperateType(Integer.valueOf(3));
                    umcOrgExtMapOperateAbilityReqBO.setFieldValueList((List)fieldValue);
                    UmcOrgExtMapOperateAbilityRspBO umcOrgExtMapOperateAbilityRspBO = this.umcOrgExtMapOperateAbilityService.operate(umcOrgExtMapOperateAbilityReqBO);
                    if (!"0000".equals(umcOrgExtMapOperateAbilityRspBO.getRespCode())) {
                        throw new BusinessException("8888", "\u67e5\u8be2\u7edf\u4e00\u8ba4\u8bc1\u552f\u4e00\u6807\u8bc6\u5931\u8d25!");
                    }
                    if (CollectionUtils.isEmpty((Collection)umcOrgExtMapOperateAbilityRspBO.getOrgExtMapList())) continue;
                    orgExtMapList.addAll(umcOrgExtMapOperateAbilityRspBO.getOrgExtMapList());
                }
                if (!CollectionUtils.isEmpty(orgExtMapList)) {
                    orgListMap = orgExtMapList.stream().collect(Collectors.toMap(EnterpriseOrgExtMapBO::getFieldValue, po -> po, (a, b) -> a));
                }
            }
            Date now = new Date();
            String successCode = "1";
            HashMap<String, String> contractCodeMap = new HashMap<String, String>();
            for (SrmContractInfoBO srmContractInfoBO2 : reqBo.getContractList()) {
                for (Object srmContractScopeBO2 : srmContractInfoBO2.getScopeList()) {
                    EnterpriseOrgExtMapBO enterpriseOrgExtMapBO = (EnterpriseOrgExtMapBO)orgListMap.get(srmContractScopeBO2.getOrgCode());
                    if (null != enterpriseOrgExtMapBO) {
                        srmContractScopeBO2.setOrgId(enterpriseOrgExtMapBO.getOrgId());
                        srmContractScopeBO2.setScopeId(Long.valueOf(Sequence.getInstance().nextId()));
                        continue;
                    }
                    notSyncFlag = true;
                    String orgCode = (String)contractCodeMap.get(srmContractScopeBO2.getContractCode());
                    if (StringUtils.hasText((String)orgCode)) {
                        contractCodeMap.put(srmContractScopeBO2.getContractCode(), orgCode + "," + srmContractScopeBO2.getOrgCode());
                        continue;
                    }
                    contractCodeMap.put(srmContractScopeBO2.getContractCode(), srmContractScopeBO2.getOrgCode());
                }
            }
            if (notSyncFlag.booleanValue() && null == reqBo.getRePushFlag()) {
                SrmContracRePushLogPO srmContracRePushLogPO = new SrmContracRePushLogPO();
                srmContracRePushLogPO.setId(Sequence.getInstance().nextId());
                srmContracRePushLogPO.setInContent(JSON.toJSONString((Object)reqBo.getContractList(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                srmContracRePushLogPO.setOutContent("\u7edf\u4e00\u8ba4\u8bc1\u5355\u4f4d\u7f16\u7801\u5bf9\u5e94\u5355\u4f4d\u67e5\u8be2\u4e0d\u5b58\u5728");
                srmContracRePushLogPO.setResult(AgrEnum.SrmContractRePushTypeStatus.error.getType());
                srmContracRePushLogPO.setFunctionCode("103");
                srmContracRePushLogPO.setFunctionName("\u534f\u8bae\u4e2d\u5fc3");
                srmContracRePushLogPO.setServiceCode("10101");
                srmContracRePushLogPO.setServiceName("\u63a8\u9001SRM");
                srmContracRePushLogPO.setCreateTime(now);
                HashSet contractCodeList = new HashSet();
                if (!CollectionUtils.isEmpty(contractCodeMap)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Map.Entry entry : contractCodeMap.entrySet()) {
                        stringBuilder.append("\u5408\u540c\u7f16\u53f7\u3010" + (String)entry.getKey() + "\u3011\u7684\u5e94\u7528\u8303\u56f4\u96c6\u5408\u4e2d\uff0c\u673a\u6784\u7f16\u7801\u3010" + (String)entry.getValue() + "\u3011\u7684\u7edf\u4e00\u8ba4\u8bc1\u552f\u4e00\u6807\u8bc6\u4e0d\u5b58\u5728");
                        contractCodeList.add(entry.getKey());
                    }
                    srmContracRePushLogPO.setExt1(stringBuilder.toString());
                }
                if (!CollectionUtils.isEmpty(contractCodeList)) {
                    srmContracRePushLogPO.setServiceDetail("SRM\u63a8\u9001,\u5408\u540c\u7f16\u53f7\u3010" + contractCodeList.stream().collect(Collectors.joining(",")) + "\u3011");
                }
                srmContracRePushLogPO.setOutContent(AgrEnum.SuccessOrError.ERROR.getDesc());
                int insert = this.srmContracRePushLogMapper.insert(srmContracRePushLogPO);
                if (insert < 1) {
                    throw new BusinessException("8888", "SRM\u5408\u540c\u5546\u57ce\u91cd\u65b0\u63a8\u9001\u8bb0\u5f55\u65e5\u5fd7\u65b0\u589e\u5931\u8d25");
                }
                HashSet successList = new HashSet();
                successList.addAll(reqBo.getContractList().stream().map(bo -> new SrmContractSyncCallBackReqBO(bo.getContractId(), bo.getContractCode(), null, successCode, null)).collect(Collectors.toList()));
                for (SrmContractSyncCallBackReqBO result : successList) {
                    if (!this.srmCallback.booleanValue()) continue;
                    this.srmContractSyncCallBackService.dealSrmContractSyncCallBack(result);
                }
            }
            if (null != reqBo.getRePushFlag() && reqBo.getRePushFlag().booleanValue()) {
                if (notSyncFlag.booleanValue()) {
                    throw new BusinessException("8888", "SRM\u5408\u540c\u5e94\u7528\u8303\u56f4\u96c6\u5408\u4e2d\u673a\u6784\u7f16\u7801\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u7684\u673a\u6784\u672a\u5168\u90e8\u540c\u6b65");
                }
                SrmContracRePushLogPO setPO = new SrmContracRePushLogPO();
                setPO.setResult(AgrEnum.SrmContractRePushTypeStatus.success.getType());
                setPO.setCreateTime(now);
                setPO.setOutContent(AgrEnum.SuccessOrError.SUCCESS.getDesc());
                SrmContracRePushLogPO wherePO = new SrmContracRePushLogPO();
                wherePO.setId(reqBo.getLogId());
                int count = this.srmContracRePushLogMapper.updateBy(setPO, wherePO);
                if (count < 1) {
                    throw new BusinessException("8888", "\u66f4\u65b0SRM\u5408\u540c\u5546\u57ce\u91cd\u65b0\u63a8\u9001\u8bb0\u5f55\u65e5\u5fd7\u72b6\u6001\u5931\u8d25");
                }
            }
        }
        rspBO.setNotSyncFlag(notSyncFlag);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

