/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementScopeSyncQueueReqBO;
import com.tydic.agreement.ability.bo.SrmContractInfoBO;
import com.tydic.agreement.ability.bo.SrmContractItemBO;
import com.tydic.agreement.ability.bo.SrmContractScopeBO;
import com.tydic.agreement.ability.bo.SrmContractSyncReqBO;
import com.tydic.agreement.ability.bo.SrmContractSyncRspBO;
import com.tydic.agreement.atom.AgrAgreementStatusChangeAtomService;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.AgrSyncSkuStatusToCommidityAtomService;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomRspBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomReqBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomRspBO;
import com.tydic.agreement.busi.AgrAgreementScopeSyncQueueBusiService;
import com.tydic.agreement.busi.SrmContractSyncBusiService;
import com.tydic.agreement.common.bo.AgrMaterialSyncBO;
import com.tydic.agreement.common.bo.AgrskuChangePriceBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgrAgreementSkuMaterialMapper;
import com.tydic.agreement.dao.AgrAgreementSkuOldMaterialMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.SrmContractItemLogMapper;
import com.tydic.agreement.dao.SrmContractItemMapper;
import com.tydic.agreement.dao.SrmContractLogMapper;
import com.tydic.agreement.dao.SrmContractMapper;
import com.tydic.agreement.dao.SrmContractScopeLogMapper;
import com.tydic.agreement.dao.SrmContractScopeMapper;
import com.tydic.agreement.dao.po.AgrAgreementSkuMaterialPO;
import com.tydic.agreement.dao.po.AgrAgreementSkuOldMaterialPO;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementScopePO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.agreement.dao.po.SrmContractItemLogPO;
import com.tydic.agreement.dao.po.SrmContractItemPO;
import com.tydic.agreement.dao.po.SrmContractLogPO;
import com.tydic.agreement.dao.po.SrmContractPO;
import com.tydic.agreement.dao.po.SrmContractScopeLogPO;
import com.tydic.agreement.dao.po.SrmContractScopePO;
import com.tydic.agreement.utils.MoneyUtil;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleReqBO;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleRspBO;
import com.tydic.contract.api.maintenance.service.QryContractSupplierListSaleService;
import com.tydic.uccext.bo.CnncCatalogPathQryAbilityReqBo;
import com.tydic.uccext.bo.CnncCatalogPathQryAbilityRspBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityReqBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityRspBo;
import com.tydic.uccext.bo.CnncUccEMdmCatalogAllBO;
import com.tydic.uccext.bo.UccMaterialCommodityTypeBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialReqBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialRspBO;
import com.tydic.uccext.service.CnncBatchQryMaterialByCodeAbilityService;
import com.tydic.uccext.service.CnncCatalogPathQryAbilityService;
import com.tydic.uccext.service.CnncQryCommodityTypeListAbilityService;
import com.tydic.uccext.service.UccQryCommodityTypeByMaterialService;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SrmContractSyncBusiServiceImpl
implements SrmContractSyncBusiService {
    @Autowired
    private SrmContractMapper srmContractMapper;
    @Autowired
    private SrmContractItemMapper srmContractItemMapper;
    @Autowired
    private SrmContractScopeMapper srmContractScopeMapper;
    @Autowired
    private SrmContractLogMapper srmContractLogMapper;
    @Autowired
    private SrmContractItemLogMapper srmContractItemLogMapper;
    @Autowired
    private SrmContractScopeLogMapper srmContractScopeLogMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgrAgreementScopeSyncQueueBusiService agrAgreementScopeSyncQueueBusiService;
    @Autowired
    private AgrSyncSkuStatusToCommidityAtomService agrSyncSkuStatusToCommidityAtomService;
    @Autowired
    private AgrAgreementStatusChangeAtomService agrAgreementStatusChangeAtomService;
    @Autowired
    private UccQryCommodityTypeByMaterialService uccQryCommodityTypeByMaterialService;
    @Autowired
    private QryContractSupplierListSaleService qryContractSupplierListSaleService;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Value(value="${cnecc_org_id}")
    private Long cneccOrgId;
    @Autowired
    private CnncBatchQryMaterialByCodeAbilityService cnncBatchQryMaterialByCodeAbilityService;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private CnncQryCommodityTypeListAbilityService cnncQryCommodityTypeListAbilityService;
    @Autowired
    private AgrAgreementSkuOldMaterialMapper agrAgreementSkuOldMaterialMapper;
    @Autowired
    private AgrAgreementSkuMaterialMapper agrAgreementSkuMaterialMapper;
    @Autowired
    private CnncCatalogPathQryAbilityService cnncCatalogPathQryAbilityService;

    @Override
    public SrmContractSyncRspBO syncSrmContract(SrmContractSyncReqBO reqBo) {
        SrmContractSyncRspBO rspBo = new SrmContractSyncRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getContractList())) {
            Date now = new Date();
            this.saveLog(reqBo, now);
            SrmContractPO srmContractPo = new SrmContractPO();
            srmContractPo.setContractCodeIn(reqBo.getContractList().stream().map(SrmContractInfoBO::getContractCode).collect(Collectors.toList()));
            List<SrmContractPO> contractPoList = this.srmContractMapper.getList(srmContractPo);
            ArrayList<SrmContractPO> insertContractInfoList = new ArrayList<SrmContractPO>();
            ArrayList<SrmContractPO> updateContractInfoList = new ArrayList<SrmContractPO>();
            ArrayList<SrmContractItemPO> insertContractItemList = new ArrayList<SrmContractItemPO>();
            ArrayList<SrmContractItemPO> updateContractItemList = new ArrayList<SrmContractItemPO>();
            ArrayList<SrmContractScopePO> insertContractScopeList = new ArrayList<SrmContractScopePO>();
            ArrayList<SrmContractScopePO> updateContractScopeList = new ArrayList<SrmContractScopePO>();
            if (CollectionUtils.isEmpty(contractPoList)) {
                reqBo.getContractList().forEach(bo -> {
                    insertContractInfoList.add(this.assemblyContractInfoPo((SrmContractInfoBO)bo, now));
                    if (!CollectionUtils.isEmpty((Collection)bo.getItemList())) {
                        insertContractItemList.addAll(this.assemblyContractItemPo(bo.getItemList(), now));
                    }
                    if (!CollectionUtils.isEmpty((Collection)bo.getScopeList())) {
                        insertContractScopeList.addAll(this.assemblyContractScopePo(bo.getScopeList(), now));
                    }
                });
            } else {
                List collect = contractPoList.stream().map(SrmContractPO::getContractCode).collect(Collectors.toList());
                reqBo.getContractList().forEach(contract -> {
                    if (collect.contains(contract.getContractCode())) {
                        updateContractInfoList.add(this.assemblyContractInfoPo((SrmContractInfoBO)contract, now));
                        if (!CollectionUtils.isEmpty((Collection)contract.getItemList())) {
                            updateContractItemList.addAll(this.assemblyContractItemPo(contract.getItemList(), now));
                        }
                        if (!CollectionUtils.isEmpty((Collection)contract.getScopeList())) {
                            updateContractScopeList.addAll(this.assemblyContractScopePo(contract.getScopeList(), now));
                        }
                    } else {
                        insertContractInfoList.add(this.assemblyContractInfoPo((SrmContractInfoBO)contract, now));
                        if (!CollectionUtils.isEmpty((Collection)contract.getItemList())) {
                            insertContractItemList.addAll(this.assemblyContractItemPo(contract.getItemList(), now));
                        }
                        if (!CollectionUtils.isEmpty((Collection)contract.getScopeList())) {
                            insertContractScopeList.addAll(this.assemblyContractScopePo(contract.getScopeList(), now));
                        }
                    }
                });
            }
            this.dealSrmContractSave(insertContractInfoList, insertContractItemList, insertContractScopeList);
            this.dealSrmContractUpdate(updateContractInfoList, updateContractItemList, updateContractScopeList);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void saveLog(SrmContractSyncReqBO reqBo, Date now) {
        ArrayList<SrmContractLogPO> contractLogPos = new ArrayList<SrmContractLogPO>();
        ArrayList<SrmContractItemLogPO> contractItemLogPos = new ArrayList<SrmContractItemLogPO>();
        ArrayList<SrmContractScopeLogPO> contractScopeLogPos = new ArrayList<SrmContractScopeLogPO>();
        reqBo.getContractList().forEach(contract -> {
            contractLogPos.add(this.assemblyContractInfoLogPo((SrmContractInfoBO)contract, now));
            if (!CollectionUtils.isEmpty((Collection)contract.getItemList())) {
                contractItemLogPos.addAll(this.assemblyContractItemLogPo(contract.getItemList(), now));
            }
            if (!CollectionUtils.isEmpty((Collection)contract.getScopeList())) {
                contractScopeLogPos.addAll(this.assemblyContractScopeLogPo(contract.getScopeList(), now));
            }
        });
        if (!CollectionUtils.isEmpty(contractLogPos)) {
            this.srmContractLogMapper.insertBatch(contractLogPos);
        }
        if (!CollectionUtils.isEmpty(contractItemLogPos)) {
            this.srmContractItemLogMapper.insertBatch(contractItemLogPos);
        }
        if (!CollectionUtils.isEmpty(contractScopeLogPos)) {
            this.srmContractScopeLogMapper.insertBatch(contractScopeLogPos);
        }
    }

    private SrmContractPO assemblyContractInfoPo(SrmContractInfoBO bo, Date now) {
        SrmContractPO po = new SrmContractPO();
        po.setContractId(bo.getContractId());
        po.setContractCode(bo.getContractCode());
        po.setContractName(bo.getContractName());
        po.setEcpContractCode(bo.getEcpContractCode());
        po.setEcpContractName(bo.getEcpContractName());
        po.setCustomerContractCode(bo.getCustomerContractCode());
        po.setIsOnlineContract(bo.getIsOnlineContract());
        po.setContractType(bo.getContractType());
        po.setPurchaseType(bo.getPurchaseType());
        po.setCenterPurchaseType(bo.getCenterPurchaseType());
        po.setPurchaseWay(bo.getPurchaseWay());
        po.setVendorSource(bo.getVendorSource());
        po.setVendorId(bo.getVendorId());
        po.setVendorCode(bo.getVendorCode());
        po.setVendorName(bo.getVendorName());
        po.setSignDate(bo.getSignDate());
        po.setEffDate(bo.getEffDate());
        po.setExpDate(bo.getExpDate());
        po.setEcpProjectId(bo.getEcpProjectId());
        po.setPackCode(bo.getPackCode());
        po.setPackName(bo.getPackName());
        po.setIsElePurchase(bo.getIsElePurchase());
        po.setRemark(bo.getRemark());
        po.setPaymentTerms(bo.getPaymentTerms());
        po.setContractAmount(bo.getContractAmount() == null ? null : bo.getContractAmount());
        po.setOrgId(bo.getOrgId());
        po.setOrgCode(bo.getOrgCode());
        po.setOrgName(bo.getOrgName());
        po.setCreatorOrgId(bo.getCreatorOrgId());
        po.setCreatorOrgCode(bo.getCreatorOrgCode());
        po.setCreatorOrgName(bo.getCreatorOrgName());
        po.setPushTime(now);
        po.setPurImpUnitOrgId(bo.getPurImpUnitOrgId());
        po.setPurImpUnitOrgName(bo.getPurImpUnitOrgName());
        return po;
    }

    private List<SrmContractItemPO> assemblyContractItemPo(List<SrmContractItemBO> itemList, Date now) {
        ArrayList<SrmContractItemPO> srmContractItemPoList = new ArrayList<SrmContractItemPO>();
        itemList.forEach(bo -> {
            SrmContractItemPO po = new SrmContractItemPO();
            po.setContractItemId(bo.getContractItemId());
            po.setContractId(bo.getContractId());
            po.setContractItemCode(bo.getContractItemCode());
            po.setContractCode(bo.getContractCode());
            po.setMaterialId(bo.getMaterialId());
            po.setMaterialName(bo.getMaterialName());
            po.setThirdCatalogId(bo.getThirdCatalogId());
            po.setScMaterialCode(bo.getScMaterialCode());
            po.setMeasureName(bo.getMeasureName());
            po.setTaxRate(bo.getTaxRate());
            po.setBuyNumber(bo.getBuyNumber());
            po.setBuyPrice(bo.getBuyPrice());
            po.setComments(bo.getComments());
            po.setModel(bo.getModel());
            po.setFigure(bo.getFigure());
            po.setSpec(bo.getSpec());
            po.setTexture(bo.getTexture());
            po.setWarrantyLevel(bo.getWarrantyLevel());
            po.setNuclearSafetyLevel(bo.getNuclearSafetyLevel());
            po.setProducingArea(bo.getProducingArea());
            po.setPushTime(now);
            srmContractItemPoList.add(po);
        });
        return srmContractItemPoList;
    }

    private List<SrmContractScopePO> assemblyContractScopePo(List<SrmContractScopeBO> scopeList, Date now) {
        ArrayList<SrmContractScopePO> srmContractScopePoList = new ArrayList<SrmContractScopePO>();
        scopeList.forEach(bo -> {
            SrmContractScopePO po = new SrmContractScopePO();
            po.setScopeId(bo.getScopeId());
            po.setContractId(bo.getContractId());
            po.setContractCode(bo.getContractCode());
            po.setOrgCode(bo.getOrgCode());
            po.setOrgId(bo.getOrgId());
            po.setOrgName(bo.getOrgName());
            po.setPushTime(now);
            srmContractScopePoList.add(po);
        });
        return srmContractScopePoList;
    }

    private SrmContractLogPO assemblyContractInfoLogPo(SrmContractInfoBO bo, Date now) {
        SrmContractLogPO po = new SrmContractLogPO();
        po.setLogId(Sequence.getInstance().nextId());
        po.setContractId(bo.getContractId());
        po.setContractCode(bo.getContractCode());
        po.setContractName(bo.getContractName());
        po.setEcpContractCode(bo.getEcpContractCode());
        po.setEcpContractName(bo.getEcpContractName());
        po.setCustomerContractCode(bo.getCustomerContractCode());
        po.setIsOnlineContract(bo.getIsOnlineContract());
        po.setContractType(bo.getContractType());
        po.setPurchaseType(bo.getPurchaseType());
        po.setCenterPurchaseType(bo.getCenterPurchaseType());
        po.setPurchaseWay(bo.getPurchaseWay());
        po.setVendorSource(bo.getVendorSource());
        po.setVendorId(bo.getVendorId());
        po.setVendorCode(bo.getVendorCode());
        po.setVendorName(bo.getVendorName());
        po.setSignDate(bo.getSignDate());
        po.setEffDate(bo.getEffDate());
        po.setExpDate(bo.getExpDate());
        po.setPackCode(bo.getPackCode());
        po.setPackName(bo.getPackName());
        po.setIsElePurchase(bo.getIsElePurchase());
        po.setRemark(bo.getRemark());
        po.setPaymentTerms(bo.getPaymentTerms());
        po.setContractAmount(bo.getContractAmount() == null ? null : bo.getContractAmount());
        po.setOrgId(bo.getOrgId());
        po.setOrgCode(bo.getOrgCode());
        po.setOrgName(bo.getOrgName());
        po.setCreatorOrgId(bo.getCreatorOrgId());
        po.setCreatorOrgCode(bo.getCreatorOrgCode());
        po.setCreatorOrgName(bo.getCreatorOrgName());
        po.setPushTime(now);
        po.setLogTime(now);
        po.setPurImpUnitOrgId(bo.getPurImpUnitOrgId());
        po.setPurImpUnitOrgName(bo.getPurImpUnitOrgName());
        return po;
    }

    private List<SrmContractItemLogPO> assemblyContractItemLogPo(List<SrmContractItemBO> itemList, Date now) {
        ArrayList<SrmContractItemLogPO> srmContractItemPoList = new ArrayList<SrmContractItemLogPO>();
        itemList.forEach(bo -> {
            SrmContractItemLogPO po = new SrmContractItemLogPO();
            po.setLogId(Sequence.getInstance().nextId());
            po.setContractItemId(bo.getContractItemId());
            po.setContractId(bo.getContractId());
            po.setContractItemCode(bo.getContractItemCode());
            po.setContractCode(bo.getContractCode());
            po.setMaterialId(bo.getMaterialId());
            po.setMaterialName(bo.getMaterialName());
            po.setThirdCatalogId(bo.getThirdCatalogId());
            po.setScMaterialCode(bo.getScMaterialCode());
            po.setMeasureName(bo.getMeasureName());
            po.setTaxRate(bo.getTaxRate());
            po.setBuyNumber(bo.getBuyNumber());
            po.setBuyPrice(bo.getBuyPrice());
            po.setComments(bo.getComments());
            po.setModel(bo.getModel());
            po.setFigure(bo.getFigure());
            po.setSpec(bo.getSpec());
            po.setTexture(bo.getTexture());
            po.setWarrantyLevel(bo.getWarrantyLevel());
            po.setNuclearSafetyLevel(bo.getNuclearSafetyLevel());
            po.setProducingArea(bo.getProducingArea());
            po.setPushTime(now);
            po.setLogTime(now);
            srmContractItemPoList.add(po);
        });
        return srmContractItemPoList;
    }

    private List<SrmContractScopeLogPO> assemblyContractScopeLogPo(List<SrmContractScopeBO> scopeList, Date now) {
        ArrayList<SrmContractScopeLogPO> srmContractScopeLogPoList = new ArrayList<SrmContractScopeLogPO>();
        scopeList.forEach(bo -> {
            SrmContractScopeLogPO po = new SrmContractScopeLogPO();
            po.setLogId(Sequence.getInstance().nextId());
            po.setScopeId(bo.getScopeId());
            po.setContractId(bo.getContractId());
            po.setContractCode(bo.getContractCode());
            po.setOrgCode(bo.getOrgCode());
            po.setOrgId(bo.getOrgId());
            po.setOrgName(bo.getOrgName());
            po.setPushTime(now);
            po.setLogTime(now);
            srmContractScopeLogPoList.add(po);
        });
        return srmContractScopeLogPoList;
    }

    private void dealSrmContractSave(List<SrmContractPO> contractInfoList, List<SrmContractItemPO> contractItemList, List<SrmContractScopePO> insertContractScopeList) {
        if (!CollectionUtils.isEmpty(contractInfoList)) {
            this.srmContractMapper.insertBatch(contractInfoList);
            if (!CollectionUtils.isEmpty(contractItemList)) {
                this.srmContractItemMapper.insertBatch(contractItemList);
            }
            if (!CollectionUtils.isEmpty(insertContractScopeList)) {
                this.srmContractScopeMapper.insertBatch(insertContractScopeList);
            }
        }
    }

    private void dealSrmContractUpdate(List<SrmContractPO> contractInfoList, List<SrmContractItemPO> contractItemList, List<SrmContractScopePO> updateContractScopeList) {
        if (!CollectionUtils.isEmpty(contractInfoList)) {
            this.srmContractMapper.updateBatchById(contractInfoList);
            ArrayList<SrmContractItemPO> insertItemList = new ArrayList<SrmContractItemPO>();
            ArrayList<SrmContractItemPO> updateItemList = new ArrayList<SrmContractItemPO>();
            ArrayList<SrmContractItemPO> deleteItemList = new ArrayList<SrmContractItemPO>();
            if (!CollectionUtils.isEmpty(contractItemList)) {
                Map<String, List<SrmContractItemPO>> collectByContractCode = contractItemList.stream().collect(Collectors.groupingBy(SrmContractItemPO::getContractCode));
                collectByContractCode.forEach((contractCode, itemList) -> {
                    List itemCodeList = itemList.stream().map(SrmContractItemPO::getContractItemCode).collect(Collectors.toList());
                    SrmContractItemPO srmContractItemPo = new SrmContractItemPO();
                    srmContractItemPo.setContractCode((String)contractCode);
                    List<SrmContractItemPO> existItemList = this.srmContractItemMapper.getList(srmContractItemPo);
                    if (!CollectionUtils.isEmpty(existItemList)) {
                        Map<String, SrmContractItemPO> exitsItemMap = existItemList.stream().collect(Collectors.toMap(SrmContractItemPO::getContractItemCode, obj -> obj, (a, b) -> a));
                        contractItemList.forEach(item -> {
                            if (exitsItemMap.containsKey(item.getContractItemCode())) {
                                updateItemList.add((SrmContractItemPO)item);
                            } else {
                                insertItemList.add((SrmContractItemPO)item);
                            }
                        });
                        exitsItemMap.keySet().forEach(itemCode -> {
                            if (!itemCodeList.contains(itemCode)) {
                                deleteItemList.add((SrmContractItemPO)exitsItemMap.get(itemCode));
                            }
                        });
                        if (!CollectionUtils.isEmpty((Collection)insertItemList)) {
                            this.srmContractItemMapper.insertBatch(insertItemList);
                        }
                        if (!CollectionUtils.isEmpty((Collection)updateItemList)) {
                            List splitContractItem = ListUtil.split((List)updateItemList, (int)500);
                            splitContractItem.forEach(list -> this.srmContractItemMapper.updateBatchById((List<SrmContractItemPO>)list));
                        }
                        if (!CollectionUtils.isEmpty((Collection)deleteItemList)) {
                            SrmContractItemPO deleteItemPo = new SrmContractItemPO();
                            deleteItemPo.setContractItemCodeIn(deleteItemList.stream().map(SrmContractItemPO::getContractItemCode).collect(Collectors.toList()));
                            deleteItemPo.setContractCode((String)contractCode);
                            this.srmContractItemMapper.deleteBy(deleteItemPo);
                        }
                    } else {
                        this.srmContractItemMapper.insertBatch(contractItemList);
                    }
                });
            }
            SrmContractScopePO srmContractScopePo = new SrmContractScopePO();
            srmContractScopePo.setContractCodeIn(contractInfoList.stream().map(SrmContractPO::getContractCode).collect(Collectors.toList()));
            this.srmContractScopeMapper.deleteBy(srmContractScopePo);
            if (!CollectionUtils.isEmpty(updateContractScopeList)) {
                this.srmContractScopeMapper.insertBatch(updateContractScopeList);
            }
            Map<Long, AgreementPO> agreementMap = this.dealAgreementUpdate(contractInfoList);
            this.dealAgreementItemUpdate(agreementMap, insertItemList, updateItemList, deleteItemList);
            this.dealAgreementScopeUpdate(agreementMap, updateContractScopeList);
        }
    }

    private Map<Long, AgreementPO> dealAgreementUpdate(List<SrmContractPO> contractInfoList) {
        HashMap<Long, AgreementPO> agreementMap = new HashMap<Long, AgreementPO>(16);
        Date now = new Date();
        HashSet<Long> beOverdueAgrIds = new HashSet<Long>();
        contractInfoList.forEach(contract -> {
            AgreementPO agreementPo = new AgreementPO();
            agreementPo.setExtContractCode(contract.getContractCode());
            agreementPo.setRelSystem(AgrEnum.RelSystem.SRM.toString());
            agreementPo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementPo = this.agreementMapper.getModelBy(agreementPo);
            if (agreementPo != null) {
                agreementPo.setAgreementName(contract.getContractName());
                agreementPo.setEntAgreementCode(contract.getCustomerContractCode());
                agreementPo.setEffDate(contract.getEffDate());
                agreementPo.setExpDate(contract.getExpDate());
                agreementPo.setAgreementVariety(contract.getPurchaseType().byteValue());
                agreementPo.setSignTime(contract.getSignDate());
                agreementPo.setUpdateLoginId(0L);
                agreementPo.setUpdateName("srm");
                agreementPo.setUpdateTime(now);
                agreementPo.setExtField1(contract.getPurchaseWay());
                agreementPo.setExtField2(contract.getEcpContractCode());
                agreementPo.setEcpPurType(contract.getCenterPurchaseType().toString());
                agreementPo.setEcpProjectId(contract.getEcpProjectId());
                if (StringUtils.hasText((String)contract.getEcpProjectId())) {
                    agreementPo.setEcpProjectName(contract.getPackCode() + "-" + contract.getPackName());
                }
                agreementPo.setAgreementTentativeAmount(contract.getContractAmount());
                agreementPo.setEcpContractType(contract.getContractType());
                agreementPo.setEcpIsOnlineContract(contract.getIsOnlineContract().byteValue());
                agreementPo.setEcpVendorSource(contract.getVendorSource().toString());
                agreementPo.setEcpProcurement(contract.getIsElePurchase().byteValue());
                agreementPo.setSrmPaymentTerms(contract.getPaymentTerms());
                agreementPo.setSrmComments(contract.getRemark());
                agreementPo.setExtContractId(contract.getContractId());
                agreementPo.setPurImpUnitOrgId(contract.getPurImpUnitOrgId());
                agreementPo.setPurImpUnitOrgName(contract.getPurImpUnitOrgName());
                this.agreementMapper.updateBatchSrmAgreement(Collections.singletonList(agreementPo));
                if (AgrCommConstant.AgreementStatus.BE_OVERDUE.equals(agreementPo.getAgreementStatus()) && agreementPo.getEffDate().before(now) && agreementPo.getExpDate().after(now)) {
                    beOverdueAgrIds.add(agreementPo.getAgreementId());
                }
                agreementMap.put(agreementPo.getAgreementId(), agreementPo);
            }
        });
        if (!CollectionUtils.isEmpty(beOverdueAgrIds)) {
            AgrAgreementStatusChangeAtomReqBO agrAgreementStatusChangeAtomReqBo = new AgrAgreementStatusChangeAtomReqBO();
            agrAgreementStatusChangeAtomReqBo.setAgreementIds(beOverdueAgrIds);
            agrAgreementStatusChangeAtomReqBo.setAgreementStatusPre(AgrCommConstant.AgreementStatus.BE_OVERDUE);
            agrAgreementStatusChangeAtomReqBo.setAgreementStatusPost(AgrCommConstant.AgreementStatus.ENABLE);
            AgrAgreementStatusChangeAtomRspBO agrAgreementStatusChangeAtomRspBo = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(agrAgreementStatusChangeAtomReqBo);
            if (!"0000".equals(agrAgreementStatusChangeAtomRspBo.getRespCode())) {
                throw new BusinessException(agrAgreementStatusChangeAtomRspBo.getRespCode(), "\u5931\u6548\u534f\u8bae\u66f4\u65b0\u4e3a\u751f\u6548\u5931\u8d25." + agrAgreementStatusChangeAtomRspBo.getRespDesc());
            }
        }
        return agreementMap;
    }

    private void dealAgreementItemUpdate(Map<Long, AgreementPO> agreementMap, List<SrmContractItemPO> insertItemList, List<SrmContractItemPO> updateItemList, List<SrmContractItemPO> deleteItemList) {
        if (!CollectionUtils.isEmpty(agreementMap)) {
            agreementMap.forEach((agrId, agrPo) -> {
                AgreementSkuPO agreementSkuPo;
                List<SrmContractItemPO> collectItemByContract;
                if (!CollectionUtils.isEmpty((Collection)insertItemList)) {
                    collectItemByContract = insertItemList.stream().filter(item -> item.getContractCode().equals(agrPo.getExtContractCode())).collect(Collectors.toList());
                    agreementSkuPo = new AgreementSkuPO();
                    agreementSkuPo.setAgreementId((Long)agrId);
                    agreementSkuPo.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
                    agreementSkuPo.setExtItemCodeIn(collectItemByContract.stream().map(SrmContractItemPO::getContractItemCode).collect(Collectors.toList()));
                    List<AgreementSkuPO> agrItemlist = this.agreementSkuMapper.getList(agreementSkuPo);
                    List<SrmContractItemPO> itemInsertList = collectItemByContract;
                    if (!CollectionUtils.isEmpty(agrItemlist)) {
                        List existItemCodes = agrItemlist.stream().map(AgreementSkuPO::getExtItemCode).collect(Collectors.toList());
                        itemInsertList = collectItemByContract.stream().filter(po -> !existItemCodes.contains(po.getContractItemCode())).collect(Collectors.toList());
                        List itemUpdateList = collectItemByContract.stream().filter(po -> existItemCodes.contains(po.getContractItemCode())).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(itemUpdateList)) {
                            updateItemList.addAll(itemUpdateList);
                        }
                    }
                    this.dealItemInsert((AgreementPO)agrPo, itemInsertList);
                }
                if (!CollectionUtils.isEmpty((Collection)updateItemList)) {
                    collectItemByContract = updateItemList.stream().filter(item -> item.getContractCode().equals(agrPo.getExtContractCode())).collect(Collectors.toList());
                    this.dealItemUpdate((AgreementPO)agrPo, collectItemByContract);
                }
                if (!CollectionUtils.isEmpty((Collection)deleteItemList)) {
                    collectItemByContract = deleteItemList.stream().filter(item -> item.getContractCode().equals(agrPo.getExtContractCode())).collect(Collectors.toList());
                    agreementSkuPo = new AgreementSkuPO();
                    agreementSkuPo.setAgreementId((Long)agrId);
                    agreementSkuPo.setExtItemCodeIn(collectItemByContract.stream().map(SrmContractItemPO::getContractItemCode).collect(Collectors.toList()));
                    agreementSkuPo.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
                    List<AgreementSkuPO> list = this.agreementSkuMapper.getList(agreementSkuPo);
                    if (!CollectionUtils.isEmpty(list)) {
                        agreementSkuPo.setUpdateLoginId(0L);
                        agreementSkuPo.setUpdateName("srm");
                        agreementSkuPo.setUpdateTime(new Date());
                        agreementSkuPo.setIsDelete(AgrCommConstant.IsDelete.DELETED);
                        this.agreementSkuMapper.updateBy(agreementSkuPo);
                        AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
                        atomReqBO.setSkuStatus(AgrCommConstant.CommiditySkuStatus.INVALID);
                        atomReqBO.setAgreementSkuIds(list.stream().map(AgreementSkuPO::getAgreementSkuId).collect(Collectors.toSet()));
                        AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
                        if (!"0000".equals(atomRspBO.getRespCode())) {
                            throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
                        }
                    }
                }
            });
        }
    }

    private void dealItemInsert(AgreementPO agreementPo, List<SrmContractItemPO> itemInsertList) {
        if (!CollectionUtils.isEmpty(itemInsertList)) {
            List materialCodes = itemInsertList.stream().map(SrmContractItemPO::getMaterialId).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
            Map<Object, Object> collectByMaterialCode = new HashMap();
            if (!CollectionUtils.isEmpty(materialCodes)) {
                UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                uccQryCommodityTypeByMaterialReqBo.setMaterialCodes(materialCodes);
                UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByMaterial(uccQryCommodityTypeByMaterialReqBo);
                if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                    throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u7f16\u7801\u5931\u8d25");
                }
                collectByMaterialCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getMaterialCode, bo -> bo, (a, b) -> a));
            }
            List<String> catalogCodes = itemInsertList.stream().filter(item -> !StringUtils.hasText((String)item.getMaterialId())).map(SrmContractItemPO::getThirdCatalogId).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
            HashMap collectByCatalogCode = new HashMap();
            if (!CollectionUtils.isEmpty(catalogCodes)) {
                UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                uccQryCommodityTypeByMaterialReqBo.setCatalogCodes(catalogCodes);
                UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByAnyCatalogCode(uccQryCommodityTypeByMaterialReqBo);
                if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                    throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u5206\u7c7b\u5931\u8d25");
                }
                HashMap<String, List> existsCatalogCodes = new HashMap<String, List>(catalogCodes.size());
                catalogCodes.forEach(catalogCode -> {
                    for (UccMaterialCommodityTypeBO typeBo : uccQryCommodityTypeByMaterialRspBo.getMaterialTypes()) {
                        if (!catalogCode.equals(typeBo.getL3CatalogCode()) && !catalogCode.equals(typeBo.getL2CatalogCode())) continue;
                        if (existsCatalogCodes.containsKey(catalogCode)) {
                            ((List)existsCatalogCodes.get(catalogCode)).add(typeBo);
                            continue;
                        }
                        ArrayList<UccMaterialCommodityTypeBO> list = new ArrayList<UccMaterialCommodityTypeBO>();
                        list.add(typeBo);
                        existsCatalogCodes.put((String)catalogCode, list);
                    }
                });
                existsCatalogCodes.forEach((catalogCode, typeBos) -> {
                    UccMaterialCommodityTypeBO reduced = (UccMaterialCommodityTypeBO)typeBos.stream().reduce(typeBos.get(0), this::mergeTypeMap);
                    collectByCatalogCode.put(catalogCode, reduced);
                });
            }
            Map supplierSaleRspBOMap = null;
            if (agreementPo.getContractId() != null && AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(agreementPo.getAgreementMode())) {
                ContractSupplierSaleReqBO contractSupplierSaleReqBO = new ContractSupplierSaleReqBO();
                contractSupplierSaleReqBO.setContractId(agreementPo.getContractId());
                contractSupplierSaleReqBO.setPageNo(-1);
                contractSupplierSaleReqBO.setPageSize(-1);
                RspPage contractSupplierSalePage = this.qryContractSupplierListSaleService.selecContractSupplierList(contractSupplierSaleReqBO);
                if (contractSupplierSalePage != null && !CollectionUtils.isEmpty((Collection)contractSupplierSalePage.getRows())) {
                    supplierSaleRspBOMap = contractSupplierSalePage.getRows().stream().collect(Collectors.toMap(ContractSupplierSaleRspBO::getCategoryId, Function.identity(), (key1, key2) -> key2));
                }
            }
            ArrayList<AgreementSkuPO> insertList = new ArrayList<AgreementSkuPO>();
            ArrayList<AgrAgreementSkuMaterialPO> agrAgreementSkuMaterialPOS = new ArrayList<AgrAgreementSkuMaterialPO>();
            Date now = new Date();
            Map<String, String> conversionScaleMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "MEASURE_CONVERSION_RELATIONSHIPS");
            for (SrmContractItemPO itemPo : itemInsertList) {
                AgreementSkuPO po = new AgreementSkuPO();
                po.setAgreementSkuId(Sequence.getInstance().nextId());
                po.setEffectiveFlag(AgrCommConstant.IsDelete.NORMAL);
                UccMaterialCommodityTypeBO uccMaterialCommodityTypeBo = !StringUtils.hasText((String)itemPo.getMaterialId()) ? (UccMaterialCommodityTypeBO)collectByCatalogCode.get(itemPo.getThirdCatalogId()) : (UccMaterialCommodityTypeBO)collectByMaterialCode.get(itemPo.getMaterialId());
                if (uccMaterialCommodityTypeBo != null && !CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) {
                    List collect = uccMaterialCommodityTypeBo.getTypeIdAndName().keySet().stream().sorted().collect(Collectors.toList());
                    for (Long item2 : collect) {
                        po.setCatalogId(item2.toString());
                        po.setCatalogName((String)uccMaterialCommodityTypeBo.getTypeIdAndName().get(item2));
                        po.setCatalogVariety(uccMaterialCommodityTypeBo.getVariety());
                        if (!StringUtils.hasText((String)itemPo.getThirdCatalogId())) {
                            itemPo.setThirdCatalogId(uccMaterialCommodityTypeBo.getL3CatalogCode());
                        }
                        if (CollectionUtils.isEmpty(supplierSaleRspBOMap)) {
                            po.setContractCovered((int)AgrEnum.YesOrNo.YES.getCode());
                        } else {
                            ContractSupplierSaleRspBO contractSupplierSaleRspBo = (ContractSupplierSaleRspBO)supplierSaleRspBOMap.get(item2);
                            if (contractSupplierSaleRspBo == null) {
                                po.setContractCovered((int)AgrEnum.YesOrNo.NO.getCode());
                                continue;
                            }
                            po.setContractCovered((int)AgrEnum.YesOrNo.YES.getCode());
                        }
                        break;
                    }
                } else {
                    po.setContractCovered((int)AgrEnum.YesOrNo.NO.getCode());
                }
                po.setMaterialMeasureName(uccMaterialCommodityTypeBo.getMeasureName());
                if (StringUtils.hasText((String)itemPo.getMaterialId())) {
                    if (Objects.equals(itemPo.getMeasureName(), po.getMaterialMeasureName())) {
                        po.setSupplyCycle(0);
                        po.setUnitOfMeasureScale(1);
                        po.setMaterialUnitOfMeasureScale(1);
                    } else {
                        String conversionScale = conversionScaleMap.get(itemPo.getMeasureName() + ":" + po.getMaterialMeasureName());
                        if (StringUtils.hasText((String)conversionScale)) {
                            String[] split = conversionScale.split(":");
                            if (split.length == 2) {
                                po.setUnitOfMeasureScale(Integer.valueOf(split[0]));
                                po.setMaterialUnitOfMeasureScale(Integer.valueOf(split[1]));
                                po.setSupplyCycle(0);
                            }
                        } else {
                            po.setEffectiveFlag(AgrCommConstant.IsDelete.DELETED);
                            AgrAgreementSkuMaterialPO agrAgreementSkuMaterialPO = new AgrAgreementSkuMaterialPO();
                            agrAgreementSkuMaterialPO.setSkuChangeId(Sequence.getInstance().nextId());
                            agrAgreementSkuMaterialPO.setAgreementId(agreementPo.getAgreementId());
                            agrAgreementSkuMaterialPO.setAgreementSkuId(po.getAgreementSkuId());
                            agrAgreementSkuMaterialPO.setCreateLoginId(0L);
                            agrAgreementSkuMaterialPO.setCreateName("srm");
                            agrAgreementSkuMaterialPO.setCreateTime(now);
                            agrAgreementSkuMaterialPO.setIsDelete(0);
                            agrAgreementSkuMaterialPO.setThirdCatalogId(po.getThirdCatalogId());
                            agrAgreementSkuMaterialPO.setCatalogId(po.getCatalogId());
                            agrAgreementSkuMaterialPO.setCatalogName(po.getCatalogName());
                            agrAgreementSkuMaterialPO.setMaterialId(itemPo.getMaterialId());
                            agrAgreementSkuMaterialPO.setMaterialName(itemPo.getMaterialName());
                            agrAgreementSkuMaterialPO.setMaterialLongName(itemPo.getMaterialName());
                            agrAgreementSkuMaterialPOS.add(agrAgreementSkuMaterialPO);
                        }
                    }
                } else {
                    po.setUnitOfMeasureScale(1);
                    po.setMaterialUnitOfMeasureScale(1);
                }
                po.setFreezeFlag(AgrCommConstant.IsDelete.NORMAL);
                po.setAgreementId(agreementPo.getAgreementId());
                po.setAgreementVersion(agreementPo.getAgreementVersion());
                po.setMaterialId(itemPo.getMaterialId());
                po.setMaterialName(itemPo.getMaterialName());
                po.setModel(itemPo.getModel());
                po.setFigure(itemPo.getFigure());
                po.setSpec(itemPo.getSpec());
                po.setTexture(itemPo.getTexture());
                po.setMeasureName(itemPo.getMeasureName());
                po.setBuyNumber(itemPo.getBuyNumber());
                try {
                    po.setBuyPrice(MoneyUtil.b2l(itemPo.getBuyPrice()));
                    po.setBuyPriceSum(MoneyUtil.b2l(itemPo.getBuyNumber().multiply(itemPo.getBuyPrice())));
                    po.setSalePrice(po.getBuyPrice());
                    po.setSalePriceSum(po.getBuyPriceSum());
                }
                catch (Exception conversionScale) {
                    // empty catch block
                }
                po.setMarkupRate(0.0);
                po.setSupplierId(agreementPo.getSupplierId());
                po.setVendorId(agreementPo.getVendorId());
                po.setVendorName(agreementPo.getVendorName());
                po.setTaxRate(itemPo.getTaxRate().byteValue());
                po.setCreateLoginId(0L);
                po.setCreateName("srm");
                po.setCreateTime(now);
                po.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                po.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
                po.setWarrantyLevel(itemPo.getWarrantyLevel());
                po.setNuclearSafetyLevel(itemPo.getNuclearSafetyLevel());
                po.setScMaterialCode(itemPo.getScMaterialCode());
                po.setThirdCatalogId(itemPo.getThirdCatalogId());
                po.setComments(itemPo.getComments());
                po.setOrderedQuantity(BigDecimal.ZERO);
                po.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
                po.setExtItemCode(itemPo.getContractItemCode());
                po.setExtItemId(itemPo.getContractItemId());
                po.setProducingArea(itemPo.getProducingArea());
                po.setIsOil(AgrEnum.YesOrNo.NO.getCode());
                po.setItemName(StringUtils.hasText((String)po.getMaterialName()) ? po.getMaterialName() : po.getCatalogName());
                insertList.add(po);
            }
            List commodityTypeIds = insertList.stream().map(AgreementSkuPO::getCatalogId).filter(StringUtils::hasText).map(Long::valueOf).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(commodityTypeIds)) {
                CnncQryCommodityTypeListAbilityReqBo cnncQryCommodityTypeListAbilityReqBo = new CnncQryCommodityTypeListAbilityReqBo();
                cnncQryCommodityTypeListAbilityReqBo.setCommodityTypeIds(commodityTypeIds);
                cnncQryCommodityTypeListAbilityReqBo.setPageSize(-1);
                cnncQryCommodityTypeListAbilityReqBo.setPageNo(-1);
                cnncQryCommodityTypeListAbilityReqBo.setQueryHaveSku(Boolean.valueOf(false));
                CnncQryCommodityTypeListAbilityRspBo cnncQryCommodityTypeListAbilityRspBo = this.cnncQryCommodityTypeListAbilityService.qryCommodityTypeList(cnncQryCommodityTypeListAbilityReqBo);
                if (!"0000".equals(cnncQryCommodityTypeListAbilityRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)cnncQryCommodityTypeListAbilityRspBo.getRows())) {
                    throw new BusinessException("8888", "\u56db\u7ea7\u5206\u7c7b\u5217\u8868\u67e5\u8be2\u5931\u8d25");
                }
                List commodityTypeListAbilityBos = JSONArray.parseArray((String)JSONArray.toJSONString((Object)cnncQryCommodityTypeListAbilityRspBo.getRows()), CnncQryCommodityTypeListAbilityBo.class);
                Map<Long, CnncQryCommodityTypeListAbilityBo> commodityTypeListAbilityBoMap = commodityTypeListAbilityBos.stream().collect(Collectors.toMap(CnncQryCommodityTypeListAbilityBo::getCommodityTypeId, obj -> obj, (a, b) -> a));
                insertList.stream().filter(agreementSkuPO -> StringUtils.hasText((String)agreementSkuPO.getCatalogId()) && agreementSkuPO.getTaxRate() != null).forEach(agreementSkuPO -> {
                    CnncQryCommodityTypeListAbilityBo cnncQryCommodityTypeListAbilityBo = (CnncQryCommodityTypeListAbilityBo)commodityTypeListAbilityBoMap.get(Long.parseLong(agreementSkuPO.getCatalogId()));
                    if (null != cnncQryCommodityTypeListAbilityBo) {
                        agreementSkuPO.setTaxCatalog(cnncQryCommodityTypeListAbilityBo.getRateTypeCode());
                    }
                });
            }
            if (!CollectionUtils.isEmpty(agrAgreementSkuMaterialPOS)) {
                this.agrAgreementSkuMaterialMapper.insertBatch(agrAgreementSkuMaterialPOS);
            }
            if (!CollectionUtils.isEmpty(insertList)) {
                this.agreementSkuMapper.insertBatch(insertList);
            }
        }
    }

    private void dealItemUpdate(AgreementPO agreementPo, List<SrmContractItemPO> itemUpdateList) {
        List materialCodes = itemUpdateList.stream().map(SrmContractItemPO::getMaterialId).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
        Map<Object, Object> collectByMaterialCode = new HashMap();
        if (!CollectionUtils.isEmpty(materialCodes)) {
            UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
            uccQryCommodityTypeByMaterialReqBo.setMaterialCodes(materialCodes);
            UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByMaterial(uccQryCommodityTypeByMaterialReqBo);
            if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u7f16\u7801\u5931\u8d25");
            }
            collectByMaterialCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getMaterialCode, bo -> bo, (a, b) -> a));
        }
        List<String> catalogCodes = itemUpdateList.stream().filter(item -> !StringUtils.hasText((String)item.getMaterialId())).map(SrmContractItemPO::getThirdCatalogId).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
        HashMap collectByCatalogCode = new HashMap();
        if (!CollectionUtils.isEmpty(catalogCodes)) {
            UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
            uccQryCommodityTypeByMaterialReqBo.setCatalogCodes(catalogCodes);
            UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByAnyCatalogCode(uccQryCommodityTypeByMaterialReqBo);
            if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u5206\u7c7b\u5931\u8d25");
            }
            HashMap<String, List> existsCatalogCodes = new HashMap<String, List>(catalogCodes.size());
            catalogCodes.forEach(catalogCode -> {
                for (UccMaterialCommodityTypeBO typeBo : uccQryCommodityTypeByMaterialRspBo.getMaterialTypes()) {
                    if (!catalogCode.equals(typeBo.getL3CatalogCode()) && !catalogCode.equals(typeBo.getL2CatalogCode())) continue;
                    if (existsCatalogCodes.containsKey(catalogCode)) {
                        ((List)existsCatalogCodes.get(catalogCode)).add(typeBo);
                        continue;
                    }
                    ArrayList<UccMaterialCommodityTypeBO> list = new ArrayList<UccMaterialCommodityTypeBO>();
                    list.add(typeBo);
                    existsCatalogCodes.put((String)catalogCode, list);
                }
            });
            existsCatalogCodes.forEach((catalogCode, typeBos) -> {
                UccMaterialCommodityTypeBO reduced = (UccMaterialCommodityTypeBO)typeBos.stream().reduce(typeBos.get(0), this::mergeTypeMap);
                collectByCatalogCode.put(catalogCode, reduced);
            });
        }
        AgreementSkuPO agreementSkuPo = new AgreementSkuPO();
        agreementSkuPo.setAgreementId(agreementPo.getAgreementId());
        agreementSkuPo.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
        agreementSkuPo.setExtItemCodeIn(itemUpdateList.stream().map(SrmContractItemPO::getContractItemCode).collect(Collectors.toList()));
        List<AgreementSkuPO> list = this.agreementSkuMapper.getList(agreementSkuPo);
        if (!CollectionUtils.isEmpty(list)) {
            AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO;
            AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO;
            List split;
            List commodityTypeIds;
            Map<String, List<AgreementSkuPO>> agreementSkuPOMap = list.stream().collect(Collectors.groupingBy(AgreementSkuPO::getExtItemCode));
            Date now = new Date();
            ArrayList<AgreementSkuPO> updateList = new ArrayList<AgreementSkuPO>();
            ArrayList<AgreementSkuPO> updateMaterialList = new ArrayList<AgreementSkuPO>();
            ArrayList<AgrskuChangePriceBO> skuChangePriceBOs = new ArrayList<AgrskuChangePriceBO>();
            ArrayList<SrmContractItemPO> itemInsertList = new ArrayList<SrmContractItemPO>();
            ArrayList<AgrAgreementSkuOldMaterialPO> agrAgreementSkuOldMaterialPOs = new ArrayList<AgrAgreementSkuOldMaterialPO>();
            ArrayList<AgrAgreementSkuMaterialPO> agrAgreementSkuMaterialPOS = new ArrayList<AgrAgreementSkuMaterialPO>();
            ArrayList<AgrMaterialSyncBO> agrMaterialSyncBOs = new ArrayList<AgrMaterialSyncBO>();
            Map<String, String> conversionScaleMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "MEASURE_CONVERSION_RELATIONSHIPS");
            for (SrmContractItemPO itemUpdate : itemUpdateList) {
                List<AgreementSkuPO> agreementSkuPos = agreementSkuPOMap.get(itemUpdate.getContractItemCode());
                UccMaterialCommodityTypeBO uccMaterialCommodityTypeBo = !StringUtils.hasText((String)itemUpdate.getMaterialId()) ? (UccMaterialCommodityTypeBO)collectByCatalogCode.get(itemUpdate.getThirdCatalogId()) : (UccMaterialCommodityTypeBO)collectByMaterialCode.get(itemUpdate.getMaterialId());
                if (uccMaterialCommodityTypeBo != null && !CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) {
                    List collect = uccMaterialCommodityTypeBo.getTypeIdAndName().keySet().stream().sorted().collect(Collectors.toList());
                    Iterator iterator = collect.iterator();
                    while (iterator.hasNext()) {
                        Long item2 = (Long)iterator.next();
                        itemUpdate.setCatalogId(item2.toString());
                        itemUpdate.setCatalogName((String)uccMaterialCommodityTypeBo.getTypeIdAndName().get(item2));
                        itemUpdate.setMaterialLongName(uccMaterialCommodityTypeBo.getLongDesc());
                    }
                    if (!StringUtils.hasText((String)itemUpdate.getThirdCatalogId())) {
                        itemUpdate.setThirdCatalogId(uccMaterialCommodityTypeBo.getL3CatalogCode());
                    }
                    itemUpdate.setMaterialMeasureName(uccMaterialCommodityTypeBo.getMeasureName());
                }
                if (!CollectionUtils.isEmpty(agreementSkuPos)) {
                    for (AgreementSkuPO po : agreementSkuPos) {
                        boolean changeFlag = false;
                        boolean effectiveFlag = false;
                        Byte preEffectiveFlag = po.getEffectiveFlag();
                        AgrskuChangePriceBO bo2 = new AgrskuChangePriceBO();
                        bo2.setAgreementId(po.getAgreementId());
                        bo2.setAgreementSkuId(po.getAgreementSkuId());
                        bo2.setMarkupRate(Double.valueOf(0.0));
                        bo2.setMarkupPrice(BigDecimal.ZERO);
                        po.setExtItemId(itemUpdate.getContractItemId());
                        boolean materialChangFlag = false;
                        if (StringUtils.hasText((String)po.getMaterialId())) {
                            boolean bl = materialChangFlag = !Objects.equals(po.getMaterialId(), itemUpdate.getMaterialId());
                            if (materialChangFlag && AgrCommConstant.IsDelete.NORMAL.equals(preEffectiveFlag)) {
                                AgrAgreementSkuOldMaterialPO agrAgreementSkuOldMaterialPO = new AgrAgreementSkuOldMaterialPO();
                                agrAgreementSkuOldMaterialPO.setAgreementId(po.getAgreementId());
                                agrAgreementSkuOldMaterialPO.setAgreementSkuId(po.getAgreementSkuId());
                                agrAgreementSkuOldMaterialPO.setMaterialCode(po.getMaterialId());
                                agrAgreementSkuOldMaterialPO.setCreateTime(now);
                                agrAgreementSkuOldMaterialPOs.add(agrAgreementSkuOldMaterialPO);
                                if (Objects.equals(itemUpdate.getMeasureName(), uccMaterialCommodityTypeBo.getMeasureName())) {
                                    effectiveFlag = true;
                                    po.setUnitOfMeasureScale(1);
                                    po.setMaterialUnitOfMeasureScale(1);
                                } else {
                                    String conversionScale = conversionScaleMap.get(itemUpdate.getMeasureName() + ":" + po.getMaterialMeasureName());
                                    if (StringUtils.hasText((String)conversionScale)) {
                                        String[] split2 = conversionScale.split(":");
                                        if (split2.length == 2) {
                                            effectiveFlag = true;
                                            po.setUnitOfMeasureScale(Integer.valueOf(split2[0]));
                                            po.setMaterialUnitOfMeasureScale(Integer.valueOf(split2[1]));
                                        }
                                    } else {
                                        effectiveFlag = false;
                                        AgrAgreementSkuMaterialPO agrAgreementSkuMaterialPO = new AgrAgreementSkuMaterialPO();
                                        agrAgreementSkuMaterialPO.setSkuChangeId(Sequence.getInstance().nextId());
                                        agrAgreementSkuMaterialPO.setAgreementId(po.getAgreementId());
                                        agrAgreementSkuMaterialPO.setAgreementSkuId(po.getAgreementSkuId());
                                        agrAgreementSkuMaterialPO.setCreateLoginId(0L);
                                        agrAgreementSkuMaterialPO.setCreateName("srm");
                                        agrAgreementSkuMaterialPO.setCreateTime(now);
                                        agrAgreementSkuMaterialPO.setIsDelete(0);
                                        agrAgreementSkuMaterialPO.setOldThirdCatalogId(po.getThirdCatalogId());
                                        agrAgreementSkuMaterialPO.setOldCatalogId(po.getCatalogId());
                                        agrAgreementSkuMaterialPO.setOldCatalogName(po.getCatalogName());
                                        agrAgreementSkuMaterialPO.setOldMaterialId(po.getMaterialId());
                                        agrAgreementSkuMaterialPO.setOldMaterialName(po.getMaterialName());
                                        agrAgreementSkuMaterialPO.setOldMaterialLongName(po.getMaterialName());
                                        agrAgreementSkuMaterialPO.setThirdCatalogId(itemUpdate.getThirdCatalogId());
                                        agrAgreementSkuMaterialPO.setCatalogId(itemUpdate.getCatalogId());
                                        agrAgreementSkuMaterialPO.setCatalogName(itemUpdate.getCatalogName());
                                        agrAgreementSkuMaterialPO.setMaterialId(itemUpdate.getMaterialId());
                                        agrAgreementSkuMaterialPO.setMaterialName(itemUpdate.getMaterialName());
                                        agrAgreementSkuMaterialPO.setMaterialLongName(itemUpdate.getMaterialName());
                                        po.setExtField6(agrAgreementSkuMaterialPO.getSkuChangeId().toString());
                                        agrAgreementSkuMaterialPOS.add(agrAgreementSkuMaterialPO);
                                    }
                                }
                            }
                        }
                        po.setMaterialId(itemUpdate.getMaterialId());
                        po.setMaterialName(itemUpdate.getMaterialName());
                        po.setThirdCatalogId(itemUpdate.getThirdCatalogId());
                        po.setScMaterialCode(itemUpdate.getScMaterialCode());
                        po.setMeasureName(itemUpdate.getMeasureName());
                        if (po.getTaxRate().byteValue() != itemUpdate.getTaxRate().byteValue()) {
                            po.setTaxRate(itemUpdate.getTaxRate().byteValue());
                            po.setTaxCatalog("");
                        }
                        if (po.getBuyNumber().compareTo(itemUpdate.getBuyNumber()) != 0) {
                            changeFlag = true;
                            bo2.setBuyNumber(itemUpdate.getBuyNumber().subtract(po.getBuyNumber()));
                        }
                        po.setBuyNumber(itemUpdate.getBuyNumber());
                        try {
                            Long buyPriceLong = MoneyUtil.b2l(itemUpdate.getBuyPrice());
                            if (!po.getBuyPrice().equals(buyPriceLong)) {
                                changeFlag = true;
                                bo2.setBuyPrice(buyPriceLong);
                                bo2.setSalePrice(buyPriceLong);
                            }
                            po.setBuyPrice(buyPriceLong);
                            po.setBuyPriceSum(MoneyUtil.b2l(itemUpdate.getBuyNumber().multiply(itemUpdate.getBuyPrice())));
                            po.setSalePrice(po.getBuyPrice());
                            po.setSalePriceSum(po.getBuyPriceSum());
                        }
                        catch (Exception buyPriceLong) {
                            // empty catch block
                        }
                        po.setComments(itemUpdate.getComments());
                        po.setModel(itemUpdate.getModel());
                        po.setFigure(itemUpdate.getFigure());
                        po.setSpec(itemUpdate.getSpec());
                        po.setTexture(itemUpdate.getTexture());
                        po.setWarrantyLevel(itemUpdate.getWarrantyLevel());
                        po.setNuclearSafetyLevel(itemUpdate.getNuclearSafetyLevel());
                        po.setProducingArea(itemUpdate.getProducingArea());
                        po.setUpdateLoginId(0L);
                        po.setUpdateName("srm");
                        po.setUpdateTime(now);
                        po.setEffectiveFlag(AgrCommConstant.IsDelete.NORMAL);
                        if (materialChangFlag && AgrCommConstant.IsDelete.NORMAL.equals(preEffectiveFlag)) {
                            if (effectiveFlag) {
                                AgrMaterialSyncBO agrMaterialSyncBO = new AgrMaterialSyncBO();
                                agrMaterialSyncBO.setAgreementId(po.getAgreementId());
                                agrMaterialSyncBO.setAgreementDetailId(po.getAgreementSkuId());
                                agrMaterialSyncBO.setMaterialCode(po.getMaterialId());
                                if (!StringUtils.isEmpty((Object)itemUpdate.getCatalogId())) {
                                    agrMaterialSyncBO.setCommodityTypeId(Long.valueOf(Long.parseLong(itemUpdate.getCatalogId())));
                                }
                                agrMaterialSyncBOs.add(agrMaterialSyncBO);
                                po.setCatalogId(itemUpdate.getCatalogId());
                                po.setCatalogName(itemUpdate.getCatalogName());
                                po.setSupplyCycle(0);
                                po.setMeasureName(itemUpdate.getMeasureName());
                                po.setMaterialMeasureName(itemUpdate.getMaterialMeasureName());
                                updateMaterialList.add(po);
                            } else {
                                updateList.add(po);
                            }
                        } else {
                            if (!Objects.equals(AgrCommConstant.IsDelete.DELETED, preEffectiveFlag)) {
                                po.setEffectiveFlag(AgrCommConstant.IsDelete.NORMAL);
                            }
                            updateList.add(po);
                        }
                        if (!changeFlag) continue;
                        skuChangePriceBOs.add(bo2);
                    }
                    continue;
                }
                itemInsertList.add(itemUpdate);
            }
            if (!CollectionUtils.isEmpty(updateMaterialList) && !CollectionUtils.isEmpty(commodityTypeIds = updateMaterialList.stream().map(AgreementSkuPO::getCatalogId).filter(StringUtils::hasText).map(Long::valueOf).distinct().collect(Collectors.toList()))) {
                CnncQryCommodityTypeListAbilityReqBo cnncQryCommodityTypeListAbilityReqBo = new CnncQryCommodityTypeListAbilityReqBo();
                cnncQryCommodityTypeListAbilityReqBo.setCommodityTypeIds(commodityTypeIds);
                cnncQryCommodityTypeListAbilityReqBo.setPageSize(-1);
                cnncQryCommodityTypeListAbilityReqBo.setPageNo(-1);
                cnncQryCommodityTypeListAbilityReqBo.setQueryHaveSku(Boolean.valueOf(false));
                CnncQryCommodityTypeListAbilityRspBo cnncQryCommodityTypeListAbilityRspBo = this.cnncQryCommodityTypeListAbilityService.qryCommodityTypeList(cnncQryCommodityTypeListAbilityReqBo);
                if (!"0000".equals(cnncQryCommodityTypeListAbilityRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)cnncQryCommodityTypeListAbilityRspBo.getRows())) {
                    throw new BusinessException("8888", "\u56db\u7ea7\u5206\u7c7b\u5217\u8868\u67e5\u8be2\u5931\u8d25");
                }
                List commodityTypeListAbilityBos = JSONArray.parseArray((String)JSONArray.toJSONString((Object)cnncQryCommodityTypeListAbilityRspBo.getRows()), CnncQryCommodityTypeListAbilityBo.class);
                Map<Long, CnncQryCommodityTypeListAbilityBo> commodityTypeListAbilityBoMap = commodityTypeListAbilityBos.stream().collect(Collectors.toMap(CnncQryCommodityTypeListAbilityBo::getCommodityTypeId, obj -> obj, (a, b) -> a));
                updateMaterialList.stream().filter(agreementSkuPO -> StringUtils.hasText((String)agreementSkuPO.getCatalogId()) && agreementSkuPO.getTaxRate() != null).forEach(agreementSkuPO -> {
                    CnncQryCommodityTypeListAbilityBo cnncQryCommodityTypeListAbilityBo = (CnncQryCommodityTypeListAbilityBo)commodityTypeListAbilityBoMap.get(Long.parseLong(agreementSkuPO.getCatalogId()));
                    if (null != cnncQryCommodityTypeListAbilityBo) {
                        agreementSkuPO.setTaxCatalog(cnncQryCommodityTypeListAbilityBo.getRateTypeCode());
                    }
                });
            }
            if (!CollectionUtils.isEmpty(agrAgreementSkuMaterialPOS)) {
                this.agrAgreementSkuMaterialMapper.insertBatch(agrAgreementSkuMaterialPOS);
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                split = ListUtil.split(updateList, (int)500);
                split.forEach(splistList -> this.agreementSkuMapper.updateBatchSrmAgreement((List<AgreementSkuPO>)splistList));
            }
            if (!CollectionUtils.isEmpty(updateMaterialList)) {
                split = ListUtil.split(updateMaterialList, (int)500);
                split.forEach(splistList -> this.agreementSkuMapper.updateBatchAgreementSku((List<AgreementSkuPO>)splistList));
            }
            if (!CollectionUtils.isEmpty(agrAgreementSkuOldMaterialPOs)) {
                split = ListUtil.split(agrAgreementSkuOldMaterialPOs, (int)500);
                split.forEach(splistList -> this.agrAgreementSkuOldMaterialMapper.insertBatch((List<AgrAgreementSkuOldMaterialPO>)splistList));
            }
            if (!CollectionUtils.isEmpty(skuChangePriceBOs)) {
                atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
                atomReqBO.setSkuChangePriceBOs(skuChangePriceBOs);
                atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    throw new BusinessException(atomRspBO.getRespCode(), "\u66f4\u65b0\u5173\u8054\u5546\u54c1\u4fe1\u606f\u5f02\u5e38!" + atomRspBO.getRespDesc());
                }
            }
            if (!CollectionUtils.isEmpty(agrMaterialSyncBOs)) {
                atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
                atomReqBO.setAgrMaterialSyncBOs(agrMaterialSyncBOs);
                atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
                if (!"0000".equals(atomRspBO.getRespCode())) {
                    throw new BusinessException(atomRspBO.getRespCode(), "\u66f4\u65b0\u5173\u8054\u5546\u54c1\u4fe1\u606f\u5f02\u5e38!" + atomRspBO.getRespDesc());
                }
            }
            if (!CollectionUtils.isEmpty(itemInsertList)) {
                this.dealItemInsert(agreementPo, itemInsertList);
            }
        } else {
            this.dealItemInsert(agreementPo, itemUpdateList);
        }
    }

    private void dealAgreementScopeUpdate(Map<Long, AgreementPO> agreementMap, List<SrmContractScopePO> updateContractScopeList) {
        if (!CollectionUtils.isEmpty(agreementMap)) {
            AgreementScopePO deleteScopePo = new AgreementScopePO();
            deleteScopePo.setAgreementIds(agreementMap.keySet());
            deleteScopePo.setIsDelete(AgrCommConstant.IsDelete.DELETED);
            this.agreementScopeMapper.updateBy(deleteScopePo);
            ArrayList agreementIds = new ArrayList();
            agreementMap.values().forEach(agreement -> {
                List<SrmContractScopePO> collect = updateContractScopeList.stream().filter(scope -> Objects.equals(agreement.getExtContractCode(), scope.getContractCode())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collect)) {
                    ArrayList<AgreementScopePO> agreementScopePos = new ArrayList<AgreementScopePO>();
                    collect.forEach(scope -> {
                        AgreementScopePO scopePo = new AgreementScopePO();
                        scopePo.setScopeId(Sequence.getInstance().nextId());
                        scopePo.setAgreementId(agreement.getAgreementId());
                        scopePo.setAgreementVersion(agreement.getAgreementVersion());
                        scopePo.setSupplierId(agreement.getSupplierId());
                        scopePo.setScopeType(agreement.getScopeType());
                        scopePo.setScopeCode(scope.getOrgId());
                        scopePo.setScopeName(scope.getOrgName());
                        scopePo.setScopeMode(AgrCommConstant.ScopeMode.THIS_AND_ALL_UNITS_AND_DEPARTMENTS_BELOW);
                        scopePo.setVisible((int)AgrEnum.YesOrNo.NO.getCode());
                        scopePo.setCreateLoginId(0L);
                        scopePo.setCreateName("srm");
                        scopePo.setCreateTime(new Date());
                        scopePo.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                        agreementScopePos.add(scopePo);
                    });
                    if (!CollectionUtils.isEmpty(agreementScopePos)) {
                        this.agreementScopeMapper.insertBatch(agreementScopePos);
                        agreementIds.add(agreement.getAgreementId());
                    }
                }
            });
            if (!CollectionUtils.isEmpty(agreementIds)) {
                AgrAgreementScopeSyncQueueReqBO agrAgreementScopeSyncQueueReqBo = new AgrAgreementScopeSyncQueueReqBO();
                agrAgreementScopeSyncQueueReqBo.setAgreementIds(agreementIds);
                this.agrAgreementScopeSyncQueueBusiService.addScopeSyncQueue(agrAgreementScopeSyncQueueReqBo);
            }
        }
    }

    private UccMaterialCommodityTypeBO mergeTypeMap(UccMaterialCommodityTypeBO bo1, UccMaterialCommodityTypeBO bo2) {
        if (bo1.getTypeIdAndName() == null) {
            bo1.setTypeIdAndName(new LinkedHashMap());
        }
        if (!CollectionUtils.isEmpty((Map)bo2.getTypeIdAndName())) {
            bo2.getTypeIdAndName().forEach((typeId, typeName) -> {
                if (!bo1.getTypeIdAndName().containsKey(typeId)) {
                    bo1.getTypeIdAndName().put(typeId, typeName);
                }
            });
        }
        return bo1;
    }

    private Map<String, CnncUccEMdmCatalogAllBO> getUccCatalogPath(List<Long> typeIds) {
        HashMap<String, CnncUccEMdmCatalogAllBO> catalogAllBOMap = new HashMap<String, CnncUccEMdmCatalogAllBO>();
        CnncCatalogPathQryAbilityReqBo cnncCatalogPathQryAbilityReqBo = new CnncCatalogPathQryAbilityReqBo();
        cnncCatalogPathQryAbilityReqBo.setTypeIds(typeIds);
        CnncCatalogPathQryAbilityRspBo cnncCatalogPathQryAbilityRspBo = this.cnncCatalogPathQryAbilityService.catalogPathQry(cnncCatalogPathQryAbilityReqBo);
        if (!"0000".equals(cnncCatalogPathQryAbilityRspBo.getRespCode())) {
            throw new ZTBusinessException("\u5546\u54c1\u7c7b\u76ee\u67e5\u8be2\u9519\u8bef!");
        }
        cnncCatalogPathQryAbilityRspBo.getCatalogList().forEach(cnncUccEMdmCatalogAllBO -> catalogAllBOMap.put(cnncUccEMdmCatalogAllBO.getCommodityTypeId().toString(), (CnncUccEMdmCatalogAllBO)cnncUccEMdmCatalogAllBO));
        return catalogAllBOMap;
    }
}

