/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.extend.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.common.bo.AgrAgreementSkuBO;
import com.tydic.agreement.common.bo.AgrDicDictionaryBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.OpsContractItemMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.agreement.dao.po.OpsContractItemPO;
import com.tydic.agreement.extend.ability.CnncAgrBatchImportOpsAgreementSkuAbilityService;
import com.tydic.agreement.extend.ability.bo.CnncAgrBatchImportOpsAgreementSkuAbilityReqBO;
import com.tydic.agreement.extend.ability.bo.CnncAgrBatchImportOpsAgreementSkuAbilityRspBO;
import com.tydic.agreement.extend.busi.CnncAgrBatchImportOpsAgreementSkuBusiService;
import com.tydic.agreement.extend.busi.bo.CnncAgrBatchImportOpsAgreementSkuBusiReqBO;
import com.tydic.agreement.extend.busi.bo.CnncAgrBatchImportOpsAgreementSkuBusiRspBO;
import com.tydic.agreement.extend.common.AgrExtCommonConstant;
import com.tydic.agreement.utils.ExcelUtils;
import com.tydic.agreement.utils.HttpUtil;
import com.tydic.commodity.bo.busi.UccEMdmCatalogBO;
import com.tydic.commodity.enumType.YesNoEnum;
import com.tydic.uccext.bo.CnncCatalogListQueryAbilityReqBO;
import com.tydic.uccext.bo.CnncCatalogListQueryAbilityRspBO;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityReqBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityRspBo;
import com.tydic.uccext.bo.UccCommodityTypeBO;
import com.tydic.uccext.bo.UccExtQryCommodityTypeOfTheSameCatalogAbilityReqBO;
import com.tydic.uccext.bo.UccExtQryCommodityTypeOfTheSameCatalogAbilityRspBO;
import com.tydic.uccext.bo.UccMaterialCommodityTypeBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialReqBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialRspBO;
import com.tydic.uccext.service.CnncCatalogListQueryAbilityService;
import com.tydic.uccext.service.CnncQryCommodityTypeListAbilityService;
import com.tydic.uccext.service.UccExtQryCommodityTypeOfTheSameCatalogAbilityService;
import com.tydic.uccext.service.UccQryCommodityTypeByMaterialService;
import com.tydic.umcext.ability.taxCode.UmcQryTaxCodeListService;
import com.tydic.umcext.ability.taxCode.bo.TaxCodeRateBO;
import com.tydic.umcext.ability.taxCode.bo.UmcQryTaxCodeListReqBO;
import com.tydic.umcext.ability.taxCode.bo.UmcQryTaxCodeListRspBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.extend.ability.CnncAgrBatchImportOpsAgreementSkuAbilityService"})
public class CnncAgrBatchImportOpsAgreementSkuAbilityServiceImpl
implements CnncAgrBatchImportOpsAgreementSkuAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CnncAgrBatchImportOpsAgreementSkuAbilityServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private OpsContractItemMapper opsContractItemMapper;
    @Autowired
    private UmcQryTaxCodeListService umcQryTaxCodeListService;
    @Autowired
    private CnncAgrBatchImportOpsAgreementSkuBusiService cnncAgrBatchImportOpsAgreementSkuBusiService;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private CnncQryCommodityTypeListAbilityService cnncQryCommodityTypeListAbilityService;
    @Autowired
    private UccExtQryCommodityTypeOfTheSameCatalogAbilityService uccExtQryCommodityTypeOfTheSameCatalogAbilityService;
    @Autowired
    private UccQryCommodityTypeByMaterialService uccQryCommodityTypeByMaterialService;
    @Autowired
    private CnncCatalogListQueryAbilityService cnncCatalogListQueryAbilityService;

    @PostMapping(value={"dealImportOpsAgreementSku"})
    public CnncAgrBatchImportOpsAgreementSkuAbilityRspBO dealImportOpsAgreementSku(@RequestBody CnncAgrBatchImportOpsAgreementSkuAbilityReqBO reqBo) {
        List cnncQryCommodityTypeListAbilityBos;
        CnncAgrBatchImportOpsAgreementSkuAbilityRspBO rspBo = new CnncAgrBatchImportOpsAgreementSkuAbilityRspBO();
        if (null == reqBo.getAgreementId()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010agreementId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBo.getUrl())) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010url\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getMemIdIn()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010memIdIn\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!StringUtils.hasText((String)reqBo.getUsername())) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010userName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(reqBo.getAgreementId());
        agreementPO.setRelSystem(AgrEnum.RelSystem.OPS.toString());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u672a\u67e5\u8be2\u5230\u534f\u8bae\u4fe1\u606f");
        }
        if (!AgrCommConstant.AgreementStatus.DRAFT.equals(agreement.getAgreementStatus()) && !AgrCommConstant.AgreementStatus.REJECT.equals(agreement.getAgreementStatus())) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u521b\u5efa\u534f\u8bae\u660e\u7ec6\uff01");
        }
        AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
        agreementSkuPO.setAgreementId(reqBo.getAgreementId());
        agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementSkuPO> agreementSkuPOS = this.agreementSkuMapper.getList(agreementSkuPO);
        if (CollectionUtils.isEmpty(agreementSkuPOS)) {
            throw new BusinessException("0101", "\u672a\u67e5\u8be2\u5230\u534f\u8bae\u660e\u7ec6\u4fe1\u606f");
        }
        Map<Long, AgreementSkuPO> agreementSkuMap = agreementSkuPOS.stream().collect(Collectors.toMap(AgreementSkuPO::getAgreementSkuId, po -> po, (a, b) -> a));
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            HttpUtil.deleteFile("temporaryfile/content.xlsx");
            File file = reqBo.getUrl().endsWith(".xls") ? new File(System.getProperty("user.dir") + "/temporaryfile/content.xls") : new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBo.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title, agreement);
        }
        catch (Exception e) {
            throw new BusinessException("22052", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e\uff01");
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<AgrAgreementSkuBO> agreementSkuBos = new ArrayList<AgrAgreementSkuBO>();
        HashMap opsContractItemPOHashMap = new HashMap(data.size());
        List<AgrDicDictionaryBO> agrDicDictionaryBOS = this.agrDicDictionaryAtomService.queryDictBOBySysCodeAndPcode("AGR", "AGR_PRODUCING_AREA");
        HashMap producingAreaMap = new HashMap(agrDicDictionaryBOS.size());
        agrDicDictionaryBOS.forEach(agrDicDictionaryBO -> producingAreaMap.put(agrDicDictionaryBO.getTitle(), agrDicDictionaryBO.getCode()));
        OpsContractItemPO opsContractItemPO = new OpsContractItemPO();
        opsContractItemPO.setContractCode(agreement.getExtContractCode());
        List<OpsContractItemPO> opsContractItemPOS = this.opsContractItemMapper.getListByOpsContractId(opsContractItemPO);
        if (!CollectionUtils.isEmpty(opsContractItemPOS)) {
            opsContractItemPOS.forEach(item -> opsContractItemPOHashMap.put(item.getAgreementSkuId(), item));
        }
        HashSet<Long> commodityTypeIds = new HashSet<Long>();
        HashMap taxRateAndCatalogMap = new HashMap(data.size());
        HashMap<String, UccEMdmCatalogBO> typeIdAndCatalogMap = new HashMap<String, UccEMdmCatalogBO>(data.size());
        for (List list : data) {
            Long buyPriceSum;
            String isOil;
            AgrAgreementSkuBO agreementSkuPo = new AgrAgreementSkuBO();
            agreementSkuBos.add(agreementSkuPo);
            StringBuilder importRemark = new StringBuilder();
            Object[] colData = list.toArray();
            String agrItemId = colData[0].toString().trim();
            agreementSkuPo.setAgreementSkuId(Long.valueOf(agrItemId));
            AgreementSkuPO agreementSkuPO2 = agreementSkuMap.get(agreementSkuPo.getAgreementSkuId());
            if (null == agreementSkuPO2) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u534f\u8bae\u660e\u7ec6\u7f16\u7801\u4e0d\u5b58\u5728\uff01");
            } else {
                agreementSkuPo.setCatalogId(agreementSkuPO2.getCatalogId());
                if (StringUtils.hasText((String)agreementSkuPO2.getCatalogId())) {
                    commodityTypeIds.add(Long.parseLong(agreementSkuPO2.getCatalogId()));
                }
            }
            String itemName = colData[1].toString().trim();
            agreementSkuPo.setItemName(itemName);
            String scMaterialCode = colData[2].toString().trim();
            agreementSkuPo.setScMaterialCode(scMaterialCode);
            String materialId = colData[3].toString().trim();
            agreementSkuPo.setMaterialId(materialId);
            String catalogId = colData[4].toString().trim();
            if (!StringUtils.hasText((String)catalogId)) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u56db\u7ea7\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            agreementSkuPo.setCatalogId(catalogId);
            String model = colData[5].toString().trim();
            agreementSkuPo.setModel(model);
            String spec = colData[6].toString().trim();
            agreementSkuPo.setSpec(spec);
            String warrantyLevel = colData[7].toString().trim();
            agreementSkuPo.setWarrantyLevel(warrantyLevel);
            String nuclearSafetyLevel = colData[8].toString().trim();
            agreementSkuPo.setNuclearSafetyLevel(nuclearSafetyLevel);
            String texture = colData[9].toString().trim();
            agreementSkuPo.setTexture(texture);
            String figure = colData[10].toString().trim();
            agreementSkuPo.setFigure(figure);
            String brandName = colData[11].toString().trim();
            agreementSkuPo.setBrandName(brandName);
            String manufacturer = colData[12].toString().trim();
            agreementSkuPo.setManufacturer(manufacturer);
            String producingArea = colData[13].toString().trim();
            agreementSkuPo.setProducingArea((String)producingAreaMap.get(producingArea));
            String supplyCycle = colData[14].toString().trim();
            if (!StringUtils.hasText((String)supplyCycle)) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u4f9b\u8d27\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
            } else if (supplyCycle.contains(".") || BigDecimal.ZERO.compareTo(new BigDecimal(supplyCycle)) >= 0) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u4f9b\u8d27\u5468\u671f\u8bf7\u586b\u5199\u5927\u4e8e0\u7684\u6b63\u6574\u6570!");
            } else {
                agreementSkuPo.setSupplyCycle(Integer.valueOf(supplyCycle));
            }
            String measureName = colData[15].toString().trim();
            agreementSkuPo.setMeasureName(measureName);
            String materialMeasureName = colData[16].toString().trim();
            agreementSkuPo.setMaterialMeasureName(materialMeasureName);
            String unitOfMeasureScale = colData[17].toString().trim();
            if (!StringUtils.hasText((String)unitOfMeasureScale)) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u8ba1\u91cf\u5355\u4f4d\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (unitOfMeasureScale.contains(".") || BigDecimal.ZERO.compareTo(new BigDecimal(unitOfMeasureScale)) >= 0) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u8ba1\u91cf\u5355\u4f4d\u6bd4\u4f8b\u8bf7\u586b\u5199\u5927\u4e8e0\u7684\u6b63\u6574\u6570!");
            } else {
                agreementSkuPo.setUnitOfMeasureScale(Integer.valueOf(unitOfMeasureScale));
            }
            String materialUnitOfMeasureScale = colData[18].toString().trim();
            if (!StringUtils.hasText((String)materialUnitOfMeasureScale)) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
            } else if (materialUnitOfMeasureScale.contains(".") || BigDecimal.ZERO.compareTo(new BigDecimal(materialUnitOfMeasureScale)) >= 0) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d\u6bd4\u4f8b\u8bf7\u586b\u5199\u5927\u4e8e0\u7684\u6b63\u6574\u6570!");
            } else {
                agreementSkuPo.setMaterialUnitOfMeasureScale(Integer.valueOf(materialUnitOfMeasureScale));
            }
            String taxCatalog = colData[19].toString().trim();
            if (!StringUtils.hasText((String)taxCatalog)) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            agreementSkuPo.setTaxCatalog(taxCatalog);
            String taxRate = colData[20].toString().trim();
            if (!StringUtils.hasText((String)taxRate)) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else {
                agreementSkuPo.setTaxRate(Byte.valueOf(taxRate));
            }
            if (StringUtils.hasText((String)agreementSkuPo.getTaxCatalog())) {
                Set mapTaxCodes = (Set)taxRateAndCatalogMap.get(taxRate);
                if (CollectionUtils.isEmpty((Collection)mapTaxCodes)) {
                    UmcQryTaxCodeListReqBO umcQryTaxCodeListReqBo = new UmcQryTaxCodeListReqBO();
                    umcQryTaxCodeListReqBo.setPageNo(-1);
                    umcQryTaxCodeListReqBo.setPageSize(-1);
                    umcQryTaxCodeListReqBo.setTaxRate(taxRate);
                    UmcQryTaxCodeListRspBO umcQryTaxCodeListRspBo = this.umcQryTaxCodeListService.qryTaxCodeList(umcQryTaxCodeListReqBo);
                    if ("0000".equals(umcQryTaxCodeListRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcQryTaxCodeListRspBo.getRows())) {
                        Set taxCodes = umcQryTaxCodeListRspBo.getRows().stream().map(TaxCodeRateBO::getTaxCode).collect(Collectors.toSet());
                        taxRateAndCatalogMap.put(taxRate, taxCodes);
                        if (!taxCodes.contains(taxCatalog)) {
                            agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                            importRemark.append("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0e\u7a0e\u7387\u4e0d\u5339\u914d\uff01");
                        }
                    } else {
                        agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                        importRemark.append("\u672a\u67e5\u8be2\u5230\u7a0e\u7387\u5bf9\u5e94\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4fe1\u606f\uff01");
                    }
                } else if (!mapTaxCodes.contains(taxCatalog)) {
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    importRemark.append("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0e\u7a0e\u7387\u4e0d\u5339\u914d\uff01");
                }
            }
            if (!StringUtils.hasText((String)(isOil = colData[21].toString().trim()))) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u662f\u5426\u6210\u54c1\u6cb9\uff081\u662f0\u5426\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else {
                agreementSkuPo.setIsOil(Byte.valueOf(isOil));
            }
            String buyNumber = colData[22].toString().trim();
            if (!StringUtils.hasText((String)buyNumber)) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else {
                if (buyNumber.contains(".")) {
                    if (buyNumber.length() - 1 - buyNumber.indexOf(".") > 6) {
                        agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                        importRemark.append("\u5546\u54c1\u6570\u91cf\u53ea\u652f\u63016\u4f4d\u5c0f\u6570\uff01");
                    }
                    if (buyNumber.indexOf(".") > 12) {
                        agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                        importRemark.append("\u5546\u54c1\u6570\u91cf\u6574\u6570\u4f4d\u53ea\u652f\u630112\u4f4d\uff01");
                    }
                } else if (buyNumber.length() > 13) {
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    importRemark.append("\u5546\u54c1\u6570\u91cf\u6574\u6570\u4f4d\u53ea\u652f\u630112\u4f4d\uff01");
                }
                agreementSkuPo.setBuyNumber(new BigDecimal(buyNumber));
            }
            String buyPrice = colData[23].toString().trim();
            if (!StringUtils.hasText((String)buyPrice)) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u91c7\u8d2d\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            } else {
                String buyPriceStr = new BigDecimal(buyPrice).multiply(new BigDecimal(10000)).stripTrailingZeros().toPlainString();
                if (buyPriceStr.contains(".")) {
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    importRemark.append("\u91c7\u8d2d\u5355\u4ef7\u4e0d\u80fd\u8d85\u8fc7\u56db\u4f4d\u5c0f\u6570\uff01");
                    agreementSkuPo.setBuyPrice(Long.valueOf(buyPriceStr.substring(0, buyPriceStr.indexOf("."))));
                } else {
                    agreementSkuPo.setBuyPrice(Long.valueOf(buyPriceStr));
                }
            }
            agreementSkuPo.setAgreementId(reqBo.getAgreementId());
            OpsContractItemPO contractItemPO = (OpsContractItemPO)opsContractItemPOHashMap.get(agreementSkuPo.getAgreementSkuId());
            if (null != contractItemPO) {
                BigDecimal contractItemPrice;
                if (null != contractItemPO.getSupplyCycle() && !contractItemPO.getSupplyCycle().equals(agreementSkuPo.getSupplyCycle())) {
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    importRemark.append("\u4f9b\u8d27\u5468\u671f\u540c\u6b65\u4f9b\u5e94\u94fe\u670d\u52a1\u7ba1\u7406\u5e73\u53f0\uff0c\u4e0d\u53ef\u4fee\u6539\uff01");
                }
                if (StrUtil.isNotBlank((CharSequence)contractItemPO.getBrand()) && !contractItemPO.getBrand().equals(agreementSkuPo.getBrandName())) {
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    importRemark.append("\u54c1\u724c\u7531OPS\u540c\u6b65\uff0c\u4e0d\u652f\u6301\u4fee\u6539\uff01");
                }
                if (StrUtil.isNotBlank((CharSequence)contractItemPO.getManufacturer()) && !contractItemPO.getManufacturer().equals(agreementSkuPo.getManufacturer())) {
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    agreementSkuPo.setManufacturer(contractItemPO.getManufacturer());
                    importRemark.append("\u751f\u4ea7\u5382\u5bb6\u7531OPS\u540c\u6b65\uff0c\u4e0d\u652f\u6301\u4fee\u6539\uff01");
                }
                if (StrUtil.isNotBlank((CharSequence)contractItemPO.getSpecModel()) && !contractItemPO.getSpecModel().equals(agreementSkuPo.getModel())) {
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    agreementSkuPo.setModel(contractItemPO.getSpecModel());
                    importRemark.append("\u89c4\u683c\u7531OPS\u540c\u6b65\uff0c\u4e0d\u652f\u6301\u4fee\u6539\uff01");
                }
                if (StrUtil.isNotBlank((CharSequence)contractItemPO.getSpecModel()) && !contractItemPO.getSpecModel().equals(agreementSkuPo.getSpec())) {
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    agreementSkuPo.setSpec(contractItemPO.getSpecModel());
                    importRemark.append("\u578b\u53f7\u7531OPS\u540c\u6b65\uff0c\u4e0d\u652f\u6301\u4fee\u6539\uff01");
                }
                if (StrUtil.isNotBlank((CharSequence)contractItemPO.getTaxRate()) && null != agreementSkuPo.getTaxRate() && !contractItemPO.getTaxRate().equals(agreementSkuPo.getTaxRate().toString())) {
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    agreementSkuPo.setTaxRate(Byte.valueOf(contractItemPO.getTaxRate()));
                    importRemark.append("\u7a0e\u7387\u7531OPS\u540c\u6b65\uff0c\u4e0d\u652f\u6301\u4fee\u6539\uff01");
                }
                if (StringUtils.hasText((String)contractItemPO.getBuyPrice()) && (contractItemPrice = new BigDecimal(contractItemPO.getBuyPrice())).compareTo(new BigDecimal(buyPrice)) != 0) {
                    Long price = contractItemPrice.multiply(new BigDecimal(10000)).longValue();
                    buyPrice = contractItemPO.getBuyPrice();
                    agreementSkuPo.setBuyPrice(price);
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    importRemark.append("\u91c7\u8d2d\u5355\u4ef7\u7531OPS\u540c\u6b65\uff0c\u4e0d\u652f\u6301\u4fee\u6539\uff01");
                }
                if (StringUtils.hasText((String)contractItemPO.getBuyNumber())) {
                    buyNumber = contractItemPO.getBuyNumber();
                    agreementSkuPo.setBuyNumber(new BigDecimal(contractItemPO.getBuyNumber()));
                }
                if (StringUtils.hasText((String)contractItemPO.getPurchaseType()) && AgrEnum.PurchaseType.WZ.getCode().equals(contractItemPO.getPurchaseType()) && !StringUtils.hasText((String)producingArea)) {
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    importRemark.append("\u534f\u8bae\u660e\u7ec6\u91c7\u8d2d\u7c7b\u578b\u4e3a\u7269\u8d44\uff0c\u7269\u8d44\u4ea7\u5730\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!AgrExtCommonConstant.ImportResult.FAILED.equals(agreementSkuPo.getImpResult()) && !StringUtils.hasText((String)agreementSkuPo.getMaterialId()) && StringUtils.hasText((String)agreementSkuPo.getCatalogId())) {
                    UccEMdmCatalogBO uccEMdmCatalogBO = (UccEMdmCatalogBO)typeIdAndCatalogMap.get(agreementSkuPo.getCatalogId());
                    if (uccEMdmCatalogBO == null) {
                        CnncQryCommodityTypeListAbilityReqBo cnncQryCommodityTypeListAbilityReqBo = new CnncQryCommodityTypeListAbilityReqBo();
                        cnncQryCommodityTypeListAbilityReqBo.setCommodityTypeIds(Collections.singletonList(Long.valueOf(agreementSkuPo.getCatalogId())));
                        cnncQryCommodityTypeListAbilityReqBo.setQueryHaveSku(Boolean.valueOf(false));
                        cnncQryCommodityTypeListAbilityReqBo.setPageSize(-1);
                        cnncQryCommodityTypeListAbilityReqBo.setPageNo(-1);
                        CnncQryCommodityTypeListAbilityRspBo cnncQryCommodityTypeListAbilityRspBo = this.cnncQryCommodityTypeListAbilityService.qryCommodityTypeList(cnncQryCommodityTypeListAbilityReqBo);
                        if (!"0000".equals(cnncQryCommodityTypeListAbilityRspBo.getRespCode())) {
                            throw new BusinessException("8888", "\u67e5\u8be2\u56db\u7ea7\u5206\u7c7b\u5931\u8d25");
                        }
                        if (!CollectionUtils.isEmpty((Collection)cnncQryCommodityTypeListAbilityRspBo.getRows())) {
                            List cnncQryCommodityTypeListAbilityBos2 = JSONArray.parseArray((String)JSONObject.toJSONString((Object)cnncQryCommodityTypeListAbilityRspBo.getRows()), CnncQryCommodityTypeListAbilityBo.class);
                            String typeRelCatalogCode = ((CnncQryCommodityTypeListAbilityBo)cnncQryCommodityTypeListAbilityBos2.get(0)).getCatalogCode();
                            CnncCatalogListQueryAbilityReqBO cnncCatalogListQueryAbilityReqBO = new CnncCatalogListQueryAbilityReqBO();
                            cnncCatalogListQueryAbilityReqBO.setCatalogCodes(Collections.singletonList(typeRelCatalogCode));
                            CnncCatalogListQueryAbilityRspBO cnncCatalogListQueryAbilityRspBO = this.cnncCatalogListQueryAbilityService.qryCatalogList(cnncCatalogListQueryAbilityReqBO);
                            if (!CollectionUtils.isEmpty((Collection)cnncCatalogListQueryAbilityRspBO.getCatalogBOList())) {
                                UccEMdmCatalogBO catalogBO = (UccEMdmCatalogBO)cnncCatalogListQueryAbilityRspBO.getCatalogBOList().get(0);
                                typeIdAndCatalogMap.put(agreementSkuPO.getCatalogId(), catalogBO);
                                if (YesNoEnum.NO.getType().equals(catalogBO.getFreezeFlag()) && YesNoEnum.NO.getType().equals(catalogBO.getIsDelete())) {
                                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                                    importRemark.append("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                                }
                            }
                        }
                    } else if (YesNoEnum.NO.getType().equals(uccEMdmCatalogBO.getFreezeFlag()) && YesNoEnum.NO.getType().equals(uccEMdmCatalogBO.getIsDelete())) {
                        agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                        importRemark.append("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                }
            }
            if ((buyPriceSum = Long.valueOf(new BigDecimal(buyPrice).multiply(new BigDecimal(buyNumber)).multiply(new BigDecimal("10000")).longValue())).toString().length() > 18) {
                agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                importRemark.append("\u603b\u4ef7\u6574\u6570\u4f4d\u53ea\u652f\u630114\u4f4d\uff0c\u8bf7\u6839\u636e\u5355\u4ef7\u8c03\u6574\u6570\u91cf\uff01");
            }
            agreementSkuPo.setBuyPriceSum(buyPriceSum);
            agreementSkuPo.setSalePrice(agreementSkuPo.getBuyPrice());
            agreementSkuPo.setSalePriceSum(buyPriceSum);
            if (AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(agreement.getAgreementMode())) {
                String markupRate = colData[24].toString().trim();
                if (!StringUtils.hasText((String)markupRate)) {
                    markupRate = "0";
                }
                markupRate = markupRate.endsWith("%") ? markupRate.substring(0, markupRate.lastIndexOf("%")) : markupRate;
                markupRate = new BigDecimal(markupRate).divide(new BigDecimal("100")).toString();
                agreementSkuPo.setMarkupRate(Double.valueOf(new BigDecimal(markupRate).multiply(new BigDecimal(100)).doubleValue()));
                String markupValue = colData[25].toString().trim();
                if (!StringUtils.hasText((String)markupValue)) {
                    markupValue = "0";
                }
                if (markupValue.contains(".") && markupValue.length() - 1 - markupValue.indexOf(".") > 4) {
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    importRemark.append("\u52a0\u4ef7\u503c\u4e0d\u80fd\u8d85\u8fc7\u56db\u4f4d\u5c0f\u6570\uff01");
                    agreementSkuPo.setMarkupValue(markupValue.substring(0, markupValue.indexOf(".") + 4));
                }
                agreementSkuPo.setMarkupValue(markupValue);
                agreementSkuPo.setSalePrice(Long.valueOf(new BigDecimal(agreementSkuPo.getBuyPrice()).add(new BigDecimal(agreementSkuPo.getBuyPrice()).multiply(new BigDecimal(markupRate))).add(new BigDecimal(agreementSkuPo.getMarkupValue()).multiply(new BigDecimal("10000"))).longValue()));
                Long salePriceSum = new BigDecimal(agreementSkuPo.getSalePrice()).multiply(new BigDecimal(buyNumber)).longValue();
                if (salePriceSum.toString().length() > 18) {
                    agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    importRemark.append("\u603b\u4ef7\u6574\u6570\u4f4d\u53ea\u652f\u630114\u4f4d\uff0c\u8bf7\u6839\u636e\u5355\u4ef7\u8c03\u6574\u6570\u91cf\uff01");
                }
                agreementSkuPo.setSalePriceSum(salePriceSum);
            }
            agreementSkuPo.setImpRemark(importRemark.toString());
            if (agreementSkuPo.getImpResult() != null) continue;
            agreementSkuPo.setImpResult(AgrExtCommonConstant.ImportResult.SUCCESS);
            agreementSkuPo.setImpRemark("\u6210\u529f");
        }
        List materialCodes = agreementSkuBos.stream().map(AgrAgreementSkuBO::getMaterialId).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(materialCodes)) {
            UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBO = new UccQryCommodityTypeByMaterialReqBO();
            uccQryCommodityTypeByMaterialReqBO.setMaterialCodes(materialCodes);
            UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByMaterial(uccQryCommodityTypeByMaterialReqBO);
            if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                throw new BusinessException("8888", "\u901a\u8fc7\u7269\u6599\u67e5\u8be2\u56db\u7ea7\u5206\u7c7b\u5931\u8d25");
            }
            List<AgrDicDictionaryBO> measureNameList = this.agrDicDictionaryAtomService.queryDictBOBySysCodeAndPcode("AGR", "MEASURE_CONVERSION_RELATIONSHIPS");
            Map<String, String> conversionScaleMap = measureNameList.stream().collect(Collectors.toMap(AgrDicDictionaryBO::getCode, AgrDicDictionaryBO::getTitle, (a, b) -> a));
            Map<String, UccMaterialCommodityTypeBO> agrFormulaVariablePOMap = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getMaterialCode, obj -> obj, (key1, key2) -> key2));
            for (AgrAgreementSkuBO skuBO : agreementSkuBos) {
                if (!StringUtils.hasText((String)skuBO.getMaterialId())) continue;
                UccMaterialCommodityTypeBO uccMaterialCommodityTypeBO = agrFormulaVariablePOMap.get(skuBO.getMaterialId());
                if (null != uccMaterialCommodityTypeBO) {
                    if (!StringUtils.hasText((String)uccMaterialCommodityTypeBO.getMeasureName())) {
                        skuBO.setImpRemark("\u8be5\u7269\u8d44\u7f16\u7801\u672a\u914d\u7f6e\u8ba1\u91cf\u5355\u4f4d");
                        skuBO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    }
                    if (!skuBO.getMaterialMeasureName().equals(uccMaterialCommodityTypeBO.getMeasureName())) {
                        skuBO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                        skuBO.setImpRemark("\u6a21\u677f\u5bfc\u5165\u660e\u7ec6\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d\u4e0e\u7269\u8d44\u7f16\u7801\u8ba1\u91cf\u5355\u4f4d\u4e0d\u4e00\u81f4");
                    }
                    if (!uccMaterialCommodityTypeBO.getMeasureName().equals(skuBO.getMeasureName())) {
                        String conversionScale;
                        if (CollectionUtils.isEmpty(conversionScaleMap) || !StringUtils.hasText((String)(conversionScale = conversionScaleMap.get(skuBO.getMeasureName() + ":" + skuBO.getMaterialMeasureName())))) continue;
                        String[] split = conversionScale.split(":");
                        if (split.length == 2) {
                            skuBO.setUnitOfMeasureScale(Integer.valueOf(split[0]));
                            skuBO.setMaterialUnitOfMeasureScale(Integer.valueOf(split[1]));
                            continue;
                        }
                        skuBO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                        skuBO.setImpRemark("\u7279\u5b9a\u8f6c\u6362\u8ba1\u91cf\u5355\u4f4d\u8f6c\u6362\u6bd4\u4f8b\u914d\u7f6e\u9519\u8bef");
                        continue;
                    }
                    skuBO.setMaterialUnitOfMeasureScale(Integer.valueOf(1));
                    skuBO.setUnitOfMeasureScale(Integer.valueOf(1));
                    continue;
                }
                skuBO.setImpRemark("\u8be5\u7269\u8d44\u7f16\u7801\u672a\u914d\u7f6e\u8ba1\u91cf\u5355\u4f4d");
                skuBO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<Long> typeIds = new HashSet<Long>();
        for (AgrAgreementSkuBO agreementSkuBo : agreementSkuBos) {
            AgreementSkuPO skuPO = agreementSkuMap.get(agreementSkuBo.getAgreementSkuId());
            if (agreementSkuBo.getCatalogId().equals(skuPO.getCatalogId())) continue;
            hashSet.add(skuPO.getThirdCatalogId());
            typeIds.add(Long.parseLong(agreementSkuBo.getCatalogId()));
            agreementSkuBo.setThirdCatalogId(skuPO.getThirdCatalogId());
        }
        Map<String, List<CnncQryCommodityTypeListAbilityBo>> catalogCodeMap = null;
        Map commodityTypesMap = null;
        if (!CollectionUtils.isEmpty(hashSet)) {
            CnncQryCommodityTypeListAbilityReqBo cnncQryCommodityTypeListAbilityReqBo = new CnncQryCommodityTypeListAbilityReqBo();
            cnncQryCommodityTypeListAbilityReqBo.setCatalogCodes(new ArrayList(hashSet));
            cnncQryCommodityTypeListAbilityReqBo.setQueryHaveSku(Boolean.valueOf(false));
            cnncQryCommodityTypeListAbilityReqBo.setPageSize(-1);
            cnncQryCommodityTypeListAbilityReqBo.setPageNo(-1);
            CnncQryCommodityTypeListAbilityRspBo cnncQryCommodityTypeListAbilityRspBo = this.cnncQryCommodityTypeListAbilityService.qryCommodityTypeList(cnncQryCommodityTypeListAbilityReqBo);
            if (!"0000".equals(cnncQryCommodityTypeListAbilityRspBo.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u540c\u4e09\u7ea7\u5206\u7c7b\u4e0b\u56db\u7ea7\u5206\u7c7b\u5931\u8d25");
            }
            if (!CollectionUtils.isEmpty((Collection)cnncQryCommodityTypeListAbilityRspBo.getRows())) {
                cnncQryCommodityTypeListAbilityBos = JSONArray.parseArray((String)JSONObject.toJSONString((Object)cnncQryCommodityTypeListAbilityRspBo.getRows()), CnncQryCommodityTypeListAbilityBo.class);
                catalogCodeMap = cnncQryCommodityTypeListAbilityBos.stream().collect(Collectors.groupingBy(CnncQryCommodityTypeListAbilityBo::getCatalogCode));
            }
        }
        if (!CollectionUtils.isEmpty(typeIds)) {
            UccExtQryCommodityTypeOfTheSameCatalogAbilityReqBO uccExtQryCommodityTypeOfTheSameCatalogAbilityReqBO = new UccExtQryCommodityTypeOfTheSameCatalogAbilityReqBO();
            uccExtQryCommodityTypeOfTheSameCatalogAbilityReqBO.setCommodityTypeIds(new ArrayList(typeIds));
            UccExtQryCommodityTypeOfTheSameCatalogAbilityRspBO uccExtQryCommodityTypeOfTheSameCatalogAbilityRspBO = this.uccExtQryCommodityTypeOfTheSameCatalogAbilityService.qryCommodityTypeOfTheSameCatalog(uccExtQryCommodityTypeOfTheSameCatalogAbilityReqBO);
            if (!"0000".equals(uccExtQryCommodityTypeOfTheSameCatalogAbilityRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u540c\u7269\u6599\u5206\u7c7b\u4e0b\u56db\u7ea7\u5206\u7c7b\u5931\u8d25");
            }
            commodityTypesMap = uccExtQryCommodityTypeOfTheSameCatalogAbilityRspBO.getCommodityTypes();
        }
        for (AgrAgreementSkuBO agrAgreementSkuBO : agreementSkuBos) {
            if (CollectionUtils.isEmpty(catalogCodeMap) || CollectionUtils.isEmpty((Collection)(cnncQryCommodityTypeListAbilityBos = (List)catalogCodeMap.get(agrAgreementSkuBO.getThirdCatalogId())))) continue;
            List commodityTypeIdList = cnncQryCommodityTypeListAbilityBos.stream().map(CnncQryCommodityTypeListAbilityBo::getCommodityTypeId).map(String::valueOf).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(commodityTypeIdList) && commodityTypeIdList.contains(agrAgreementSkuBO.getCatalogId())) {
                Map<Long, UccCommodityTypeBO> uccCommodityTypeBOMap;
                UccCommodityTypeBO uccCommodityTypeBO;
                Long catalogId;
                List uccCommodityTypeBOS;
                if (CollectionUtils.isEmpty((Map)commodityTypesMap) || !StringUtils.hasText((String)agrAgreementSkuBO.getCatalogId()) || CollectionUtils.isEmpty((Collection)(uccCommodityTypeBOS = (List)commodityTypesMap.get(catalogId = Long.valueOf(Long.parseLong(agrAgreementSkuBO.getCatalogId()))))) || null == (uccCommodityTypeBO = (uccCommodityTypeBOMap = uccCommodityTypeBOS.stream().collect(Collectors.toMap(UccCommodityTypeBO::getCommodityTypeId, obj -> obj, (a, b) -> a))).get(catalogId))) continue;
                agrAgreementSkuBO.setCatalogId(uccCommodityTypeBO.getCommodityTypeId().toString());
                agrAgreementSkuBO.setCatalogName(uccCommodityTypeBO.getCommodityTypeName());
                continue;
            }
            agrAgreementSkuBO.setImpRemark("\u56db\u7ea7\u5206\u7c7b\u4ec5\u5141\u8bb8\u4fee\u6539\u4e3a\u5916\u90e8\u7cfb\u7edf\u6240\u4f20\u4e09\u7ea7\u5206\u7c7b\u4e0b\u7684\u56db\u7ea7\u5206\u7c7b\u7c7b\u578b");
            agrAgreementSkuBO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
        }
        CnncAgrBatchImportOpsAgreementSkuBusiReqBO busiReqBo = new CnncAgrBatchImportOpsAgreementSkuBusiReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)busiReqBo));
        busiReqBo.setAgreementId(reqBo.getAgreementId());
        busiReqBo.setImportAgrSkus(agreementSkuBos);
        CnncAgrBatchImportOpsAgreementSkuBusiRspBO cnncAgrBatchImportOpsAgreementSkuBusiRspBO = this.cnncAgrBatchImportOpsAgreementSkuBusiService.dealImportOpsAgreementSku(busiReqBo);
        BeanUtils.copyProperties((Object)((Object)cnncAgrBatchImportOpsAgreementSkuBusiRspBO), (Object)rspBo);
        return rspBo;
    }

    private void getExcelDateByImport(MultipartFile multipartFile, List<List<String>> data, List<String> title, AgreementPO agreement) {
        try {
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            int count = 0;
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                int i;
                if (count < 6) {
                    ++count;
                    continue;
                }
                boolean cow = true;
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                for (i = 0; i < end; ++i) {
                    if (null == row.getCell(i) || "".equals(row.getCell(i).toString())) continue;
                    cow = false;
                    break;
                }
                if (cow) continue;
                for (i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getCellValue(cell);
                    if (count == 6) {
                        title.add(String.valueOf(obj).trim());
                        continue;
                    }
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".00")) {
                        str = str.substring(0, str.length() - 3);
                    }
                    d.add(str);
                }
                data.add(d);
                if (data.size() <= 3000) continue;
                throw new BusinessException("22052", "\u5bfc\u5165\u660e\u7ec6\u534f\u8bae\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc73000\u6761");
            }
        }
        catch (Exception e) {
            throw new BusinessException("22052", e.getMessage());
        }
    }
}

