/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.extend.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.agreement.ability.bo.AgrAgreementScopeSyncQueueReqBO;
import com.tydic.agreement.busi.AgrAgreementScopeSyncQueueBusiService;
import com.tydic.agreement.common.bo.AgrScopeSyncBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementScopeMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementScopePO;
import com.tydic.agreement.extend.ability.CnncAgrSyncScopeAbilityService;
import com.tydic.agreement.extend.ability.bo.AgrOrgScopeBO;
import com.tydic.agreement.extend.ability.bo.AgrOrgScopeSyncBO;
import com.tydic.agreement.extend.ability.bo.CnncAgrSyncScopeAbilityReqBO;
import com.tydic.agreement.extend.ability.bo.CnncAgrSyncScopeAbilityRspBO;
import com.tydic.commodity.util.ListUtils;
import com.tydic.umc.base.bo.UmcRspPageBO;
import com.tydic.umcext.ability.org.UmcExtQryAgrScopeOrgInfoAbilityService;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import com.tydic.umcext.ability.org.bo.UmcExtQryAgrScopeOrgInfoAbilityReqBO;
import com.tydic.umcext.ability.org.bo.UmcExtQryAgrScopeOrgInfoAbilityRspBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgAbilityBO;
import com.tydic.umcext.ability.org.bo.UmcZhEnterpriseOrgAbilityReqPageBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.extend.ability.CnncAgrSyncScopeAbilityService"})
public class CnncAgrSyncScopeAbilityServiceImpl
implements CnncAgrSyncScopeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CnncAgrSyncScopeAbilityServiceImpl.class);
    public final String UCC_ORG_AGR_WHITELIST_RESTRICTION = "UCC_ORG_AGR_WHITELIST_RESTRICTION";
    public final String UCC_ORG_AGR_EXCLUDE_RESTRICTION = "UCC_ORG_AGR_EXCLUDE_RESTRICTION";
    private final String orgType_department = "03";
    private final String queryType_nextLv = "01";
    private final String queryType_onlyThis = "02";
    private final String queryType_thisAndAllBelow = "03";
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementScopeMapper agreementScopeMapper;
    @Autowired
    private AgrAgreementScopeSyncQueueBusiService agrAgreementScopeSyncQueueBusiService;
    @Autowired
    private UmcExtQryAgrScopeOrgInfoAbilityService umcExtQryAgrScopeOrgInfoAbilityService;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"syncScope"})
    public CnncAgrSyncScopeAbilityRspBO syncScope(@RequestBody CnncAgrSyncScopeAbilityReqBO reqBO) {
        List igAgrIds;
        CnncAgrSyncScopeAbilityRspBO rspBO = new CnncAgrSyncScopeAbilityRspBO();
        AgreementPO agreementPO = new AgreementPO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgreementIds())) {
            agreementPO.setAgreementIds(new ArrayList<Long>(reqBO.getAgreementIds()));
        }
        agreementPO.setAgreementStatus(reqBO.getStatus());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> agreementPOS = this.agreementMapper.getList(agreementPO);
        if (CollectionUtils.isEmpty(agreementPOS)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList<AgrScopeSyncBO> agrScopeSyncBOS = new ArrayList<AgrScopeSyncBO>();
        AgreementScopePO agreementScopePO = new AgreementScopePO();
        agreementScopePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        HashSet<String> scopeCodeSet = new HashSet<String>();
        for (AgreementPO agreement : agreementPOS) {
            scopeCodeSet.clear();
            AgrScopeSyncBO agrScopeSyncBO = new AgrScopeSyncBO();
            if (agreement.getAgreementType().equals(AgrCommConstant.agreementType.GROUP_AGREEMENT)) {
                scopeCodeSet.add("*");
            } else if (AgrCommConstant.IsDelete.DELETED.equals(agreement.getIsDelete())) {
                scopeCodeSet.add("*");
            } else {
                if (agreement.getAgreementType().equals(AgrCommConstant.agreementType.AREA_AGREEMENT)) {
                    scopeCodeSet.add(agreement.getSupplierId().toString());
                }
                agreementScopePO.setAgreementId(agreement.getAgreementId());
                List<AgreementScopePO> agreementScopePOS = this.agreementScopeMapper.getList(agreementScopePO);
                if (!CollectionUtils.isEmpty(agreementScopePOS)) {
                    List<AgreementScopePO> thisAndAllBelowScope;
                    List collectOrgIds;
                    Map<Integer, List<AgreementScopePO>> collectByMode = agreementScopePOS.stream().collect(Collectors.groupingBy(AgreementScopePO::getScopeMode));
                    List<AgreementScopePO> thisAndItsDepartmentScope = collectByMode.get(AgrCommConstant.ScopeMode.THIS_AND_ITS_DEPARTMENT);
                    if (!CollectionUtils.isEmpty(thisAndItsDepartmentScope)) {
                        UmcExtQryAgrScopeOrgInfoAbilityReqBO umcExtQryAgrScopeOrgInfoAbilityReqBO = new UmcExtQryAgrScopeOrgInfoAbilityReqBO();
                        collectOrgIds = thisAndItsDepartmentScope.stream().map(AgreementScopePO::getScopeCode).distinct().collect(Collectors.toList());
                        scopeCodeSet.addAll(collectOrgIds.stream().map(String::valueOf).collect(Collectors.toSet()));
                        while (!CollectionUtils.isEmpty(collectOrgIds)) {
                            umcExtQryAgrScopeOrgInfoAbilityReqBO.setPageNo(Integer.valueOf(-1));
                            umcExtQryAgrScopeOrgInfoAbilityReqBO.setPageSize(Integer.valueOf(-1));
                            umcExtQryAgrScopeOrgInfoAbilityReqBO.setQueryType("01");
                            umcExtQryAgrScopeOrgInfoAbilityReqBO.setOrgType("03");
                            umcExtQryAgrScopeOrgInfoAbilityReqBO.setOrgIds(collectOrgIds);
                            UmcExtQryAgrScopeOrgInfoAbilityRspBO umcExtQryAgrScopeOrgInfoAbilityRspBO = this.umcExtQryAgrScopeOrgInfoAbilityService.qryAgrScopeOrgInfo(umcExtQryAgrScopeOrgInfoAbilityReqBO);
                            if (!"0000".equals(umcExtQryAgrScopeOrgInfoAbilityRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)umcExtQryAgrScopeOrgInfoAbilityRspBO.getRows())) break;
                            collectOrgIds = umcExtQryAgrScopeOrgInfoAbilityRspBO.getRows().stream().map(UmcZhEnterpriseOrgAbilityBO::getOrgId).collect(Collectors.toList());
                            scopeCodeSet.addAll(collectOrgIds.stream().map(String::valueOf).collect(Collectors.toSet()));
                        }
                    }
                    if (!CollectionUtils.isEmpty(thisAndAllBelowScope = collectByMode.get(AgrCommConstant.ScopeMode.THIS_AND_ALL_UNITS_AND_DEPARTMENTS_BELOW))) {
                        collectOrgIds = thisAndAllBelowScope.stream().map(AgreementScopePO::getScopeCode).distinct().collect(Collectors.toList());
                        scopeCodeSet.addAll(collectOrgIds.stream().map(String::valueOf).collect(Collectors.toSet()));
                        int totalPage = 1;
                        for (int pageNo = 1; pageNo <= totalPage; ++pageNo) {
                            UmcExtQryAgrScopeOrgInfoAbilityReqBO umcExtQryAgrScopeOrgInfoAbilityReqBO = new UmcExtQryAgrScopeOrgInfoAbilityReqBO();
                            umcExtQryAgrScopeOrgInfoAbilityReqBO.setPageNo(Integer.valueOf(pageNo));
                            umcExtQryAgrScopeOrgInfoAbilityReqBO.setPageSize(Integer.valueOf(500));
                            umcExtQryAgrScopeOrgInfoAbilityReqBO.setQueryType("03");
                            umcExtQryAgrScopeOrgInfoAbilityReqBO.setOrgIds(collectOrgIds);
                            UmcExtQryAgrScopeOrgInfoAbilityRspBO umcExtQryAgrScopeOrgInfoAbilityRspBO = this.umcExtQryAgrScopeOrgInfoAbilityService.qryAgrScopeOrgInfo(umcExtQryAgrScopeOrgInfoAbilityReqBO);
                            if ("0000".equals(umcExtQryAgrScopeOrgInfoAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcExtQryAgrScopeOrgInfoAbilityRspBO.getRows())) {
                                scopeCodeSet.addAll(umcExtQryAgrScopeOrgInfoAbilityRspBO.getRows().stream().map(UmcZhEnterpriseOrgAbilityBO::getOrgId).map(String::valueOf).collect(Collectors.toSet()));
                            }
                            totalPage = umcExtQryAgrScopeOrgInfoAbilityRspBO.getTotal() == null ? 1 : umcExtQryAgrScopeOrgInfoAbilityRspBO.getTotal();
                        }
                    }
                }
            }
            agrScopeSyncBO.setAgreementId(agreement.getAgreementId());
            agrScopeSyncBO.setScopeCodes(JSON.toJSONString(scopeCodeSet));
            agrScopeSyncBOS.add(agrScopeSyncBO);
        }
        List scopeAllAgrIds = agrScopeSyncBOS.stream().filter(bo -> bo.getScopeCodes().contains("*")).map(AgrScopeSyncBO::getAgreementId).collect(Collectors.toList());
        List scopeAgrIds = agrScopeSyncBOS.stream().filter(bo -> !bo.getScopeCodes().contains("*")).map(AgrScopeSyncBO::getAgreementId).collect(Collectors.toList());
        Object object = this.cacheClient.get("UCC_ORG_AGR_EXCLUDE_RESTRICTION");
        List list = igAgrIds = object == null ? new ArrayList() : JSONObject.parseArray((String)JSONObject.toJSONString((Object)object), Long.class);
        if (!CollectionUtils.isEmpty(scopeAllAgrIds)) {
            igAgrIds.removeAll(scopeAllAgrIds);
        }
        if (!CollectionUtils.isEmpty(scopeAgrIds)) {
            igAgrIds.addAll(scopeAgrIds);
        }
        this.cacheClient.set("UCC_ORG_AGR_EXCLUDE_RESTRICTION", igAgrIds.stream().distinct().collect(Collectors.toList()));
        HashSet scopeOrg = new HashSet();
        agrScopeSyncBOS.stream().filter(bo -> !bo.getScopeCodes().contains("*")).collect(Collectors.groupingBy(AgrScopeSyncBO::getAgreementId, Collectors.mapping(bo -> JSON.parseArray((String)bo.getScopeCodes(), Long.class), Collectors.toSet()))).forEach((k, v) -> {
            AgrOrgScopeSyncBO agrOrgScopeSyncBo = new AgrOrgScopeSyncBO();
            agrOrgScopeSyncBo.setAgreementId(k);
            Set orgScopeBos = v.stream().flatMap(Collection::stream).map(orgId -> {
                AgrOrgScopeBO agrOrgScopeBo = new AgrOrgScopeBO();
                agrOrgScopeBo.setOrgId(orgId);
                agrOrgScopeBo.setScopeModeChange(Integer.valueOf(AgrEnum.YesOrNo.NO.getCode().byteValue()));
                return agrOrgScopeBo;
            }).collect(Collectors.toSet());
            agrOrgScopeSyncBo.setOrgScopes(orgScopeBos);
            scopeOrg.add(agrOrgScopeSyncBo);
        });
        CnncAgrSyncScopeAbilityReqBO cnncAgrSyncScopeAbilityReqBO = new CnncAgrSyncScopeAbilityReqBO();
        cnncAgrSyncScopeAbilityReqBO.setSyncAllOrgFlag(reqBO.getSyncAllOrgFlag());
        cnncAgrSyncScopeAbilityReqBO.setOrgIds(scopeOrg);
        this.syncOrgScope(cnncAgrSyncScopeAbilityReqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"syncOrgScope"})
    public CnncAgrSyncScopeAbilityRspBO syncOrgScope(@RequestBody CnncAgrSyncScopeAbilityReqBO reqBO) {
        CnncAgrSyncScopeAbilityRspBO rspBO = new CnncAgrSyncScopeAbilityRspBO();
        if (reqBO.getSyncAllOrgFlag() == 1) {
            UmcZhEnterpriseOrgAbilityReqPageBO umcZhEnterpriseOrgAbilityReqPageBO = new UmcZhEnterpriseOrgAbilityReqPageBO();
            umcZhEnterpriseOrgAbilityReqPageBO.setProjectOwnership("ZH");
            umcZhEnterpriseOrgAbilityReqPageBO.setPageSize(Integer.valueOf(500));
            umcZhEnterpriseOrgAbilityReqPageBO.setPageNo(Integer.valueOf(1));
            umcZhEnterpriseOrgAbilityReqPageBO.setQueryType("02");
            UmcRspPageBO boUmcRspPageBO = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByPage(umcZhEnterpriseOrgAbilityReqPageBO);
            int totalPage = boUmcRspPageBO.getTotal();
            if (totalPage >= 1) {
                this.setCache(boUmcRspPageBO.getRows());
                for (int i = 2; i <= totalPage; ++i) {
                    umcZhEnterpriseOrgAbilityReqPageBO.setPageNo(Integer.valueOf(i));
                    boUmcRspPageBO = this.umcZhEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByPage(umcZhEnterpriseOrgAbilityReqPageBO);
                    this.setCache(boUmcRspPageBO.getRows());
                }
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrgIds())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Integer successCount = 0;
        HashSet<AgrOrgScopeSyncBO> failOrg = new HashSet<AgrOrgScopeSyncBO>();
        AgrOrgScopeSyncBO agrOrgScopeSyncBo = new AgrOrgScopeSyncBO();
        HashSet orgScopes = new HashSet();
        agrOrgScopeSyncBo.setAgreementId(null);
        agrOrgScopeSyncBo.setOrgScopes(orgScopes);
        failOrg.add(agrOrgScopeSyncBo);
        Map orgIdMap = reqBO.getOrgIds().stream().map(AgrOrgScopeSyncBO::getOrgScopes).flatMap(Collection::stream).collect(Collectors.groupingBy(AgrOrgScopeBO::getScopeModeChange, Collectors.mapping(AgrOrgScopeBO::getOrgId, Collectors.toSet())));
        UmcExtQryAgrScopeOrgInfoAbilityReqBO umcExtQryAgrScopeOrgInfoAbilityReqBO = new UmcExtQryAgrScopeOrgInfoAbilityReqBO();
        umcExtQryAgrScopeOrgInfoAbilityReqBO.setPageSize(Integer.valueOf(500));
        for (Map.Entry entry : orgIdMap.entrySet()) {
            Integer modeChange = entry.getKey();
            Set<Long> orgIds = entry.getValue();
            if (CollectionUtils.isEmpty(orgIds)) continue;
            int totalPage = 1;
            int pageNo = 1;
            if (modeChange != null && Objects.equals(modeChange.byteValue(), AgrEnum.YesOrNo.YES.getCode())) {
                umcExtQryAgrScopeOrgInfoAbilityReqBO.setQueryType("03");
            } else {
                umcExtQryAgrScopeOrgInfoAbilityReqBO.setQueryType("02");
            }
            umcExtQryAgrScopeOrgInfoAbilityReqBO.setOrgIds(new ArrayList(orgIds));
            while (pageNo <= totalPage) {
                umcExtQryAgrScopeOrgInfoAbilityReqBO.setPageNo(Integer.valueOf(pageNo));
                UmcExtQryAgrScopeOrgInfoAbilityRspBO umcExtQryAgrScopeOrgInfoAbilityRspBO = this.umcExtQryAgrScopeOrgInfoAbilityService.qryAgrScopeOrgInfo(umcExtQryAgrScopeOrgInfoAbilityReqBO);
                totalPage = umcExtQryAgrScopeOrgInfoAbilityRspBO.getTotal() == null ? 1 : umcExtQryAgrScopeOrgInfoAbilityRspBO.getTotal();
                ++pageNo;
                if (!CollectionUtils.isEmpty((Collection)umcExtQryAgrScopeOrgInfoAbilityRspBO.getRows())) {
                    for (UmcZhEnterpriseOrgAbilityBO orgInfo : umcExtQryAgrScopeOrgInfoAbilityRspBO.getRows()) {
                        List<Long> scopeAgreementIds = this.agreementScopeMapper.getScopeAgreementIds(orgInfo.getCompanyOrgId(), orgInfo.getOrgTreePath(), AgrCommConstant.agreementType.AREA_AGREEMENT, AgrCommConstant.AgreementStatus.ENABLE);
                        if (!CollectionUtils.isEmpty(scopeAgreementIds)) {
                            this.cacheClient.set("UCC_ORG_AGR_WHITELIST_RESTRICTION" + orgInfo.getOrgId(), scopeAgreementIds);
                        } else {
                            this.cacheClient.delete("UCC_ORG_AGR_WHITELIST_RESTRICTION" + orgInfo.getOrgId());
                        }
                        Integer n = successCount;
                        Integer n2 = successCount = Integer.valueOf(successCount + 1);
                    }
                    continue;
                }
                orgIds.forEach(orgId -> {
                    AgrOrgScopeBO agrOrgScopeBo = new AgrOrgScopeBO();
                    agrOrgScopeBo.setScopeModeChange(modeChange);
                    agrOrgScopeBo.setOrgId(orgId);
                    orgScopes.add(agrOrgScopeBo);
                });
            }
            if (CollectionUtils.isEmpty(failOrg) || CollectionUtils.isEmpty(orgScopes) || reqBO.getRetryFlag().booleanValue()) continue;
            AgrAgreementScopeSyncQueueReqBO agrAgreementScopeSyncQueueReqBO = new AgrAgreementScopeSyncQueueReqBO();
            agrAgreementScopeSyncQueueReqBO.setOrgIds(failOrg);
            this.agrAgreementScopeSyncQueueBusiService.addOrgScopeSyncQueue(agrAgreementScopeSyncQueueReqBO);
        }
        rspBO.setFailOrg(orgScopes.stream().map(AgrOrgScopeBO::getOrgId).collect(Collectors.toSet()));
        rspBO.setSuccess(successCount);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qryOrgScope"})
    public CnncAgrSyncScopeAbilityRspBO qryOrgScope(@RequestBody CnncAgrSyncScopeAbilityReqBO reqBO) {
        CnncAgrSyncScopeAbilityRspBO rspBO = new CnncAgrSyncScopeAbilityRspBO();
        Object object = this.cacheClient.get("UCC_ORG_AGR_EXCLUDE_RESTRICTION");
        List igAgrIds = JSONObject.parseArray((String)JSONObject.toJSONString((Object)object), Long.class);
        igAgrIds = ListUtils.removeReapet((List)igAgrIds);
        log.debug("\u534f\u8bae\u9650\u5236\u96c6\u5408:" + igAgrIds.toString());
        rspBO.setAgrIds(igAgrIds);
        StringBuilder stringBuilder = new StringBuilder();
        for (AgrOrgScopeSyncBO agrOrgScopeSyncBo : reqBO.getOrgIds()) {
            for (AgrOrgScopeBO agrOrgScopeBo : agrOrgScopeSyncBo.getOrgScopes()) {
                String key = "UCC_ORG_AGR_WHITELIST_RESTRICTION" + agrOrgScopeBo.getOrgId();
                Object object1 = this.cacheClient.get(key);
                if (object1 == null) continue;
                List havAgrIds = JSONObject.parseArray((String)JSONObject.toJSONString((Object)object1), Long.class);
                log.debug("\u534f\u8baeID:" + agrOrgScopeSyncBo.getAgreementId() + ",\u673a\u6784:" + agrOrgScopeBo.getOrgId() + ",\u534f\u8bae\u8303\u56f4:" + havAgrIds.toString());
                stringBuilder.append(agrOrgScopeBo.getOrgId()).append(":").append(havAgrIds).append("\n");
            }
        }
        rspBO.setScope(stringBuilder.toString());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void setCache(List<UmcZhEnterpriseOrgAbilityBO> orgInfos) {
        if (!CollectionUtils.isEmpty(orgInfos)) {
            for (UmcZhEnterpriseOrgAbilityBO orgInfo : orgInfos) {
                List<Long> scopeAgreementIds = this.agreementScopeMapper.getScopeAgreementIds(orgInfo.getCompanyOrgId(), orgInfo.getOrgTreePath(), AgrCommConstant.agreementType.AREA_AGREEMENT, AgrCommConstant.AgreementStatus.ENABLE);
                if (!CollectionUtils.isEmpty(scopeAgreementIds)) {
                    this.cacheClient.set("UCC_ORG_AGR_WHITELIST_RESTRICTION" + orgInfo.getOrgId(), scopeAgreementIds);
                    continue;
                }
                this.cacheClient.delete("UCC_ORG_AGR_WHITELIST_RESTRICTION" + orgInfo.getOrgId());
            }
        }
    }
}

