/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.extend.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.bo.AgrFormulaBO;
import com.tydic.agreement.ability.bo.QuotaDataOriginBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuFormulaBO;
import com.tydic.agreement.dao.AgrFormulaMapper;
import com.tydic.agreement.dao.po.AgrFormulaPO;
import com.tydic.agreement.extend.ability.CnncCalculateByFormulaService;
import com.tydic.agreement.extend.ability.bo.CnncCalculateByFormulaReqBO;
import com.tydic.agreement.extend.ability.bo.CnncCalculateByFormulaRspBO;
import com.tydic.agreement.utils.ParsiiUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.extend.ability.CnncCalculateByFormulaService"})
public class CnncCalculateByFormulaServiceImpl
implements CnncCalculateByFormulaService {
    private static final Logger log = LoggerFactory.getLogger(CnncCalculateByFormulaServiceImpl.class);
    @Autowired
    private AgrFormulaMapper agrFormulaMapper;
    @Value(value="${SMM1_COPPER:SMM\u4e00\u53f7\u7535\u89e3\u94dc\u5747\u4ef7}")
    private String SMM1_COPPER = "SMM\u4e00\u53f7\u7535\u89e3\u94dc\u5747\u4ef7";
    @Value(value="${SMMA00_AL:SMMA00\u94dd\u5747\u4ef7}")
    private String SMMA00_AL = "SMMA00\u94dd\u5747\u4ef7";

    @PostMapping(value={"calculate"})
    public CnncCalculateByFormulaRspBO calculate(@RequestBody CnncCalculateByFormulaReqBO reqBO) {
        CnncCalculateByFormulaRspBO rspBO = new CnncCalculateByFormulaRspBO();
        rspBO.setResult("0.00");
        AgrFormulaPO agrFormulaPO = new AgrFormulaPO();
        agrFormulaPO.setFormulaId(reqBO.getFormulaId());
        List<AgrFormulaPO> agrFormulaPOS = this.agrFormulaMapper.selectByConditionPage(agrFormulaPO, (Page<AgrFormulaBO>)new Page(1, 1));
        if (CollectionUtils.isEmpty(agrFormulaPOS)) {
            throw new BusinessException("8888", "\u516c\u5f0f\u4e0d\u5b58\u5728!");
        }
        AgrAgreementSkuFormulaBO agreementSkuFormulaBO = (AgrAgreementSkuFormulaBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AgrAgreementSkuFormulaBO.class);
        try {
            AgrFormulaPO formulaPO = agrFormulaPOS.get(0);
            String smm1coppervalue = "";
            String smm1alvalue = "";
            double exceptResult1 = -1.0;
            double exceptResult2 = -1.0;
            Boolean flag = false;
            Map<String, Double> variableMap = this.setVariableMap(agreementSkuFormulaBO, agrFormulaPOS.get(0));
            if (!StringUtils.isBlank((CharSequence)agrFormulaPOS.get(0).getQuotaDataOrigin())) {
                List quotaDataOriginBOS = JSON.parseArray((String)agrFormulaPOS.get(0).getQuotaDataOrigin(), QuotaDataOriginBO.class);
                for (QuotaDataOriginBO quotaDataOriginBO : quotaDataOriginBOS) {
                    if (quotaDataOriginBO.getQuotaId().equals("s20015437")) {
                        smm1coppervalue = quotaDataOriginBO.getValue();
                    }
                    if (!quotaDataOriginBO.getQuotaId().equals("s20016448")) continue;
                    smm1alvalue = quotaDataOriginBO.getValue();
                }
                if (!StringUtils.isBlank((CharSequence)formulaPO.getExceptFormulaContent1())) {
                    exceptResult1 = ParsiiUtils.doEvaluate(formulaPO.getExceptFormulaContent1(), variableMap);
                }
                if (!StringUtils.isBlank((CharSequence)formulaPO.getExceptFormulaContent2())) {
                    exceptResult2 = ParsiiUtils.doEvaluate(formulaPO.getExceptFormulaContent2(), variableMap);
                }
                if (formulaPO.getExceptMethod() != null && exceptResult1 != -1.0 && exceptResult2 != -1.0) {
                    if (formulaPO.getExceptMethod().equals("and")) {
                        if (exceptResult1 > 0.0 && exceptResult2 > 0.0) {
                            flag = true;
                        }
                    } else if (formulaPO.getExceptMethod().equals("or") && (exceptResult1 > 0.0 || exceptResult2 > 0.0)) {
                        flag = true;
                    }
                } else if (exceptResult1 != -1.0 && exceptResult1 > 0.0) {
                    flag = true;
                } else if (exceptResult2 != -1.0 && exceptResult2 > 0.0) {
                    flag = true;
                }
                if (flag.booleanValue()) {
                    if (!StringUtils.isBlank((CharSequence)smm1coppervalue)) {
                        variableMap.put(this.SMM1_COPPER, Double.valueOf(smm1coppervalue));
                    }
                    if (!StringUtils.isBlank((CharSequence)smm1alvalue)) {
                        variableMap.put(this.SMMA00_AL, Double.valueOf(smm1alvalue));
                    }
                }
            }
            double result = ParsiiUtils.doEvaluate(agrFormulaPOS.get(0).getFormulaContent(), variableMap);
            BigDecimal price = BigDecimal.valueOf(result).setScale(4, RoundingMode.DOWN);
            rspBO.setResult(price.toPlainString());
        }
        catch (Exception e) {
            log.error("\u516c\u5f0f\u8ba1\u7b97\u9519\u8bef:" + e.getMessage(), (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u516c\u5f0f\u8ba1\u7b97\u9519\u8bef:" + e.getMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<String, Double> setVariableMap(AgrAgreementSkuFormulaBO agreementSkuFormulaBO, AgrFormulaPO agrFormulaPO) {
        HashMap<String, Double> variableMap = new HashMap<String, Double>();
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue1())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue1())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue1() + "\u5fc5\u586b!");
            }
            variableMap.put(agrFormulaPO.getConstantValue1(), Double.valueOf(agreementSkuFormulaBO.getConstantValue1()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue2())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue2())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue2() + "\u5fc5\u586b!");
            }
            variableMap.put(agrFormulaPO.getConstantValue2(), Double.valueOf(agreementSkuFormulaBO.getConstantValue2()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue3())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue3())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue3() + "\u5fc5\u586b!");
            }
            variableMap.put(agrFormulaPO.getConstantValue3(), Double.valueOf(agreementSkuFormulaBO.getConstantValue3()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue4())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue4())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue4() + "\u5fc5\u586b!");
            }
            variableMap.put(agrFormulaPO.getConstantValue4(), Double.valueOf(agreementSkuFormulaBO.getConstantValue4()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue5())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue5())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue5() + "\u5fc5\u586b!");
            }
            variableMap.put(agrFormulaPO.getConstantValue5(), Double.valueOf(agreementSkuFormulaBO.getConstantValue5()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue6())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue6())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue6() + "\u5fc5\u586b!");
            }
            variableMap.put(agrFormulaPO.getConstantValue6(), Double.valueOf(agreementSkuFormulaBO.getConstantValue6()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue7())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue7())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue7() + "\u5fc5\u586b!");
            }
            variableMap.put(agrFormulaPO.getConstantValue7(), Double.valueOf(agreementSkuFormulaBO.getConstantValue7()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue8())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue8())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue8() + "\u5fc5\u586b!");
            }
            variableMap.put(agrFormulaPO.getConstantValue8(), Double.valueOf(agreementSkuFormulaBO.getConstantValue8()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue9())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue9())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue9() + "\u5fc5\u586b!");
            }
            variableMap.put(agrFormulaPO.getConstantValue9(), Double.valueOf(agreementSkuFormulaBO.getConstantValue9()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue10())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue10())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue10() + "\u5fc5\u586b!");
            }
            variableMap.put(agrFormulaPO.getConstantValue10(), Double.valueOf(agreementSkuFormulaBO.getConstantValue10()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getNameA())) {
            if (StringUtils.isBlank((CharSequence)agrFormulaPO.getVariableA())) {
                throw new BusinessException("8888", agrFormulaPO.getNameA() + "\u5fc5\u586b!");
            }
            variableMap.put(agrFormulaPO.getNameA(), Double.valueOf(agrFormulaPO.getVariableA()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getNameB())) {
            if (StringUtils.isBlank((CharSequence)agrFormulaPO.getVariableB())) {
                throw new BusinessException("8888", agrFormulaPO.getNameB() + "\u5fc5\u586b!");
            }
            variableMap.put(agrFormulaPO.getNameB(), Double.valueOf(agrFormulaPO.getVariableB()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getNameC())) {
            if (StringUtils.isBlank((CharSequence)agrFormulaPO.getVariableC())) {
                throw new BusinessException("8888", agrFormulaPO.getNameC() + "\u503c\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getNameC(), Double.valueOf(agrFormulaPO.getVariableC()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getNameD())) {
            if (StringUtils.isBlank((CharSequence)agrFormulaPO.getVariableD())) {
                throw new BusinessException("8888", agrFormulaPO.getNameD() + "\u503c\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getNameD(), Double.valueOf(agrFormulaPO.getVariableD()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getNameE())) {
            if (StringUtils.isBlank((CharSequence)agrFormulaPO.getVariableE())) {
                throw new BusinessException("8888", agrFormulaPO.getNameE() + "\u503c\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getNameE(), Double.valueOf(agrFormulaPO.getVariableE()));
        }
        return variableMap;
    }
}

