/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.extend.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.EcpContractOperateService;
import com.tydic.agreement.ability.bo.EcpContractBO;
import com.tydic.agreement.ability.bo.EcpContractItemBO;
import com.tydic.agreement.ability.bo.EcpContractLogBO;
import com.tydic.agreement.ability.bo.EcpContractOperateReqBO;
import com.tydic.agreement.ability.bo.EcpContractOperateRspBO;
import com.tydic.agreement.ability.bo.EcpContractScopeBO;
import com.tydic.agreement.ability.bo.EcpScopeCodesBo;
import com.tydic.agreement.ability.bo.ExtContractInfoBO;
import com.tydic.agreement.ability.bo.QryEcpContractLogReqBO;
import com.tydic.agreement.ability.bo.QryEcpContractLogRspBO;
import com.tydic.agreement.ability.bo.QryEcpContractReqBO;
import com.tydic.agreement.ability.bo.QryEcpContractRspBO;
import com.tydic.agreement.ability.bo.ScopeCodeBo;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.EcpContractOperateBusiService;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgrCustomizeMapper;
import com.tydic.agreement.dao.AgrSyncContractInterfaceLogMapper;
import com.tydic.agreement.dao.EcpContractLogMapper;
import com.tydic.agreement.dao.EcpContractMapper;
import com.tydic.agreement.dao.EcpContractScopeLogMapper;
import com.tydic.agreement.dao.EcpContractScopeMapper;
import com.tydic.agreement.dao.po.AgrSyncContractInterfaceLogPO;
import com.tydic.agreement.dao.po.EcpContractLogPO;
import com.tydic.agreement.dao.po.EcpContractPO;
import com.tydic.agreement.dao.po.EcpContractScopeLogPO;
import com.tydic.agreement.utils.DuplicateCommitLimit;
import com.tydic.commodity.bo.busi.UccCommdMeasureInfoReqBo;
import com.tydic.commodity.bo.busi.UccCommdMeasureInfoRspBo;
import com.tydic.commodity.bo.busi.UccCommdMeasureReqBo;
import com.tydic.commodity.bo.busi.UccEMdmCatalogBO;
import com.tydic.commodity.busi.api.UccCommdMeasureInfoBusiService;
import com.tydic.commodity.busi.api.UccCommodityMeasureBo;
import com.tydic.commodity.enumType.YesNoEnum;
import com.tydic.enquiry.api.AddProjectInfoAbilityService;
import com.tydic.enquiry.api.QryProjectInfoListPageAbilityService;
import com.tydic.enquiry.api.bo.AddProjectInfoReqBO;
import com.tydic.enquiry.api.bo.AddProjectInfoRspBO;
import com.tydic.enquiry.api.bo.ProjectInfoBO;
import com.tydic.enquiry.api.bo.QryProjectInfoListPageReqBO;
import com.tydic.enquiry.api.bo.QryProjectInfoListPageRspBO;
import com.tydic.uccext.bo.CnncCatalogListQueryAbilityReqBO;
import com.tydic.uccext.bo.CnncCatalogListQueryAbilityRspBO;
import com.tydic.uccext.bo.UccMaterialCommodityTypeBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialReqBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialRspBO;
import com.tydic.uccext.service.CnncCatalogListQueryAbilityService;
import com.tydic.uccext.service.UccQryCommodityTypeByMaterialService;
import com.tydic.umc.common.EnterpriseOrgExtMapJoinBO;
import com.tydic.umcext.ability.org.UmcOrgExtMapOperateAbilityService;
import com.tydic.umcext.ability.org.bo.UmcOrgExtMapOperateAbilityReqBO;
import com.tydic.umcext.ability.org.bo.UmcOrgExtMapOperateAbilityRspBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import com.tydic.umcext.ability.supplier.UmcSupplierAccountEnableAbilityService;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityReqBO;
import com.tydic.umcext.ability.supplier.bo.UmcQrySupplierInfoDetailAbilityRspBO;
import com.tydic.umcext.ability.supplier.bo.UmcSupplierAccountEnableAbilityReqBO;
import com.tydic.umcext.constant.UmcCommConstant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_TEST/2.0.0/com.tydic.agreement.ability.EcpContractOperateService"})
public class EcpContractOperateServiceImpl
implements EcpContractOperateService {
    private static final Logger log = LoggerFactory.getLogger(EcpContractOperateServiceImpl.class);
    private static final List<Integer> ecpPurchaseTypeList = Arrays.asList(2, 3, 4);
    @Autowired
    private AgrCustomizeMapper agrCustomizeMapper;
    @Autowired
    private EcpContractMapper ecpContractMapper;
    @Autowired
    private EcpContractScopeMapper ecpContractScopeMapper;
    @Autowired
    private EcpContractLogMapper ecpContractLogMapper;
    @Autowired
    private EcpContractScopeLogMapper ecpContractScopeLogMapper;
    @Autowired
    private AgrSyncContractInterfaceLogMapper agrSyncContractInterfaceLogMapper;
    @Autowired
    private EcpContractOperateBusiService ecpContractOperateBusiService;
    @Autowired
    private UmcOrgExtMapOperateAbilityService umcOrgExtMapOperateAbilityService;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private AddProjectInfoAbilityService addProjectInfoAbilityService;
    @Autowired
    private QryProjectInfoListPageAbilityService qryProjectInfoListPageAbilityService;
    @Autowired
    private UccQryCommodityTypeByMaterialService uccQryCommodityTypeByMaterialService;
    @Autowired
    private UmcSupplierAccountEnableAbilityService umcSupplierAccountEnableAbilityService;
    @Autowired
    private UccCommdMeasureInfoBusiService uccCommdMeasureInfoBusiService;
    @Autowired
    private CnncCatalogListQueryAbilityService cnncCatalogListQueryAbilityService;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;

    @DuplicateCommitLimit
    @PostMapping(value={"syncEcpContract"})
    public EcpContractOperateRspBO syncEcpContract(@RequestBody EcpContractOperateReqBO reqBO) {
        AgrSyncContractInterfaceLogPO agrSyncContractInterfaceLogPo4;
        log.debug("ECP\u540c\u6b65\u5408\u540c\u5165\u53c2\u8be6\u60c5:{}", (Object)JSON.toJSONString((Object)reqBO));
        long logId = Sequence.getInstance().nextId();
        boolean logFlag = true;
        try {
            AgrSyncContractInterfaceLogPO agrSyncContractInterfaceLogPo2 = new AgrSyncContractInterfaceLogPO();
            agrSyncContractInterfaceLogPo2.setLogId(logId);
            agrSyncContractInterfaceLogPo2.setCreateTime(new Date());
            agrSyncContractInterfaceLogPo2.setRelSystem(AgrEnum.RelSystem.ECP.toString());
            agrSyncContractInterfaceLogPo2.setInterfaceType(AgrEnum.SyncContractInterfaceType.receive.getType());
            agrSyncContractInterfaceLogPo2.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncEcpContract.toString());
            agrSyncContractInterfaceLogPo2.setKeyParam(reqBO.getContractCode());
            agrSyncContractInterfaceLogPo2.setParams(JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
            this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPo2);
        }
        catch (Exception ignore) {
            logFlag = false;
        }
        EcpContractOperateRspBO rspBO = new EcpContractOperateRspBO();
        try {
            this.validPrams(reqBO);
            if (ecpPurchaseTypeList.contains(reqBO.getCenterPurchaseType())) {
                EnterpriseOrgExtMapJoinBO purchaseOrgExtMapJoinBO = this.qryOrgId(reqBO.getPurImpUnitOrgCode());
                if (purchaseOrgExtMapJoinBO == null) {
                    throw new ZTBusinessException("\u91c7\u8d2d\u5b9e\u65bd\u5355\u4f4d\u673a\u6784\u7f16\u53f7\u67e5\u8be2\u4e0d\u5b58\u5728!");
                }
                reqBO.setPurImpUnitOrgId(purchaseOrgExtMapJoinBO.getOrgId());
                reqBO.setPurImpUnitOrgName(purchaseOrgExtMapJoinBO.getOrgName());
            }
            reqBO.setEcpContractId(reqBO.getContractId());
            EnterpriseOrgExtMapJoinBO enterpriseOrgExtMapJoinBO1 = this.qryOrgId(reqBO.getOrgCode());
            EnterpriseOrgExtMapJoinBO enterpriseOrgExtMapJoinBO2 = this.qryOrgId(reqBO.getVendorCode());
            Long vendorId = null;
            if (enterpriseOrgExtMapJoinBO1 == null) {
                throw new ZTBusinessException("\u5bf9\u5e94\u5355\u4f4d\u67e5\u8be2\u4e0d\u5b58\u5728!");
            }
            QryProjectInfoListPageReqBO qryProjectInfoListPageReqBO = new QryProjectInfoListPageReqBO();
            qryProjectInfoListPageReqBO.setProjectCode(reqBO.getPackCode());
            QryProjectInfoListPageRspBO qryProjectInfoListPageRspBO = this.qryProjectInfoListPageAbilityService.qryProjectInfoListPage(qryProjectInfoListPageReqBO);
            if (!CollectionUtils.isEmpty((Collection)qryProjectInfoListPageRspBO.getProjectInfoList())) {
                reqBO.setEcpProjectId(((ProjectInfoBO)qryProjectInfoListPageRspBO.getProjectInfoList().get(0)).getProjectId().toString());
                reqBO.setEcpProjectCode(((ProjectInfoBO)qryProjectInfoListPageRspBO.getProjectInfoList().get(0)).getProjectCode());
                reqBO.setEcpProjectName(((ProjectInfoBO)qryProjectInfoListPageRspBO.getProjectInfoList().get(0)).getProjectName());
            } else {
                AddProjectInfoReqBO addProjectInfoReqBO = new AddProjectInfoReqBO();
                ProjectInfoBO projectInfoBO = new ProjectInfoBO();
                addProjectInfoReqBO.setProjectInfo(projectInfoBO);
                projectInfoBO.setProjectCode(reqBO.getPackCode());
                projectInfoBO.setProjectName(reqBO.getPackName());
                addProjectInfoReqBO.setCompanyId(enterpriseOrgExtMapJoinBO1.getOrgId());
                addProjectInfoReqBO.setCompanyName(enterpriseOrgExtMapJoinBO1.getOrgName());
                AddProjectInfoRspBO addProjectInfoRspBO = this.addProjectInfoAbilityService.addProjectInfo(addProjectInfoReqBO);
                if (!addProjectInfoRspBO.getRespCode().equals("0000")) {
                    if (!addProjectInfoRspBO.getRespDesc().contains("\u9879\u76ee\u7f16\u7801\u91cd\u590d")) {
                        throw new BusinessException("8888", addProjectInfoRspBO.getRespDesc());
                    }
                } else {
                    reqBO.setEcpProjectId(addProjectInfoRspBO.getProjectId().toString());
                    reqBO.setEcpProjectCode(reqBO.getPackCode());
                    reqBO.setEcpProjectName(reqBO.getPackName());
                }
            }
            reqBO.setOrgId(enterpriseOrgExtMapJoinBO1.getOrgId().toString());
            reqBO.setOrgName(enterpriseOrgExtMapJoinBO1.getOrgName());
            if (enterpriseOrgExtMapJoinBO2 == null) {
                throw new ZTBusinessException("\u5bf9\u5e94\u4f9b\u5e94\u5546\u67e5\u8be2\u4e0d\u5b58\u5728!");
            }
            UmcQrySupplierInfoDetailAbilityReqBO umcQrySupplierInfoDetailAbilityReqBO = new UmcQrySupplierInfoDetailAbilityReqBO();
            umcQrySupplierInfoDetailAbilityReqBO.setOrgIdWeb(enterpriseOrgExtMapJoinBO2.getOrgId());
            UmcQrySupplierInfoDetailAbilityRspBO umcQrySupplierInfoDetailAbilityRspBO = this.umcQrySupplierInfoDetailAbilityService.qrySupplierInfoDetail(umcQrySupplierInfoDetailAbilityReqBO);
            if (!"0000".equals(umcQrySupplierInfoDetailAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u5e94\u5546\u5931\u8d25:" + umcQrySupplierInfoDetailAbilityRspBO.getRespDesc());
            }
            if (umcQrySupplierInfoDetailAbilityRspBO.getSupplierId() == null) {
                throw new ZTBusinessException("\u5bf9\u5e94\u4f9b\u5e94\u5546\u67e5\u8be2\u4e0d\u5b58\u5728!");
            }
            vendorId = umcQrySupplierInfoDetailAbilityRspBO.getSupplierId();
            reqBO.setVendorId(vendorId.toString());
            reqBO.setVendorName(umcQrySupplierInfoDetailAbilityRspBO.getSupplierName());
            if (!CollectionUtils.isEmpty((Collection)reqBO.getScopeCodes())) {
                ArrayList<ScopeCodeBo> scopeCodeBoList = new ArrayList<ScopeCodeBo>();
                for (EcpScopeCodesBo scopeCode : reqBO.getScopeCodes()) {
                    ScopeCodeBo scopeCodeBo = new ScopeCodeBo();
                    EnterpriseOrgExtMapJoinBO enterpriseOrgExtMapJoinBO = this.qryOrgId(scopeCode.getScopeCode());
                    if (enterpriseOrgExtMapJoinBO == null) {
                        log.error("\u67e5\u8be2\u5e94\u7528\u8303\u56f4[" + scopeCode + "]\u5bf9\u5e94\u7684\u5355\u4f4d\u4e0d\u5b58\u5728!");
                    } else {
                        scopeCodeBo.setOrgId(enterpriseOrgExtMapJoinBO.getOrgId().toString());
                        scopeCodeBo.setOrgName(enterpriseOrgExtMapJoinBO.getOrgName());
                    }
                    scopeCodeBo.setEcpContractId(reqBO.getContractId());
                    scopeCodeBo.setScopeCode(scopeCode.getScopeCode());
                    scopeCodeBoList.add(scopeCodeBo);
                }
                reqBO.setScopeCodeBoList(scopeCodeBoList);
            }
        }
        catch (Exception e) {
            rspBO.setCode("1");
            rspBO.setMessage("\u5931\u8d25");
            rspBO.setSuccess(Boolean.valueOf(false));
            rspBO.setMeta("ECP\u5408\u540c\u540c\u6b65\u5931\u8d25." + e.getMessage());
            try {
                AgrSyncContractInterfaceLogPO agrSyncContractInterfaceLogPo3 = new AgrSyncContractInterfaceLogPO();
                agrSyncContractInterfaceLogPo3.setLogId(logId);
                agrSyncContractInterfaceLogPo3.setResult(rspBO.getMeta());
                agrSyncContractInterfaceLogPo3.setDealResult(AgrEnum.SuccessOrError.ERROR.getCode());
                if (logFlag) {
                    this.agrSyncContractInterfaceLogMapper.updateById(agrSyncContractInterfaceLogPo3);
                } else {
                    agrSyncContractInterfaceLogPo3.setCreateTime(new Date());
                    agrSyncContractInterfaceLogPo3.setRelSystem(AgrEnum.RelSystem.ECP.toString());
                    agrSyncContractInterfaceLogPo3.setInterfaceType(AgrEnum.SyncContractInterfaceType.receive.getType());
                    agrSyncContractInterfaceLogPo3.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncEcpContract.toString());
                    agrSyncContractInterfaceLogPo3.setKeyParam(reqBO.getContractCode());
                    agrSyncContractInterfaceLogPo3.setParams(JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                    this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPo3);
                }
            }
            catch (Exception agrSyncContractInterfaceLogPo3) {
                // empty catch block
            }
            return rspBO;
        }
        rspBO = this.ecpContractOperateBusiService.syncEcpContract(reqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            rspBO.setCode("0");
            rspBO.setMessage("\u6210\u529f");
            rspBO.setSuccess(Boolean.valueOf(true));
            rspBO.setMeta("\u6210\u529f");
            try {
                agrSyncContractInterfaceLogPo4 = new AgrSyncContractInterfaceLogPO();
                agrSyncContractInterfaceLogPo4.setLogId(logId);
                agrSyncContractInterfaceLogPo4.setResult(rspBO.getMeta());
                agrSyncContractInterfaceLogPo4.setDealResult(AgrEnum.SuccessOrError.SUCCESS.getCode());
                if (logFlag) {
                    this.agrSyncContractInterfaceLogMapper.updateById(agrSyncContractInterfaceLogPo4);
                } else {
                    agrSyncContractInterfaceLogPo4.setCreateTime(new Date());
                    agrSyncContractInterfaceLogPo4.setRelSystem(AgrEnum.RelSystem.ECP.toString());
                    agrSyncContractInterfaceLogPo4.setInterfaceType(AgrEnum.SyncContractInterfaceType.receive.getType());
                    agrSyncContractInterfaceLogPo4.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncEcpContract.toString());
                    agrSyncContractInterfaceLogPo4.setKeyParam(reqBO.getContractCode());
                    agrSyncContractInterfaceLogPo4.setParams(JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                    this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPo4);
                }
            }
            catch (Exception agrSyncContractInterfaceLogPo4) {
                // empty catch block
            }
            try {
                UmcSupplierAccountEnableAbilityReqBO umcSupplierAccountEnableAbilityReqBo = new UmcSupplierAccountEnableAbilityReqBO();
                umcSupplierAccountEnableAbilityReqBo.setSupplierIdList(Collections.singletonList(Long.valueOf(reqBO.getVendorId())));
                this.umcSupplierAccountEnableAbilityService.dealSupplierAccountEnable(umcSupplierAccountEnableAbilityReqBo);
            }
            catch (Exception umcSupplierAccountEnableAbilityReqBo) {
                // empty catch block
            }
            try {
                List<String> collectMeasureNames;
                if (!CollectionUtils.isEmpty((Collection)reqBO.getItemList()) && !CollectionUtils.isEmpty(collectMeasureNames = reqBO.getItemList().stream().map(EcpContractItemBO::getMeasureName).filter(StringUtils::hasText).distinct().collect(Collectors.toList()))) {
                    UccCommdMeasureInfoReqBo uccCommdMeasureInfoReqBo = new UccCommdMeasureInfoReqBo();
                    uccCommdMeasureInfoReqBo.setMeasureNames(collectMeasureNames);
                    UccCommdMeasureInfoRspBo uccCommdMeasureInfoRspBo = this.uccCommdMeasureInfoBusiService.queryByBinaryNames(uccCommdMeasureInfoReqBo);
                    if ("0000".equals(uccCommdMeasureInfoRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)uccCommdMeasureInfoRspBo.getRows())) {
                        List uccCommodityMeasureBos = JSONArray.parseArray((String)JSONArray.toJSONString((Object)uccCommdMeasureInfoRspBo.getRows()), UccCommodityMeasureBo.class);
                        collectMeasureNames.removeAll(uccCommodityMeasureBos.stream().map(UccCommodityMeasureBo::getMeasureName).collect(Collectors.toList()));
                    }
                    if (!CollectionUtils.isEmpty(collectMeasureNames)) {
                        UccCommdMeasureReqBo uccCommdMeasureReqBo = new UccCommdMeasureReqBo();
                        uccCommdMeasureReqBo.setUsername("sys");
                        uccCommdMeasureReqBo.setMeasureType(Integer.valueOf(0));
                        collectMeasureNames.forEach(measureName -> {
                            uccCommdMeasureReqBo.setMeasureName(measureName);
                            this.uccCommdMeasureInfoBusiService.addMeasure(uccCommdMeasureReqBo);
                        });
                    }
                }
            }
            catch (Exception collectMeasureNames) {}
        } else {
            rspBO.setCode("1");
            rspBO.setMessage("\u5931\u8d25");
            rspBO.setSuccess(Boolean.valueOf(false));
            rspBO.setMeta("ECP\u5408\u540c\u540c\u6b65\u5931\u8d25." + rspBO.getRespDesc());
            try {
                agrSyncContractInterfaceLogPo4 = new AgrSyncContractInterfaceLogPO();
                agrSyncContractInterfaceLogPo4.setLogId(logId);
                agrSyncContractInterfaceLogPo4.setResult(rspBO.getMeta());
                agrSyncContractInterfaceLogPo4.setDealResult(AgrEnum.SuccessOrError.ERROR.getCode());
                if (logFlag) {
                    this.agrSyncContractInterfaceLogMapper.updateById(agrSyncContractInterfaceLogPo4);
                } else {
                    agrSyncContractInterfaceLogPo4.setCreateTime(new Date());
                    agrSyncContractInterfaceLogPo4.setRelSystem(AgrEnum.RelSystem.ECP.toString());
                    agrSyncContractInterfaceLogPo4.setInterfaceType(AgrEnum.SyncContractInterfaceType.receive.getType());
                    agrSyncContractInterfaceLogPo4.setInterfaceName(AgrEnum.SyncContractInterfaceName.syncEcpContract.toString());
                    agrSyncContractInterfaceLogPo4.setKeyParam(reqBO.getContractCode());
                    agrSyncContractInterfaceLogPo4.setParams(JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteBigDecimalAsPlain}));
                    this.agrSyncContractInterfaceLogMapper.insert(agrSyncContractInterfaceLogPo4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rspBO;
    }

    private void validPrams(EcpContractOperateReqBO reqBO) {
        if (!StringUtils.hasText((String)reqBO.getOrgCode())) {
            throw new ZTBusinessException("OrgCode \u4e3a\u7a7a!");
        }
        if (!StringUtils.hasText((String)reqBO.getContractCode())) {
            throw new ZTBusinessException("contractCode \u4e3a\u7a7a!");
        }
        if (!StringUtils.hasText((String)reqBO.getVendorCode())) {
            throw new ZTBusinessException("vendorCode \u4e3a\u7a7a!");
        }
        if (reqBO.getContractType() == null) {
            throw new ZTBusinessException("\u5408\u540c\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (ecpPurchaseTypeList.contains(reqBO.getCenterPurchaseType()) && !StringUtils.hasText((String)reqBO.getPurImpUnitOrgCode())) {
            throw new ZTBusinessException("\u96c6\u4e2d\u91c7\u8d2d\u7c7b\u578b\u4e3a\u4e8c\u7ea7\u96c6\u91c7\uff08\u4e8c\u7ea7\u76f4\u63a5\u3001\u4e8c\u7ea7\u6388\u6743\u3001\u4e8c\u7ea7\u7ec4\u7ec7\uff09\u65f6\uff0c\u91c7\u8d2d\u5b9e\u65bd\u5355\u4f4d\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getItemList())) {
            List catalogCodes;
            Object sj;
            UccMaterialCommodityTypeBO uccMaterialCommodityTypeBo;
            List allCatalogCodes = reqBO.getItemList().stream().map(EcpContractItemBO::getCatalogCode).collect(Collectors.toList());
            CnncCatalogListQueryAbilityReqBO cnncCatalogListQueryAbilityReqBO = new CnncCatalogListQueryAbilityReqBO();
            cnncCatalogListQueryAbilityReqBO.setCatalogCodes(allCatalogCodes);
            CnncCatalogListQueryAbilityRspBO cnncCatalogListQueryAbilityRspBO = this.cnncCatalogListQueryAbilityService.qryCatalogList(cnncCatalogListQueryAbilityReqBO);
            Map<Object, Object> catalogAndFreezeMap = !CollectionUtils.isEmpty((Collection)cnncCatalogListQueryAbilityRspBO.getCatalogBOList()) ? cnncCatalogListQueryAbilityRspBO.getCatalogBOList().stream().collect(Collectors.toMap(UccEMdmCatalogBO::getCatalogCode, obj -> {
                if (YesNoEnum.NO.getType().equals(obj.getFreezeFlag()) && YesNoEnum.NO.getType().equals(obj.getIsDelete())) {
                    return YesNoEnum.NO.getType();
                }
                return YesNoEnum.YES.getType();
            }, (a, b) -> a)) : Collections.emptyMap();
            for (EcpContractItemBO item : reqBO.getItemList()) {
                if (!StringUtils.hasText((String)item.getContractItemId()) || !StringUtils.hasText((String)item.getContractItemCode())) {
                    throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6ID\u6216\u5408\u540c\u660e\u7ec6\u7f16\u53f7\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)item.getItemName())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u7269\u9879\u540d\u79f0\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)item.getVariety())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u91c7\u8d2d\u7c7b\u578b\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)item.getCatalogCode())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u7269\u9879\u5206\u7c7b\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)item.getMeasureName())) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a");
                }
                if (AgrEnum.Variety.WZ.getCode().toString().equals(item.getVariety())) {
                    if (item.getTaxRate() == null) {
                        throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u7a0e\u7387\u4e3a\u7a7a");
                    }
                    if (!StringUtils.hasText((String)item.getMaterialCode())) {
                        throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u7269\u8d44\u7f16\u7801\u4e3a\u7a7a");
                    }
                    if (!StringUtils.hasText((String)item.getProducingArea())) {
                        throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u7269\u8d44\u4ea7\u5730\u4e3a\u7a7a");
                    }
                } else {
                    Integer freeze = (Integer)catalogAndFreezeMap.get(item.getCatalogCode());
                    if (YesNoEnum.NO.getType().equals(freeze) && !StringUtils.hasText((String)item.getMaterialCode())) {
                        throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u7269\u8d44\u7f16\u7801\u4e3a\u7a7a");
                    }
                }
                if (!AgrEnum.EcpContractType.GDZJ.getCode().equals(reqBO.getContractType().toString())) continue;
                if (item.getBuyNumber() == null) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u6570\u91cf\u4e3a\u7a7a");
                }
                if (item.getBuyPrice() == null) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u5355\u4ef7\u4e3a\u7a7a");
                }
                if (item.getTotalBuyPrice() == null) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u603b\u4ef7\u4e3a\u7a7a");
                }
                if (item.getBuyNumber().compareTo(AgrCommConstant.MAX_NUMBER) > 0) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u6570\u91cf\u8d85\u51fa\u53ef\u63a5\u6536\u6700\u5927\u8303\u56f4\uff0812\u4f4d\u6574\u6570+6\u4f4d\u5c0f\u6570\uff09");
                }
                if (item.getBuyPrice().compareTo(AgrCommConstant.MAX_PRICE) > 0) {
                    throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u5355\u4ef7\u8d85\u51fa\u53ef\u63a5\u6536\u6700\u5927\u8303\u56f4\uff0814\u4f4d\u6574\u6570+4\u4f4d\u5c0f\u6570\uff09");
                }
                if (item.getTotalBuyPrice().compareTo(AgrCommConstant.MAX_PRICE) <= 0) continue;
                throw new ZTBusinessException("\u660e\u7ec6[" + item.getContractItemCode() + "]\u603b\u4ef7\u8d85\u51fa\u53ef\u63a5\u6536\u6700\u5927\u8303\u56f4\uff0814\u4f4d\u6574\u6570+4\u4f4d\u5c0f\u6570\uff09");
            }
            List materialCodes = reqBO.getItemList().stream().map(EcpContractItemBO::getMaterialCode).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(materialCodes)) {
                UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                uccQryCommodityTypeByMaterialReqBo.setMaterialCodes(materialCodes);
                UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByMaterial(uccQryCommodityTypeByMaterialReqBo);
                if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                    throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u7f16\u7801\u5931\u8d25");
                }
                Map<String, UccMaterialCommodityTypeBO> collectByMaterialCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getMaterialCode, bo -> bo, (a, b) -> a));
                HashSet<String> sjCheckMaterial = new HashSet<String>();
                HashSet<String> sjCheckMaterialAndL3Catalog = new HashSet<String>();
                for (EcpContractItemBO item : reqBO.getItemList()) {
                    if (!StringUtils.hasText((String)item.getMaterialCode())) continue;
                    uccMaterialCommodityTypeBo = collectByMaterialCode.get(item.getMaterialCode());
                    if (uccMaterialCommodityTypeBo == null || CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) {
                        sjCheckMaterial.add(item.getMaterialCode());
                        continue;
                    }
                    if (item.getCatalogCode().equals(uccMaterialCommodityTypeBo.getL3CatalogCode())) continue;
                    sjCheckMaterialAndL3Catalog.add(item.getMaterialCode());
                }
                if (!CollectionUtils.isEmpty(sjCheckMaterial)) {
                    sj = new StringJoiner(",", "[", "]");
                    sjCheckMaterial.forEach(((StringJoiner)sj)::add);
                    throw new ZTBusinessException("\u660e\u7ec6\u7269\u8d44\u7f16\u7801" + sj + "\u4e0d\u5b58\u5728");
                }
                if (!CollectionUtils.isEmpty(sjCheckMaterialAndL3Catalog)) {
                    sj = new StringJoiner(",", "[", "]");
                    sjCheckMaterialAndL3Catalog.forEach(((StringJoiner)sj)::add);
                    throw new ZTBusinessException("\u660e\u7ec6\u7269\u8d44\u7f16\u7801" + sj + "\u5bf9\u5e94\u7684\u7269\u8d44\u5206\u7c7b\u4e0d\u5b58\u5728\u6216\u4e0d\u4e00\u81f4");
                }
            }
            if (!CollectionUtils.isEmpty(catalogCodes = reqBO.getItemList().stream().map(EcpContractItemBO::getCatalogCode).filter(str -> StringUtils.hasText((String)str) && YesNoEnum.YES.getType().equals(catalogAndFreezeMap.get(str))).filter(StringUtils::hasText).distinct().collect(Collectors.toList()))) {
                UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
                uccQryCommodityTypeByMaterialReqBo.setSecondCatalogs(catalogCodes);
                UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByl2CatalogCode(uccQryCommodityTypeByMaterialReqBo);
                if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)uccQryCommodityTypeByMaterialRspBo.getMaterialTypes())) {
                    throw new ZTBusinessException("\u6821\u9a8c\u660e\u7ec6\u7269\u8d44\u5206\u7c7b\u5931\u8d25");
                }
                Map<String, UccMaterialCommodityTypeBO> collectByCatalogCode = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes().stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getL2CatalogCode, bo -> bo, (a, b) -> a));
                HashSet<String> sjCheckCatalogCode = new HashSet<String>();
                for (EcpContractItemBO item : reqBO.getItemList()) {
                    if (!YesNoEnum.YES.getType().equals(catalogAndFreezeMap.get(item.getCatalogCode())) || (uccMaterialCommodityTypeBo = collectByCatalogCode.get(item.getCatalogCode())) != null && !CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) continue;
                    sjCheckCatalogCode.add(item.getCatalogCode());
                }
                if (!CollectionUtils.isEmpty(sjCheckCatalogCode)) {
                    sj = new StringJoiner(",", "[", "]");
                    sjCheckCatalogCode.forEach(((StringJoiner)sj)::add);
                    throw new ZTBusinessException("\u660e\u7ec6\u7269\u8d44\u5206\u7c7b" + sj + "\u4e0d\u5b58\u5728");
                }
            }
        }
    }

    private EnterpriseOrgExtMapJoinBO qryOrgId(String esbOrgCode) {
        EnterpriseOrgExtMapJoinBO enterpriseOrgExtMapJoinBO = null;
        UmcOrgExtMapOperateAbilityReqBO umcOrgExtMapOperateAbilityReqBO = new UmcOrgExtMapOperateAbilityReqBO();
        umcOrgExtMapOperateAbilityReqBO.setFieldValue(esbOrgCode);
        umcOrgExtMapOperateAbilityReqBO.setFieldCode("esbOrgCode");
        umcOrgExtMapOperateAbilityReqBO.setOperateType(UmcCommConstant.UmcOrgExtMapOperateStatus.JOIN_QRY);
        UmcOrgExtMapOperateAbilityRspBO umcOrgExtMapOperateAbilityRspBO = this.umcOrgExtMapOperateAbilityService.operate(umcOrgExtMapOperateAbilityReqBO);
        if (!"0000".equals(umcOrgExtMapOperateAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u7edf\u4e00\u8ba4\u8bc1\u552f\u4e00\u6807\u8bc6\u5931\u8d25!");
        }
        if (!CollectionUtils.isEmpty((Collection)umcOrgExtMapOperateAbilityRspBO.getRows())) {
            enterpriseOrgExtMapJoinBO = (EnterpriseOrgExtMapJoinBO)umcOrgExtMapOperateAbilityRspBO.getRows().get(0);
        }
        return enterpriseOrgExtMapJoinBO;
    }

    @PostMapping(value={"qryEcpContractList"})
    public QryEcpContractRspBO qryEcpContractList(@RequestBody QryEcpContractReqBO reqBO) {
        QryEcpContractRspBO rspBO = new QryEcpContractRspBO();
        EcpContractPO ecpContractPO = new EcpContractPO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrgIds())) {
            ecpContractPO.setOrgIds(reqBO.getOrgIds().stream().filter(Objects::nonNull).map(String::valueOf).map(String::trim).distinct().collect(Collectors.toList()));
        }
        ecpContractPO.setEcpContractId(reqBO.getEcpContractId());
        ecpContractPO.setContractCode(reqBO.getContractCode());
        ecpContractPO.setContractName(reqBO.getContractName());
        ecpContractPO.setCustomContractCode(reqBO.getCustomContractCode());
        ecpContractPO.setQryOpsModel(reqBO.getQryOpsModel());
        ArrayList ecpContractBOS = new ArrayList();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ExtContractInfoBO> extContractListPage = this.agrCustomizeMapper.getExtContractListPage(null, ecpContractPO, (Page<ExtContractInfoBO>)page);
        if (!CollectionUtils.isEmpty(extContractListPage)) {
            Map<String, String> scopeTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "EXT_SCOPE_TYPE_PCODE");
            extContractListPage.forEach(extContractInfoBO -> {
                EcpContractBO ecpContractBO = (EcpContractBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)extContractInfoBO), EcpContractBO.class);
                ecpContractBO.setEcpContractId(extContractInfoBO.getContractId());
                ecpContractBO.setCustomContractCode(extContractInfoBO.getCustomerContractCode());
                if (AgrEnum.RelSystem.SRM.toString().equalsIgnoreCase(extContractInfoBO.getRelSystem())) {
                    ecpContractBO.setScopeType(AgrEnum.ExtScopeType.MEMBER.getScopeTypeCode());
                    ecpContractBO.setScopeTypeStr(AgrEnum.ExtScopeType.MEMBER.getScopeTypeDesc());
                } else if (StringUtils.hasText((String)ecpContractBO.getScopeType())) {
                    ecpContractBO.setScopeTypeStr((String)scopeTypeStr.get(ecpContractBO.getScopeType()));
                }
                ecpContractBO.setSginTime(extContractInfoBO.getSignDate());
                ecpContractBO.setContractAmount(extContractInfoBO.getContractAmount() == null ? null : extContractInfoBO.getContractAmount().toPlainString());
                ecpContractBOS.add(ecpContractBO);
            });
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        } else {
            rspBO.setPageNo(Integer.valueOf(1));
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(1));
        }
        rspBO.setRows(ecpContractBOS);
        return rspBO;
    }

    @PostMapping(value={"qryEcpContractLogList"})
    public QryEcpContractLogRspBO qryEcpContractLogList(@RequestBody QryEcpContractLogReqBO reqBO) {
        QryEcpContractLogRspBO rspBO = new QryEcpContractLogRspBO();
        if (!StringUtils.hasText((String)reqBO.getContractCode()) && !StringUtils.hasText((String)reqBO.getEcpContractId())) {
            return rspBO;
        }
        EcpContractLogPO selectPO = new EcpContractLogPO();
        selectPO.setContractCode(reqBO.getContractCode());
        selectPO.setEcpContractId(reqBO.getEcpContractId());
        selectPO.setExtField1(reqBO.getAgreementId());
        selectPO.setExtField2(reqBO.getContractId());
        selectPO.setOrderBy(" update_time desc");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<EcpContractLogBO> ecpContractLogBOList = this.ecpContractLogMapper.selectListPageByCondition(selectPO, (Page<EcpContractLogPO>)page);
        if (!CollectionUtils.isEmpty(ecpContractLogBOList)) {
            EcpContractScopeLogPO ecpContractScopeLogPO = new EcpContractScopeLogPO();
            for (EcpContractLogBO ecpContractLogBO : ecpContractLogBOList) {
                ecpContractScopeLogPO.setLogId(ecpContractLogBO.getLogId());
                List<EcpContractScopeBO> ecpContractScopeBOS = this.ecpContractScopeLogMapper.selectListByCondition(ecpContractScopeLogPO);
                ecpContractLogBO.setEcpContractScopeList(ecpContractScopeBOS);
            }
            rspBO.setRows(ecpContractLogBOList);
            if (!ecpContractLogBOList.isEmpty()) {
                rspBO.setChangeFlag("1");
            }
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        } else {
            rspBO.setPageNo(Integer.valueOf(1));
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(1));
        }
        return rspBO;
    }
}

