/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.extend.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.agreement.atom.AgrDicDictionaryAtomService;
import com.tydic.agreement.common.bo.AgrAgreementSkuBO;
import com.tydic.agreement.common.bo.AgrDicDictionaryBO;
import com.tydic.agreement.common.bo.AgrImoprtTemplateBO;
import com.tydic.agreement.constant.AgrCommConstant;
import com.tydic.agreement.constant.AgrEnum;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgreementPO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.agreement.extend.busi.CnncAgrBatchImportAgreementSkuBusiService;
import com.tydic.agreement.extend.busi.CnncAgrExportImportResultsBusiService;
import com.tydic.agreement.extend.busi.bo.CnncAgrBatchImportAgreementSkuBusiReqBO;
import com.tydic.agreement.extend.busi.bo.CnncAgrBatchImportAgreementSkuBusiRspBO;
import com.tydic.agreement.extend.busi.bo.CnncAgrExportImportResultsBusiReqBO;
import com.tydic.agreement.extend.busi.bo.CnncAgrExportImportResultsBusiRspBO;
import com.tydic.agreement.extend.common.AgrExtCommonConstant;
import com.tydic.agreement.extend.facde.CnncAgrExternalCatalogLevelCheckServiceHolder;
import com.tydic.agreement.extend.facde.CnncAgrExternalImportResultLogServiceHolder;
import com.tydic.agreement.external.ucc.bo.AgrExternalCatalogLevelCheckReqBO;
import com.tydic.agreement.external.ucc.bo.AgrExternalCatalogLevelCheckRspBO;
import com.tydic.agreement.external.umc.bo.AgrExternalImportResultLogServiceReqBO;
import com.tydic.agreement.external.umc.bo.AgrExternalImportResultLogServiceRspBO;
import com.tydic.agreement.utils.ExcelUtils;
import com.tydic.agreement.utils.HttpUtil;
import com.tydic.commodity.bo.busi.UccEMdmCatalogBO;
import com.tydic.commodity.enumType.CatalogVarietyEnum;
import com.tydic.commodity.enumType.YesNoEnum;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleReqBO;
import com.tydic.contract.api.maintenance.bo.ContractSupplierSaleRspBO;
import com.tydic.contract.api.maintenance.service.QryContractSupplierListSaleService;
import com.tydic.uccext.bo.CnncCatalogListQueryAbilityReqBO;
import com.tydic.uccext.bo.CnncCatalogListQueryAbilityRspBO;
import com.tydic.uccext.bo.CnncCatalogPathQryAbilityReqBo;
import com.tydic.uccext.bo.CnncCatalogPathQryAbilityRspBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityReqBo;
import com.tydic.uccext.bo.CnncQryCommodityTypeListAbilityRspBo;
import com.tydic.uccext.bo.CnncUccEMdmCatalogAllBO;
import com.tydic.uccext.bo.UccMaterialCommodityTypeBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialReqBO;
import com.tydic.uccext.bo.UccQryCommodityTypeByMaterialRspBO;
import com.tydic.uccext.service.CnncBatchQryMaterialByCodeAbilityService;
import com.tydic.uccext.service.CnncCatalogListQueryAbilityService;
import com.tydic.uccext.service.CnncCatalogPathQryAbilityService;
import com.tydic.uccext.service.CnncQryCommodityTypeListAbilityService;
import com.tydic.uccext.service.UccQryCommodityTypeByMaterialService;
import com.tydic.umcext.ability.taxCode.UmcQryTaxCodeListService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CnncAgrBatchImportAgreementSkuBusiServiceImpl
implements CnncAgrBatchImportAgreementSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(CnncAgrBatchImportAgreementSkuBusiServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private CnncAgrExternalCatalogLevelCheckServiceHolder cnncAgrExternalCatalogLevelCheckServiceHolder;
    @Autowired
    private CnncAgrExportImportResultsBusiService cnncAgrExportImportResultsBusiService;
    @Autowired
    private CnncAgrExternalImportResultLogServiceHolder cnncAgrExternalImportResultLogServiceHolder;
    @Autowired
    private CnncBatchQryMaterialByCodeAbilityService cnncBatchQryMaterialByCodeAbilityService;
    @Autowired
    private UccQryCommodityTypeByMaterialService uccQryCommodityTypeByMaterialService;
    @Autowired
    private CnncCatalogPathQryAbilityService cnncCatalogPathQryAbilityService;
    @Autowired
    private QryContractSupplierListSaleService qryContractSupplierListSaleService;
    @Autowired
    private UmcQryTaxCodeListService umcQryTaxCodeListService;
    @Autowired
    private CnncQryCommodityTypeListAbilityService cnncQryCommodityTypeListAbilityService;
    @Autowired
    private CnncCatalogListQueryAbilityService cnncCatalogListQueryAbilityService;

    public static void main(String[] args) {
        String str = "[{\"buyPrice\":\"19600\",\"figure\":\"\",\"brandName\":\"\u4e0a\u4e0a\",\"buyNumber\":\"4500\",\"texture\":\"\u94dc\",\"materialId\":\"00085076\",\"measureName\":\"\u7c73\",\"spec\":\"2.5\",\"manufacturer\":\"\u6c5f\u82cf\u4e0a\u4e0a\u7535\u7f06\u96c6\u56e2\u6709\u9650\u516c\u53f8\",\"catalogName\":\"\u5851\u6599\u7edd\u7f18\u7535\u7f06\",\"supplyCycle\":\"25\",\"catalogId\":\"19090101\",\"taxCatalog\":\"000000000001\",\"isOil\":\"0\",\"impRemark\":\"\u6210\u529f\",\"impResult\":0,\"model\":\"BV\"},{\"buyPrice\":\"31300\",\"figure\":\"\",\"brandName\":\"\u4e0a\u4e0a\",\"buyNumber\":\"4500\",\"texture\":\"\u94dc\",\"materialId\":\"00104514\",\"measureName\":\"\u7c73\",\"spec\":\"4\",\"manufacturer\":\"\u6c5f\u82cf\u4e0a\u4e0a\u7535\u7f06\u96c6\u56e2\u6709\u9650\u516c\u53f8\",\"catalogName\":\"\u5851\u6599\u7edd\u7f18\u7535\u7f06\",\"supplyCycle\":\"25\",\"catalogId\":\"19090101\",\"taxCatalog\":\"000000000002\",\"isOil\":\"0\",\"impRemark\":\"\u6210\u529f\",\"impResult\":0,\"model\":\"BV\"},{\"buyPrice\":\"128000.0\",\"figure\":\"\",\"brandName\":\"\u4e0a\u4e0a\",\"buyNumber\":\"4500\",\"texture\":\"\u94dc\",\"materialId\":\"00091961\",\"measureName\":\"\u7c73\",\"spec\":\"16\",\"manufacturer\":\"\u6c5f\u82cf\u4e0a\u4e0a\u7535\u7f06\u96c6\u56e2\u6709\u9650\u516c\u53f8\",\"catalogName\":\"\u94dc\u82af\u5851\u6599\u7ebf\",\"supplyCycle\":\"25\",\"catalogId\":\"19140401\",\"taxCatalog\":\"000000000003\",\"isOil\":\"0\",\"impRemark\":\"\u6210\u529f\",\"impResult\":0,\"model\":\"WDZ-BYJ\"},{\"buyPrice\":\"20200\",\"figure\":\"\",\"brandName\":\"\u4e0a\u4e0a\",\"buyNumber\":\"3300\",\"texture\":\"\u94dc\",\"materialId\":\"00091962\",\"measureName\":\"\u7c73\",\"spec\":\"2.5\",\"manufacturer\":\"\u6c5f\u82cf\u4e0a\u4e0a\u7535\u7f06\u96c6\u56e2\u6709\u9650\u516c\u53f8\",\"catalogName\":\"\u94dc\u82af\u5851\u6599\u7ebf\",\"supplyCycle\":\"25\",\"catalogId\":\"19140401\",\"taxCatalog\":\"000000000004\",\"isOil\":\"0\",\"impRemark\":\"\u6210\u529f\",\"impResult\":0,\"model\":\"WDZ-BYJ\"},{\"buyPrice\":\"35100\",\"figure\":\"\",\"brandName\":\"\u4e0a\u4e0a\",\"buyNumber\":\"2400\",\"texture\":\"\u94dc\",\"materialId\":\"00091963\",\"measureName\":\"\u7c73\",\"spec\":\"4\",\"manufacturer\":\"\u6c5f\u82cf\u4e0a\u4e0a\u7535\u7f06\u96c6\u56e2\u6709\u9650\u516c\u53f8\",\"catalogName\":\"\u94dc\u82af\u5851\u6599\u7ebf\",\"supplyCycle\":\"25\",\"catalogId\":\"19140401\",\"taxCatalog\":\"000000000005\",\"isOil\":\"0\",\"impRemark\":\"\u6210\u529f\",\"impResult\":0,\"model\":\"WDZN-BYJ\"}]";
        List agreementSkuPOs = JSON.parseArray((String)str, AgreementSkuPO.class);
    }

    public CnncAgrBatchImportAgreementSkuBusiRspBO dealAgrDetailedBatchImportAgreement(CnncAgrBatchImportAgreementSkuBusiReqBO busiReqBO) {
        List agreementSkuPOs;
        CnncAgrBatchImportAgreementSkuBusiRspBO rsp = new CnncAgrBatchImportAgreementSkuBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        if (!AgrCommConstant.AgreementStatus.DRAFT.equals(agreement.getAgreementStatus()) && !AgrCommConstant.AgreementStatus.REJECT.equals(agreement.getAgreementStatus())) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u521b\u5efa\u534f\u8bae\u660e\u7ec6\uff01");
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            HttpUtil.deleteFile("temporaryfile/content.xlsx");
            File file = busiReqBO.getUrl().endsWith(".xls") ? new File(System.getProperty("user.dir") + "/temporaryfile/content.xls") : new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(busiReqBO.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title, agreement);
        }
        catch (Exception e) {
            throw new BusinessException("22052", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u5bfc\u5165\u6a21\u677f\u4e0d\u6b63\u786e\uff01");
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>();
        String code = Objects.equals(agreement.getAgreementMode(), (byte)2) ? "4" : "1";
        String importTemplateStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IMPORT_TEMPLATE_PCODE", code);
        List templateBOs = JSON.parseArray((String)importTemplateStr, AgrImoprtTemplateBO.class);
        block6: for (AgrImoprtTemplateBO bo : templateBOs) {
            for (int i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(bo.getFieldName())) continue;
                dateMapIndex.put(bo.getFieldNameEng(), i);
                continue block6;
            }
        }
        ArrayList importDataMaps = new ArrayList();
        HashMap checkMap = new HashMap();
        for (List list : data) {
            boolean importErrMsgFlag = false;
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            StringBuilder importRemark = new StringBuilder();
            try {
                for (AgrImoprtTemplateBO bo : templateBOs) {
                    Object markupValue;
                    Integer sheetKey = (Integer)dateMapIndex.get(bo.getFieldNameEng());
                    if (null == sheetKey) {
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u3010").append(bo.getFieldName()).append("\u3011\u4e3a\u7a7a\uff01");
                        continue;
                    }
                    if (sheetKey >= list.size()) continue;
                    Object content = list.get(sheetKey);
                    if (bo.getIsMustFill().booleanValue()) {
                        if (null == content || "".equals(content) || "null".equals(content)) {
                            importErrMsgFlag = true;
                            importRemark.setLength(0);
                            importRemark.append("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010").append(bo.getFieldName()).append("\u3011\u5fc5\u586b\uff01");
                            continue;
                        }
                    } else if ("null".equals(content)) {
                        content = "";
                    }
                    if ("markupRate".equals(bo.getFieldNameEng())) {
                        String markupRate = (String)content;
                        if (!StringUtils.hasText((String)markupRate)) {
                            markupRate = "0";
                        }
                        markupRate = markupRate.endsWith("%") ? markupRate.substring(0, markupRate.lastIndexOf("%")) : markupRate;
                        markupRate = new BigDecimal(markupRate).divide(new BigDecimal("100")).toPlainString();
                        content = markupRate;
                    }
                    if ("buyPrice".equals(bo.getFieldNameEng())) {
                        String buyPrice = (String)content;
                        String buyPriceStr = new BigDecimal(buyPrice).multiply(new BigDecimal("10000")).stripTrailingZeros().toPlainString();
                        if (buyPriceStr.contains(".")) {
                            importErrMsgFlag = true;
                            importRemark.append("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u91c7\u8d2d\u5355\u4ef7\u4e0d\u80fd\u8d85\u8fc7\u56db\u4f4d\u5c0f\u6570\uff01");
                            content = buyPriceStr.substring(0, buyPriceStr.indexOf("."));
                        } else {
                            content = buyPriceStr;
                        }
                    }
                    if ("buyNumber".equals(bo.getFieldNameEng())) {
                        String buyNumber = (String)content;
                        if (buyNumber.contains(".")) {
                            if (buyNumber.length() - 1 - buyNumber.indexOf(".") > 6) {
                                importErrMsgFlag = true;
                                importRemark.append("\u5546\u54c1\u6570\u91cf\u53ea\u652f\u63016\u4f4d\u5c0f\u6570\uff01");
                            }
                            if (buyNumber.indexOf(".") > 12) {
                                importErrMsgFlag = true;
                                importRemark.append("\u5546\u54c1\u6570\u91cf\u6574\u6570\u4f4d\u53ea\u652f\u630112\u4f4d\uff01");
                            }
                        } else if (buyNumber.length() > 12) {
                            importErrMsgFlag = true;
                            importRemark.append("\u5546\u54c1\u6570\u91cf\u6574\u6570\u4f4d\u53ea\u652f\u630112\u4f4d\uff01");
                        }
                    }
                    if ("markupValue".equals(bo.getFieldNameEng()) && ((String)(markupValue = (String)content)).contains(".") && ((String)markupValue).length() - 1 - ((String)markupValue).indexOf(".") > 4) {
                        importErrMsgFlag = true;
                        importRemark.append("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u52a0\u4ef7\u503c\u4e0d\u80fd\u8d85\u8fc7\u56db\u4f4d\u5c0f\u6570\uff01");
                    }
                    dataMap.put(bo.getFieldNameEng(), content);
                }
            }
            catch (Exception e) {
                importErrMsgFlag = true;
                log.error("\u5bfc\u5165\u6570\u636e\u9519\u8bef:", (Throwable)e);
                importRemark.setLength(0);
                importRemark.append("\u6570\u636e\u975e\u6cd5!\u8bf7\u68c0\u67e5\u6570\u636e\u683c\u5f0f\u662f\u5426\u6b63\u786e!");
            }
            if (importErrMsgFlag) {
                dataMap.put("impResult", AgrExtCommonConstant.ImportResult.FAILED);
                dataMap.put("impRemark", importRemark.toString());
            } else {
                dataMap.put("impRemark", "\u6210\u529f");
                dataMap.put("impResult", AgrExtCommonConstant.ImportResult.SUCCESS);
            }
            importDataMaps.add(dataMap);
        }
        String jsonStr = JSON.toJSONString(importDataMaps);
        try {
            agreementSkuPOs = JSON.parseArray((String)jsonStr, AgreementSkuPO.class);
        }
        catch (Exception exception) {
            throw new BusinessException("22052", "\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
        this.validateParam(agreementSkuPOs);
        List<AgrDicDictionaryBO> list = this.agrDicDictionaryAtomService.queryDictBOBySysCodeAndPcode("AGR", "AGR_PRODUCING_AREA");
        HashMap producingAreaMap = new HashMap(list.size());
        list.forEach(agrDicDictionaryBO -> producingAreaMap.put(agrDicDictionaryBO.getTitle(), agrDicDictionaryBO.getCode()));
        List materialCodes = agreementSkuPOs.stream().map(AgreementSkuPO::getMaterialId).filter(StringUtils::hasText).collect(Collectors.toList());
        Map agreementSkuMap = agreementSkuPOs.stream().collect(Collectors.toMap(AgreementSkuPO::getMaterialId, Function.identity(), (key1, key2) -> key2));
        if (!CollectionUtils.isEmpty(materialCodes)) {
            UccQryCommodityTypeByMaterialReqBO uccQryCommodityTypeByMaterialReqBo = new UccQryCommodityTypeByMaterialReqBO();
            uccQryCommodityTypeByMaterialReqBo.setMaterialCodes(materialCodes);
            UccQryCommodityTypeByMaterialRspBO uccQryCommodityTypeByMaterialRspBo = this.uccQryCommodityTypeByMaterialService.qryCommodityTypeByMaterial(uccQryCommodityTypeByMaterialReqBo);
            if (!"0000".equals(uccQryCommodityTypeByMaterialRspBo.getRespCode())) {
                throw new BusinessException("8888", "\u67e5\u8be2\u7269\u6599\u4fe1\u606f\u5931\u8d25");
            }
            List materialTypes = uccQryCommodityTypeByMaterialRspBo.getMaterialTypes();
            if (!CollectionUtils.isEmpty((Collection)materialTypes)) {
                Map<String, UccMaterialCommodityTypeBO> collectByMat = materialTypes.stream().collect(Collectors.toMap(UccMaterialCommodityTypeBO::getMaterialCode, obj -> obj, (a, b) -> a));
                for (Object agreementSkuPO : agreementSkuPOs) {
                    UccMaterialCommodityTypeBO uccMaterialCommodityTypeBo;
                    if (AgrExtCommonConstant.ImportResult.FAILED.equals(((AgreementSkuPO)agreementSkuPO).getImpResult()) || (uccMaterialCommodityTypeBo = collectByMat.get(((AgreementSkuPO)agreementSkuPO).getMaterialId())) == null) continue;
                    if (!StringUtils.hasText((String)((AgreementSkuPO)agreementSkuPO).getMaterialName())) {
                        ((AgreementSkuPO)agreementSkuPO).setMaterialName(uccMaterialCommodityTypeBo.getLongDesc());
                    }
                    if (!StringUtils.hasText((String)((AgreementSkuPO)agreementSkuPO).getThirdCatalogId())) {
                        ((AgreementSkuPO)agreementSkuPO).setThirdCatalogId(uccMaterialCommodityTypeBo.getL3CatalogCode());
                    }
                    if (!StringUtils.hasText((String)((AgreementSkuPO)agreementSkuPO).getCatalogId())) continue;
                    if (CollectionUtils.isEmpty((Map)uccMaterialCommodityTypeBo.getTypeIdAndName())) {
                        ((AgreementSkuPO)agreementSkuPO).setImpRemark("\u7269\u8d44\u7f16\u7801\u4e0d\u5c5e\u4e8e\u8be5\u56db\u7ea7\u5206\u7c7b\uff01");
                        ((AgreementSkuPO)agreementSkuPO).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                        continue;
                    }
                    String typeName = (String)uccMaterialCommodityTypeBo.getTypeIdAndName().get(Long.valueOf(((AgreementSkuPO)agreementSkuPO).getCatalogId()));
                    if (typeName == null) {
                        ((AgreementSkuPO)agreementSkuPO).setImpRemark("\u7269\u8d44\u7f16\u7801\u4e0d\u5c5e\u4e8e\u8be5\u56db\u7ea7\u5206\u7c7b\uff01");
                        ((AgreementSkuPO)agreementSkuPO).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    }
                    if (StringUtils.hasText((String)((AgreementSkuPO)agreementSkuPO).getCatalogName())) continue;
                    ((AgreementSkuPO)agreementSkuPO).setCatalogName(typeName);
                }
            } else {
                throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7269\u8d44\u7f16\u7801\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u586b\u5199\u6b63\u786e");
            }
        }
        ArrayList<Long> catalogIds = new ArrayList<Long>();
        for (AgreementSkuPO po : agreementSkuPOs) {
            if (!StringUtils.hasText((String)po.getCatalogId())) continue;
            catalogIds.add(Long.parseLong(po.getCatalogId()));
        }
        if (!CollectionUtils.isEmpty(catalogIds)) {
            CnncQryCommodityTypeListAbilityReqBo cnncQryCommodityTypeListAbilityReqBo = new CnncQryCommodityTypeListAbilityReqBo();
            cnncQryCommodityTypeListAbilityReqBo.setCommodityTypeIds(catalogIds.stream().distinct().collect(Collectors.toList()));
            cnncQryCommodityTypeListAbilityReqBo.setPageSize(-1);
            cnncQryCommodityTypeListAbilityReqBo.setPageNo(-1);
            cnncQryCommodityTypeListAbilityReqBo.setQueryHaveSku(Boolean.valueOf(false));
            CnncQryCommodityTypeListAbilityRspBo cnncQryCommodityTypeListAbilityRspBo = this.cnncQryCommodityTypeListAbilityService.qryCommodityTypeList(cnncQryCommodityTypeListAbilityReqBo);
            if (!"0000".equals(cnncQryCommodityTypeListAbilityRspBo.getRespCode()) || CollectionUtils.isEmpty((Collection)cnncQryCommodityTypeListAbilityRspBo.getRows())) {
                throw new BusinessException("8888", "\u56db\u7ea7\u5206\u7c7b\u5217\u8868\u67e5\u8be2\u5931\u8d25");
            }
            List commodityTypeListAbilityBos = JSON.parseArray((String)JSON.toJSONString((Object)cnncQryCommodityTypeListAbilityRspBo.getRows()), CnncQryCommodityTypeListAbilityBo.class);
            Map<Long, CnncQryCommodityTypeListAbilityBo> commodityTypeListAbilityBoMap = commodityTypeListAbilityBos.stream().collect(Collectors.toMap(CnncQryCommodityTypeListAbilityBo::getCommodityTypeId, obj -> obj, (a, b) -> a));
            for (AgreementSkuPO agreementSkuPO : agreementSkuPOs) {
                if (!StringUtils.hasText((String)agreementSkuPO.getCatalogId())) continue;
                CnncQryCommodityTypeListAbilityBo cnncQryCommodityTypeListAbilityBo = commodityTypeListAbilityBoMap.get(Long.parseLong(agreementSkuPO.getCatalogId()));
                if (null != cnncQryCommodityTypeListAbilityBo) {
                    agreementSkuPO.setThirdCatalogId(cnncQryCommodityTypeListAbilityBo.getCatalogCode());
                    if (StringUtils.hasText((String)cnncQryCommodityTypeListAbilityBo.getRateTypeCode())) {
                        agreementSkuPO.setTaxCatalog(cnncQryCommodityTypeListAbilityBo.getRateTypeCode());
                        continue;
                    }
                    agreementSkuPO.setImpRemark("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                    agreementSkuPO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    continue;
                }
                agreementSkuPO.setImpRemark("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                agreementSkuPO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
            }
        }
        ArrayList<AgreementSkuPO> insertSkuPoList = new ArrayList<AgreementSkuPO>();
        if (!CollectionUtils.isEmpty(catalogIds)) {
            Map<String, CnncUccEMdmCatalogAllBO> catalogAllBOMap = this.getUccCatalogPath(catalogIds);
            Map<Object, Object> catalogAndFreezeMap = Collections.emptyMap();
            if (!CollectionUtils.isEmpty((Map)catalogAllBOMap)) {
                CnncCatalogListQueryAbilityReqBO cnncCatalogListQueryAbilityReqBO = new CnncCatalogListQueryAbilityReqBO();
                cnncCatalogListQueryAbilityReqBO.setCatalogCodes(catalogAllBOMap.values().stream().map(CnncUccEMdmCatalogAllBO::getCatalogCodeL2).collect(Collectors.toList()));
                CnncCatalogListQueryAbilityRspBO cnncCatalogListQueryAbilityRspBO = this.cnncCatalogListQueryAbilityService.qryCatalogList(cnncCatalogListQueryAbilityReqBO);
                if (!CollectionUtils.isEmpty((Collection)cnncCatalogListQueryAbilityRspBO.getCatalogBOList())) {
                    catalogAndFreezeMap = cnncCatalogListQueryAbilityRspBO.getCatalogBOList().stream().collect(Collectors.toMap(UccEMdmCatalogBO::getCatalogCode, obj -> {
                        if (YesNoEnum.NO.getType().equals(obj.getFreezeFlag()) && YesNoEnum.NO.getType().equals(obj.getIsDelete())) {
                            return YesNoEnum.NO.getType();
                        }
                        return YesNoEnum.YES.getType();
                    }, (a, b) -> a));
                }
            }
            for (AgreementSkuPO po : agreementSkuPOs) {
                if (AgrExtCommonConstant.ImportResult.FAILED.equals(po.getImpResult())) continue;
                CnncUccEMdmCatalogAllBO cnncUccEMdmCatalogAllBO = (CnncUccEMdmCatalogAllBO)catalogAllBOMap.get(po.getCatalogId());
                if (cnncUccEMdmCatalogAllBO != null) {
                    po.setCatalogName(cnncUccEMdmCatalogAllBO.getCatalogNameL4());
                    po.setCatalogVariety(cnncUccEMdmCatalogAllBO.getVarietyL3());
                    if (cnncUccEMdmCatalogAllBO.getVarietyL3() != null && CatalogVarietyEnum.WZ.getVarietyCode().equals(cnncUccEMdmCatalogAllBO.getVarietyL3()) && !StringUtils.hasText((String)po.getProducingArea())) {
                        po.setImpRemark("\u56db\u7ea7\u5206\u7c7b\u4e3a\u7269\u8d44\u7c7b\uff0c\u7269\u8d44\u4ea7\u5730\u5fc5\u586b");
                        po.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    }
                    if (AgrExtCommonConstant.ImportResult.FAILED.equals(po.getImpResult()) || StringUtils.hasText((String)po.getMaterialId())) continue;
                    Integer freeze = (Integer)catalogAndFreezeMap.get(cnncUccEMdmCatalogAllBO.getCatalogCodeL2());
                    if (!YesNoEnum.NO.getType().equals(freeze)) continue;
                    po.setImpRemark("\u7269\u6599\u7f16\u7801\u5fc5\u586b");
                    po.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    continue;
                }
                po.setImpRemark("\u56db\u7ea7\u5206\u7c7b\u7f16\u7801\u4e0d\u6b63\u786e!");
                po.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
            }
            AgrExternalCatalogLevelCheckReqBO catalogLevelCheckReqBO = new AgrExternalCatalogLevelCheckReqBO();
            catalogLevelCheckReqBO.setCatalogIds(catalogIds);
            if (busiReqBO.getCatalogLevel() != null) {
                catalogLevelCheckReqBO.setCatalogLevel(busiReqBO.getCatalogLevel());
            } else {
                catalogLevelCheckReqBO.setCatalogLevel(Integer.valueOf(4));
            }
            log.debug("\u8c03\u7528\u5546\u54c1\u7c7b\u76ee\u7b49\u7ea7\u6821\u9a8c\u5165\u53c2:" + JSON.toJSONString((Object)catalogLevelCheckReqBO));
            AgrExternalCatalogLevelCheckRspBO catalogLevelCheckRspBO = this.cnncAgrExternalCatalogLevelCheckServiceHolder.getAgrExternalCatalogLevelCheckService().catalogLevelCheck(catalogLevelCheckReqBO);
            log.debug("\u8c03\u7528\u5546\u54c1\u7c7b\u76ee\u7b49\u7ea7\u6821\u9a8c\u51fa\u53c2:" + JSON.toJSONString((Object)catalogLevelCheckRspBO));
            if (catalogLevelCheckRspBO.getRespCode().equals("0000") && catalogLevelCheckRspBO.getFailCatalogIds() != null && catalogLevelCheckRspBO.getFailCatalogIds().size() > 0) {
                for (AgreementSkuPO po : agreementSkuPOs) {
                    if (AgrExtCommonConstant.ImportResult.FAILED.equals(po.getImpResult())) continue;
                    for (Object catalogId : catalogLevelCheckRspBO.getFailCatalogIds()) {
                        if (po.getCatalogId() == null || !po.getCatalogId().equals(((Long)catalogId).toString())) continue;
                        po.setImpRemark("\u534f\u8bae\u5546\u54c1\u5206\u7c7b\u7b49\u7ea7\u9519\u8bef!");
                        po.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                    }
                }
                rsp.setFailCatalogIds(catalogLevelCheckRspBO.getFailCatalogIds());
            }
            if (agreement.getContractId() != null && AgrCommConstant.agreementMode.PLAT_AGREEMENT.equals(agreement.getAgreementMode())) {
                ContractSupplierSaleReqBO contractSupplierSaleReqBO = new ContractSupplierSaleReqBO();
                contractSupplierSaleReqBO.setContractId(agreement.getContractId());
                contractSupplierSaleReqBO.setPageNo(-1);
                contractSupplierSaleReqBO.setPageSize(-1);
                RspPage contractSupplierSalePage = this.qryContractSupplierListSaleService.selecContractSupplierList(contractSupplierSaleReqBO);
                if (contractSupplierSalePage != null && !CollectionUtils.isEmpty((Collection)contractSupplierSalePage.getRows())) {
                    Map supplierSaleRspBOMap = contractSupplierSalePage.getRows().stream().collect(Collectors.toMap(ContractSupplierSaleRspBO::getCategoryId, Function.identity(), (key1, key2) -> key2));
                    for (AgreementSkuPO agreementSkuPO : agreementSkuPOs) {
                        if (AgrExtCommonConstant.ImportResult.FAILED.equals(agreementSkuPO.getImpResult())) continue;
                        if (catalogAllBOMap.get(agreementSkuPO.getCatalogId()) == null) {
                            agreementSkuPO.setImpRemark(!StringUtils.hasText((String)agreementSkuPO.getImpRemark()) ? "" : agreementSkuPO.getImpRemark() + "\u56db\u7ea7\u5206\u7c7b\u4e0d\u5728\u5408\u540c\u8303\u56f4\u5185!");
                            agreementSkuPO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                            agreementSkuPO.setContractCovered((int)AgrEnum.YesOrNo.NO.getCode());
                            continue;
                        }
                        if (supplierSaleRspBOMap.get(((CnncUccEMdmCatalogAllBO)catalogAllBOMap.get(agreementSkuPO.getCatalogId())).getCatalogIdL4()) != null) {
                            agreementSkuPO.setContractCovered((int)AgrEnum.YesOrNo.YES.getCode());
                            continue;
                        }
                        agreementSkuPO.setImpRemark(!StringUtils.hasText((String)agreementSkuPO.getImpRemark()) ? "" : agreementSkuPO.getImpRemark() + "\u56db\u7ea7\u5206\u7c7b\u4e0d\u5728\u5408\u540c\u8303\u56f4\u5185!");
                        agreementSkuPO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                        agreementSkuPO.setContractCovered((int)AgrEnum.YesOrNo.NO.getCode());
                    }
                }
            }
        }
        for (AgreementSkuPO po : agreementSkuPOs) {
            if (po.getContractCovered() == null && AgrCommConstant.agreementMode.UNIT_AGREEMENT.equals(agreement.getAgreementMode())) {
                po.setContractCovered((int)AgrEnum.YesOrNo.YES.getCode());
            }
            if (po.getMarkupRate() == null) {
                po.setMarkupRate(BigDecimal.ZERO.doubleValue());
            }
            po.setAgreementSkuId(Sequence.getInstance().nextId());
            po.setAgreementId(agreement.getAgreementId());
            po.setSupplierId(agreement.getSupplierId());
            po.setAgreementVersion(agreement.getAgreementVersion());
            po.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            po.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            po.setCreateLoginId(busiReqBO.getMemIdIn());
            po.setCreateName(busiReqBO.getUsername());
            po.setCreateTime(new Date());
            po.setItemSource(AgrEnum.ItemSource.FROM_AGREEMENT.getType());
            if (po.getBuyPrice() != null && po.getBuyNumber() != null) {
                po.setBuyPriceSum(new BigDecimal(po.getBuyPrice()).multiply(po.getBuyNumber()).longValue());
                po.setSalePrice(new BigDecimal(po.getBuyPrice()).add(new BigDecimal(po.getBuyPrice()).multiply(new BigDecimal(po.getMarkupRate().toString()))).longValue());
            }
            if (po.getSalePrice() != null && po.getBuyNumber() != null) {
                if (po.getMarkupValue() != null) {
                    po.setSalePrice(po.getSalePrice() + new BigDecimal(po.getMarkupValue()).multiply(new BigDecimal("10000")).longValue());
                }
                po.setSalePriceSum(new BigDecimal(po.getSalePrice()).multiply(po.getBuyNumber()).longValue());
            }
            if (po.getBuyPriceSum().toString().length() > 18) {
                po.setImpRemark("\u603b\u4ef7\u6574\u6570\u4f4d\u53ea\u652f\u630114\u4f4d\uff0c\u8bf7\u6839\u636e\u5355\u4ef7\u8c03\u6574\u6570\u91cf\uff01");
                po.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
            }
            if (po.getSalePrice().toString().length() > 18) {
                po.setImpRemark("\u603b\u4ef7\u6574\u6570\u4f4d\u53ea\u652f\u630114\u4f4d\uff0c\u8bf7\u6839\u636e\u5355\u4ef7\u8c03\u6574\u6570\u91cf\uff01");
                po.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
            }
            if (po.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) {
                insertSkuPoList.add(po);
            }
            po.setMarkupRate(new BigDecimal(po.getMarkupRate().toString()).multiply(new BigDecimal("100")).doubleValue());
            po.setProducingAreaStr(po.getProducingArea());
            po.setProducingArea((String)producingAreaMap.get(po.getProducingArea()));
            if (po.getCatalogVariety() != null) continue;
            po.setCatalogVariety((int)agreement.getAgreementVariety());
        }
        List agrAgreementSkuBOList = JSON.parseArray((String)JSON.toJSONString((Object)agreementSkuPOs), AgrAgreementSkuBO.class);
        CnncAgrExportImportResultsBusiReqBO importResultsBusiReqBO = new CnncAgrExportImportResultsBusiReqBO();
        importResultsBusiReqBO.setImportSkuList(agrAgreementSkuBOList);
        importResultsBusiReqBO.setTradeMode(agreement.getTradeMode());
        log.debug("\u8c03\u7528\u5bfc\u51fa\u6587\u4ef6\u5165\u53c2:" + JSON.toJSONString((Object)importResultsBusiReqBO));
        CnncAgrExportImportResultsBusiRspBO importResultsBusiRspBO = this.cnncAgrExportImportResultsBusiService.exportImportResults(importResultsBusiReqBO);
        log.debug("\u8c03\u7528\u5bfc\u51fa\u6587\u4ef6\u51fa\u53c2:" + JSON.toJSONString((Object)importResultsBusiRspBO));
        if (!importResultsBusiRspBO.getRespCode().equals("0000")) {
            rsp.setRespCode("8888");
            rsp.setRespCode(importResultsBusiRspBO.getRespCode());
            return rsp;
        }
        Long failedImportCounts = 0L;
        Long sucessImportCounts = 0L;
        for (AgreementSkuPO agreementSkuPO : agreementSkuPOs) {
            Long l;
            Object catalogId;
            if (agreementSkuPO.getImpResult().equals(AgrExtCommonConstant.ImportResult.FAILED)) {
                catalogId = failedImportCounts;
                l = failedImportCounts = Long.valueOf(failedImportCounts + 1L);
                continue;
            }
            if (!agreementSkuPO.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) continue;
            catalogId = sucessImportCounts;
            l = sucessImportCounts = Long.valueOf(sucessImportCounts + 1L);
        }
        AgrExternalImportResultLogServiceReqBO agrExternalImportResultLogServiceReqBO = new AgrExternalImportResultLogServiceReqBO();
        agrExternalImportResultLogServiceReqBO.setExportData(importResultsBusiRspBO.getExportData());
        agrExternalImportResultLogServiceReqBO.setFileName(importResultsBusiRspBO.getFilePath());
        agrExternalImportResultLogServiceReqBO.setFileUrl(importResultsBusiRspBO.getFullFilePath());
        agrExternalImportResultLogServiceReqBO.setSuccessCount(sucessImportCounts);
        agrExternalImportResultLogServiceReqBO.setFailureCount(failedImportCounts);
        agrExternalImportResultLogServiceReqBO.setMemId(busiReqBO.getMemIdIn());
        agrExternalImportResultLogServiceReqBO.setImpRemark("");
        agrExternalImportResultLogServiceReqBO.setImpResult(Integer.valueOf(0));
        agrExternalImportResultLogServiceReqBO.setIsSkuChange(Integer.valueOf(0));
        log.debug("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)agrExternalImportResultLogServiceReqBO));
        AgrExternalImportResultLogServiceRspBO agrExternalImportResultLogServiceRspBO = this.cnncAgrExternalImportResultLogServiceHolder.getAgrExternalImportResultLogService().importLog(agrExternalImportResultLogServiceReqBO);
        log.debug("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)agrExternalImportResultLogServiceRspBO));
        if (insertSkuPoList.size() > 0) {
            int isInsert = this.agreementSkuMapper.insertBatch(insertSkuPoList);
            rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6210\u529f!\u603b\u5171\u3010" + data.size() + "\u3011\u6761\u6570\u636e\uff0c\u5bfc\u5165\u6210\u529f\u3010" + isInsert + "\u3011\u6761");
        }
        rsp.setRespCode(importResultsBusiRspBO.getRespCode());
        return rsp;
    }

    private void validateParam(List<AgreementSkuPO> agreementSkuPOs) {
        for (AgreementSkuPO po : agreementSkuPOs) {
            if (StringUtils.hasText((String)po.getSpec()) || StringUtils.hasText((String)po.getFigure())) continue;
            po.setImpRemark(!StringUtils.hasText((String)po.getImpRemark()) ? "" : po.getImpRemark() + "\u89c4\u683c/\u578b\u53f7\u548c\u56fe\u53f7/\u5382\u5bb6\u96f6\u4ef6\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
            po.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
        }
    }

    private void getExcelDateByImport(MultipartFile multipartFile, List<List<String>> data, List<String> title, AgreementPO agreement) {
        try {
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            int count = 0;
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                int i;
                if (count < 10) {
                    ++count;
                    continue;
                }
                boolean cow = true;
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                for (i = 0; i < end; ++i) {
                    if (null == row.getCell(i) || "".equals(row.getCell(i).toString())) continue;
                    cow = false;
                    break;
                }
                if (cow) continue;
                for (i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getCellValue(cell);
                    if (count == 10) {
                        title.add(String.valueOf(obj).trim());
                        continue;
                    }
                    if (count < 11) continue;
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".00")) {
                        str = str.substring(0, str.length() - 3);
                    }
                    d.add(str);
                }
                data.add(d);
            }
        }
        catch (Exception e) {
            throw new BusinessException("22052", e.getMessage());
        }
    }

    private Map<String, CnncUccEMdmCatalogAllBO> getUccCatalogPath(List<Long> typeIds) {
        HashMap<String, CnncUccEMdmCatalogAllBO> catalogAllBOMap = new HashMap<String, CnncUccEMdmCatalogAllBO>();
        CnncCatalogPathQryAbilityReqBo cnncCatalogPathQryAbilityReqBo = new CnncCatalogPathQryAbilityReqBo();
        cnncCatalogPathQryAbilityReqBo.setTypeIds(typeIds);
        CnncCatalogPathQryAbilityRspBo cnncCatalogPathQryAbilityRspBo = this.cnncCatalogPathQryAbilityService.catalogPathQry(cnncCatalogPathQryAbilityReqBo);
        if (!"0000".equals(cnncCatalogPathQryAbilityRspBo.getRespCode())) {
            throw new ZTBusinessException("\u5546\u54c1\u7c7b\u76ee\u67e5\u8be2\u9519\u8bef!");
        }
        cnncCatalogPathQryAbilityRspBo.getCatalogList().forEach(cnncUccEMdmCatalogAllBO -> catalogAllBOMap.put(cnncUccEMdmCatalogAllBO.getCommodityTypeId().toString(), (CnncUccEMdmCatalogAllBO)cnncUccEMdmCatalogAllBO));
        return catalogAllBOMap;
    }
}

