/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.extend.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.bo.AgrFormulaBO;
import com.tydic.agreement.ability.bo.QuotaDataOriginBO;
import com.tydic.agreement.common.bo.AgrAgreementSkuFormulaBO;
import com.tydic.agreement.common.bo.AgrskuChangePriceBO;
import com.tydic.agreement.dao.AgrFormulaMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.dao.po.AgrFormulaPO;
import com.tydic.agreement.dao.po.AgreementSkuChangePO;
import com.tydic.agreement.dao.po.AgreementSkuPO;
import com.tydic.agreement.extend.busi.CnncAgrUpdateSkuByFormulaService;
import com.tydic.agreement.extend.busi.bo.CnncAgrUpdateSkuByFormulaReqBO;
import com.tydic.agreement.extend.busi.bo.CnncAgrUpdateSkuByFormulaRspBO;
import com.tydic.agreement.utils.MoneyUtil;
import com.tydic.agreement.utils.ParsiiUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CnncAgrUpdateSkuByFormulaServiceImpl
implements CnncAgrUpdateSkuByFormulaService {
    private static final Logger log = LoggerFactory.getLogger(CnncAgrUpdateSkuByFormulaServiceImpl.class);
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSkuChangeMapper agreementChangeMapper;
    @Autowired
    private AgrFormulaMapper agrFormulaMapper;
    @Value(value="${SMM1_COPPER:SMM\u4e00\u53f7\u7535\u89e3\u94dc\u5747\u4ef7}")
    private String SMM1_COPPER = "SMM\u4e00\u53f7\u7535\u89e3\u94dc\u5747\u4ef7";
    @Value(value="${SMMA00_AL:SMMA00\u94dd\u5747\u4ef7}")
    private String SMMA00_AL = "SMMA00\u94dd\u5747\u4ef7";

    public CnncAgrUpdateSkuByFormulaRspBO updateSkuByFormula(CnncAgrUpdateSkuByFormulaReqBO reqBO) {
        CnncAgrUpdateSkuByFormulaRspBO rspBO = new CnncAgrUpdateSkuByFormulaRspBO();
        ArrayList<AgrskuChangePriceBO> skuChangePriceBOs = new ArrayList<AgrskuChangePriceBO>();
        ArrayList<Long> failedAgrSkuList = new ArrayList<Long>();
        rspBO.setFailedSkuList(failedAgrSkuList);
        rspBO.setSkuChangePriceBOs(skuChangePriceBOs);
        if (reqBO.getAgreementId() == null && CollectionUtils.isEmpty((Collection)reqBO.getAgreementSkuIds()) && reqBO.getFormulaId() == null) {
            throw new BusinessException("8888", "\u534f\u8baeID\u548c\u660e\u7ec6ID\u96c6\u5408\u4ee5\u53ca\u516c\u5f0fID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a!");
        }
        ArrayList<Long> formulaIds = new ArrayList<Long>();
        ArrayList<AgrAgreementSkuFormulaBO> agrAgreementSkuFormulaBOS = new ArrayList<AgrAgreementSkuFormulaBO>();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getChangeCode())) {
            List<AgrAgreementSkuFormulaBO> changeCodeFormulaBOs = this.agreementChangeMapper.getSkuListByFormula(reqBO.getAgreementId(), reqBO.getAgreementSkuIds(), reqBO.getFormulaId(), reqBO.getStatus(), reqBO.getChangeCode());
            if (CollectionUtils.isEmpty(changeCodeFormulaBOs)) {
                log.error("\u534f\u8bae\u53d8\u66f4\u660e\u7ec6\u516c\u5f0f\u66f4\u65b0\u96c6\u5408\u4e3a\u7a7a!");
                rspBO.setRespCode("0000");
                rspBO.setRespCode("\u6210\u529f");
                return rspBO;
            }
            agrAgreementSkuFormulaBOS.addAll(changeCodeFormulaBOs);
        } else {
            List<AgrAgreementSkuFormulaBO> skuFormulaBOS = this.agreementSkuMapper.getSkuListByFormula(reqBO.getAgreementId(), reqBO.getAgreementSkuIds(), reqBO.getFormulaId(), reqBO.getStatus());
            if (CollectionUtils.isEmpty(skuFormulaBOS)) {
                log.error("\u534f\u8bae\u660e\u7ec6\u516c\u5f0f\u66f4\u65b0\u96c6\u5408\u4e3a\u7a7a!");
                rspBO.setRespCode("0000");
                rspBO.setRespCode("\u6210\u529f");
                return rspBO;
            }
            agrAgreementSkuFormulaBOS.addAll(skuFormulaBOS);
        }
        agrAgreementSkuFormulaBOS.forEach(agrAgreementSkuFormulaBO -> formulaIds.add(agrAgreementSkuFormulaBO.getFormulaId()));
        AgrFormulaPO agrFormulaPO = new AgrFormulaPO();
        agrFormulaPO.setFormulaIds(formulaIds);
        List<AgrFormulaPO> agrFormulaPOS = this.agrFormulaMapper.selectByConditionPage(agrFormulaPO, (Page<AgrFormulaBO>)new Page(-1, -1));
        Map formulaMap = agrFormulaPOS.stream().collect(Collectors.toMap(AgrFormulaPO::getFormulaId, Function.identity(), (key1, key2) -> key2));
        ArrayList<AgreementSkuPO> agreementSkuPOS = new ArrayList<AgreementSkuPO>();
        for (AgrAgreementSkuFormulaBO agreementSkuFormulaBO : agrAgreementSkuFormulaBOS) {
            AgrFormulaPO formulaPO = (AgrFormulaPO)formulaMap.get(agreementSkuFormulaBO.getFormulaId());
            AgreementSkuPO po = new AgreementSkuPO();
            po.setBuyNumber(agreementSkuFormulaBO.getBuyNumber());
            po.setAgreementSkuId(agreementSkuFormulaBO.getAgreementSkuId());
            po.setAgreementId(agreementSkuFormulaBO.getAgreementId());
            po.setMarkupRate(agreementSkuFormulaBO.getMarkupRate());
            po.setMarkupValue(agreementSkuFormulaBO.getMarkupValue());
            if (formulaPO == null) continue;
            String smm1coppervalue = "";
            String smm1alvalue = "";
            if (!StringUtils.isBlank((CharSequence)formulaPO.getQuotaDataOrigin())) {
                List quotaDataOriginBOS = JSON.parseArray((String)formulaPO.getQuotaDataOrigin(), QuotaDataOriginBO.class);
                for (QuotaDataOriginBO quotaDataOriginBO : quotaDataOriginBOS) {
                    if (quotaDataOriginBO.getQuotaId().equals("s20015437")) {
                        smm1coppervalue = quotaDataOriginBO.getValue();
                    }
                    if (!quotaDataOriginBO.getQuotaId().equals("s20016448")) continue;
                    smm1alvalue = quotaDataOriginBO.getValue();
                }
            }
            try {
                boolean flag = false;
                double exceptResult1 = -1.0;
                double exceptResult2 = -1.0;
                Map<String, Double> variableMap = this.setVariableMap(agreementSkuFormulaBO, formulaPO);
                if (!StringUtils.isBlank((CharSequence)formulaPO.getExceptFormulaContent1())) {
                    exceptResult1 = ParsiiUtils.doEvaluate(formulaPO.getExceptFormulaContent1(), variableMap);
                }
                if (!StringUtils.isBlank((CharSequence)formulaPO.getExceptFormulaContent2())) {
                    exceptResult2 = ParsiiUtils.doEvaluate(formulaPO.getExceptFormulaContent2(), variableMap);
                }
                if (formulaPO.getExceptMethod() != null && exceptResult1 != -1.0 && exceptResult2 != -1.0) {
                    if (formulaPO.getExceptMethod().equals("and")) {
                        if (exceptResult1 > 0.0 && exceptResult2 > 0.0) {
                            flag = true;
                        }
                    } else if (formulaPO.getExceptMethod().equals("or") && (exceptResult1 > 0.0 || exceptResult2 > 0.0)) {
                        flag = true;
                    }
                } else if (exceptResult1 > 0.0) {
                    flag = true;
                } else if (exceptResult2 > 0.0) {
                    flag = true;
                }
                if (flag) {
                    if (!StringUtils.isBlank((CharSequence)smm1coppervalue)) {
                        variableMap.put(this.SMM1_COPPER, Double.valueOf(smm1coppervalue));
                    }
                    if (!StringUtils.isBlank((CharSequence)smm1alvalue)) {
                        variableMap.put(this.SMMA00_AL, Double.valueOf(smm1alvalue));
                    }
                }
                double result = ParsiiUtils.doEvaluate(formulaPO.getFormulaContent(), variableMap);
                po.setBuyPrice(MoneyUtil.b2l(new BigDecimal(result)));
                if (po.getMarkupRate() == null) {
                    po.setMarkupRate(new BigDecimal("0").doubleValue());
                }
                BigDecimal markupRate = BigDecimal.valueOf(po.getMarkupRate()).divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
                if (po.getBuyPrice() != null && po.getBuyNumber() != null) {
                    po.setBuyPriceSum(new BigDecimal(po.getBuyPrice()).multiply(po.getBuyNumber()).longValue());
                    BigDecimal salePrice = new BigDecimal(po.getBuyPrice()).add(new BigDecimal(po.getBuyPrice()).multiply(markupRate));
                    po.setSalePrice(salePrice.longValue());
                    if (StringUtils.isNotBlank((CharSequence)po.getMarkupValue())) {
                        po.setSalePrice(salePrice.add(new BigDecimal(po.getMarkupValue()).multiply(new BigDecimal("10000"))).longValue());
                    }
                }
                if (po.getSalePrice() != null && po.getBuyNumber() != null) {
                    po.setSalePriceSum(new BigDecimal(po.getSalePrice()).multiply(po.getBuyNumber()).longValue());
                }
                agreementSkuPOS.add(po);
            }
            catch (Exception e) {
                failedAgrSkuList.add(agreementSkuFormulaBO.getAgreementSkuId());
                log.error("\u660e\u7ec6\u3010" + agreementSkuFormulaBO.getAgreementSkuId() + "\u3011\u8ba1\u7b97\u9519\u8bef!", (Throwable)e);
            }
        }
        if (!CollectionUtils.isEmpty(agreementSkuPOS)) {
            for (AgreementSkuPO agreementSkuPO : agreementSkuPOS) {
                if (StringUtils.isBlank((CharSequence)reqBO.getChangeCode())) {
                    int result = this.agreementSkuMapper.updateBy(agreementSkuPO);
                    this.addSkuChangePriceBOs(skuChangePriceBOs, agreementSkuPO, result);
                    continue;
                }
                AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
                BeanUtil.copyProperties((Object)agreementSkuPO, (Object)agreementSkuChangePO, (String[])new String[0]);
                agreementSkuChangePO.setChangeCode(reqBO.getChangeCode());
                int result = this.agreementChangeMapper.updateBy(agreementSkuChangePO);
                this.addSkuChangePriceBOs(skuChangePriceBOs, agreementSkuPO, result);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void addSkuChangePriceBOs(List<AgrskuChangePriceBO> skuChangePriceBOs, AgreementSkuPO agreementSkuPO, int result) {
        if (result > 0) {
            AgrskuChangePriceBO agrskuChangePriceBO = new AgrskuChangePriceBO();
            agrskuChangePriceBO.setBuyNumber(agreementSkuPO.getBuyNumber());
            agrskuChangePriceBO.setSalePrice(agreementSkuPO.getSalePrice());
            agrskuChangePriceBO.setBuyPrice(agreementSkuPO.getBuyPrice());
            agrskuChangePriceBO.setAgreementId(agreementSkuPO.getAgreementId());
            agrskuChangePriceBO.setAgreementSkuId(agreementSkuPO.getAgreementSkuId());
            skuChangePriceBOs.add(agrskuChangePriceBO);
        }
    }

    private Map<String, Double> setVariableMap(AgrAgreementSkuFormulaBO agreementSkuFormulaBO, AgrFormulaPO agrFormulaPO) {
        HashMap<String, Double> variableMap = new HashMap<String, Double>();
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue1())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue1())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue1() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getConstantValue1(), Double.valueOf(agreementSkuFormulaBO.getConstantValue1()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue2())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue2())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue2() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getConstantValue2(), Double.valueOf(agreementSkuFormulaBO.getConstantValue2()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue3())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue3())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue3() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getConstantValue3(), Double.valueOf(agreementSkuFormulaBO.getConstantValue3()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue4())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue4())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue4() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getConstantValue4(), Double.valueOf(agreementSkuFormulaBO.getConstantValue4()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue5())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue5())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue5() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getConstantValue5(), Double.valueOf(agreementSkuFormulaBO.getConstantValue5()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue6())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue6())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue6() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getConstantValue6(), Double.valueOf(agreementSkuFormulaBO.getConstantValue6()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue7())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue7())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue7() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getConstantValue7(), Double.valueOf(agreementSkuFormulaBO.getConstantValue7()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue8())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue8())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue8() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getConstantValue8(), Double.valueOf(agreementSkuFormulaBO.getConstantValue8()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue9())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue9())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue9() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getConstantValue9(), Double.valueOf(agreementSkuFormulaBO.getConstantValue9()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getConstantValue10())) {
            if (StringUtils.isBlank((CharSequence)agreementSkuFormulaBO.getConstantValue10())) {
                throw new BusinessException("8888", agrFormulaPO.getConstantValue10() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getConstantValue10(), Double.valueOf(agreementSkuFormulaBO.getConstantValue10()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getNameA())) {
            if (StringUtils.isBlank((CharSequence)agrFormulaPO.getVariableA())) {
                throw new BusinessException("8888", agrFormulaPO.getNameA() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getNameA(), Double.valueOf(agrFormulaPO.getVariableA()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getNameB())) {
            if (StringUtils.isBlank((CharSequence)agrFormulaPO.getVariableB())) {
                throw new BusinessException("8888", agrFormulaPO.getNameB() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getNameB(), Double.valueOf(agrFormulaPO.getVariableB()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getNameC())) {
            if (StringUtils.isBlank((CharSequence)agrFormulaPO.getVariableC())) {
                throw new BusinessException("8888", agrFormulaPO.getNameC() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getNameC(), Double.valueOf(agrFormulaPO.getVariableC()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getNameD())) {
            if (StringUtils.isBlank((CharSequence)agrFormulaPO.getVariableD())) {
                throw new BusinessException("8888", agrFormulaPO.getNameD() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getNameD(), Double.valueOf(agrFormulaPO.getVariableD()));
        }
        if (!StringUtils.isBlank((CharSequence)agrFormulaPO.getNameE())) {
            if (StringUtils.isBlank((CharSequence)agrFormulaPO.getVariableE())) {
                throw new BusinessException("8888", agrFormulaPO.getNameE() + "\u4e3a\u7a7a!");
            }
            variableMap.put(agrFormulaPO.getNameE(), Double.valueOf(agrFormulaPO.getVariableE()));
        }
        return variableMap;
    }
}

