/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.external.srm.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.agreement.external.srm.SrmContractSyncCallBackService;
import com.tydic.agreement.external.srm.bo.SrmContractSyncCallBackReqBO;
import com.tydic.agreement.external.srm.bo.SrmContractSyncCallBackRspBO;
import com.tydic.agreement.utils.http.HSHttpHelper;
import com.tydic.agreement.utils.http.HSNHttpHeader;
import com.tydic.agreement.utils.http.HttpRetBean;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SrmContractSyncCallBackServiceImpl
implements SrmContractSyncCallBackService {
    private static final Logger log = LoggerFactory.getLogger(SrmContractSyncCallBackServiceImpl.class);
    @Value(value="${SRM_CONTRACT_SYNC_CALL_BACK}")
    private String srmContractCallBackUrl;

    @Override
    public SrmContractSyncCallBackRspBO dealSrmContractSyncCallBack(SrmContractSyncCallBackReqBO reqBo) {
        SrmContractSyncCallBackRspBO rspBo = new SrmContractSyncCallBackRspBO();
        if (!(reqBo != null && StringUtils.hasText((String)reqBo.getPcHeaderId()) && StringUtils.hasText((String)reqBo.getPcNum()) && StringUtils.hasText((String)reqBo.getProcessStatus()))) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u8bf7\u6c42\u5fc5\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        if (StringUtils.hasText((String)reqBo.getReturnReason()) && reqBo.getReturnReason().length() > 500) {
            reqBo.setReturnReason(reqBo.getReturnReason().substring(0, 500));
        }
        try {
            String reqStr = JSON.toJSONString((Object)reqBo);
            log.debug("srm\u5408\u540c\u56de\u8c03:{}", (Object)JSON.toJSONString((Object)reqStr));
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.srmContractCallBackUrl), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(), "UTF-8", true);
            log.debug("srm\u5408\u540c\u56de\u8c03\u63a5\u53e3\u51fa\u53c2:" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new BusinessException("8888", "srm\u5408\u540c\u56de\u8c03\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a\uff01");
            }
            return this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("srm\u5408\u540c\u56de\u8c03\u63a5\u53e3\u670d\u52a1\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("srm\u5408\u540c\u56de\u8c03\u63a5\u53e3\u5931\u8d25");
            return rspBo;
        }
    }

    private SrmContractSyncCallBackRspBO resolveRsp(String returnString) {
        SrmContractSyncCallBackRspBO rspBo = new SrmContractSyncCallBackRspBO();
        try {
            rspBo = (SrmContractSyncCallBackRspBO)((Object)JSONObject.parseObject((String)returnString, SrmContractSyncCallBackRspBO.class));
        }
        catch (Exception e) {
            log.error("srm\u5408\u540c\u56de\u8c03\u63a5\u53e3\u54cd\u5e94\u53c2\u6570\u8f6c\u6362\u5931\u8d25" + e.getMessage(), (Throwable)e);
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("srm\u5408\u540c\u56de\u8c03\u63a5\u53e3\u54cd\u5e94\u53c2\u6570\u8f6c\u6362\u5931\u8d25" + e.getMessage());
            return rspBo;
        }
        rspBo.setReturnStr(returnString);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f!");
        return rspBo;
    }
}

