/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.external.ssm;

import com.alibaba.fastjson.JSON;
import com.tydic.agreement.external.ssm.ErrorCorrectingService;
import com.tydic.agreement.external.ssm.bo.ErrorCorrectResultBO;
import com.tydic.agreement.external.ssm.bo.ErrorCorrectingReqBO;
import com.tydic.agreement.external.ssm.bo.ErrorCorrectingRspBO;
import com.tydic.agreement.utils.http.HSHttpHelper;
import com.tydic.agreement.utils.http.HSNHttpHeader;
import com.tydic.agreement.utils.http.HttpRetBean;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ErrorCorrectingServiceImpl
implements ErrorCorrectingService {
    private static final Logger log = LoggerFactory.getLogger(ErrorCorrectingServiceImpl.class);
    @Value(value="${Error_Correcting_Multi_Url:http://192.168.22.200/Argreement/Error_Correcting_Multi}")
    private String Error_Correcting_Multi_Url;

    public ErrorCorrectingRspBO errorCorrect(ErrorCorrectingReqBO reqBO) {
        ErrorCorrectingRspBO rspBO = new ErrorCorrectingRspBO();
        try {
            String reqStr = JSON.toJSONString((Object)reqBO.getCorrectList());
            log.debug("\u5546\u54c1\u7ea0\u9519\u591a\u6761\u6570\u636e\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqStr));
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.Error_Correcting_Multi_Url), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(), "UTF-8", true);
            log.debug("\u5546\u54c1\u7ea0\u9519\u591a\u6761\u6570\u636e\u63a5\u53e3\u51fa\u53c2:" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f!");
                return rspBO;
            }
            return this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u7ea0\u9519\u591a\u6761\u6570\u636e\u63a5\u53e3\u670d\u52a1\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1\u7ea0\u9519\u591a\u6761\u6570\u636e\u63a5\u53e3\u5931\u8d25");
            return rspBO;
        }
    }

    private ErrorCorrectingRspBO resolveRsp(String returnString) {
        ErrorCorrectingRspBO rspBO = new ErrorCorrectingRspBO();
        try {
            List errorCorrectResultBOS = JSON.parseArray((String)returnString, ErrorCorrectResultBO.class);
            rspBO.setErrorCorrectResultList(errorCorrectResultBOS);
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u7ea0\u9519\u591a\u6761\u6570\u636e\u63a5\u53e3\u53c2\u6570\u8f6c\u6362\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1\u7ea0\u9519\u591a\u6761\u6570\u636e\u63a5\u53e3\u53c2\u6570\u8f6c\u6362\u5931\u8d25" + e.getMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f!");
        return rspBO;
    }
}

