/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.external.ssm;

import com.alibaba.fastjson.JSON;
import com.tydic.agreement.external.ssm.SkuRcmmdService;
import com.tydic.agreement.external.ssm.bo.SkuRcmmdReqBO;
import com.tydic.agreement.external.ssm.bo.SkuRcmmdResultBO;
import com.tydic.agreement.external.ssm.bo.SkuRcmmdRspBO;
import com.tydic.agreement.utils.http.HSHttpHelper;
import com.tydic.agreement.utils.http.HSNHttpHeader;
import com.tydic.agreement.utils.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SkuRcmmdServiceImpl
implements SkuRcmmdService {
    private static final Logger log = LoggerFactory.getLogger(SkuRcmmdServiceImpl.class);
    @Value(value="${Coding_Rcmmd_Multi_Url:http://192.168.22.200/Coding_Rcmmd/Coding_Rcmmd_Multi}")
    private String Coding_Rcmmd_Multi_Url;
    @Value(value="${Coding_Rcmmd_Mes_Url:http://192.168.22.200/Coding_Rcmmd/Coding_Rcmmd_Mes}")
    private String Coding_Rcmmd_Mes_Url;

    public SkuRcmmdRspBO Rcmmd(SkuRcmmdReqBO reqBO) {
        SkuRcmmdRspBO rspBO = new SkuRcmmdRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuRcmmdList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u6c42\u5217\u8868\u4e0d\u80fd\u4e3a\u4e3a\u7a7a");
            return rspBO;
        }
        try {
            HttpRetBean httpRetBean;
            String reqStr;
            if (!reqBO.getSingleFlag().booleanValue()) {
                reqStr = JSON.toJSONString((Object)reqBO.getSkuRcmmdList());
                log.debug("\u63a8\u8350\u591a\u6761\u6570\u636e\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqStr));
                httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.Coding_Rcmmd_Multi_Url), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(), "UTF-8", true);
            } else {
                reqStr = JSON.toJSONString(reqBO.getSkuRcmmdList().get(0));
                log.debug("\u63a8\u8350\u5355\u6761\u6570\u636e\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqStr));
                httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.Coding_Rcmmd_Mes_Url), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes(), "UTF-8", true);
            }
            log.debug("\u63a8\u8350\u6570\u636e\u63a5\u53e3\u51fa\u53c2:" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f!");
                return rspBO;
            }
            return this.resolveRsp(returnString, reqBO.getSingleFlag());
        }
        catch (Exception e) {
            log.error("\u63a8\u8350\u6570\u636e\u63a5\u53e3\u670d\u52a1\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u63a8\u8350\u6570\u636e\u63a5\u53e3\u5931\u8d25");
            return rspBO;
        }
    }

    private SkuRcmmdRspBO resolveRsp(String returnString, Boolean singleFlag) {
        SkuRcmmdRspBO rspBO = new SkuRcmmdRspBO();
        try {
            List<SkuRcmmdResultBO> rcmmdResultBOS = new ArrayList();
            if (singleFlag.booleanValue()) {
                SkuRcmmdResultBO skuRcmmdResultBO = (SkuRcmmdResultBO)JSON.parseObject((String)returnString, SkuRcmmdResultBO.class);
                rcmmdResultBOS.add(skuRcmmdResultBO);
            } else {
                rcmmdResultBOS = JSON.parseArray((String)returnString, SkuRcmmdResultBO.class);
            }
            rspBO.setSkuRcmmdResultList(rcmmdResultBOS);
        }
        catch (Exception e) {
            log.error("\u63a8\u8350\u6570\u636e\u63a5\u53e3\u53c2\u6570\u8f6c\u6362\u5931\u8d25" + e.getMessage());
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u63a8\u8350\u63a5\u53e3\u53c2\u6570\u8f6c\u6362\u5931\u8d25" + e.getMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f!");
        return rspBO;
    }
}

