/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.external.ssm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.agreement.ability.bo.QuotaListBO;
import com.tydic.agreement.external.ssm.SsmGetQuotaListService;
import com.tydic.agreement.external.ssm.bo.SsmGetQuotaListReqBO;
import com.tydic.agreement.external.ssm.bo.SsmGetQuotaListRspBO;
import com.tydic.agreement.utils.http.HSHttpHelper;
import com.tydic.agreement.utils.http.HSNHttpHeader;
import com.tydic.agreement.utils.http.HttpRetBean;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SsmGetQuotaListServiceImpl
implements SsmGetQuotaListService {
    private static final Logger log = LoggerFactory.getLogger(SsmGetQuotaListServiceImpl.class);
    @Value(value="${SSM_QUOTA_LIST_URL:http://172.16.100.65:8001/OSN/api/quota/v1}")
    private String SSM_QUOTA_LIST_URL;

    public SsmGetQuotaListRspBO getQuotaList(SsmGetQuotaListReqBO reqBO) {
        SsmGetQuotaListRspBO rspBO = new SsmGetQuotaListRspBO();
        try {
            JSONObject reqObject = new JSONObject();
            String token = reqBO.getToken();
            if (StringUtils.isBlank((CharSequence)token)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("token \u4e3a\u7a7a!");
                return rspBO;
            }
            reqObject.put("token", (Object)token);
            reqObject.put("request_source", (Object)"datapro");
            reqObject.put("quota_ids", (Object)reqBO.getQuotaIds());
            reqObject.put("start_date", (Object)reqBO.getStartDate());
            reqObject.put("end_date", (Object)reqBO.getEndDate());
            reqObject.put("sort_type", (Object)"1");
            log.debug("SMM\u83b7\u53d6\u6307\u6807\u5217\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqObject));
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.SSM_QUOTA_LIST_URL), HSNHttpHeader.getRequestHeaders("json"), reqObject.toJSONString().getBytes(), "UTF-8", true);
            log.debug("\u83b7\u53d6\u6307\u6807\u6570\u636e\u5217\u8868\u670d\u52a1:" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (org.springframework.util.StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6307\u6807\u6570\u636e\u5217\u8868\u670d\u52a1\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
            return this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6307\u6807\u6570\u636e\u5217\u8868\u670d\u52a1\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u83b7\u53d6\u6307\u6807\u6570\u636e\u5217\u8868\u670d\u52a1\u5931\u8d25");
            return rspBO;
        }
    }

    private SsmGetQuotaListRspBO resolveRsp(String returnString) {
        SsmGetQuotaListRspBO rspBO = new SsmGetQuotaListRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            Object data = rspJsonObject.get((Object)"data");
            Object msg = rspJsonObject.get((Object)"msg");
            Object code = rspJsonObject.get((Object)"code");
            if (code == null || !code.toString().equals("0")) {
                rspBO.setRespDesc(JSON.toJSONString((Object)msg));
                rspBO.setRespCode("8888");
                return rspBO;
            }
            List list = JSON.parseArray((String)JSON.toJSONString((Object)data), QuotaListBO.class);
            rspBO.setData(list);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f!");
        return rspBO;
    }
}

