/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.external.ssm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.agreement.external.ssm.SsmGetTokenService;
import com.tydic.agreement.external.ssm.bo.SsmGetTokenRspBO;
import com.tydic.agreement.utils.http.HSHttpHelper;
import com.tydic.agreement.utils.http.HSNHttpHeader;
import com.tydic.agreement.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SsmGetTokenServiceImpl
implements SsmGetTokenService {
    private static final Logger log = LoggerFactory.getLogger(SsmGetTokenServiceImpl.class);
    @Value(value="${SSM_AUTH_URL:http://172.16.100.65:8001/OSN/api/auth/v1}")
    private String SSM_AUTH_URL;
    @Value(value="${ssm_user_name:18116206995}")
    private String user_name;
    @Value(value="${ssm_password:cnsc2022}")
    private String password;

    public SsmGetTokenRspBO getToken() {
        SsmGetTokenRspBO rspBO = new SsmGetTokenRspBO();
        try {
            JSONObject reqObject = new JSONObject();
            reqObject.put("user_name", (Object)this.user_name);
            reqObject.put("password", (Object)SsmGetTokenServiceImpl.getMd5(this.password));
            reqObject.put("source", (Object)"datapro");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.SSM_AUTH_URL), HSNHttpHeader.getRequestHeaders("json"), reqObject.toJSONString().getBytes(), "UTF-8", true);
            log.debug("\u83b7\u53d6token\u670d\u52a1:" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6token\u670d\u52a1\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
            return this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6token\u670d\u52a1\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u83b7\u53d6token\u5931\u8d25");
            return rspBO;
        }
    }

    private SsmGetTokenRspBO resolveRsp(String returnString) {
        SsmGetTokenRspBO rspBO = new SsmGetTokenRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            Object data = rspJsonObject.get((Object)"data");
            Object msg = rspJsonObject.get((Object)"msg");
            Object code = rspJsonObject.get((Object)"code");
            if (code == null || !code.toString().equals("0")) {
                rspBO.setRespDesc(JSON.toJSONString((Object)msg));
                rspBO.setRespCode("8888");
                return rspBO;
            }
            rspBO = (SsmGetTokenRspBO)JSON.parseObject((String)JSON.toJSONString((Object)data), SsmGetTokenRspBO.class);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6ssm token\u5931\u8d25" + e);
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u83b7\u53d6ssm token\u5931\u8d25" + e);
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f!");
        return rspBO;
    }

    private static String getMd5(String str) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            return DatatypeConverter.printHexBinary((byte[])digest).toLowerCase();
        }
        catch (Exception e) {
            throw new Exception("MD5\u52a0\u5bc6\u51fa\u73b0\u9519\u8bef\uff0c" + e);
        }
    }
}

