/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.external.ucc.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.dao.AgrStandardSpuLogMapper;
import com.tydic.agreement.dao.po.AgrStandardSpuLogPO;
import com.tydic.agreement.external.ucc.AgrExternalStandardSpuSyncService;
import com.tydic.agreement.external.ucc.bo.AgrExternalStandardSpuSyncApplyInfoReqBO;
import com.tydic.agreement.external.ucc.bo.AgrExternalStandardSpuSyncApplyInfoRspBO;
import com.tydic.agreement.utils.http.HSHttpHelper;
import com.tydic.agreement.utils.http.HSNHttpHeader;
import com.tydic.agreement.utils.http.HttpRetBean;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AgrExternalStandardSpuSyncServiceImpl
implements AgrExternalStandardSpuSyncService {
    private static final Logger log = LoggerFactory.getLogger(AgrExternalStandardSpuSyncServiceImpl.class);
    @Value(value="${SC_SYNC_APPLY_INFO_URL:}")
    private String SC_SYNC_APPLY_INFO_URL;
    @Autowired
    private AgrStandardSpuLogMapper agrStandardSpuLogMapper;

    @Override
    public AgrExternalStandardSpuSyncApplyInfoRspBO syncApplyInfo(AgrExternalStandardSpuSyncApplyInfoReqBO reqBO) {
        String reqJson = this.assemblyPublicParam(reqBO.getData());
        log.debug("\u6807\u51c6\u5546\u54c1\u6210\u4ea4\u4fe1\u606f\u540c\u6b65\u5165\u53c2\uff1a{}", (Object)reqJson);
        this.saveRequestLog(reqJson, "syncApplyInfo");
        HttpRetBean httpRetBean = null;
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.SC_SYNC_APPLY_INFO_URL), HSNHttpHeader.getRequestHeaders("json"), reqJson.getBytes(), "UTF-8", true);
        }
        catch (IOException | URISyntaxException e) {
            throw new BusinessException("8888", "\u6807\u51c6\u5546\u54c1\u6210\u4ea4\u4fe1\u606f\u540c\u6b65\u5931\u8d25\uff01");
        }
        String result = httpRetBean.getStr();
        log.debug("\u6807\u51c6\u5546\u54c1\u6210\u4ea4\u4fe1\u606f\u540c\u6b65\u51fa\u53c2result\uff1a{}", (Object)result);
        if (!StringUtils.hasText((String)result)) {
            log.info("\u6807\u51c6\u5546\u54c1\u6210\u4ea4\u4fe1\u606f\u540c\u6b65\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            throw new ZTBusinessException("\u6807\u51c6\u5546\u54c1\u6210\u4ea4\u4fe1\u606f\u540c\u6b65\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
        }
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (null == resultJson) {
            log.info("\u6807\u51c6\u5546\u54c1\u6210\u4ea4\u4fe1\u606f\u540c\u6b65\u8fd4\u56de\u7ed3\u679c\u8f6c\u6362JSON\u5f02\u5e38");
            throw new ZTBusinessException("\u6807\u51c6\u5546\u54c1\u6210\u4ea4\u4fe1\u606f\u540c\u6b65\u8fd4\u56de\u7ed3\u679c\u8f6c\u6362JSON\u5f02\u5e38\uff01");
        }
        if (!"0000".equals(resultJson.getString("respCode"))) {
            throw new ZTBusinessException("\u6807\u51c6\u5546\u54c1\u6210\u4ea4\u4fe1\u606f\u540c\u6b65\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff01" + result);
        }
        AgrExternalStandardSpuSyncApplyInfoRspBO rspBO = (AgrExternalStandardSpuSyncApplyInfoRspBO)((Object)JSONObject.toJavaObject((JSON)resultJson, AgrExternalStandardSpuSyncApplyInfoRspBO.class));
        log.debug("\u6807\u51c6\u5546\u54c1\u6210\u4ea4\u4fe1\u606f\u540c\u6b65\u51fa\u53c2rspBO\uff1a{}", (Object)rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String assemblyPublicParam(Object data) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("serialNo", (Object)Sequence.getInstance().nextId());
        jsonObject.put("poolName", (Object)"zhonghe");
        jsonObject.put("data", data);
        return jsonObject.toJSONString();
    }

    private void saveRequestLog(String paramJson, String apiName) {
        try {
            AgrStandardSpuLogPO standardSpuLogPO = new AgrStandardSpuLogPO();
            standardSpuLogPO.setId(Sequence.getInstance().nextId());
            standardSpuLogPO.setType("p");
            standardSpuLogPO.setApiName(apiName);
            standardSpuLogPO.setContent(paramJson);
            standardSpuLogPO.setLogTime(new Date());
            this.agrStandardSpuLogMapper.insert(standardSpuLogPO);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
        }
    }
}

