/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.utils;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import parsii.eval.Expression;
import parsii.eval.Parser;
import parsii.eval.Scope;
import parsii.eval.Variable;

public class ParsiiUtils {
    private String expr;
    private Map<String, Double> variableMap;

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public Map<String, Double> getVariableMap() {
        return this.variableMap;
    }

    public void setVariableMap(Map<String, Double> variableMap) {
        this.variableMap = variableMap;
    }

    public static double doEvaluate(String expr, Map<String, Double> variableMap) throws Exception {
        Scope scope = new Scope();
        if (StringUtils.isBlank((CharSequence)expr)) {
            throw new Exception("\u516c\u5f0f\u8868\u8fbe\u5f0f\u4e3a\u7a7a!");
        }
        Expression parsiiExpr = Parser.parse((String)expr, (Scope)scope);
        parsiiExpr.simplify();
        if (!CollectionUtils.isEmpty(variableMap)) {
            ParsiiUtils.setVariable(scope, variableMap);
        }
        return parsiiExpr.evaluate();
    }

    private static void setVariable(Scope scope, Map<String, Double> variableMap) {
        variableMap.forEach((name, value) -> {
            if (!StringUtils.isBlank((CharSequence)name) && value != null) {
                Variable variable = scope.getVariable(name);
                variable.setValue(value.doubleValue());
            }
        });
    }

    public static String validate(String expression, List<String> variables) {
        String[] splits;
        if (variables == null || variables.isEmpty()) {
            throw new RuntimeException("\u5185\u7f6e\u53d8\u91cf\u4e3a\u7a7a");
        }
        if ((expression = expression.replaceAll(" ", "")).split("[+\\-*/]{2,}").length > 1) {
            throw new RuntimeException("\u516c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u5305\u542b\u8fde\u7eed\u8fd0\u7b97\u7b26");
        }
        if (StringUtils.contains((CharSequence)expression, (CharSequence)"()")) {
            throw new RuntimeException("\u516c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u5305\u542b\u7a7a\u62ec\u53f7");
        }
        expression = expression.replaceAll("]", ")");
        expression = expression.replaceAll("}", ")");
        expression = expression.replaceAll("\\[", "(");
        expression = expression.replaceAll("\\{", "(");
        expression = expression.replaceAll("\\)\\(", "\\)*\\(");
        expression = expression.replaceAll("\\(-", "\\(0-");
        expression = expression.replaceAll("\\(\\+", "\\(0+");
        System.out.println(expression);
        for (String split : splits = expression.split("[+\\-*/()]")) {
            if (StringUtils.isBlank((CharSequence)split) || Pattern.matches("-?(0|([1-9]\\d*))(\\.\\d+)?", split) || variables.contains(split)) continue;
            throw new RuntimeException("\u516c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u5305\u542b\u975e\u6cd5\u53d8\u91cf\u6216\u5b57\u7b26");
        }
        Character preChar = null;
        Stack<Character> stack = new Stack<Character>();
        String resultExpression = expression;
        for (int i = 0; i < expression.length(); ++i) {
            char currChar = expression.charAt(i);
            if (i == 0) {
                if (Pattern.matches("[*/]", String.valueOf(currChar))) {
                    throw new RuntimeException("\u516c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u4ee5\u9519\u8bef\u8fd0\u7b97\u7b26\u5f00\u5934");
                }
                if (currChar == '+') {
                    resultExpression = expression.substring(1);
                }
                if (currChar == '-') {
                    resultExpression = "0" + expression;
                }
            }
            if ('(' == currChar) {
                stack.push(Character.valueOf('('));
            } else if (')' == currChar) {
                if (stack.size() > 0) {
                    stack.pop();
                } else {
                    throw new RuntimeException("\u516c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u62ec\u53f7\u4e0d\u914d\u5bf9");
                }
            }
            if (preChar != null && preChar.charValue() == '(' && Pattern.matches("[+\\-*/]+", String.valueOf(currChar))) {
                throw new RuntimeException("\u516c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u5de6\u62ec\u53f7\u540e\u662f\u8fd0\u7b97\u7b26");
            }
            if (preChar != null && preChar.charValue() == ')' && !Pattern.matches("[+\\-*/]+", String.valueOf(currChar))) {
                throw new RuntimeException("\u516c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u53f3\u62ec\u53f7\u540e\u9762\u4e0d\u662f\u8fd0\u7b97\u7b26");
            }
            if (i == expression.length() - 1 && Pattern.matches("[+\\-*/]", String.valueOf(currChar))) {
                throw new RuntimeException("\u516c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u4ee5\u8fd0\u7b97\u7b26\u7ed3\u5c3e");
            }
            preChar = Character.valueOf(currChar);
        }
        if (!stack.isEmpty()) {
            throw new RuntimeException("\u516c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u62ec\u53f7\u4e0d\u914d\u5bf9");
        }
        return resultExpression;
    }
}

