/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.util.StringUtil;
import com.tydic.agreement.extend.common.AgrExtCommonConstant;
import com.tydic.agreement.utils.PropertiesUtils;
import com.tydic.agreement.utils.SendMessReqBO;
import com.tydic.agreement.utils.SendMessRspBO;
import com.tydic.agreement.utils.http.HSHttpHelper;
import com.tydic.agreement.utils.http.HSNHttpHeader;
import com.tydic.agreement.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessUtils {
    private static final Logger log = LoggerFactory.getLogger(SendMessUtils.class);

    public static SendMessRspBO dealSendRemind(SendMessReqBO reqBO) {
        SendMessRspBO rspBO;
        String token = reqBO.getToken();
        if (reqBO.getSendType().equals(AgrExtCommonConstant.MESSAGE_SEND_MESSAGE)) {
            String requestJsonStr = SendMessUtils.initRequestMessageJsonStr(reqBO);
            log.debug("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = null == reqBO.getTemplateId() || 0L == reqBO.getTemplateId() ? SendMessUtils.sendFrom(requestJsonStr, PropertiesUtils.getProperty("SEND_INNER_MESSAGE_URL"), token) : SendMessUtils.sendFrom(requestJsonStr, PropertiesUtils.getProperty("SEND_INNER_SYSMESSAGE_URL"), token);
        } else if (reqBO.getSendType().equals(AgrExtCommonConstant.MESSAGE_SEND_EMAIL)) {
            String requestJsonStr = SendMessUtils.initRequestEmailJsonStr(reqBO);
            if (null == reqBO.getMailFileBOS()) {
                log.debug("\u53d1\u9001\u90ae\u4ef6\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
                rspBO = SendMessUtils.doUrlPostRequest(requestJsonStr, "NOTIFY_SEND_MAIL_URL", token);
            } else {
                log.debug("\u53d1\u9001\u90ae\u4ef6(\u5305\u542b\u9644\u4ef6)\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
                rspBO = SendMessUtils.doUrlPostRequest(requestJsonStr, "SEND_MAIL_CONTAIN_ANNEX", token);
            }
        } else if (reqBO.getSendType().equals(AgrExtCommonConstant.MESSAGE_SEND_MOBILE)) {
            String requestJsonStr = SendMessUtils.initRequestMobileJsonStr(reqBO);
            log.debug("\u53d1\u9001\u77ed\u4fe1\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = SendMessUtils.doUrlPostRequest(requestJsonStr, "SEND_ONLY_SMS_MESSAGE_URL", "");
        } else if (reqBO.getSendType().equals(AgrExtCommonConstant.MESSAGE_SEND_WX)) {
            String requestJsonStr = SendMessUtils.initRequestWXJsonStr(reqBO);
            log.debug("\u53d1\u9001\u5fae\u4fe1\u901a\u77e5\u4e2d\u5fc3\u5165\u53c2\uff1a" + requestJsonStr);
            rspBO = SendMessUtils.doUrlPostRequest(requestJsonStr, "SEND_WX_MESSAGE_URL", "");
            rspBO = new SendMessRspBO();
        } else {
            rspBO = new SendMessRspBO();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u77e5\u901a\u77e5\u7c7b\u578b");
        }
        return rspBO;
    }

    private static SendMessRspBO sendFrom(String requestJsonStr, String url, String token) {
        SendMessRspBO rspBO = new SendMessRspBO();
        Map map = (Map)JSONObject.parseObject((String)requestJsonStr, Map.class);
        HashMap<String, String> param = new HashMap<String, String>(map.size());
        for (Map.Entry elem : map.entrySet()) {
            if (elem.getValue() == null) continue;
            param.put((String)elem.getKey(), elem.getValue().toString());
        }
        try {
            HashMap<String, String> header = null;
            if (token != null) {
                header = new HashMap<String, String>(1);
                header.put("auth-token", token);
            }
            String rsp = SendMessUtils.doPost(url, param, header);
            log.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a" + rsp);
            rspBO = SendMessUtils.resolveRsp(rsp);
        }
        catch (Exception var9) {
            log.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38!", (Throwable)var9);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBO;
    }

    private static SendMessRspBO doUrlPostRequest(String requestJsonStr, String url, String token) {
        SendMessRspBO rspBO = new SendMessRspBO();
        try {
            HttpRetBean httpRetBean;
            Header[] headers = HSNHttpHeader.getRequestHeaders("json");
            if (StringUtils.isNotBlank((CharSequence)token)) {
                Header[] header = new Header[headers.length + 1];
                System.arraycopy(headers, 0, header, 0, headers.length);
                header[headers.length] = new BasicHeader("auth-token", token);
                httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtils.getProperty(url)), header, requestJsonStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            } else {
                httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtils.getProperty(url)), headers, requestJsonStr.getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            }
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtils.getProperty(url) + "]");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                log.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a!");
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return rspBO;
            }
            rspBO = SendMessUtils.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        return rspBO;
    }

    private static String initRequestEmailJsonStr(SendMessReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("to", (Object)reqBO.getEmail());
        jsonObject.put("content", (Object)reqBO.getText());
        jsonObject.put("subject", (Object)reqBO.getSubject());
        if (null != reqBO.getMailFileBOS() && reqBO.getMailFileBOS().size() > 0) {
            jsonObject.put("mailFileList", reqBO.getMailFileBOS());
        }
        if (!StringUtil.isEmpty((String)reqBO.getFrom())) {
            jsonObject.put("from", (Object)reqBO.getFrom());
        }
        return jsonObject.toJSONString();
    }

    private static String initRequestMobileJsonStr(SendMessReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("mobile", (Object)reqBO.getMobile());
        jsonObject.put("content", (Object)reqBO.getText());
        return jsonObject.toJSONString();
    }

    private static String initRequestMessageJsonStr(SendMessReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sendid", (Object)reqBO.getUserId());
        jsonObject.put("recid", (Object)reqBO.getReceiveId());
        jsonObject.put("appid", (Object)PropertiesUtils.getProperty("APP_ID"));
        jsonObject.put("titel", (Object)reqBO.getTitle());
        jsonObject.put("text", (Object)reqBO.getText());
        jsonObject.put("token", (Object)reqBO.getToken());
        if (null != reqBO.getTemplateId() && reqBO.getTemplateId() != 0L) {
            jsonObject.put("templateId", (Object)reqBO.getTemplateId());
            jsonObject.put("templateParam", (Object)JSON.toJSONString(reqBO.getTemplateParam()));
        }
        return jsonObject.toJSONString();
    }

    private static String initRequestWXJsonStr(SendMessReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("touser", (Object)reqBO.getReceiveId());
        jsonObject.put("templateId", (Object)reqBO.getTemplateId());
        JSONObject data = new JSONObject();
        data.put("title", (Object)reqBO.getTitle());
        data.put("text", (Object)reqBO.getText());
        jsonObject.put("data", (Object)data);
        return jsonObject.toJSONString();
    }

    private static SendMessRspBO resolveRsp(String returnString) {
        log.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + returnString);
        SendMessRspBO rspBO = new SendMessRspBO();
        JSONObject jsonObjectReturn = JSONObject.parseObject((String)returnString);
        if (!"0".equals(jsonObjectReturn.getString("code"))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u63d0\u9192\u6210\u529f!");
        return rspBO;
    }

    public static String doPost(String url, Map<String, String> map, Map<String, String> headers) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity httpEntity;
            HttpResponse response;
            httpClient = HttpClientBuilder.create().build();
            httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            if (list.size() > 0) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, charset);
                entity.setContentType("application/x-www-form-urlencoded");
                httpPost.setHeader("Accept", "text/plain;charset=utf-8");
                httpPost.setHeader("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
                if (headers != null && headers.size() > 0) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        httpPost.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (httpEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)httpEntity, (String)charset);
            }
        }
        catch (Exception var10) {
            var10.printStackTrace();
        }
        return result;
    }
}

