/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.commodity.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService;
import com.tydic.bcm.personal.commodity.api.BcmUpdateStatusApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyOrderBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailRspBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateStatusApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateStatusApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.common.api.BcmQueryFlowInstanceDetailService;
import com.tydic.bcm.personal.common.api.BcmUpdateFlowTaskService;
import com.tydic.bcm.personal.common.bo.BcmFlowInstanceBO;
import com.tydic.bcm.personal.common.bo.BcmQueryFlowInstanceDetailReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryFlowInstanceDetailRspBO;
import com.tydic.bcm.personal.common.bo.BcmUpdateFlowTaskReqBO;
import com.tydic.bcm.personal.constants.BcmBpmFlowConstant;
import com.tydic.bcm.personal.constants.BcmFlowTaskStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityCancelTypeEnum;
import com.tydic.bcm.personal.constants.BooleanFlagEnum;
import com.tydic.bcm.personal.constants.BpmApproveResultEnum;
import com.tydic.bcm.saas.personal.commodity.api.BcmSaasApproveApplyOrderService;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasApproveApplyOrderReqBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasApproveApplyOrderRspBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.SaasParamValidateUtils;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspInfoBO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.commodity.api.BcmSaasApproveApplyOrderService"})
public class BcmSaasApproveApplyOrderServiceImpl
implements BcmSaasApproveApplyOrderService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasApproveApplyOrderServiceImpl.class);
    @Autowired
    private BcmUpdateStatusApplyCommodityOrderService updateStatusApplyCommodityOrderService;
    @Autowired
    private BcmQueryFlowInstanceDetailService bcmQueryFlowInstanceDetailService;
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private BcmQueryApplyOrderDetailService queryApplyOrderDetailService;
    @Autowired
    private BcmUpdateFlowTaskService updateFlowTaskService;
    private static final Integer defaultPoolStatus = 1;
    private static final Integer defaultPoolType = 2;
    private static final Integer defaultPoolRelType = 5;
    @Value(value="${DEAL_SKU_POOL_URL:}")
    private String dealSkuPoolUrl;

    @Override
    @PostMapping(value={"approveApplyOrder"})
    public BcmSaasApproveApplyOrderRspBO approveApplyOrder(@RequestBody BcmSaasApproveApplyOrderReqBO reqBO) {
        BcmUpdateStatusApplyCommodityOrderRspBO bcmUpdateStatusApplyCommodityOrderRspBO;
        SaasParamValidateUtils.validate(reqBO);
        BcmQueryFlowInstanceDetailReqBO bcmQueryFlowInstanceDetailReq = new BcmQueryFlowInstanceDetailReqBO();
        bcmQueryFlowInstanceDetailReq.setTaskId(reqBO.getTaskId());
        BcmQueryFlowInstanceDetailRspBO bcmQueryFlowInstanceDetailRspBO = this.bcmQueryFlowInstanceDetailService.queryFlowInstanceDetail(bcmQueryFlowInstanceDetailReq);
        if (!"0000".equals(bcmQueryFlowInstanceDetailRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmQueryFlowInstanceDetailRspBO.getRespDesc());
        }
        BcmQueryApplyOrderDetailReqBO detailReqBO = new BcmQueryApplyOrderDetailReqBO();
        detailReqBO.setApplyOrderId(reqBO.getApplyOrderId());
        BcmQueryApplyOrderDetailRspBO bcmQueryApplyOrderDetailRspBO = this.queryApplyOrderDetailService.queryApplyOrderDetail(detailReqBO);
        if (!"0000".equals(bcmQueryApplyOrderDetailRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmQueryApplyOrderDetailRspBO.getRespDesc());
        }
        BcmApplyOrderBO applyOrder = bcmQueryApplyOrderDetailRspBO.getApplyOrder();
        BcmFlowInstanceBO flowInstance = bcmQueryFlowInstanceDetailRspBO.getFlowInstance();
        EacApproveAbilityReqInfoBO eacApproveAbilityReqInfo = new EacApproveAbilityReqInfoBO();
        eacApproveAbilityReqInfo.setTaskId(reqBO.getTaskId());
        eacApproveAbilityReqInfo.setApproveAdvice(reqBO.getApproveAdvice());
        eacApproveAbilityReqInfo.setApproveResult(reqBO.getApproveResult());
        EacApproveAbilityReqBO eacApproveAbilityReq = new EacApproveAbilityReqBO();
        eacApproveAbilityReq.setData((List)Lists.newArrayList((Object[])new EacApproveAbilityReqInfoBO[]{eacApproveAbilityReqInfo}));
        EacApproveAbilityRspBO eacApproveAbilityRspBO = this.eacRuTaskAbilityService.approveByMq(eacApproveAbilityReq);
        if (!"0000".equals(eacApproveAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException(eacApproveAbilityRspBO.getRespDesc());
        }
        EacApproveAbilityRspInfoBO eacApproveAbilityRspInfoBO = (EacApproveAbilityRspInfoBO)eacApproveAbilityRspBO.getData().get(0);
        log.info("\u6d41\u7a0b\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)eacApproveAbilityRspInfoBO));
        BcmUpdateStatusApplyCommodityOrderReqBO updateStatusApplyCommodityOrderReqBO = new BcmUpdateStatusApplyCommodityOrderReqBO();
        updateStatusApplyCommodityOrderReqBO.setApplyOrderId(reqBO.getApplyOrderId());
        updateStatusApplyCommodityOrderReqBO.setUpdateUserId(reqBO.getUserId());
        updateStatusApplyCommodityOrderReqBO.setUpdateUserName(reqBO.getName());
        updateStatusApplyCommodityOrderReqBO.setUpdateTime(new Date());
        if (BpmApproveResultEnum.REJECT.getApprove().equals(reqBO.getApproveResult())) {
            updateStatusApplyCommodityOrderReqBO.setCancelReason(reqBO.getApproveAdvice());
            if (BcmBpmFlowConstant.FlowInstanceFlowType.APPLY_ORDER_AUDIT.equals(flowInstance.getFlowType())) {
                updateStatusApplyCommodityOrderReqBO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.TERMINATION.getStatus());
                updateStatusApplyCommodityOrderReqBO.setCancelType(BcmPersonalCommodityCancelTypeEnum.APPLY_AUDIT_REJECT.getCancelType());
            } else if (BcmBpmFlowConstant.FlowInstanceFlowType.APPLY_ORDER_SELECT_AUDIT.equals(flowInstance.getFlowType())) {
                updateStatusApplyCommodityOrderReqBO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.IN_SELECT.getStatus());
                updateStatusApplyCommodityOrderReqBO.setCancelType(BcmPersonalCommodityCancelTypeEnum.SELECT_AUDIT_REJECT.getCancelType());
            }
        }
        if (BpmApproveResultEnum.PASS.getApprove().equals(reqBO.getApproveResult()) && eacApproveAbilityRspInfoBO.getIsFinish().booleanValue()) {
            if (BcmBpmFlowConstant.FlowInstanceFlowType.APPLY_ORDER_AUDIT.equals(flowInstance.getFlowType())) {
                updateStatusApplyCommodityOrderReqBO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.IN_REPLY.getStatus());
                this.addSkuPool(applyOrder);
                updateStatusApplyCommodityOrderReqBO.setApplyApprovePassTime(new Date());
                updateStatusApplyCommodityOrderReqBO.setReplyDeadlineDate((Date)DateUtil.offsetDay((Date)new Date(), (int)applyOrder.getReplyDayLimit()));
            } else if (BcmBpmFlowConstant.FlowInstanceFlowType.APPLY_ORDER_SELECT_AUDIT.equals(flowInstance.getFlowType())) {
                updateStatusApplyCommodityOrderReqBO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.FINISH.getStatus());
                updateStatusApplyCommodityOrderReqBO.setSelectApprovePassTime(new Date());
            }
        }
        if (!"0000".equals((bcmUpdateStatusApplyCommodityOrderRspBO = this.updateStatusApplyCommodityOrderService.updateStatusApplyCommodityOrder(updateStatusApplyCommodityOrderReqBO)).getRespCode())) {
            throw new ZTBusinessException(bcmUpdateStatusApplyCommodityOrderRspBO.getRespDesc());
        }
        BcmUpdateFlowTaskReqBO taskReq = new BcmUpdateFlowTaskReqBO();
        if (BpmApproveResultEnum.PASS.getApprove().equals(reqBO.getApproveResult())) {
            taskReq.setTaskStatus(BcmFlowTaskStatusEnum.PASS.getTaskStatus());
        } else if (BpmApproveResultEnum.REJECT.getApprove().equals(reqBO.getApproveResult())) {
            taskReq.setTaskStatus(BcmFlowTaskStatusEnum.REJECT.getTaskStatus());
        }
        taskReq.setFlowInstanceId(flowInstance.getId());
        taskReq.setFlowInstId(flowInstance.getFlowInstId());
        taskReq.setFlowFinishFlag(eacApproveAbilityRspInfoBO.getIsFinish() != false ? BooleanFlagEnum.YES.getFlag() : BooleanFlagEnum.NO.getFlag());
        taskReq.setTaskId(reqBO.getTaskId() + "");
        taskReq.setAuditUserId(reqBO.getUserId());
        taskReq.setAuditUserName(reqBO.getName());
        taskReq.setAuditOrgId(reqBO.getOrgId());
        taskReq.setAuditOrgName(reqBO.getOrgName());
        taskReq.setAuditCompanyName(reqBO.getCompanyName());
        taskReq.setAuditCompanyId(reqBO.getCompanyId());
        taskReq.setUpdateUserId(reqBO.getUserId());
        taskReq.setUpdateUserName(reqBO.getName());
        taskReq.setUpdateTime(new Date());
        taskReq.setCurrentNodeCode(eacApproveAbilityRspInfoBO.getTacheCode());
        taskReq.setCurrentNodeName(eacApproveAbilityRspInfoBO.getTacheName());
        this.updateFlowTaskService.updateFlowTask(taskReq);
        return new BcmSaasApproveApplyOrderRspBO();
    }

    private void addSkuPool(BcmApplyOrderBO applyOrder) {
        JSONObject addPoolReqStr = new JSONObject();
        addPoolReqStr.put("poolName", (Object)(applyOrder.getApplyOrderName() + "\u5b9a\u5236\u5546\u54c1"));
        addPoolReqStr.put("poolStatus", (Object)defaultPoolStatus);
        addPoolReqStr.put("poolRelType", (Object)defaultPoolRelType);
        addPoolReqStr.put("poolType", (Object)defaultPoolType);
        addPoolReqStr.put("poolStartTime", (Object)applyOrder.getApplyOrderItem().getBuyStartTime());
        addPoolReqStr.put("poolEndTime", (Object)applyOrder.getApplyOrderItem().getBuyEndTime());
        addPoolReqStr.put("expand4", (Object)applyOrder.getPurCompanyId());
        addPoolReqStr.put("expand5", (Object)applyOrder.getPurCompanyName());
        addPoolReqStr.put("expand7", (Object)applyOrder.getApplyOrderId());
        addPoolReqStr.put("expand8", (Object)applyOrder.getApplyOrderCode());
        addPoolReqStr.put("expand9", (Object)applyOrder.getApplyOrderName());
        addPoolReqStr.put("companyName", (Object)applyOrder.getApplyUserCompanyId());
        addPoolReqStr.put("companyId", (Object)applyOrder.getApplyUserCompanyId());
        addPoolReqStr.put("username", (Object)applyOrder.getApplyUserName());
        addPoolReqStr.put("userId", (Object)applyOrder.getApplyUserId());
        log.info("\u8c03\u7528\u5b9a\u5236\u5546\u54c1\u6c60\u521b\u5efa\u63a5\u53e3\u5165\u53c2\u4e3a:{}", (Object)addPoolReqStr);
        String addPoolRspStr = BcmSaasHttpUtil.doPost(this.dealSkuPoolUrl, addPoolReqStr.toJSONString());
        log.info("\u8c03\u7528\u5b9a\u5236\u5546\u54c1\u6c60\u521b\u5efa\u63a5\u53e3\u51fa\u53c2\u4e3a:{}", (Object)addPoolRspStr);
    }
}

