/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderListService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.saas.personal.commodity.api.BcmUccstopCommodityPoolAbilityService;
import com.tydic.bcm.saas.personal.commodity.bo.BcmUccstopCommodityPoolAbilityReqBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmUccstopCommodityPoolAbilityRspBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmUccstopCommodityPoolAbilityServiceReqBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.commodity.api.BcmUccstopCommodityPoolAbilityService"})
public class BcmUccstopCommodityPoolAbilityServiceImpl
implements BcmUccstopCommodityPoolAbilityService {
    @Value(value="${STOP.COMMODITY.POOL.URl}")
    private String url;
    @Autowired
    private BcmQueryApplyCommodityOrderListService bcmQueryApplyCommodityOrderListService;

    @Override
    @PostMapping(value={"stopCommodityPool"})
    public BcmUccstopCommodityPoolAbilityRspBO stopCommodityPool(@RequestBody BcmUccstopCommodityPoolAbilityReqBO reqBO) {
        BcmQueryApplyCommodityOrderListReqBO bcmQueryApplyCommodityOrderListReqBO = this.getBcmQueryApplyCommodityOrderListReqBO();
        BcmQueryApplyCommodityOrderListRspBO bcmQueryApplyCommodityOrderListRspBO = this.bcmQueryApplyCommodityOrderListService.getList(bcmQueryApplyCommodityOrderListReqBO);
        if (!"0000".equals(bcmQueryApplyCommodityOrderListRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmQueryApplyCommodityOrderListRspBO.getRespDesc());
        }
        if (CollectionUtils.isNotEmpty((Collection)bcmQueryApplyCommodityOrderListRspBO.getList())) {
            this.stopCommodityPool(bcmQueryApplyCommodityOrderListRspBO);
        }
        return BcmSaasRuUtil.success(BcmUccstopCommodityPoolAbilityRspBO.class);
    }

    private void stopCommodityPool(BcmQueryApplyCommodityOrderListRspBO bcmQueryApplyCommodityOrderListRspBO) {
        for (BcmApplyCommodityOrderBO bo : bcmQueryApplyCommodityOrderListRspBO.getList()) {
            BcmUccstopCommodityPoolAbilityServiceReqBO bcmUccstopCommodityPoolAbilityServiceReqBO = new BcmUccstopCommodityPoolAbilityServiceReqBO();
            bcmUccstopCommodityPoolAbilityServiceReqBO.setExpand7(bo.getApplyOrderId().toString());
            String body = JSONObject.toJSONString((Object)bcmUccstopCommodityPoolAbilityServiceReqBO);
            BcmSaasHttpUtil.doPost(this.url, body);
        }
    }

    private BcmQueryApplyCommodityOrderListReqBO getBcmQueryApplyCommodityOrderListReqBO() {
        BcmQueryApplyCommodityOrderListReqBO bcmQueryApplyCommodityOrderListReqBO = new BcmQueryApplyCommodityOrderListReqBO();
        bcmQueryApplyCommodityOrderListReqBO.setLastBuyTime(new Date());
        bcmQueryApplyCommodityOrderListReqBO.setApplyOrderStatusList(Arrays.asList(BcmPersonalApplyOrderStatusEnum.IN_REPLY.getStatus(), BcmPersonalApplyOrderStatusEnum.IN_SELECT.getStatus(), BcmPersonalApplyOrderStatusEnum.SELECTED.getStatus(), BcmPersonalApplyOrderStatusEnum.IN_RESULT_APPROVAL.getStatus(), BcmPersonalApplyOrderStatusEnum.FINISH.getStatus()));
        return bcmQueryApplyCommodityOrderListReqBO;
    }
}

