/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.mq;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyOrderBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailRspBO;
import com.tydic.bcm.personal.common.api.BcmApproveApplyOrderService;
import com.tydic.bcm.personal.common.bo.BcmApproveApplyOrderRspBO;
import com.tydic.bcm.personal.common.bo.BcmFlowInstanceBO;
import com.tydic.bcm.personal.common.bo.BcmFlowTaskBO;
import com.tydic.bcm.personal.constants.BcmBpmFlowConstant;
import com.tydic.bcm.personal.constants.BcmFlowTaskStatusEnum;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasGeminiReceiverBO;
import com.tydic.bcm.saas.personal.constant.BcmSaasPersonalCommodityConstant;
import com.tydic.bcm.saas.personal.mq.BpmAuditMessageBO;
import com.tydic.bcm.saas.personal.mq.NoticeSendUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class BcmApplyOrderApproveMessageService
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(BcmApplyOrderApproveMessageService.class);
    @Autowired
    private BcmApproveApplyOrderService bcmApproveApplyOrderService;
    @Autowired
    private BcmQueryApplyOrderDetailService bcmQueryApplyOrderDetailService;
    @Value(value="${notice.apply.order.audit.taskCode}")
    private String applyOrderListAuditTaskCode;
    @Value(value="${notice.url}")
    private String noticeUrl;
    @Value(value="${bcm.dyc.front.url}")
    private String frontUrl;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.info("{} \u6d88\u606f\u5185\u5bb9\uff1a {}", (Object)message.getTag(), (Object)message.getContent());
        BpmAuditMessageBO bpmAuditMessage = (BpmAuditMessageBO)JSON.parseObject((String)message.getContent(), BpmAuditMessageBO.class);
        BcmFlowInstanceBO bcmFlowInstanceBO = this.fillFlowInstance(bpmAuditMessage);
        BcmApproveApplyOrderRspBO bcmApproveApplyOrderRspBO = this.bcmApproveApplyOrderService.approveApplyOrder(bcmFlowInstanceBO);
        if (!"0000".equals(bcmApproveApplyOrderRspBO.getRespCode())) {
            log.error("\u6d88\u8d39\u5931\u8d25 {}", (Object)JSON.toJSONString((Object)bcmApproveApplyOrderRspBO));
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        try {
            this.sendNotice(bpmAuditMessage, bcmFlowInstanceBO.getObjId());
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u901a\u77e5\u4ee3\u529e\u5931\u8d25", (Throwable)e);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private BcmFlowInstanceBO fillFlowInstance(BpmAuditMessageBO bpmAuditMessage) {
        BcmFlowInstanceBO bcmFlowInstance = new BcmFlowInstanceBO();
        bcmFlowInstance.setFlowInstId(bpmAuditMessage.getProcInstId());
        if (bpmAuditMessage.getIsfinish().booleanValue()) {
            bcmFlowInstance.setIsFinish(BcmSaasPersonalCommodityConstant.FlowInstanceIsFinish.YES);
            bcmFlowInstance.setCurrentNodeStatus(BcmSaasPersonalCommodityConstant.FlowInstanceCurrentNodeStatus.APPROVAL_FINISH);
        } else {
            bcmFlowInstance.setIsFinish(BcmSaasPersonalCommodityConstant.FlowInstanceIsFinish.NO);
            bcmFlowInstance.setCurrentNodeStatus(BcmSaasPersonalCommodityConstant.FlowInstanceCurrentNodeStatus.IN_APPROVAL);
        }
        if (CollectionUtil.isNotEmpty(bpmAuditMessage.getTaskList())) {
            BpmAuditMessageBO.TaskListDTO task = bpmAuditMessage.getTaskList().get(0);
            BpmAuditMessageBO.TaskListDTO.BusinessDTO business = task.getBusiness();
            bcmFlowInstance.setObjId(business.getBusinessId());
            if ("apply_commodity_order".equals(task.getProcDefKey())) {
                bcmFlowInstance.setObjType(BcmBpmFlowConstant.FlowInstanceObjType.APPLY_ORDER);
                bcmFlowInstance.setFlowType(BcmBpmFlowConstant.FlowInstanceFlowType.APPLY_ORDER_AUDIT);
            } else if ("apply_commodity_order_select".equals(task.getProcDefKey())) {
                bcmFlowInstance.setObjType(BcmBpmFlowConstant.FlowInstanceObjType.APPLY_ORDER);
                bcmFlowInstance.setFlowType(BcmBpmFlowConstant.FlowInstanceFlowType.APPLY_ORDER_SELECT_AUDIT);
            }
            bcmFlowInstance.setFlowKey(task.getProcDefKey());
            bcmFlowInstance.setFlowDefId(task.getProcDefId());
            bcmFlowInstance.setCurrentNodeCode(task.getStepId());
            bcmFlowInstance.setCurrentNodeName(task.getStepName());
            bcmFlowInstance.setAuditStartTime(task.getCreateTime());
        }
        ArrayList<BcmFlowTaskBO> bcmFlowTaskList = new ArrayList<BcmFlowTaskBO>();
        if (CollectionUtil.isNotEmpty(bpmAuditMessage.getTaskList())) {
            for (BpmAuditMessageBO.TaskListDTO taskListDTO : bpmAuditMessage.getTaskList()) {
                BcmFlowTaskBO bcmFlowTask = new BcmFlowTaskBO();
                bcmFlowTask.setTaskId(taskListDTO.getApproveTaskId());
                bcmFlowTask.setFlowInstId(taskListDTO.getProcInstId());
                bcmFlowTask.setCurrentNodeCode(taskListDTO.getStepId());
                bcmFlowTask.setCurrentNodeName(taskListDTO.getStepName());
                bcmFlowTask.setTaskCreateTime(taskListDTO.getCreateTime());
                bcmFlowTask.setTaskStatus(BcmFlowTaskStatusEnum.WAIT_APPROVE.getTaskStatus());
                if (taskListDTO.getUserId() != null) {
                    bcmFlowTask.setPendingAuditUserId(taskListDTO.getUserId());
                    bcmFlowTask.setPendingAuditUserName(taskListDTO.getUserName());
                }
                if (taskListDTO.getOrgId() != null) {
                    bcmFlowTask.setPendingAuditOrgId(taskListDTO.getOrgId());
                    bcmFlowTask.setPendingAuditOrgName(taskListDTO.getOrgName());
                }
                if (taskListDTO.getCompanyId() != null) {
                    bcmFlowTask.setPendingAuditCompanyId(taskListDTO.getCompanyId());
                    bcmFlowTask.setPendingAuditCompanyName(taskListDTO.getCompanyName());
                }
                bcmFlowTaskList.add(bcmFlowTask);
            }
        }
        bcmFlowInstance.setBcmFlowTaskList(bcmFlowTaskList);
        log.info("\u6d41\u7a0b\u8f6c\u5316\u540e\u5bf9\u8c61 ### {}", (Object)JSON.toJSONString((Object)bcmFlowInstance));
        return bcmFlowInstance;
    }

    private void sendNotice(BpmAuditMessageBO bpmAuditMessage, Long applyOrderId) {
        if (CollectionUtil.isEmpty(bpmAuditMessage.getTaskList())) {
            return;
        }
        BcmQueryApplyOrderDetailReqBO queryApplyOrderDetailReqBO = new BcmQueryApplyOrderDetailReqBO();
        queryApplyOrderDetailReqBO.setApplyOrderId(applyOrderId);
        BcmQueryApplyOrderDetailRspBO bcmQueryApplyOrderDetailRspBO = this.bcmQueryApplyOrderDetailService.queryApplyOrderDetail(queryApplyOrderDetailReqBO);
        if (!"0000".equals(bcmQueryApplyOrderDetailRspBO.getRespCode())) {
            log.error("\u6d88\u8d39\u5931\u8d25 {}", (Object)JSON.toJSONString((Object)bcmQueryApplyOrderDetailRspBO));
            throw new ZTBusinessException("\u67e5\u8be2\u4e0a\u67b6\u7533\u8bf7\u5355\u8be6\u60c5\u51fa\u9519");
        }
        for (BpmAuditMessageBO.TaskListDTO taskListDTO : bpmAuditMessage.getTaskList()) {
            BcmApplyOrderBO applyOrder = bcmQueryApplyOrderDetailRspBO.getApplyOrder();
            StringBuilder builder = new StringBuilder(this.frontUrl);
            builder.append("ecOnshelfApprovalDetail?isShowApprovalBtn=true&f=ecOnshelfApproval&isArg=true&tabKey=1");
            builder.append("&orderCode=").append(applyOrder.getApplyOrderCode());
            builder.append("&orderId=").append(applyOrder.getApplyOrderId());
            builder.append("&taskId=").append(taskListDTO.getTaskId());
            BcmSaasGeminiReceiverBO bcmSaasGeminiReceiverBO = new BcmSaasGeminiReceiverBO();
            bcmSaasGeminiReceiverBO.setReceiverId(taskListDTO.getUserId());
            bcmSaasGeminiReceiverBO.setReceiverName(taskListDTO.getUserName());
            NoticeSendUtils.sendSingleApplyOrder(this.applyOrderListAuditTaskCode, this.noticeUrl, applyOrder.getApplyUserId(), applyOrder.getApplyUserName(), bcmSaasGeminiReceiverBO, "\u5f85\u5ba1\u6279\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355\uff1a" + applyOrder.getApplyOrderCode(), builder.toString(), applyOrder.getApplyOrderCode());
        }
    }
}

