/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonStatusEnum;
import com.tydic.bcm.saas.personal.commodity.api.BcmSaasQueryApplyCommodityOrderDetailService;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasQueryApplyOrderDetailReqBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasQueryApplyOrderDetailRspBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasReplyApplyOrderItemBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasSkuPageListBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasSkuPageListReqBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasSkuPageListRspBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.commodity.api.BcmSaasQueryApplyCommodityOrderDetailService"})
public class BcmSaasQueryApplyCommodityOrderDetailServiceImpl
implements BcmSaasQueryApplyCommodityOrderDetailService {
    @Autowired
    private BcmQueryApplyOrderDetailService bcmQueryApplyOrderDetailService;
    @Value(value="${ucc.url}")
    private String uccUrl;

    @Override
    @PostMapping(value={"queryApplyOrderDetail"})
    public BcmSaasQueryApplyOrderDetailRspBO queryApplyOrderDetail(@RequestBody BcmSaasQueryApplyOrderDetailReqBO reqBO) {
        this.verifyParam(reqBO);
        BcmQueryApplyOrderDetailReqBO bcmQueryApplyOrderDetailReqBO = this.getBcmQueryApplyOrderDetailReqBO(reqBO);
        BcmQueryApplyOrderDetailRspBO bcmQueryApplyOrderDetailRspBO = this.bcmQueryApplyOrderDetailService.queryApplyOrderDetail(bcmQueryApplyOrderDetailReqBO);
        if (!"0000".equals(bcmQueryApplyOrderDetailRspBO.getRespCode())) {
            throw new ZTBusinessException(bcmQueryApplyOrderDetailRspBO.getRespDesc());
        }
        return this.setRspBO(bcmQueryApplyOrderDetailRspBO);
    }

    private BcmSaasQueryApplyOrderDetailRspBO setRspBO(BcmQueryApplyOrderDetailRspBO bcmQueryApplyOrderDetailRspBO) {
        BcmSaasQueryApplyOrderDetailRspBO rspBO = BcmSaasRuUtil.js(bcmQueryApplyOrderDetailRspBO, BcmSaasQueryApplyOrderDetailRspBO.class);
        if (!CollectionUtils.isEmpty(rspBO.getApplyOrder().getReplyCommodityList())) {
            ArrayList<Long> skuIdList = new ArrayList<Long>(rspBO.getApplyOrder().getReplyCommodityList().size());
            for (BcmSaasReplyApplyOrderItemBO bo : rspBO.getApplyOrder().getReplyCommodityList()) {
                if (bo.getSkuId() == null) continue;
                skuIdList.add(bo.getSkuId());
            }
            if (!CollectionUtils.isEmpty(skuIdList)) {
                BcmSaasSkuPageListRspBO bcmSaasSkuPageListRspBO = this.getSkuList(skuIdList);
                if (!"0000".equals(bcmSaasSkuPageListRspBO.getRespCode())) {
                    throw new ZTBusinessException(bcmSaasSkuPageListRspBO.getRespDesc());
                }
                if (!CollectionUtils.isEmpty(bcmSaasSkuPageListRspBO.getRows())) {
                    Map<Long, BcmSaasSkuPageListBO> skuMap = bcmSaasSkuPageListRspBO.getRows().stream().collect(Collectors.toMap(BcmSaasSkuPageListBO::getSkuId, v -> v, (k1, k2) -> k2));
                    for (BcmSaasReplyApplyOrderItemBO bo : rspBO.getApplyOrder().getReplyCommodityList()) {
                        if (bo.getSkuId() == null || skuMap.get(bo.getSkuId()) == null) continue;
                        bo.setSkuStatus(skuMap.get(bo.getSkuId()).getSkuStatus());
                        bo.setSkuStatusStr(skuMap.get(bo.getSkuId()).getSkuStatusDesc());
                        bo.setCommodityCode(skuMap.get(bo.getSkuId()).getCommodityCode());
                        bo.setSupplierShopId(skuMap.get(bo.getSkuId()).getSupplierShopId());
                        bo.setSalePrice(skuMap.get(bo.getSkuId()).getSalePrice());
                        bo.setUpTime(skuMap.get(bo.getSkuId()).getUpTime());
                        bo.setMarketPrice(skuMap.get(bo.getSkuId()).getMarketPrice());
                        bo.setDiscount(skuMap.get(bo.getSkuId()).getDiscount());
                        bo.setModel(skuMap.get(bo.getSkuId()).getModel());
                        bo.setSpec(skuMap.get(bo.getSkuId()).getSpec());
                        bo.setExtSkuId(skuMap.get(bo.getSkuId()).getExtSkuId());
                    }
                }
            }
        }
        return rspBO;
    }

    private BcmSaasSkuPageListRspBO getSkuList(List<Long> skuIdList) {
        BcmSaasSkuPageListReqBO bcmSaasSkuPageListReqBO = new BcmSaasSkuPageListReqBO();
        bcmSaasSkuPageListReqBO.setPageSize(skuIdList.size());
        bcmSaasSkuPageListReqBO.setExportSkuIds(skuIdList);
        String result = BcmSaasHttpUtil.doPost(this.uccUrl + "com.tydic.commodity.common.ability.api.UccEcommerceSkuListQryAbilityService/getEstoreSkuListQry", JSONObject.toJSONString((Object)((Object)bcmSaasSkuPageListReqBO)));
        return BcmSaasRuUtil.jss(result, BcmSaasSkuPageListRspBO.class);
    }

    private BcmQueryApplyOrderDetailReqBO getBcmQueryApplyOrderDetailReqBO(BcmSaasQueryApplyOrderDetailReqBO reqBO) {
        BcmQueryApplyOrderDetailReqBO bcmQueryApplyOrderDetailReqBO = (BcmQueryApplyOrderDetailReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), BcmQueryApplyOrderDetailReqBO.class);
        if (bcmQueryApplyOrderDetailReqBO.getQueryReplyFlag() == null) {
            bcmQueryApplyOrderDetailReqBO.setQueryReplyFlag(BcmPersonalCommonStatusEnum.YES.getStatus());
        }
        if ("2".equals(reqBO.getLoginTagIn())) {
            bcmQueryApplyOrderDetailReqBO.setSupId(reqBO.getOrgId());
        }
        return bcmQueryApplyOrderDetailReqBO;
    }

    private void verifyParam(BcmSaasQueryApplyOrderDetailReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getApplyOrderId() == null && StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u7533\u8bf7\u5355id\u548c\u6d41\u7a0b\u4efb\u52a1id\u4e0d\u80fd\u540c\u65f6\u4e3anull");
        }
    }
}

