/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.commodity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService;
import com.tydic.bcm.personal.commodity.api.BcmSelectBatchApplyCommodityOrderSupplierReplyService;
import com.tydic.bcm.personal.commodity.api.BcmUpdateStatusApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailRspBO;
import com.tydic.bcm.personal.commodity.bo.BcmSelectBatchReplyCommodityReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmSelectBatchReplyCommodityRspBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateStatusApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateStatusApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BooleanFlagEnum;
import com.tydic.bcm.saas.personal.commodity.api.BcmSaasSelectBatchApplyCommodityOrderSupplierReplyService;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasSelectBatchReplyCommodityReqBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasSelectBatchReplyCommodityRspBO;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasSelectReplyCommodityBO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.commodity.api.BcmSaasSelectBatchApplyCommodityOrderSupplierReplyService"})
public class BcmSaasSelectBatchApplyCommodityOrderSupplierReplyServiceImpl
implements BcmSaasSelectBatchApplyCommodityOrderSupplierReplyService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasSelectBatchApplyCommodityOrderSupplierReplyServiceImpl.class);
    @Autowired
    private BcmSelectBatchApplyCommodityOrderSupplierReplyService bcmSelectBatchApplyCommodityOrderSupplierReplyService;
    @Autowired
    private BcmUpdateStatusApplyCommodityOrderService bcmUpdateStatusApplyCommodityOrderService;
    @Autowired
    private BcmQueryApplyOrderDetailService bcmQueryApplyOrderDetailService;
    @Autowired
    private EacProjectAbilityService projectAbilityService;
    private static final Integer SUBMIT = 2;

    @Override
    @PostMapping(value={"selectBatchReplyCommodity"})
    public BcmSaasSelectBatchReplyCommodityRspBO selectBatchReplyCommodity(@RequestBody BcmSaasSelectBatchReplyCommodityReqBO reqBO) {
        this.verifyParam(reqBO);
        BcmSelectBatchReplyCommodityReqBO abilityReqBO = (BcmSelectBatchReplyCommodityReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), BcmSelectBatchReplyCommodityReqBO.class);
        BcmSelectBatchReplyCommodityRspBO abilityRspBO = this.bcmSelectBatchApplyCommodityOrderSupplierReplyService.selectBatchReplyCommodity(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        if (SUBMIT.equals(reqBO.getOperType())) {
            Map<Long, List<BcmSaasSelectReplyCommodityBO>> orderIdMap = reqBO.getReplyCommodityOrderItemList().stream().collect(Collectors.groupingBy(BcmSaasSelectReplyCommodityBO::getApplyOrderId));
            for (Long applyOrderId : orderIdMap.keySet()) {
                BcmQueryApplyOrderDetailReqBO detailReqBO = new BcmQueryApplyOrderDetailReqBO();
                detailReqBO.setApplyOrderId(applyOrderId);
                detailReqBO.setQueryReplyFlag(BooleanFlagEnum.YES.getFlag());
                detailReqBO.setSelectFlag(BooleanFlagEnum.YES.getFlag());
                log.info("\u67e5\u8be2\u7533\u8bf7\u5355\u8be6\u60c5\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)detailReqBO));
                BcmQueryApplyOrderDetailRspBO detailRspBO = this.bcmQueryApplyOrderDetailService.queryApplyOrderDetail(detailReqBO);
                log.info("\u67e5\u8be2\u7533\u8bf7\u5355\u8be6\u60c5\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)detailRspBO));
                if (!"0000".equals(detailRspBO.getRespCode())) {
                    throw new ZTBusinessException(detailRspBO.getRespDesc());
                }
                List filterBOList = detailRspBO.getApplyOrder().getReplyCommodityList().stream().filter(item -> ObjectUtil.isEmpty((Object)item.getSkuId()) || ObjectUtil.isEmpty((Object)item.getSkuCode())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(filterBOList)) continue;
                BcmUpdateStatusApplyCommodityOrderReqBO statusApplyCommodityOrderReqBO = new BcmUpdateStatusApplyCommodityOrderReqBO();
                statusApplyCommodityOrderReqBO.setApplyOrderId(applyOrderId);
                statusApplyCommodityOrderReqBO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.IN_RESULT_APPROVAL.getStatus());
                statusApplyCommodityOrderReqBO.setUpdateUserId(reqBO.getUserId());
                statusApplyCommodityOrderReqBO.setUpdateUserName(reqBO.getName());
                statusApplyCommodityOrderReqBO.setUpdateTime(new Date());
                BcmUpdateStatusApplyCommodityOrderRspBO statusApplyCommodityOrderRspBO = this.bcmUpdateStatusApplyCommodityOrderService.updateStatusApplyCommodityOrder(statusApplyCommodityOrderReqBO);
                if (!"0000".equals(statusApplyCommodityOrderRspBO.getRespCode())) {
                    throw new ZTBusinessException(statusApplyCommodityOrderRspBO.getRespDesc());
                }
                EacStartProjectAbilityReqBO startProjectAbilityReq = new EacStartProjectAbilityReqBO();
                startProjectAbilityReq.setProcDefKey("apply_commodity_order_select");
                startProjectAbilityReq.setSysCode("DYC");
                startProjectAbilityReq.setUserId(reqBO.getUserId() + "");
                startProjectAbilityReq.setUserName(reqBO.getName());
                startProjectAbilityReq.setBusinessIdList((List)Lists.newArrayList((Object[])new String[]{String.valueOf(applyOrderId)}));
                log.info("\u53d1\u8d77\u6d41\u7a0b\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)startProjectAbilityReq));
                EacStartProjectAbilityRspBO startProjectAbilityRspBO = this.projectAbilityService.startProjectByMq(startProjectAbilityReq);
                log.info("\u53d1\u8d77\u6d41\u7a0b\u51fa\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)startProjectAbilityRspBO));
            }
        }
        return new BcmSaasSelectBatchReplyCommodityRspBO();
    }

    private void verifyParam(BcmSaasSelectBatchReplyCommodityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u9009\u62e9\u6302\u63a5\u5546\u54c1\uff08\u6279\u91cf\uff09\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty(reqBO.getReplyCommodityOrderItemList())) {
            throw new ZTBusinessException("\u9009\u62e9\u6302\u63a5\u5546\u54c1\uff08\u6279\u91cf\uff09\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u3010replyCommodityOrderItemList\u3011\u4e3a\u7a7a");
        }
        reqBO.getReplyCommodityOrderItemList().forEach(item -> {
            if (ObjectUtil.isEmpty((Object)item.getReplyItemId())) {
                throw new ZTBusinessException("\u9009\u62e9\u6302\u63a5\u5546\u54c1\uff08\u6279\u91cf\uff09\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u6570\u636eID\u3010replyItemId\u3011\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)item.getApplyOrderId())) {
                throw new ZTBusinessException("\u9009\u62e9\u6302\u63a5\u5546\u54c1\uff08\u6279\u91cf\uff09\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355ID\u3010applyOrderId\u3011\u4e3a\u7a7a");
            }
        });
    }
}

