/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.notice.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderBO;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderPageBO;
import com.tydic.bcm.personal.commodity.bo.BcmApplyOrderBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.saas.personal.commodity.bo.BcmSaasGeminiReceiverBO;
import com.tydic.bcm.saas.personal.mq.BpmAuditMessageBO;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendNoticeService;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendTodoService;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasAddTodoBO;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasHaveDoneTodoBO;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasProductTodoBO;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasRevokeTodoBo;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmGeminiReceiverBO;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmGeminiSendAbilityReqBO;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.NoticeSendUtils;
import com.tydic.dyc.base.bo.RspBo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class BcmSaasSendNoticeServiceImpl
implements BcmSaasSendNoticeService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasSendNoticeServiceImpl.class);
    @Autowired
    private BcmQueryApplyOrderDetailService bcmQueryApplyOrderDetailService;
    @Value(value="${notice.apply.order.audit.taskCode}")
    private String applyOrderListAuditTaskCode;
    @Value(value="${notice.apply.order.terminate.taskCode}")
    private String applyOrderTerminateTaskCode;
    @Value(value="${notice.apply.order.pending.taskCode}")
    private String applyOrderPendingTaskCode;
    @Value(value="${notice.apply.order.complete.taskCode}")
    private String applyOrderCompleteTaskCode;
    @Value(value="${notice.url}")
    private String noticeUrl;
    @Value(value="${bcm.dyc.front.url}")
    private String frontUrl;
    @Value(value="${TBS_APPLY_ORDER_MESSAGE}")
    private String tbMessageCode;
    @Value(value="${CUTOFF_SELECT_APPLY_ORDER_MESSAGE}")
    private String taskCode;
    @Value(value="${APPLY_ORDER_SELECT_URL}")
    private String applyOrderSelectUrl;
    @Value(value="${bcm.dyc.queryOrgUser.url}")
    private String queryOrgUserUrl;
    @Value(value="${SUP_ORG_CLASS:5}")
    private String supOrgClass;
    @Value(value="${bcm.dyc.host}")
    private String dycHost;
    @Value(value="${BCM_APPLY_ORDER_DETAIL_URL}")
    private String bcmApplyOrderDetailUrl;
    private static final Integer defaultPage = -1;
    @Resource
    private BcmSaasSendTodoService bcmSaasSendTodoService;

    @Override
    @Async
    public void sendAsyncApplyOrderTerminateNotice(Long applyOrderId, String cancelReason, Long userId, String userName) {
        BcmQueryApplyOrderDetailReqBO bcmQueryApplyOrderDetailReqBO = new BcmQueryApplyOrderDetailReqBO();
        bcmQueryApplyOrderDetailReqBO.setApplyOrderId(applyOrderId);
        BcmQueryApplyOrderDetailRspBO bcmQueryApplyOrderDetailRspBO = this.bcmQueryApplyOrderDetailService.queryApplyOrderDetail(bcmQueryApplyOrderDetailReqBO);
        if (!"0000".equals(bcmQueryApplyOrderDetailRspBO.getRespCode())) {
            log.error("\u6d88\u8d39\u5931\u8d25 {}", (Object)JSON.toJSONString((Object)bcmQueryApplyOrderDetailRspBO));
            throw new ZTBusinessException("\u67e5\u8be2\u4e0a\u67b6\u7533\u8bf7\u5355\u8be6\u60c5\u51fa\u9519");
        }
        BcmApplyOrderBO applyOrder = bcmQueryApplyOrderDetailRspBO.getApplyOrder();
        BcmSaasGeminiReceiverBO bcmSaasGeminiReceiverBO = new BcmSaasGeminiReceiverBO();
        bcmSaasGeminiReceiverBO.setReceiverId(applyOrder.getApplyUserId());
        bcmSaasGeminiReceiverBO.setReceiverName(applyOrder.getApplyUserName());
        NoticeSendUtils.sendTerminateApplyOrder(this.applyOrderTerminateTaskCode, this.noticeUrl, bcmSaasGeminiReceiverBO, "\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355:" + applyOrder.getApplyOrderCode() + "\u5df2\u7ec8\u6b62", applyOrder.getApplyOrderItem().getCommodityTypeName(), applyOrder.getApplyOrderCode(), cancelReason, userId, userName);
    }

    @Override
    @Async
    public void sendAsyncApplyOrderAuditNotice(Long applyOrderId, List<BpmAuditMessageBO.TaskListDTO> taskList) {
        if (CollectionUtil.isEmpty(taskList)) {
            return;
        }
        BcmQueryApplyOrderDetailReqBO queryApplyOrderDetailReqBO = new BcmQueryApplyOrderDetailReqBO();
        queryApplyOrderDetailReqBO.setApplyOrderId(applyOrderId);
        BcmQueryApplyOrderDetailRspBO bcmQueryApplyOrderDetailRspBO = this.bcmQueryApplyOrderDetailService.queryApplyOrderDetail(queryApplyOrderDetailReqBO);
        if (!"0000".equals(bcmQueryApplyOrderDetailRspBO.getRespCode())) {
            log.error("\u6d88\u8d39\u5931\u8d25 {}", (Object)JSON.toJSONString((Object)bcmQueryApplyOrderDetailRspBO));
            throw new ZTBusinessException("\u67e5\u8be2\u4e0a\u67b6\u7533\u8bf7\u5355\u8be6\u60c5\u51fa\u9519");
        }
        ArrayList<BcmSaasAddTodoBO> todoList = new ArrayList<BcmSaasAddTodoBO>();
        for (BpmAuditMessageBO.TaskListDTO taskListDTO : taskList) {
            BcmApplyOrderBO applyOrder = bcmQueryApplyOrderDetailRspBO.getApplyOrder();
            StringBuilder builder = new StringBuilder(this.frontUrl);
            builder.append("ecOnshelfApprovalDetail?isShowApprovalBtn=true&f=ecOnshelfApproval&isArg=true&tabKey=1");
            builder.append("&orderCode=").append(applyOrder.getApplyOrderCode());
            builder.append("&orderId=").append(applyOrder.getApplyOrderId());
            builder.append("&taskId=").append(taskListDTO.getApproveTaskId());
            BcmSaasGeminiReceiverBO bcmSaasGeminiReceiverBO = new BcmSaasGeminiReceiverBO();
            bcmSaasGeminiReceiverBO.setReceiverId(taskListDTO.getUserId());
            bcmSaasGeminiReceiverBO.setReceiverName(taskListDTO.getUserName());
            NoticeSendUtils.sendSingleApplyOrder(this.applyOrderListAuditTaskCode, this.noticeUrl, bcmSaasGeminiReceiverBO, "\u5f85\u5ba1\u6279\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355\uff1a" + applyOrder.getApplyOrderCode(), builder.toString(), applyOrder.getApplyOrderCode());
            BcmSaasAddTodoBO bcmSaasAddTodoBO = new BcmSaasAddTodoBO();
            bcmSaasAddTodoBO.setBusiId(applyOrderId + "");
            bcmSaasAddTodoBO.setTodoItemCode("APPLY_COMMODITY_ORDER");
            bcmSaasAddTodoBO.setTodoName("\u5f85\u5ba1\u6279\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355\uff1a" + applyOrder.getApplyOrderCode());
            bcmSaasAddTodoBO.setTodoItemName("\u4e0a\u67b6\u7533\u8bf7\u5355\u5ba1\u6279\u4ee3\u529e");
            bcmSaasAddTodoBO.setTodoUrl(builder.toString());
            bcmSaasAddTodoBO.setTodoModuleCode("ucc");
            bcmSaasAddTodoBO.setTodoModuleName("\u5546\u54c1\u4ee3\u529e");
            bcmSaasAddTodoBO.setCandidateOperId(taskListDTO.getUserId() + "");
            bcmSaasAddTodoBO.setCandidateOperName(taskListDTO.getUserName() + "");
            todoList.add(bcmSaasAddTodoBO);
            this.pushGuwpTodo(builder.toString(), bcmSaasAddTodoBO.getTodoName(), taskListDTO.getUserId());
        }
        this.bcmSaasSendTodoService.sendBatchTodo(todoList);
    }

    @Override
    @Async
    public void sendAsyncSelectNotice(BcmApplyCommodityOrderPageBO item) {
        String detailUrl = this.frontUrl + "ecSelectGoods?tabId=1002&f=ecCommodityOnshelfManage&applyOrderId=" + item.getApplyOrderId();
        BcmGeminiSendAbilityReqBO bcmGeminiSendAbilityReqBO = new BcmGeminiSendAbilityReqBO();
        JSONObject json = new JSONObject();
        json.put("applyOrderCode", (Object)item.getApplyOrderCode());
        json.put("applyOrderSelectUrl", (Object)(this.applyOrderSelectUrl + item.getApplyOrderId()));
        bcmGeminiSendAbilityReqBO.setTaskCode(this.tbMessageCode);
        bcmGeminiSendAbilityReqBO.setData(json.toJSONString());
        bcmGeminiSendAbilityReqBO.setSendId(BcmPersonalCommonConstant.DefaultUser.DEFAULT_USER_ID.toString());
        bcmGeminiSendAbilityReqBO.setSendName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        ArrayList<BcmGeminiReceiverBO> receivers = new ArrayList<BcmGeminiReceiverBO>();
        BcmGeminiReceiverBO receiverBO = new BcmGeminiReceiverBO();
        receiverBO.setReceiverId(item.getApplyUserId().toString());
        receiverBO.setReceiverName(item.getApplyUserName());
        receivers.add(receiverBO);
        bcmGeminiSendAbilityReqBO.setReceivers(receivers);
        BcmSaasHttpUtil.doPost(this.noticeUrl, JSONObject.toJSONString((Object)bcmGeminiSendAbilityReqBO));
        BcmSaasAddTodoBO bcmSaasAddTodoBO = new BcmSaasAddTodoBO();
        bcmSaasAddTodoBO.setBusiId(item.getApplyOrderId() + "");
        bcmSaasAddTodoBO.setTodoItemCode("APPLY_COMMODITY_ORDER");
        bcmSaasAddTodoBO.setTodoName("\u5f85\u5ba1\u6279\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355\uff1a" + item.getApplyOrderCode());
        bcmSaasAddTodoBO.setTodoItemName("\u4e0a\u67b6\u7533\u8bf7\u5355\u5ba1\u6279\u4ee3\u529e");
        bcmSaasAddTodoBO.setTodoUrl(detailUrl);
        bcmSaasAddTodoBO.setTodoModuleCode("ucc");
        bcmSaasAddTodoBO.setTodoModuleName("\u5546\u54c1\u4ee3\u529e");
        bcmSaasAddTodoBO.setCandidateOperId(item.getApplyUserId().toString());
        bcmSaasAddTodoBO.setCandidateOperName(item.getApplyUserName());
        this.bcmSaasSendTodoService.sendTodo(bcmSaasAddTodoBO);
        this.pushGuwpTodo(detailUrl, bcmSaasAddTodoBO.getTodoName(), item.getApplyUserId());
    }

    @Override
    @Async
    public void sendAsyncPendingSelect(BcmApplyCommodityOrderBO bo) {
        String detailUrl = this.frontUrl + "ecSelectGoods?tabId=1002&f=ecCommodityOnshelfManage&applyOrderId=" + bo.getApplyOrderId();
        BcmGeminiSendAbilityReqBO bcmGeminiSendAbilityReqBO = new BcmGeminiSendAbilityReqBO();
        JSONObject json = new JSONObject();
        json.put("applyOrderCode", (Object)bo.getApplyOrderCode());
        json.put("applyOrderSelectUrl", (Object)(this.applyOrderSelectUrl + bo.getApplyOrderId()));
        bcmGeminiSendAbilityReqBO.setTaskCode(this.taskCode);
        bcmGeminiSendAbilityReqBO.setData(json.toJSONString());
        bcmGeminiSendAbilityReqBO.setSendId(BcmPersonalCommonConstant.DefaultUser.DEFAULT_USER_ID.toString());
        bcmGeminiSendAbilityReqBO.setSendName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        ArrayList<BcmGeminiReceiverBO> receivers = new ArrayList<BcmGeminiReceiverBO>();
        BcmGeminiReceiverBO receiverBO = new BcmGeminiReceiverBO();
        receiverBO.setReceiverId(String.valueOf(bo.getApplyUserId()));
        receiverBO.setReceiverName(bo.getApplyUserName());
        receivers.add(receiverBO);
        bcmGeminiSendAbilityReqBO.setReceivers(receivers);
        BcmSaasHttpUtil.doPost(this.noticeUrl, JSONObject.toJSONString((Object)bcmGeminiSendAbilityReqBO));
        BcmSaasAddTodoBO bcmSaasAddTodoBO = new BcmSaasAddTodoBO();
        bcmSaasAddTodoBO.setBusiId(bo.getApplyOrderId() + "");
        bcmSaasAddTodoBO.setTodoItemCode("APPLY_COMMODITY_ORDER");
        bcmSaasAddTodoBO.setTodoName("\u5f85\u5ba1\u6279\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355\uff1a" + bo.getApplyOrderCode());
        bcmSaasAddTodoBO.setTodoItemName("\u4e0a\u67b6\u7533\u8bf7\u5355\u5ba1\u6279\u4ee3\u529e");
        bcmSaasAddTodoBO.setTodoUrl(detailUrl);
        bcmSaasAddTodoBO.setTodoModuleCode("ucc");
        bcmSaasAddTodoBO.setTodoModuleName("\u5546\u54c1\u4ee3\u529e");
        bcmSaasAddTodoBO.setCandidateOperId(bo.getApplyUserId().toString());
        bcmSaasAddTodoBO.setCandidateOperName(bo.getApplyUserName());
        this.bcmSaasSendTodoService.sendTodo(bcmSaasAddTodoBO);
        this.pushGuwpTodo(detailUrl, bcmSaasAddTodoBO.getTodoName(), bo.getApplyUserId());
    }

    @Override
    @Async
    public void sendAsyncApplyOrderPendingNotice(Long applyOrderId) {
        BcmQueryApplyOrderDetailReqBO queryApplyOrderDetailReqBO = new BcmQueryApplyOrderDetailReqBO();
        queryApplyOrderDetailReqBO.setApplyOrderId(applyOrderId);
        BcmQueryApplyOrderDetailRspBO bcmQueryApplyOrderDetailRspBO = this.bcmQueryApplyOrderDetailService.queryApplyOrderDetail(queryApplyOrderDetailReqBO);
        if (!"0000".equals(bcmQueryApplyOrderDetailRspBO.getRespCode())) {
            log.error("\u6d88\u8d39\u5931\u8d25 {}", (Object)JSON.toJSONString((Object)bcmQueryApplyOrderDetailRspBO));
            throw new ZTBusinessException("\u67e5\u8be2\u4e0a\u67b6\u7533\u8bf7\u5355\u8be6\u60c5\u51fa\u9519");
        }
        JSONObject reqStr = new JSONObject();
        reqStr.put("orgClass", (Object)this.supOrgClass);
        reqStr.put("pageNo", (Object)defaultPage);
        reqStr.put("pageSize", (Object)defaultPage);
        log.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u7528\u6237\u4fe1\u606f\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = BcmSaasHttpUtil.doPost(this.queryOrgUserUrl, reqStr.toJSONString());
        log.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u7528\u6237\u4fe1\u606f\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        JSONObject rspJson = JSONObject.parseObject((String)rspStr);
        if (!"0".equals(rspJson.get((Object)"code").toString())) {
            throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u5e94\u5546\u7528\u6237\u4fe1\u606f\u51fa\u9519");
        }
        String dataStr = rspJson.getString("data");
        JSONObject dataJson = JSONObject.parseObject((String)dataStr);
        JSONArray rows = JSONObject.parseArray((String)dataJson.getString("rows"));
        BcmApplyOrderBO applyOrder = bcmQueryApplyOrderDetailRspBO.getApplyOrder();
        StringBuilder builder = new StringBuilder(this.frontUrl);
        builder.append("addReplyOnshelfApply?type=init&f=ecReplyOnshelfApplyList");
        builder.append("&applyOrderId=").append(applyOrder.getApplyOrderId());
        ArrayList<BcmSaasAddTodoBO> todoList = new ArrayList<BcmSaasAddTodoBO>();
        ArrayList<BcmSaasGeminiReceiverBO> receiverBOS = new ArrayList<BcmSaasGeminiReceiverBO>();
        for (Object item : rows) {
            String itemStr = item.toString();
            JSONObject itemJson = JSONObject.parseObject((String)itemStr);
            BcmSaasGeminiReceiverBO bcmSaasGeminiReceiverBO = new BcmSaasGeminiReceiverBO();
            bcmSaasGeminiReceiverBO.setReceiverId(itemJson.getLong("userId"));
            bcmSaasGeminiReceiverBO.setReceiverName(itemJson.getString("custName"));
            if (ObjectUtil.isNotEmpty((Object)itemJson.getString("regEmail"))) {
                bcmSaasGeminiReceiverBO.setEMail(itemJson.getString("regEmail"));
            }
            receiverBOS.add(bcmSaasGeminiReceiverBO);
            BcmSaasAddTodoBO bcmSaasAddTodoBO = new BcmSaasAddTodoBO();
            bcmSaasAddTodoBO.setBusiId(applyOrderId + "");
            bcmSaasAddTodoBO.setTodoItemCode("APPLY_COMMODITY_ORDER");
            bcmSaasAddTodoBO.setTodoName("\u5f85\u5ba1\u6279\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355\uff1a" + applyOrder.getApplyOrderCode());
            bcmSaasAddTodoBO.setTodoItemName("\u4e0a\u67b6\u7533\u8bf7\u5355\u5ba1\u6279\u4ee3\u529e");
            bcmSaasAddTodoBO.setTodoUrl(builder.toString());
            bcmSaasAddTodoBO.setTodoModuleCode("ucc");
            bcmSaasAddTodoBO.setTodoModuleName("\u5546\u54c1\u4ee3\u529e");
            bcmSaasAddTodoBO.setCandidateOperId(itemJson.getString("userId"));
            bcmSaasAddTodoBO.setCandidateOperName(itemJson.getString("custName"));
            todoList.add(bcmSaasAddTodoBO);
        }
        this.bcmSaasSendTodoService.sendBatchTodo(todoList);
        NoticeSendUtils.sendPendingApplyOrder(this.applyOrderPendingTaskCode, this.noticeUrl, receiverBOS, "\u5f85\u53d7\u7406\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355\uff1a" + applyOrder.getApplyOrderCode(), applyOrder.getApplyOrderCode());
    }

    @Override
    @Async
    public void sendAsyncApplyOrderCompleteNotice(Long applyOrderId) {
        BcmQueryApplyOrderDetailReqBO queryApplyOrderDetailReqBO = new BcmQueryApplyOrderDetailReqBO();
        queryApplyOrderDetailReqBO.setApplyOrderId(applyOrderId);
        BcmQueryApplyOrderDetailRspBO bcmQueryApplyOrderDetailRspBO = this.bcmQueryApplyOrderDetailService.queryApplyOrderDetail(queryApplyOrderDetailReqBO);
        if (!"0000".equals(bcmQueryApplyOrderDetailRspBO.getRespCode())) {
            log.error("\u6d88\u8d39\u5931\u8d25 {}", (Object)JSON.toJSONString((Object)bcmQueryApplyOrderDetailRspBO));
            throw new ZTBusinessException("\u67e5\u8be2\u4e0a\u67b6\u7533\u8bf7\u5355\u8be6\u60c5\u51fa\u9519");
        }
        BcmApplyOrderBO applyOrder = bcmQueryApplyOrderDetailRspBO.getApplyOrder();
        BcmSaasGeminiReceiverBO receiverBO = new BcmSaasGeminiReceiverBO();
        receiverBO.setReceiverId(applyOrder.getApplyUserId());
        receiverBO.setReceiverName(applyOrder.getApplyUserName());
        StringBuilder title = new StringBuilder();
        title.append("\u3010\u4ea4\u94f6e\u91c7\u3011\u60a8\u6709\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355").append(applyOrder.getApplyOrderCode()).append("(\u5546\u54c1\u7c7b\u578b\u4e3a").append(applyOrder.getApplyOrderItem().getCommodityTypeName()).append("\u7b49)\uff0c\u5df2\u901a\u8fc7\u6700\u7ec8\u7684\u9009\u5b9a\u786e\u8ba4\u3002");
        NoticeSendUtils.sendCompleteApplyOrder(this.applyOrderCompleteTaskCode, this.noticeUrl, receiverBO, title.toString(), applyOrder.getApplyOrderCode(), applyOrder.getApplyOrderItem().getCommodityTypeName());
    }

    private void pushGuwpTodo(String todoUrl, String todoItemName, Long receviceId) {
        BcmSaasProductTodoBO reqBO = new BcmSaasProductTodoBO();
        reqBO.setTodoUrl(todoUrl);
        reqBO.setCreateTime(new Date());
        reqBO.setTodoItemName(todoItemName);
        JSONObject object = new JSONObject();
        object.put("userIdWeb", (Object)receviceId);
        log.info("\u8c03\u7528\u7528\u6237\u8be6\u60c5\u53c2\u6570 {}", (Object)object.toString());
        String result = HttpUtil.post((String)("http://" + this.dycHost + "/dyc/saas/user/noauth/qryUserInfoDetail"), (String)object.toString());
        log.info("\u8fd4\u56de\u7528\u6237\u4fe1\u606f {}", (Object)result);
        RspBo baseRspBo = (RspBo)JSONObject.parseObject((String)result, RspBo.class);
        if (!"0".equals(baseRspBo.getCode())) {
            throw new ZTBusinessException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        JSONObject data = jsonObject.getJSONObject("data");
        String extCustId = data.getString("extCustId");
        String custName = data.getString("custName");
        reqBO.setCandidateOperExtId(extCustId);
        reqBO.setCandidateOperName(custName);
        this.bcmSaasSendTodoService.pushTodo(reqBO);
    }

    @Override
    @Async
    public void sendAsyncHaveDoneTodo(Long applyOrderId, Long userId, String userName) {
        BcmSaasHaveDoneTodoBO bcmSaasHaveDoneTodoBO = new BcmSaasHaveDoneTodoBO();
        bcmSaasHaveDoneTodoBO.setBusiId(applyOrderId + "");
        bcmSaasHaveDoneTodoBO.setOperUserId(userId);
        bcmSaasHaveDoneTodoBO.setOperUserName(userName);
        bcmSaasHaveDoneTodoBO.setDoneUrl(this.bcmApplyOrderDetailUrl + applyOrderId);
        bcmSaasHaveDoneTodoBO.setTodoItemCode("APPLY_COMMODITY_ORDER");
        this.bcmSaasSendTodoService.sendHaveDone(bcmSaasHaveDoneTodoBO);
    }

    @Override
    public void sendAsyncApplyOrderRevokeNotice(Long applyOrderId, List<BpmAuditMessageBO.TaskListDTO> taskList, Long userId, String userName) {
        BcmSaasRevokeTodoBo bcmSaasHaveDoneTodoBO = new BcmSaasRevokeTodoBo();
        bcmSaasHaveDoneTodoBO.setBusiId(applyOrderId + "");
        bcmSaasHaveDoneTodoBO.setOperUserId(userId);
        bcmSaasHaveDoneTodoBO.setOperUserName(userName);
        this.bcmSaasSendTodoService.revokeTodo(bcmSaasHaveDoneTodoBO);
        if (CollectionUtil.isEmpty(taskList)) {
            return;
        }
        BcmQueryApplyOrderDetailReqBO queryApplyOrderDetailReqBO = new BcmQueryApplyOrderDetailReqBO();
        queryApplyOrderDetailReqBO.setApplyOrderId(applyOrderId);
        BcmQueryApplyOrderDetailRspBO bcmQueryApplyOrderDetailRspBO = this.bcmQueryApplyOrderDetailService.queryApplyOrderDetail(queryApplyOrderDetailReqBO);
        if (!"0000".equals(bcmQueryApplyOrderDetailRspBO.getRespCode())) {
            log.error("\u6d88\u8d39\u5931\u8d25 {}", (Object)JSON.toJSONString((Object)bcmQueryApplyOrderDetailRspBO));
            throw new ZTBusinessException("\u67e5\u8be2\u4e0a\u67b6\u7533\u8bf7\u5355\u8be6\u60c5\u51fa\u9519");
        }
        ArrayList<BcmSaasAddTodoBO> todoList = new ArrayList<BcmSaasAddTodoBO>();
        for (BpmAuditMessageBO.TaskListDTO taskListDTO : taskList) {
            BcmApplyOrderBO applyOrder = bcmQueryApplyOrderDetailRspBO.getApplyOrder();
            StringBuilder builder = new StringBuilder(this.frontUrl);
            builder.append("ecOnshelfApprovalDetail?isShowApprovalBtn=true&f=ecOnshelfApproval&isArg=true&tabKey=1");
            builder.append("&orderCode=").append(applyOrder.getApplyOrderCode());
            builder.append("&orderId=").append(applyOrder.getApplyOrderId());
            builder.append("&taskId=").append(taskListDTO.getApproveTaskId());
            BcmSaasGeminiReceiverBO bcmSaasGeminiReceiverBO = new BcmSaasGeminiReceiverBO();
            bcmSaasGeminiReceiverBO.setReceiverId(taskListDTO.getUserId());
            bcmSaasGeminiReceiverBO.setReceiverName(taskListDTO.getUserName());
            NoticeSendUtils.sendSingleApplyOrder(this.applyOrderListAuditTaskCode, this.noticeUrl, bcmSaasGeminiReceiverBO, "\u5f85\u5ba1\u6279\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355\uff1a" + applyOrder.getApplyOrderCode(), builder.toString(), applyOrder.getApplyOrderCode());
            BcmSaasAddTodoBO bcmSaasAddTodoBO = new BcmSaasAddTodoBO();
            bcmSaasAddTodoBO.setBusiId(applyOrderId + "");
            bcmSaasAddTodoBO.setTodoItemCode("APPLY_COMMODITY_ORDER");
            bcmSaasAddTodoBO.setTodoName("\u5f85\u5ba1\u6279\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355\uff1a" + applyOrder.getApplyOrderCode());
            bcmSaasAddTodoBO.setTodoItemName("\u4e0a\u67b6\u7533\u8bf7\u5355\u5ba1\u6279\u4ee3\u529e");
            bcmSaasAddTodoBO.setTodoUrl(builder.toString());
            bcmSaasAddTodoBO.setTodoModuleCode("ucc");
            bcmSaasAddTodoBO.setTodoModuleName("\u5546\u54c1\u4ee3\u529e");
            bcmSaasAddTodoBO.setCandidateOperId(taskListDTO.getUserId() + "");
            bcmSaasAddTodoBO.setCandidateOperName(taskListDTO.getUserName() + "");
            todoList.add(bcmSaasAddTodoBO);
            this.pushGuwpTodo(builder.toString(), bcmSaasAddTodoBO.getTodoName(), taskListDTO.getUserId());
        }
        this.bcmSaasSendTodoService.sendBatchTodo(todoList);
    }
}

