/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.nacos.client.utils.StringUtils;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderPageListService;
import com.tydic.bcm.personal.commodity.api.BcmUpdateStatusApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderPageBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderPageListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderPageListRspBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateStatusApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityCancelTypeEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.constants.BcmPersonalFlowConstant;
import com.tydic.bcm.personal.constants.BooleanFlagEnum;
import com.tydic.bcm.personal.flow.api.BcmQueryFlowInstanceService;
import com.tydic.bcm.personal.flow.bo.BcmQueryFlowInstanceReqBO;
import com.tydic.bcm.personal.flow.bo.BcmQueryFlowInstanceRspBO;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendNoticeService;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendTodoService;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasAddTodoBO;
import com.tydic.bcm.saas.personal.notice.bo.BcmSaasProductTodoBO;
import com.tydic.bcm.saas.personal.task.api.BcmSaasApplyOrderTerminateReplyTimeTaskService;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasTerminateApplyCommodityOrderReqBO;
import com.tydic.bcm.saas.personal.task.bo.BcmSaasTerminateApplyCommodityOrderRspBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.task.api.BcmSaasApplyOrderTerminateReplyTimeTaskService"})
public class BcmSaasApplyOrderTerminateReplyTimeTaskServiceImpl
implements BcmSaasApplyOrderTerminateReplyTimeTaskService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasApplyOrderTerminateReplyTimeTaskServiceImpl.class);
    @Autowired
    private BcmQueryApplyCommodityOrderPageListService bcmQueryApplyCommodityOrderPageListService;
    @Autowired
    private BcmUpdateStatusApplyCommodityOrderService bcmUpdateStatusApplyCommodityOrderService;
    private final BcmSaasSendNoticeService bcmSaasSendNoticeService;
    @Value(value="${REPLY_SUPPLIER_NUM:2}")
    private Integer replySupplierNum;
    @Value(value="${DEAL_REPLY_COUNT:100}")
    private Integer dealReplyCount;
    @Value(value="${bcm.dyc.front.url}")
    private String frontUrl;
    @Autowired
    private BcmSaasSendTodoService bcmSaasSendTodoService;
    @Autowired
    private BcmQueryFlowInstanceService bcmQueryFlowInstanceService;
    @Value(value="${APPLY_ORDER_TODO_CODE:APPLY_COMMODITY_ORDER}")
    private String applyOrderTodoCode;

    @Override
    @PostMapping(value={"terminateApplyCommodityOrder"})
    public BcmSaasTerminateApplyCommodityOrderRspBO terminateApplyCommodityOrder(@RequestBody BcmSaasTerminateApplyCommodityOrderReqBO reqBO) {
        BcmSaasTerminateApplyCommodityOrderRspBO rspBO = new BcmSaasTerminateApplyCommodityOrderRspBO();
        BcmQueryApplyCommodityOrderPageListReqBO orderPageListReqBO = new BcmQueryApplyCommodityOrderPageListReqBO();
        orderPageListReqBO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.IN_REPLY.getStatus());
        orderPageListReqBO.setPageSize(this.dealReplyCount.intValue());
        orderPageListReqBO.setReplyDeadlineEndDate(new Date());
        orderPageListReqBO.setSumFlag(BooleanFlagEnum.YES.getFlag());
        int initPageNo = orderPageListReqBO.getPageNo();
        while (true) {
            orderPageListReqBO.setPageNo(initPageNo);
            BcmQueryApplyCommodityOrderPageListRspBO orderPageListRspBO = this.bcmQueryApplyCommodityOrderPageListService.queryApplyCommodityOrderPageList(orderPageListReqBO);
            if (ObjectUtil.isEmpty((Object)orderPageListRspBO.getRows())) break;
            for (BcmApplyCommodityOrderPageBO item : orderPageListRspBO.getRows()) {
                BcmUpdateStatusApplyCommodityOrderReqBO updateOrderReqBO;
                if (ObjectUtil.isNotEmpty((Object)item.getReplySupplierNum()) && item.getReplySupplierNum() >= this.replySupplierNum) {
                    updateOrderReqBO = new BcmUpdateStatusApplyCommodityOrderReqBO();
                    updateOrderReqBO.setApplyOrderId(item.getApplyOrderId());
                    updateOrderReqBO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.IN_SELECT.getStatus());
                    updateOrderReqBO.setSelectDeadFlag(BooleanFlagEnum.YES.getFlag());
                    updateOrderReqBO.setUpdateUserId(Long.valueOf(1L));
                    updateOrderReqBO.setUpdateUserName("\u5b9a\u65f6\u4efb\u52a1");
                    updateOrderReqBO.setUpdateTime(new Date());
                    this.bcmUpdateStatusApplyCommodityOrderService.updateStatusApplyCommodityOrder(updateOrderReqBO);
                    this.bcmSaasSendNoticeService.sendAsyncSelectNotice(item);
                    this.sendTodo(item);
                    continue;
                }
                updateOrderReqBO = new BcmUpdateStatusApplyCommodityOrderReqBO();
                updateOrderReqBO.setApplyOrderId(item.getApplyOrderId());
                updateOrderReqBO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.TERMINATION.getStatus());
                updateOrderReqBO.setCancelType(BcmPersonalCommodityCancelTypeEnum.REPLY_DEADLINE.getCancelType());
                updateOrderReqBO.setCancelReason(BcmPersonalCommodityCancelTypeEnum.REPLY_DEADLINE.getCancelDesc());
                updateOrderReqBO.setUpdateUserId(Long.valueOf(1L));
                updateOrderReqBO.setUpdateUserName("\u5b9a\u65f6\u4efb\u52a1");
                updateOrderReqBO.setUpdateTime(new Date());
                this.bcmUpdateStatusApplyCommodityOrderService.updateStatusApplyCommodityOrder(updateOrderReqBO);
                this.bcmSaasSendNoticeService.sendAsyncApplyOrderTerminateNotice(item.getApplyOrderId(), BcmPersonalCommodityCancelTypeEnum.REPLY_DEADLINE.getCancelDesc(), null, null);
            }
            ++initPageNo;
        }
        return rspBO;
    }

    private void sendTodo(BcmApplyCommodityOrderPageBO applyOrder) {
        BcmQueryFlowInstanceReqBO bcmQueryFlowInstanceReqBO = new BcmQueryFlowInstanceReqBO();
        bcmQueryFlowInstanceReqBO.setObjId(applyOrder.getApplyOrderId());
        bcmQueryFlowInstanceReqBO.setIsFinish(BcmPersonalFlowConstant.IsFinish.NO);
        bcmQueryFlowInstanceReqBO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmQueryFlowInstanceReqBO.setObjType(BcmPersonalFlowConstant.ObjType.APPLY_ORDER);
        BcmQueryFlowInstanceRspBO bcmQueryFlowInstanceRspBO = this.bcmQueryFlowInstanceService.queryFlowInstance(bcmQueryFlowInstanceReqBO);
        if (!"0000".equals(bcmQueryFlowInstanceRspBO.getRespCode())) {
            log.error(bcmQueryFlowInstanceRspBO.getRespDesc());
            return;
        }
        if (StringUtils.isBlank((String)bcmQueryFlowInstanceRspBO.getFlowInstId())) {
            log.error("\u672a\u67e5\u8be2\u5230\u6d41\u7a0b\u5b9e\u4f8b");
            return;
        }
        BcmSaasProductTodoBO bcmSaasProductTodoBO = new BcmSaasProductTodoBO();
        bcmSaasProductTodoBO.setBusiId(String.valueOf(applyOrder.getApplyOrderId()));
        bcmSaasProductTodoBO.setTodoUrl(this.frontUrl + "ecSelectGoods?tabId=1002&f=ecCommodityOnshelfManage&applyOrderId=" + applyOrder.getApplyOrderId());
        bcmSaasProductTodoBO.setTodoItemName("\u5f85\u9009\u5b9a\u5546\u5bb6\uff1a\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355" + applyOrder.getApplyOrderCode());
        bcmSaasProductTodoBO.setProcInstId(bcmQueryFlowInstanceRspBO.getFlowInstId());
        bcmSaasProductTodoBO.setCandidateOperId(applyOrder.getApplyUserId().toString());
        bcmSaasProductTodoBO.setCandidateOperName(applyOrder.getApplyUserName());
        bcmSaasProductTodoBO.setCreateTime(new Date());
        bcmSaasProductTodoBO.setTodoItemCode(this.applyOrderTodoCode);
        this.bcmSaasSendTodoService.pushTodo(bcmSaasProductTodoBO);
        BcmSaasAddTodoBO bcmSaasAddTodo = new BcmSaasAddTodoBO();
        bcmSaasAddTodo.setBusiId(String.valueOf(applyOrder.getApplyOrderId()));
        bcmSaasAddTodo.setTodoUrl(this.frontUrl + "ecSelectGoods?tabId=1002&f=ecCommodityOnshelfManage&applyOrderId=" + applyOrder.getApplyOrderId());
        bcmSaasAddTodo.setTodoItemName("\u5f85\u9009\u5b9a\u5546\u5bb6\uff1a\u5546\u54c1\u4e0a\u67b6\u7533\u8bf7\u5355" + applyOrder.getApplyOrderCode());
        bcmSaasAddTodo.setCreateOperId("1");
        bcmSaasAddTodo.setCreateOperName("\u7cfb\u7edf");
        bcmSaasAddTodo.setCandidateOperId(applyOrder.getApplyUserId().toString());
        bcmSaasAddTodo.setCandidateOperName(applyOrder.getApplyUserName());
        bcmSaasAddTodo.setTodoItemCode(this.applyOrderTodoCode);
        this.bcmSaasSendTodoService.sendTodo(bcmSaasAddTodo);
    }

    public BcmSaasApplyOrderTerminateReplyTimeTaskServiceImpl(BcmSaasSendNoticeService bcmSaasSendNoticeService) {
        this.bcmSaasSendNoticeService = bcmSaasSendNoticeService;
    }
}

