/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.common.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.saas.personal.common.api.BcmSaasQueryFinanceOrgService;
import com.tydic.bcm.saas.personal.common.bo.BcmSaasFinanceOrgBO;
import com.tydic.bcm.saas.personal.common.bo.BcmSaasQueryFinanceOrgReqBO;
import com.tydic.bcm.saas.personal.common.bo.BcmSaasQueryFinanceOrgRspBO;
import com.tydic.bcm.saas.personal.common.bo.BcmSaasUmcOrgRspBO;
import com.tydic.bcm.saas.personal.common.bo.DycUmcOrgBO;
import com.tydic.bcm.saas.personal.common.bo.DycUmcOrgListQryRspBO;
import com.tydic.bcm.saas.personal.utils.SaasParamValidateUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.bcm.saas.personal.common.api.BcmSaasQueryFinanceOrgService"})
public class BcmSaasFinanceOrgServiceImpl
implements BcmSaasQueryFinanceOrgService {
    private static final Logger log = LoggerFactory.getLogger(BcmSaasFinanceOrgServiceImpl.class);
    @Value(value="${bcm.dyc.umcb.org}")
    private String umcbOrgUrl;

    @Override
    @PostMapping(value={"queryFinanceOrg"})
    public BcmSaasQueryFinanceOrgRspBO queryFinanceOrg(@RequestBody BcmSaasQueryFinanceOrgReqBO reqBO) {
        SaasParamValidateUtils.validate(reqBO);
        List orgIds = Arrays.stream(reqBO.getOrgTreePathIn().split("-")).mapToLong(t -> Long.parseLong(t.trim())).boxed().collect(Collectors.toList());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("pageNo", -1);
        param.put("pageSize", -1);
        param.put("addOrgIds", orgIds);
        String result = HttpUtil.post((String)this.umcbOrgUrl, (String)JSON.toJSONString(param));
        BcmSaasUmcOrgRspBO bcmSaasUmcOrgRspBO = (BcmSaasUmcOrgRspBO)JSON.parseObject((String)result, BcmSaasUmcOrgRspBO.class);
        log.info("\u8bf7\u6c42\u673a\u6784\u5217\u8868\u63a5\u53e3  {} \n \u8f6c\u6362\u4e4b\u540e\u7684\u5bf9\u8c61 {}", (Object)result, (Object)JSON.toJSONString((Object)bcmSaasUmcOrgRspBO));
        if (!"0".equals(bcmSaasUmcOrgRspBO.getCode())) {
            throw new ZTBusinessException(bcmSaasUmcOrgRspBO.getMessage());
        }
        DycUmcOrgListQryRspBO data = bcmSaasUmcOrgRspBO.getData();
        if (!"0000".equals(data.getRespCode())) {
            throw new ZTBusinessException(data.getMessage());
        }
        if (ObjectUtil.isNotEmpty((Object)data.getRows())) {
            List sortOrgInfoBOS = data.getRows().stream().sorted(Comparator.comparingInt(DycUmcOrgBO::getDeep).reversed()).collect(Collectors.toList());
            for (DycUmcOrgBO item : sortOrgInfoBOS) {
                if (!"1".equals(item.getExtField2())) continue;
                BcmSaasFinanceOrgBO bcmSaasFinanceOrgBO = (BcmSaasFinanceOrgBO)BeanUtil.copyProperties((Object)item, BcmSaasFinanceOrgBO.class);
                return new BcmSaasQueryFinanceOrgRspBO(bcmSaasFinanceOrgBO);
            }
        }
        return new BcmSaasQueryFinanceOrgRspBO();
    }
}

