/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.product.ext.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.saas.personal.product.ext.bo.BcmOutSendEvaInfoToZcPlatformServiceReqBo;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.bcm.saas.personal.utils.BcmSaasRuUtil;
import com.tydic.dyc.saas.uoc.api.DycSendEvaInfoToZcPlatformServiceExtPt;
import com.tydic.dyc.saas.uoc.bo.DycSendEvaInfoToZcPlatformServiceReqBo;
import com.tydic.dyc.saas.uoc.bo.DycSendEvaInfoToZcPlatformServiceRspBo;
import com.tydic.dyc.saas.uoc.bo.DycUocSaleOrderEvaObjInfoBO;
import com.tydic.dyc.saas.uoc.bo.DycUocSaleOrderEvaStarLevelBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.saas.uoc.api.DycSendEvaInfoToZcPlatformServiceExtPt"})
public class DycSendEvaInfoToZcPlatformServiceImpl
implements DycSendEvaInfoToZcPlatformServiceExtPt {
    @Value(value="${ORDER_EVA_URL:url}")
    private String url;

    @PostMapping(value={"syncEvaInfo"})
    public DycSendEvaInfoToZcPlatformServiceRspBo syncEvaInfo(@RequestBody DycSendEvaInfoToZcPlatformServiceReqBo reqBo) {
        this.verifyParam(reqBo);
        this.toZcPlatform(reqBo);
        return BcmSaasRuUtil.success(DycSendEvaInfoToZcPlatformServiceRspBo.class);
    }

    private void toZcPlatform(DycSendEvaInfoToZcPlatformServiceReqBo reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getObjInfoList())) {
            for (DycUocSaleOrderEvaObjInfoBO evaObjInfo : reqBO.getObjInfoList()) {
                BcmOutSendEvaInfoToZcPlatformServiceReqBo outSendEvaInfo = new BcmOutSendEvaInfoToZcPlatformServiceReqBo();
                outSendEvaInfo.setOrderNo(evaObjInfo.getObjName());
                if (!CollectionUtils.isEmpty((Collection)evaObjInfo.getStarLevelList())) {
                    BigDecimal sum = BigDecimal.ZERO;
                    for (DycUocSaleOrderEvaStarLevelBO evaStarLevel : evaObjInfo.getStarLevelList()) {
                        sum = sum.add(new BigDecimal(evaStarLevel.getLevelValue()));
                    }
                    outSendEvaInfo.setTotalSocre(sum.divide(new BigDecimal(evaObjInfo.getStarLevelList().size()), RoundingMode.HALF_DOWN).toString());
                }
                String body = JSONObject.toJSONString((Object)outSendEvaInfo);
                BcmSaasHttpUtil.doPost(this.url, body);
            }
        }
    }

    private void verifyParam(DycSendEvaInfoToZcPlatformServiceReqBo reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getObjInfoList())) {
            throw new ZTBusinessException("\u5165\u53c2\u9700\u8981\u540c\u6b65\u7684\u5355\u636e\u8bc4\u4ef7\u4fe1\u606f\u4e0d\u80fd\u4e3anull");
        }
        for (DycUocSaleOrderEvaObjInfoBO dycUocSaleOrderEvaObjInfoBO : reqBO.getObjInfoList()) {
            if (!StringUtils.isBlank((String)dycUocSaleOrderEvaObjInfoBO.getOrderId())) continue;
            throw new ZTBusinessException("\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3anull");
        }
    }
}

