/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.product.ext.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.dyc.saas.uoc.api.DycUocOrderTakeUpBudgetServiceExtPt;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderTakeUpBudgetCommodityInfoBO;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderTakeUpBudgetServiceExtReqBo;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderTakeUpBudgetServiceExtRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.saas.uoc.api.DycUocOrderTakeUpBudgetServiceExtPt"})
public class DycUocOrderTakeUpBudgetServiceExtPtImpl
implements DycUocOrderTakeUpBudgetServiceExtPt {
    private static final Logger log = LoggerFactory.getLogger(DycUocOrderTakeUpBudgetServiceExtPtImpl.class);
    @Value(value="${OCCUPY_BUDGET_URL:}")
    private String occupyBudgetUrl;
    private static final String SUCCESS = "0";

    @PostMapping(value={"takeUpBudget"})
    public DycUocOrderTakeUpBudgetServiceExtRspBo takeUpBudget(@RequestBody DycUocOrderTakeUpBudgetServiceExtReqBo reqBo) {
        DycUocOrderTakeUpBudgetServiceExtRspBo rspBo = new DycUocOrderTakeUpBudgetServiceExtRspBo();
        JSONObject reqStr = DycUocOrderTakeUpBudgetServiceExtPtImpl.setReqStr(reqBo);
        log.info("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u91ca\u653e\u8ba2\u5355\u9884\u7b97\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = BcmSaasHttpUtil.doPost(this.occupyBudgetUrl, reqStr.toJSONString());
        log.info("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u91ca\u653e\u8ba2\u5355\u9884\u7b97\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        JSONObject rspJson = JSONObject.parseObject((String)rspStr);
        if (!SUCCESS.equals(rspJson.getString("code"))) {
            throw new ZTBusinessException("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u91ca\u653e\u8ba2\u5355\u9884\u7b97\u62a5\u9519:" + rspJson.getString("message"));
        }
        return rspBo;
    }

    private static JSONObject setReqStr(DycUocOrderTakeUpBudgetServiceExtReqBo reqBo) {
        JSONObject reqStr = new JSONObject();
        reqStr.put("onlyId", (Object)reqBo.getSaleOrderId());
        reqStr.put("pkOrg", (Object)reqBo.getFinancialOrgId());
        reqStr.put("payStatus", (Object)reqBo.getPayStatus());
        reqStr.put("money", (Object)reqBo.getTotalPurchaseFee());
        reqStr.put("taxDeductible", (Object)reqBo.getTaxDeductible());
        reqStr.put("norigtaxmny", (Object)reqBo.getTotalPurchaseFee());
        reqStr.put("recorder", (Object)reqBo.getCreateOperName());
        reqStr.put("recorderCode", (Object)reqBo.getExtCustId());
        reqStr.put("dept", (Object)reqBo.getRelevantDeptId());
        reqStr.put("billmake", (Object)reqBo.getExtCustId());
        JSONArray payitemList = new JSONArray();
        JSONArray fileList = new JSONArray();
        for (DycUocOrderTakeUpBudgetCommodityInfoBO item : reqBo.getSaleOrderItemList()) {
            JSONObject itemStr = DycUocOrderTakeUpBudgetServiceExtPtImpl.setOrderItem(reqBo, item);
            payitemList.add((Object)itemStr);
            if (!ObjectUtil.isNotEmpty((Object)item.getSkuMainPicUrl())) continue;
            JSONObject fileStr = DycUocOrderTakeUpBudgetServiceExtPtImpl.setFile(reqBo, item);
            fileList.add((Object)fileStr);
        }
        reqStr.put("payitemList", (Object)payitemList);
        reqStr.put("fileList", (Object)fileList);
        return reqStr;
    }

    private static JSONObject setFile(DycUocOrderTakeUpBudgetServiceExtReqBo reqBo, DycUocOrderTakeUpBudgetCommodityInfoBO item) {
        JSONObject fileStr = new JSONObject();
        fileStr.put("ecmId", (Object)"");
        fileStr.put("fileName", (Object)"");
        fileStr.put("fileType", (Object)"");
        fileStr.put("fileLength", (Object)"");
        return fileStr;
    }

    private static JSONObject setOrderItem(DycUocOrderTakeUpBudgetServiceExtReqBo reqBo, DycUocOrderTakeUpBudgetCommodityInfoBO item) {
        JSONObject itemStr = new JSONObject();
        itemStr.put("orderId", (Object)item.getSaleOrderItemId());
        itemStr.put("moneyDe", (Object)item.getPurchasePrice());
        itemStr.put("deductible", (Object)item.getTaxDeductible());
        itemStr.put("norigtaxmnyB", (Object)item.getPurchasePrice());
        itemStr.put("pkInoutbusiclass", (Object)item.getIncomeAndExpProjectName());
        itemStr.put("pkObj", (Object)reqBo.getBudgetProjectName());
        itemStr.put("pkCostcenter", (Object)reqBo.getCostCenterName());
        itemStr.put("creditCode", (Object)item.getCreditCode());
        return itemStr;
    }
}

