/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.product.ext.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.saas.personal.utils.BcmSaasHttpUtil;
import com.tydic.ext.fsc.api.FscOrderInfoPushServiceExtPt;
import com.tydic.ext.fsc.bo.FscExtInvoiceBO;
import com.tydic.ext.fsc.bo.FscOrderInfoPushReqBO;
import com.tydic.ext.fsc.bo.FscOrderInfoPushRspBO;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_SAAS_GROUP_DEV/3.0.0/com.tydic.ext.fsc.api.FscOrderInfoPushServiceExtPt"})
public class FscOrderInfoPushServiceExtPtImpl
implements FscOrderInfoPushServiceExtPt {
    private static final Logger log = LoggerFactory.getLogger(FscOrderInfoPushServiceExtPtImpl.class);
    @Value(value="${ORDER_INFO_PUSH_URL:}")
    private String orderInfoPushUrl;
    private static final String SUCCESS = "0";

    @PostMapping(value={"pushFscOrder"})
    public FscOrderInfoPushRspBO pushFscOrder(@RequestBody FscOrderInfoPushReqBO reqBO) {
        FscOrderInfoPushRspBO rspBO = new FscOrderInfoPushRspBO();
        JSONObject reqStr = FscOrderInfoPushServiceExtPtImpl.setReqStr(reqBO);
        log.info("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u5165\u53c2\u4e3a\uff1a{}", (Object)reqStr);
        String rspStr = BcmSaasHttpUtil.doPost(this.orderInfoPushUrl, reqStr.toJSONString());
        log.info("\u8c03\u7528\u5916\u90e8\u7cfb\u7edf\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u51fa\u53c2\u4e3a\uff1a{}", (Object)rspStr);
        JSONObject rspJson = JSONObject.parseObject((String)rspStr);
        if (!SUCCESS.equals(rspJson.getString("code"))) {
            throw new ZTBusinessException("\u8c03\u7528\u5916\u90e8\u7cfb\u7ed3\u7b97\u5355\u4fe1\u606f\u63a8\u9001\u62a5\u9519:" + rspJson.getString("message"));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private static JSONObject setReqStr(FscOrderInfoPushReqBO reqBO) {
        JSONObject reqStr = new JSONObject();
        reqStr.put("jsdId", (Object)reqBO.getFscOrderId());
        reqStr.put("payMsg", (Object)"");
        reqStr.put("money", (Object)"");
        reqStr.put("taxDeductible", (Object)"");
        reqStr.put("totalPrice", (Object)"");
        reqStr.put("pkOrg", (Object)"");
        reqStr.put("agentName", (Object)"");
        reqStr.put("agentCode", (Object)"");
        reqStr.put("billMake", (Object)"");
        reqStr.put("currency", (Object)"");
        reqStr.put("abstractInfo", (Object)"");
        reqStr.put("telephone", (Object)"");
        reqStr.put("dept", (Object)"");
        JSONArray payitemList = new JSONArray();
        JSONObject payItem = FscOrderInfoPushServiceExtPtImpl.setPayItem(reqBO);
        payitemList.add((Object)payItem);
        reqStr.put("payitemList", (Object)payitemList);
        JSONArray payInvoiceList = new JSONArray();
        for (FscExtInvoiceBO invoiceItem : reqBO.getFscExtInvoiceBOList()) {
            JSONObject payInvoice = FscOrderInfoPushServiceExtPtImpl.setPayInvoice(invoiceItem);
            payInvoiceList.add((Object)payInvoice);
        }
        reqStr.put("payInvoiceList", (Object)payInvoiceList);
        JSONArray supplierList = new JSONArray();
        JSONObject supplier = FscOrderInfoPushServiceExtPtImpl.setSupplier(reqBO);
        supplierList.add((Object)supplier);
        reqStr.put("supplierList", (Object)supplierList);
        JSONArray supplierBankList = new JSONArray();
        JSONObject supplierBank = FscOrderInfoPushServiceExtPtImpl.setSupplierBank(reqBO);
        supplierList.add((Object)supplierBank);
        reqStr.put("supplierBankList", (Object)supplierBankList);
        JSONArray fileList = new JSONArray();
        JSONObject file = FscOrderInfoPushServiceExtPtImpl.setFile(reqBO);
        fileList.add((Object)file);
        reqStr.put("fileList", (Object)fileList);
        return reqStr;
    }

    private static JSONObject setFile(FscOrderInfoPushReqBO reqBO) {
        JSONObject file = new JSONObject();
        file.put("ecmId", (Object)"");
        file.put("fileName", (Object)"");
        file.put("fileType", (Object)"");
        file.put("fileLength", (Object)"");
        return file;
    }

    private static JSONObject setSupplierBank(FscOrderInfoPushReqBO reqBO) {
        JSONObject supplierBank = new JSONObject();
        supplierBank.put("accNum", (Object)"");
        supplierBank.put("accName", (Object)"");
        supplierBank.put("pkBankType", (Object)"");
        supplierBank.put("pkBankDoc", (Object)"");
        supplierBank.put("accountProperty", (Object)"");
        supplierBank.put("enableState", (Object)"");
        supplierBank.put("pkCurrType", (Object)"");
        supplierBank.put("isDefault", (Object)"");
        return supplierBank;
    }

    private static JSONObject setSupplier(FscOrderInfoPushReqBO reqBO) {
        JSONObject supplier = new JSONObject();
        supplier.put("pkOrgS", (Object)reqBO.getSupplierId());
        supplier.put("supplierCode", (Object)"");
        supplier.put("supplierName", (Object)reqBO.getSupplierName());
        supplier.put("pkSupplierClass", (Object)"");
        supplier.put("supplierStatus", (Object)"");
        supplier.put("taxpayerId", (Object)"");
        supplier.put("societyCode", (Object)"");
        supplier.put("supplierCountry", (Object)"");
        return supplier;
    }

    private static JSONObject setPayInvoice(FscExtInvoiceBO invoiceItem) {
        JSONObject payInvoice = new JSONObject();
        payInvoice.put("invoiceType", (Object)"");
        payInvoice.put("invoiceCode", (Object)invoiceItem.getInvoiceCode());
        payInvoice.put("invoiceNo", (Object)invoiceItem.getInvoiceNo());
        payInvoice.put("checkCode", (Object)"");
        payInvoice.put("invoiceDate", (Object)invoiceItem.getBillDate());
        payInvoice.put("noTaxMoney", (Object)invoiceItem.getAmt());
        payInvoice.put("incomeTax", (Object)invoiceItem.getTaxAmt());
        BigDecimal priceAndTax = invoiceItem.getAmt().add(invoiceItem.getTaxAmt());
        payInvoice.put("priceAndTax", (Object)priceAndTax);
        payInvoice.put("remark", (Object)"");
        return payInvoice;
    }

    private static JSONObject setPayItem(FscOrderInfoPushReqBO reqBO) {
        JSONObject payItem = new JSONObject();
        payItem.put("idB", (Object)"");
        payItem.put("message", (Object)"");
        payItem.put("pkInoutbusiclass", (Object)"");
        payItem.put("budgetAccount", (Object)"");
        payItem.put("ccCode", (Object)"");
        payItem.put("fileId", (Object)"");
        payItem.put("moneyDe", (Object)"");
        payItem.put("taxDeductibleB", (Object)"");
        payItem.put("totalPriceB", (Object)"");
        payItem.put("recAccount", (Object)"");
        payItem.put("supplier", (Object)"");
        payItem.put("deductionAmount", (Object)"");
        payItem.put("deductionPrepayments", (Object)"");
        payItem.put("hxAmount", (Object)"");
        payItem.put("retentionMoney", (Object)"");
        payItem.put("inputTaxCategory", (Object)"");
        payItem.put("paBalaType", (Object)"");
        payItem.put("crossBorderType", (Object)"");
        payItem.put("secondaryTransfer", (Object)"");
        payItem.put("field1B", (Object)"");
        payItem.put("field12", (Object)"");
        return payItem;
    }
}

