/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.saas.personal.mq;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService;
import com.tydic.bcm.personal.common.api.BcmApproveApplyOrderService;
import com.tydic.bcm.personal.common.bo.BcmApproveApplyOrderRspBO;
import com.tydic.bcm.personal.common.bo.BcmFlowInstanceBO;
import com.tydic.bcm.personal.common.bo.BcmFlowTaskBO;
import com.tydic.bcm.personal.constants.BcmBpmFlowConstant;
import com.tydic.bcm.personal.constants.BcmFlowTaskStatusEnum;
import com.tydic.bcm.saas.personal.constant.BcmSaasPersonalCommodityConstant;
import com.tydic.bcm.saas.personal.mq.BpmAuditMessageBO;
import com.tydic.bcm.saas.personal.notice.BcmSaasSendNoticeService;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BcmApplyOrderApproveMessageService
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(BcmApplyOrderApproveMessageService.class);
    @Autowired
    private BcmApproveApplyOrderService bcmApproveApplyOrderService;
    @Autowired
    private BcmQueryApplyOrderDetailService bcmQueryApplyOrderDetailService;
    @Resource
    private BcmSaasSendNoticeService bcmSaasSendNoticeService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        log.info("{} \u6d88\u606f\u5185\u5bb9\uff1a {}", (Object)message.getTag(), (Object)message.getContent());
        BpmAuditMessageBO bpmAuditMessage = (BpmAuditMessageBO)JSON.parseObject((String)message.getContent(), BpmAuditMessageBO.class);
        BcmFlowInstanceBO bcmFlowInstanceBO = this.fillFlowInstance(bpmAuditMessage);
        BcmApproveApplyOrderRspBO bcmApproveApplyOrderRspBO = this.bcmApproveApplyOrderService.approveApplyOrder(bcmFlowInstanceBO);
        if (!"0000".equals(bcmApproveApplyOrderRspBO.getRespCode())) {
            log.error("\u6d88\u8d39\u5931\u8d25 {}", (Object)JSON.toJSONString((Object)bcmApproveApplyOrderRspBO));
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        this.bcmSaasSendNoticeService.sendAsyncApplyOrderAuditNotice(bcmFlowInstanceBO.getObjId(), bpmAuditMessage.getTaskList());
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private BcmFlowInstanceBO fillFlowInstance(BpmAuditMessageBO bpmAuditMessage) {
        BcmFlowInstanceBO bcmFlowInstance = new BcmFlowInstanceBO();
        bcmFlowInstance.setFlowInstId(bpmAuditMessage.getProcInstId());
        if (bpmAuditMessage.getIsfinish().booleanValue()) {
            bcmFlowInstance.setIsFinish(BcmSaasPersonalCommodityConstant.FlowInstanceIsFinish.YES);
            bcmFlowInstance.setCurrentNodeStatus(BcmSaasPersonalCommodityConstant.FlowInstanceCurrentNodeStatus.APPROVAL_FINISH);
        } else {
            bcmFlowInstance.setIsFinish(BcmSaasPersonalCommodityConstant.FlowInstanceIsFinish.NO);
            bcmFlowInstance.setCurrentNodeStatus(BcmSaasPersonalCommodityConstant.FlowInstanceCurrentNodeStatus.IN_APPROVAL);
        }
        if (CollectionUtil.isNotEmpty(bpmAuditMessage.getTaskList())) {
            BpmAuditMessageBO.TaskListDTO task = bpmAuditMessage.getTaskList().get(0);
            BpmAuditMessageBO.TaskListDTO.BusinessDTO business = task.getBusiness();
            bcmFlowInstance.setObjId(business.getBusinessId());
            if ("apply_commodity_order".equals(task.getProcDefKey())) {
                bcmFlowInstance.setObjType(BcmBpmFlowConstant.FlowInstanceObjType.APPLY_ORDER);
                bcmFlowInstance.setFlowType(BcmBpmFlowConstant.FlowInstanceFlowType.APPLY_ORDER_AUDIT);
            } else if ("apply_commodity_order_select".equals(task.getProcDefKey())) {
                bcmFlowInstance.setObjType(BcmBpmFlowConstant.FlowInstanceObjType.APPLY_ORDER);
                bcmFlowInstance.setFlowType(BcmBpmFlowConstant.FlowInstanceFlowType.APPLY_ORDER_SELECT_AUDIT);
            }
            bcmFlowInstance.setFlowKey(task.getProcDefKey());
            bcmFlowInstance.setFlowDefId(task.getProcDefId());
            bcmFlowInstance.setCurrentNodeCode(task.getStepId());
            bcmFlowInstance.setCurrentNodeName(task.getStepName());
            bcmFlowInstance.setAuditStartTime(task.getCreateTime());
        }
        ArrayList<BcmFlowTaskBO> bcmFlowTaskList = new ArrayList<BcmFlowTaskBO>();
        if (CollectionUtil.isNotEmpty(bpmAuditMessage.getTaskList())) {
            for (BpmAuditMessageBO.TaskListDTO taskListDTO : bpmAuditMessage.getTaskList()) {
                BcmFlowTaskBO bcmFlowTask = new BcmFlowTaskBO();
                bcmFlowTask.setTaskId(taskListDTO.getApproveTaskId());
                bcmFlowTask.setFlowInstId(taskListDTO.getProcInstId());
                bcmFlowTask.setCurrentNodeCode(taskListDTO.getStepId());
                bcmFlowTask.setCurrentNodeName(taskListDTO.getStepName());
                bcmFlowTask.setTaskCreateTime(taskListDTO.getCreateTime());
                bcmFlowTask.setTaskStatus(BcmFlowTaskStatusEnum.WAIT_APPROVE.getTaskStatus());
                if (taskListDTO.getUserId() != null) {
                    bcmFlowTask.setPendingAuditUserId(taskListDTO.getUserId());
                    bcmFlowTask.setPendingAuditUserName(taskListDTO.getUserName());
                }
                if (taskListDTO.getOrgId() != null) {
                    bcmFlowTask.setPendingAuditOrgId(taskListDTO.getOrgId());
                    bcmFlowTask.setPendingAuditOrgName(taskListDTO.getOrgName());
                }
                if (taskListDTO.getCompanyId() != null) {
                    bcmFlowTask.setPendingAuditCompanyId(taskListDTO.getCompanyId());
                    bcmFlowTask.setPendingAuditCompanyName(taskListDTO.getCompanyName());
                }
                bcmFlowTaskList.add(bcmFlowTask);
            }
        }
        bcmFlowInstance.setBcmFlowTaskList(bcmFlowTaskList);
        log.info("\u6d41\u7a0b\u8f6c\u5316\u540e\u5bf9\u8c61 ### {}", (Object)JSON.toJSONString((Object)bcmFlowInstance));
        return bcmFlowInstance;
    }
}

